/*====================================================================*/
/*  Name:     IMOLSPRO.H    (Library Services - prototype statements) */
/*====================================================================*/
/*                                                                    */
/*  Licensed Materials - Property of IBM                              */
/*                                                                    */
/*  5765-IMT (C) Copyright IBM Corporation 1997, 1998                 */
/*                                                                    */
/*  All rights reserved.                                              */
/*  US Government Users Restricted Rights -                           */
/*  Use, duplication or disclosure restricted by GSA ADP              */
/*  Schedule Contract with IBM Corporation.                           */
/*                                                                    */
/*  See Copyright Instructions.                                       */
/*                                                                    */
/*====================================================================*/
/*                                                                    */
/* Permission Notice                                                  */
/*                                                                    */
/* Permission is granted to copy, use, modify, and merge this         */
/* software into your applications and to permit others to do any of  */
/* the foregoing.                                                     */
/* You may further distribute these object classes for commercial     */
/* purposes only as part of your application that adds significant    */
/* value and function beyond that provided by these object classes.   */
/* You must include this permission statement and retain the          */
/* copyright notice in all copies and modified versions of this       */
/* software.                                                          */
/*                                                                    */
/*====================================================================*/

#if !defined(IMOLSPRO_DEFINED)      /* prototypes already included ?  */
#define IMOLSPRO_DEFINED            /* if not, include them           */

/*--------------------------------------------------------------------*/
/*  Library Services - mapping of external names to uppercase         */
/*--------------------------------------------------------------------*/
#define  LIB_init                      LIB_INIT
#define  LIB_access_doc                LIB_ACCESS_DOC
#define  LIB_read_doc_content          LIB_READ_DOC_CONTENT
#define  LIB_close_doc                 LIB_CLOSE_DOC
#define  LIB_list_doc_groups           LIB_LIST_DOC_GROUPS
#define  LIB_list_documents            LIB_LIST_DOCUMENTS
#define  LIB_get_doc_attr_values       LIB_GET_DOC_ATTR_VALUES
#define  LIB_get_doc_group_attr_values LIB_GET_DOC_GROUP_ATTR_VALUES
#define  LIB_doc_index_status          LIB_DOC_INDEX_STATUS
#define  LIB_end                       LIB_END

/*--------------------------------------------------------------------*/
/*  Library Services - calling conventions                            */
/*--------------------------------------------------------------------*/

#if defined(__WINDOWS__) || defined(_WIN32)
   #if defined(_WIN32)
      #define  LSCALL               __cdecl
   #else
      #define  LSCALL               FAR PASCAL
   #endif
#elif defined(__UNIX__) || defined(_AIX) || defined(_HP_UX) || defined(__SOLARIS__) || defined(AS400)
#define  LSCALL
#else
#define  LSCALL                     _System
#endif

/*--------------------------------------------------------------------*/
/*  Library Services - prototype statements                           */
/*--------------------------------------------------------------------*/
#ifdef __cplusplus
extern "C" {
#endif

unsigned long                       /* Initialize Library Services ---*/
LSCALL   LIB_init
 (
 unsigned short    usLenSessInfo,   /* In:  Length of session info    */
 char            * pSessionInfo,    /* In:  Session information       */
                                    /*      with index name and       */
                                    /*      library information items */
 void           ** ppAnchor,        /* Out: pointer that can be used  */
                                    /*      as anchor (when calling   */
                                    /*      LIB_init, *ppAnchor has   */
                                    /*      to be initialized to 0)   */
 unsigned short  * pusReserved,     /* Reserved for future use        */
 char            * pReserved,       /* Reserved for future use        */
 char            * pDiagInfo        /* I/O: buffer to receive         */
                                    /*      diagnosis information     */
 );

unsigned long                       /* Access Document ---------------*/
LSCALL   LIB_access_doc
 (
 void            * pAnchor,         /* In:  anchor                    */
 unsigned short    usLenDocId,      /* In:  length of document id     */
 char            * pDocId,          /* In:  document identifier       */
 unsigned short  * pusLenDocInfo,   /* Out: actual length of document */
                                    /*      related information       */
 char            * pDocInfo,        /* I/O: buffer to receive         */
                                    /*      document related info     */
 void           ** ppDocHandle,     /* Out: document handle           */
 char            * pDiagInfo        /* I/O: buffer to receive         */
                                    /*      diagnosis information     */
 );

unsigned long                       /* Read Document Text ------------*/
LSCALL   LIB_read_doc_content
 (
 void            * pAnchor,         /* In:  anchor                    */
 void            * pDocHandle,      /* In:  document handle           */
 unsigned short    usSkipBytes,     /* In:  number of bytes to skip   */
                                    /*      from current position     */
 unsigned short    usReadBytes,     /* In:  bytes to read then from   */
                                    /*      current position          */
 unsigned short  * pusBytesRead,    /* Out: number of bytes actually  */
                                    /*      read                      */
 char            * pDocText,        /* I/O: buffer to receive text    */
 char            * pDiagInfo        /* I/O: buffer to receive         */
                                    /*      diagnosis information     */
 );

unsigned long                       /* Close Document ----------------*/
LSCALL   LIB_close_doc
 (
 void            * pAnchor,         /* In:  anchor                    */
 void            * pDocHandle,      /* In:  document handle           */
                                    /*      to be released by LS      */
 char            * pDiagInfo        /* I/O: buffer to receive         */
                                    /*      diagnosis information     */
 );

unsigned long                       /* List Doc Group Identifiers ----*/
LSCALL   LIB_list_doc_groups
 (
 void            * pAnchor,         /* In:  anchor                    */
 unsigned short    usLenDocGroupId, /* In:  length of input           */
 char            * pDocGroupId,     /* In:  library/document group    */
                                    /*      identifier                */
 unsigned long     ulLenOutBuffer,  /* In:  length of buffer to       */
                                    /*      receive doc group list    */
 char              RequestType,     /* In:  type of the request       */
                                    /* I/O: document group list handle*/
 void           ** ppDocGroupListHandle,
                                    /* Out: actual length of document */
 unsigned long   * pulLenDocGroupList,
                                    /*      group list                */
 char            * pDocGroupList,   /* I/O: buffer to receive         */
                                    /*      document group list       */
 char            * pDiagInfo        /* I/O: buffer to receive         */
                                    /*      diagnosis information     */
 );

unsigned long                       /* List Document Identifiers -----*/
LSCALL   LIB_list_documents
 (
 void            * pAnchor,         /* In:  anchor                    */
 unsigned short    usLenDocGroupId, /* In:  length of input           */
 char            * pDocGroupId,     /* In:  document group identifier */
 unsigned long     ulLenOutBuffer,  /* In:  length of buffer to       */
                                    /*      receive document id       */
 char              RequestType,     /* In:  type of the request       */
 void           ** ppDocListHandle, /* I/O: document list handle      */
 unsigned long   * pulLenDocList,   /* Out: actual length of document */
                                    /*      identifier list           */
 char            * pDocList,        /* I/O: buffer to receive         */
                                    /*      document identifiers      */
 char            * pDiagInfo        /* I/O: buffer to receive         */
                                    /*      diagnosis information     */
 );

unsigned long                       /* Get Document Attribute Values--*/
LSCALL   LIB_get_doc_attr_values
 (
 void            * pAnchor,         /* In:  anchor                    */
 unsigned short    usLenDocAttrList,/* In:  length of input           */
 char            * pDocAttrList,    /* In:  attribute / document list */
 unsigned long     ulLenOutBuffer,  /* In:  length of buffer to       */
                                    /*      receive requested values  */
 char              RequestType,     /* In:  type of the request       */
                                    /* I/O: attribute value list      */
                                    /*      handle                    */
 void           ** ppAttrValListHandle,
 unsigned long   * pulLenAttrValues,/* Out: actual length of          */
                                    /*      attribute values          */
 char            * pAttrValues,     /* I/O: buffer to receive         */
                                    /*      attribute values          */
 char            * pDiagInfo        /* I/O: buffer to receive         */
                                    /*      diagnosis information     */
 );

unsigned long                       /* Get Docgroup Attribute Values -*/
LSCALL   LIB_get_doc_group_attr_values
 (
 void            * pAnchor,         /* In:  anchor                    */
                                    /* In:  length of input           */
 unsigned short    usLenDocGrpAttrList,
 char            * pDGrpAttrList,   /* In:  attribute / docgroup list */
 unsigned long     ulLenOutBuffer,  /* In:  length of buffer to       */
                                    /*      receive requested values  */
 char              RequestType,     /* In:  type of the request       */
                                    /* I/O: attribute value list      */
                                    /*      handle                    */
 void **           ppAttrValListHandle,
 unsigned long   * pulLenAttrValues,/* Out: actual length of          */
                                    /*      attribute values          */
 char            * pAttrValues,     /* I/O: buffer to receive         */
                                    /*      attribute values          */
 char            * pDiagInfo        /* I/O: buffer to receive         */
                                    /*      diagnosis information     */
 );

unsigned long                       /* Set document index status -----*/
LSCALL   LIB_doc_index_status
 (
 void            * pAnchor,         /* In:  anchor                    */
 unsigned short    usLenDocStatList,/* In:  length of input           */
 char            * pDocStatList,    /* In:  list of documents to set  */
                                    /*      index status              */
 unsigned short    usCheckRequired, /* In:  special checks required   */
 char            * pDiagInfo        /* I/O: buffer to receive         */
                                    /*      diagnosis information     */
 );

unsigned long                       /* End Library Services ----------*/
LSCALL   LIB_end
 (
 void            * pAnchor,         /* In:  anchor                    */
 char            * pDiagInfo        /* I/O: buffer to receive         */
                                    /*      diagnosis information     */
 );

#ifdef __cplusplus
   }
#endif

#endif                              /* end of include                 */

