/*====================================================================*/
/*  Name:     IMOLSDEF.H     (Library Services - general definitions) */
/*====================================================================*/
/*                                                                    */
/*  Licensed Materials - Property of IBM                              */
/*                                                                    */
/*  5765-IMT (C) Copyright IBM Corporation 1997, 1998                 */
/*                                                                    */
/*  All rights reserved.                                              */
/*  US Government Users Restricted Rights -                           */
/*  Use, duplication or disclosure restricted by GSA ADP              */
/*  Schedule Contract with IBM Corporation.                           */
/*                                                                    */
/*  See Copyright Instructions.                                       */
/*                                                                    */
/*====================================================================*/
/*                                                                    */
/* Permission Notice                                                  */
/*                                                                    */
/* Permission is granted to copy, use, modify, and merge this         */
/* software into your applications and to permit others to do any of  */
/* the foregoing.                                                     */
/* You may further distribute these object classes for commercial     */
/* purposes only as part of your application that adds significant    */
/* value and function beyond that provided by these object classes.   */
/* You must include this permission statement and retain the          */
/* copyright notice in all copies and modified versions of this       */
/* software.                                                          */
/*                                                                    */
/*====================================================================*/

#if !defined(IMOLSDEF_DEFINED)      /* definitions already included ? */
#define IMOLSDEF_DEFINED            /* if not, include them           */

#include "imoapic.h"                /* include api header file        */
/*--------------------------------------------------------------------*/
/* Parameter definitions                                              */
/*--------------------------------------------------------------------*/
#define  LS_FIRST     0xC6          /* Start  type                    */
#define  LS_NEXT      0xD5          /* Next   type                    */
#define  LS_CANCEL    0xC3          /* Cancel type                    */

#define  LS_TRUE      1             /*                                */
#define  LS_FALSE     0             /*                                */

/*--------------------------------------------------------------------*/
/* Return Code values                                                 */
/*--------------------------------------------------------------------*/
#define  RC_OK                                     0
#define  RC_END_OF_FILE                            4
#define  RC_TERMINATION_ERROR                      8

#define  RC_NO_ATTRIBUTES_DEFINED                121

/*--------------------------------------------------------------------*/
/* Datastream item identifiers for Digital Library library services   */
/*--------------------------------------------------------------------*/
#define  ID_LIBI          45           /* Library access information  */
                                       /* -- library identifier LIBNAM*/
                                       /* -- user_id            UID   */
                                       /* -- password           PWD   */
#define  ID_NLS         620            /* language support            */
#define  ID_DICT        630            /* dictionary type             */
#define     DICT_GENERAL     0x00      /* -- general dictionary       */
#define     DICT_SYNONYMS    0x08      /* -- common synonyms          */
#define     DICT_STOPWORDS   0x09      /* -- common stopwords         */
#define     DICT_ABBR        0x0A      /* -- common abbreviations     */
#define     DICT_X_STOPWORDS 0x19      /* -- index-specific stopwords */
#define  ID_ADDST       640            /* stopword to be added        */
#define  ID_REMST       650            /* stopword to be removed      */
#define  ID_SWT         670            /* stopword table word list    */
/*--------------------------------------------------------------------*/
/* Datastream item identifiers                                        */
/*--------------------------------------------------------------------*/
#define  ID_DGNAM     1001          /* Document group name            */
#define  ID_DOCF      1011          /* Document format                */
#define  ID_DSID      1012          /* Document index status          */

#define  ID_DNFND     1021          /* Document not found             */
#define  ID_DNACC     1022          /* Document curr. not accessible  */
#define  ID_DACCD     1023          /* Document access denied         */
#define  ID_DAERR     1024          /* Document access error          */

#define  ID_DGNFND    1031          /* Document group not found       */
#define  ID_DGNACC    1032          /* Document group curr. not acc.  */
#define  ID_DGACCD    1033          /* Document group access denied   */
#define  ID_DGAERR    1034          /* Document group access error    */

#define  ID_DTRQ      1101          /* Date-time requested            */
#define  ID_DTLM      1102          /* Date-time last modified        */
#define  ID_DTDL      1103          /* Date-time deleted              */
#define  ID_DTIM      1104          /* Date-time timestamp            */

#define  ID_ATID      1301          /* Attribute identifier           */
#define  ID_AVAL       460          /* Attribute value                */

/*--------------------------------------------------------------------*/
/* Document index status identifiers                                  */
/*--------------------------------------------------------------------*/
#define  DSID_INDX    1501          /* Index status: indexed          */
#define  DSID_NIDX    1502          /* Index status: not indexed      */
#define  DSID_DERR    1503          /* Index status: document error   */
#define  DSID_DXCL    1504          /* Index status: document excluded*/
#define  DSID_UNQA    1505          /* Index status: unqueue ADD doc. */
#define  DSID_UNQR    1506          /* Index status: unqueue REM doc. */
#define  DSID_NFND    1507          /* Index status: document notfound*/
#define  DSID_NACC    1508          /* Index status: doc notaccessible*/

/*--------------------------------------------------------------------*/
/* Attribute identifiers                                              */
/*--------------------------------------------------------------------*/
#define  ATID_DESC   "\x44\x53"     /* Attribute id: DS - description */
#define  ATID_DTIME  "\x44\x54"     /* Attribute id: DT - date-time   */
#define  ATID_LOC    "\x4c\x4f"     /* Attribute id: LO - location    */
#define  ATID_NAME   "\x4e\x4d"     /* Attribute id: NM - name        */

/*--------------------------------------------------------------------*/
/* Document format identifiers                                        */
/*--------------------------------------------------------------------*/
//
//   Supported Formats:
//
#define  FFT              0x0002    /* DCA:FFT                        */
#define  RFT              0x000B    /* DCA:RFT/E                      */
#define  TDS              0x000E    /* IBM PC Flat ASCII              */
#define  ASCIISECTION     0x0010    /* Flat ASCII with Section Support*/

#define  WP5              0x1001    /* WordPerfect 5.x                */
#define  MSWORD           0x1002    /* MS Word                        */
#define  ECTF             0x1003    /* IBM SearchManager/370          */
                                    /* ECTF, codepage 850             */
#define  RTF              0x1004    /* Rich text format (RTF)         */
#define  DSTF             0x1005    /* Own datastream text format     */
#define  AMI              0x1006    /* Lotus Ami Pro Version 4        */
#define  IBMWORKS         0x1007    /* IBM Works / Legato             */
#define  STARWRITER       0x1008    /* Star Writer v1/v2              */
#define  DESCRIBE         0x1009    /* DeScribe 4.0 or higher         */
#define  HTML             0x1042    /* HTML format                    */
#define  XML              0x1043    /* XML format                     */

/*--------------------------------------------------------------------*/
/* The EHW_USER_FORMATS defines the starting value of your own        */
/* document formats when the user exit is active. For all values      */
/* greater than EHW_USER_FORMATS, the user exit is called.            */
/* All values lower than EHW_USER_FORMATS are reserved.               */
/*--------------------------------------------------------------------*/

#define  EHW_USER_FORMATS 0x2000

/*--------------------------------------------------------------------*/
/* Date/time format                                                   */
/*--------------------------------------------------------------------*/
typedef unsigned char LS_DATIME[8]; /* LS date-time field in binary   */
                                    /*    format:   YYMDHmsh          */
                                    /*                                */
                                    /* where YY        = year         */
                                    /*       M         = month        */
                                    /*       D         = day          */
                                    /*       H         = hour         */
                                    /*       m         = minute       */
                                    /*       s         = second       */
                                    /*       h         = 1/100 second */
                                    /*                                */
                                    /* X'0000000000000000' if not     */
                                    /*   existing                     */

/*--------------------------------------------------------------------*/
/* Lengths and constants                                              */
/*--------------------------------------------------------------------*/
#define  LEN_DIAGNOSIS_INFO  16     /* length of diagnostic info      */
                                    /* returned by services           */

                                    /* LIBRARY (used when scope of    */
                                    /*          LIB_list_doc_groups   */
                                    /*          is entire library)    */
#define  LIBRARY   "\xff\xff\xff\xff"

#endif                              /* end of include switch          */

