/*====================================================================*/
/*  Name:     IMOLANG.H      (Languages and CCSIDs - definitions)     */
/*====================================================================*/
/*                                                                    */
/*  Licensed Materials - Property of IBM                              */
/*                                                                    */
/*  5765-IMT (C) Copyright IBM Corporation 1997, 1998                 */
/*                                                                    */
/*  All rights reserved.                                              */
/*  US Government Users Restricted Rights -                           */
/*  Use, duplication or disclosure restricted by GSA ADP              */
/*  Schedule Contract with IBM Corporation.                           */
/*                                                                    */
/*  See Copyright Instructions.                                       */
/*                                                                    */
/*====================================================================*/
/*                                                                    */
/* Permission Notice                                                  */
/*                                                                    */
/* Permission is granted to copy, use, modify, and merge this         */
/* software into your applications and to permit others to do any of  */
/* the foregoing.                                                     */
/* You may further distribute these object classes for commercial     */
/* purposes only as part of your application that adds significant    */
/* value and function beyond that provided by these object classes.   */
/* You must include this permission statement and retain the          */
/* copyright notice in all copies and modified versions of this       */
/* software.                                                          */
/*                                                                    */
/*====================================================================*/

#if !defined(IMOLANG_DEFINED)          /* already included  ?         */
#define IMOLANG_DEFINED                /* no !                        */

/*--------------------------------------------------------------------*/
/*  Coded Character Set Identifiers                                   */
/*--------------------------------------------------------------------*/
/*  For further information, see:                                     */
/*  Character Data Representation Architecture - Level 1, Reference   */
/*  Character Data Representation Architecture - Level 1, Registry    */
/*--------------------------------------------------------------------*/
/*  SAA CCSIDs for Latin-1 countries (character set 697):             */
#define  CCSID_00037      37           /* CECP: USA, CND, and others  */
#define  CCSID_00273     273           /* CECP: Austria, Germany      */
#define  CCSID_00277     277           /* CECP: Denmark, Norway       */
#define  CCSID_00278     278           /* CECP: Finland, Sweden       */
#define  CCSID_00280     280           /* CECP: Italy                 */
#define  CCSID_00284     284           /* CECP: Spain, Latin America  */
#define  CCSID_00285     285           /* CECP: United Kingdom        */
#define  CCSID_00297     297           /* CECP: France                */
#define  CCSID_00500     500           /* CECP: International Latin-1 */
#define  CCSID_00871     871           /* CECP: Iceland               */
#define  CCSID_04946    4946           /* PC Data-190: Latin-1 =CP850 */
#define  CCSID_00819     819           /* ISO 8859-1:  Latin-1        */
/*--------------------------------------------------------------------*/
/*  SAA CCSID  for Japanese:                                          */
#define  CCSID_00932     932           /* Combined Japanese SBCS/DBCS */
#define  CCSID_00942     942           /* Combined Japanese SBCS/DBCS */
#define  CCSID_00943     943           /* Combined Japanese SBCS/DBCS */
#define  CCSID_05039    5039           /* Combined Japanese SBCS/DBCS */
#define  CCSID_00954     954           /* Japanese EUC                */
/*  only for EBCDIC platforms:                                        */
#define  CCSID_05026    5026           /* Japanese Katakana (EBCDIC)  */
/*   use CCSID_05026 instead of CCSID 930                             */
#define  CCSID_05035    5035           /* Japanese Latin    (EBCDIC)  */
/*   use CCSID_05035 instead of CCSID 939                             */

/*  SAA CCSID  for Traditional Chinese:                               */
#define  CCSID_00948     948           /* Combined Trad. C. SBCS/DBCS */
#define  CCSID_00950     950           /* Combined Trad. C. SBCS/DBCS */
#define  CCSID_00964     964           /* Traditional Chinise EUC     */
/*  only for EBCDIC platforms:                                        */
#define  CCSID_00937     937           /* Traditional Chinise (EBCDIC)*/

/*  SAA CCSID  for Simplified Chinese:                                */
#define  CCSID_01381    1381           /* Combined Simpl.C. SBCS/DBCS */
#define  CCSID_01383    1383           /* Simple Chinese EUC          */
#define  CCSID_01386    1386           /* Simple Chinese PC Data      */
/*  only for EBCDIC platforms:                                        */
#define  CCSID_01388    1388           /* Simple Chinese (EBCDIC)     */
/*   use CCSID_01388 instead of CCSID 935                             */
#define  CCSID_00935     935           /* Simple Chinese (EBCDIC)     */

/*  SAA CCSID  for Korean:                                            */
#define  CCSID_00949     949           /* Combined Korean   SBCS/DBCS */
#define  CCSID_00970     970           /* Korean EUC                  */
#define  CCSID_01363    1363           /* Combined Korean   SBCS/DBCS */
#define  CCSID_00933     933           /* Korean (EBCDIC)             */
/*--------------------------------------------------------------------*/
/*  selected Migration/Coexistence CCSIDs for Latin-1 countries:      */
#define  CCSID_00437     437           /* PC Data-222; PC Base: USA ..*/
#define  CCSID_00850     850           /* PC Data; MLP 222: Latin-1   */
#define  CCSID_00860     860           /* PC Data: Portugal           */
#define  CCSID_00861     861           /* PC Data: Iceland            */
#define  CCSID_00863     863           /* PC Data: Canada             */
#define  CCSID_00865     865           /* PC Data: Denmark, Norway    */
/*--------------------------------------------------------------------*/
/*  CCSIDs for Cyrillic:                                              */
#define  CCSID_00866      866           /* PC Data: Cyrillic          */
#define  CCSID_00878      878           /* Cyrillic Internet          */
#define  CCSID_00915      915           /* AIX Data: Cyrillic         */
#define  CCSID_01025      1025          /* EBCDIC Cyrillic            */
#define  CCSID_01251      1251          /* Win Cyrillic (Euro enabled)*/
#define  CCSID_00855      855           /* Bulgarian - PC             */
/*--------------------------------------------------------------------*/
/*  CCSIDs for Arabic:                                                */
#define  CCSID_01256     1256           /* Win Arabic (Euro enabled)  */
#define  CCSID_00864      864           /* PC Data: Arabic            */
#define  CCSID_00420      420           /* Host: Arabic               */
#define  CCSID_01089     1089           /* AIX: Arabic                */
#define  CCSID_01046     1046           /* AIX: Arabic                */
/*--------------------------------------------------------------------*/
/*  CCSIDs for Hebrew:                                                */
#define  CCSID_01255     1255           /* Win Hebrew (Euro enabled)  */
#define  CCSID_00862      862           /* PC Data: Hebrew            */
#define  CCSID_00424      424           /* Host: Hebrew               */
#define  CCSID_00916      916           /* AIX: Hebrew (iso 8859/8)   */
/*--------------------------------------------------------------------*/
/*  CCSIDs for Thai:                                                  */
#define  CCSID_00874      874           /* PC Data: Thai              */
#define  CCSID_00838      838           /* Host: Thai                 */
/*--------------------------------------------------------------------*/
/*  CCSIDs for codepages containing the EURO symbol:                  */
#define  CCSID_00923     923            /* ISO 8859-15: Latin-9       */
#define  CCSID_00924     924            /* same as 923 but on EBCDIC  */
#define  CCSID_00858     858            /* modified 850               */
#define  CCSID_01252    1252            /* Microsoft Windows US ANSI  */
/*--------------------------------------------------------------------*/
/*  CCSIDs for East-European languages:                               */
#define  CCSID_00852     852            /* Latin 2 - Personal Computer*/
#define  CCSID_00870     870            /* Latin 2 - EBCDIC Multiling.*/
#define  CCSID_00912     912            /* Latin 2 - ISO              */
#define  CCSID_01250    1250            /* Latin 2 - Windows          */
#define  CCSID_01112    1112            /* Latvian - EBCDIC           */
#define  CCSID_00921     921            /* Latvian - PC/AIX           */
/*--------------------------------------------------------------------*/
/*  CCSIDs for Turkish:                                               */
#define  CCSID_00857     857            /* Turkish - Personal Computer*/
#define  CCSID_00920     920            /* Turkish - ISO8859-9        */
#define  CCSID_01026    1026            /* Turkish - EBCDIC Multiling.*/
#define  CCSID_01254    1254            /* Turkish - Windows          */
/*--------------------------------------------------------------------*/
/*  CCSIDs for Greek:                                                 */
#define  CCSID_00869     869            /* Greek - Personal Computer  */
#define  CCSID_00813     813            /* Greek - ISO8859-7          */
#define  CCSID_00875     875            /* Greek - EBCDIC Multiling.  */
#define  CCSID_01253    1253            /* Greek - Windows            */
/*--------------------------------------------------------------------*/
/*  CCSIDs for Estonian:                                              */
#define  CCSID_00922     922            /* Estonian - PC/AIX          */
#define  CCSID_01122    1122            /* Estonian - EBCDIC          */
#define  CCSID_01257    1257            /* Estonian - Windows         */
/*--------------------------------------------------------------------*/
/*  CCSIDs for Ukrainian:                                             */
#define  CCSID_01124    1124            /* Ukrainian - AIX            */
#define  CCSID_01125    1125            /* Ukrainian - PC             */
#define  CCSID_01123    1123            /* Ukrainian - EBCDIC         */
/*--------------------------------------------------------------------*/
/*  CCSIDs for Vietnamese:                                            */
#define  CCSID_01129    1129            /* Vietnamese - AIX           */
#define  CCSID_01130    1130            /* Vietnamese - EBCDIC        */
#define  CCSID_01258    1258            /* Vietnamese - Windows       */
/*--------------------------------------------------------------------*/
/*  CCSIDs for Belorussian:                                           */
#define  CCSID_01131    1131            /* Belorussian - PC           */
/*--------------------------------------------------------------------*/
/*  CCSIDs for Hindi:                                                 */
#define  CCSID_00806     806            /* Hindi                      */

/*--------------------------------------------------------------------*/
#define  CCSID_13488    13488           /* Unicode UCS2               */
#define  CCSID_01208     1208           /* Unicode UTF8               */
/*--------------------------------------------------------------------*/

/*--------------------------------------------------------------------*/
/*  Language Identifiers ISO Notation                                 */
/*--------------------------------------------------------------------*/
/*--------------------------------------------------------------------*/
/*  Group 1 Languages                                                 */
/*--------------------------------------------------------------------*/
#define LANG_EN_US      6011           /* English / U.S.              */
#define LANG_EN_GB      5997           /* English / U.K.              */
#define LANG_EN_ZA      6009           /* English / South Africa      */
#define LANG_EN_AU      5991           /* English / Australia         */
#define LANG_EN_BE      5992           /* English / Belgium           */
#define LANG_FR_FR      7011           /* French / France             */
#define LANG_FR_BE      7012           /* French / Belgium            */
#define LANG_FR_CA      7013           /* French / Canada             */
#define LANG_FR_CH      7029           /* French / Switzerland        */
#define LANG_DE_DE      4841           /* German / Germany            */
#define LANG_DE_CH      4839           /* German / Switzerland        */
#define LANG_IT_IT      9771           /* Italian / Italy             */
#define LANG_IT_CH      9789           /* Italian / Switzerland       */
#define LANG_PT_BR     16072           /* Portugese / Brazil          */
#define LANG_ES_ES      6156           /* Spanish / Spain             */
#define LANG_ZH_CN      4029           /* Chinese / PRC (Simplified)  */
#define LANG_ZH_TW      4030           /* Chinese / ROC (Taiwan, Tra.)*/
#define LANG_JA_JP     10564           /* Japanese / Japan            */
#define LANG_KO_KR     11438           /* Korean / Korea              */

/*--------------------------------------------------------------------*/
/*  Group 2 Languages                                                 */
/*--------------------------------------------------------------------*/
#define LANG_AR_AA      2511           /* Arabic / Arabic Speaking    */
#define LANG_CS_CZ      4365           /* Czech / Czech Republic      */
#define LANG_NL_NL     14034           /* Dutch / Netherlands         */
#define LANG_NL_BE     14032           /* Dutch / Belgium             */
#define LANG_DA_DK      4714           /* Danish / Denmark            */
#define LANG_FI_FI      6754           /* Finnish / Finland           */
#define LANG_EL_GR      5942           /* Greek / Greece              */
#define LANG_IW_IL      8422           /* Hebrew / Israel             */
#define LANG_HU_HU      8914           /* Hungarian / Hungary         */
#define LANG_NO_NO     14138           /* Norwegian / Norway          */
#define LANG_PL_PL     15840           /* Polish / Poland             */
#define LANG_PT_PT     16077           /* Portuguese / Portugal       */
#define LANG_RU_RU     17919           /* Russian / Russia            */
#define LANG_SV_SE     18835           /* Swedish / Sweden            */
#define LANG_TR_TR     19621           /* Turkish / Turkey            */

/*--------------------------------------------------------------------*/
/*  Group 3 Languages                                                 */
/*--------------------------------------------------------------------*/
#define LANG_SQ_AL     18689           /* Albanian / Albania          */
#define LANG_BE_BY      3032           /* Belorussian / Belarus       */
#define LANG_BG_BG      3098           /* Bulgarian / Bulgaria        */
#define LANG_CA_ES      3820           /* Catalan / Spain             */
#define LANG_HR_HR      8832           /* Croatian / Croatia          */
#define LANG_ET_EE      6194           /* Estonian / Estonia          */
#define LANG_LV_LV     12554           /* Latvian / Latvia            */
#define LANG_LT_LT     12494           /* Lithuanian / Lithuania      */
#define LANG_MK_MK     13104           /* Macedonian / FYR Macedonia  */
#define LANG_RO_RO     17733           /* Romanian / Romania          */
#define LANG_SR_SP     18712           /* Serbian (Cyrillic) / Serbia */
#define LANG_SH_SP     18722           /* Serbian (Latin) / Serbia    */
#define LANG_SK_SK     18525           /* Slovak / Slovakia           */
#define LANG_SL_SI     18545           /* Slovenian / Slovenia        */
#define LANG_TH_TH     19311           /* Thai / Thailand             */
#define LANG_UK_UA     20318           /* Ukrainian / Ukraine         */
#define LANG_VI_VN     21164           /* Vietnamese / Vietnam        */

/*--------------------------------------------------------------------*/
/*  Group 4 Languages                                                 */
/*--------------------------------------------------------------------*/
#define LANG_HI_IN      8554           /* Hindi / India               */

/*--------------------------------------------------------------------*/
/*  Other Languages                                                   */
/*--------------------------------------------------------------------*/
#define LANG_IS_IS      9752           /* Icelandic                   */
#define LANG_NO_BOK    14122           /* Norwegian - Bokmal          */
#define LANG_NO_NYN    14134           /* Norwegian - Nynorsk         */






/*--------------------------------------------------------------------*/
/*  Old Language Identifiers (for compatability reasons)              */
/*--------------------------------------------------------------------*/
#define LANG_ARB        LANG_AR_AA     /* Arabic                      */
#define LANG_CAT        LANG_CA_ES     /* Catalan                     */
#define LANG_CHS        LANG_ZH_CN     /* Simplified Chinese          */
#define LANG_CHT        LANG_ZH_TW     /* Traditional Chinese         */
#define LANG_DAN        LANG_DA_DK     /* Danish                      */
#define LANG_DEU        LANG_DE_DE     /* German                      */
#define LANG_DES        LANG_DE_CH     /* Swiss German                */
#define LANG_ENG        LANG_EN_GB     /* UK English                  */
#define LANG_ENU        LANG_EN_US     /* US English                  */
#define LANG_ESP        LANG_ES_ES     /* Spanish                     */
#define LANG_FIN        LANG_FI_FI     /* Finnish                     */
#define LANG_FRA        LANG_FR_FR     /* French                      */
#define LANG_FRC        LANG_FR_CA     /* Canadian French             */
#define LANG_HBR        LANG_IW_IL     /* Hebrew                      */
#define LANG_ISL        LANG_IS_IS     /* Icelandic                   */
#define LANG_ITA        LANG_IT_IT     /* Italian                     */
#define LANG_JAP        LANG_JA_JP     /* Japanese                    */
#define LANG_KOR        LANG_KO_KR     /* Korean                      */
#define LANG_NLD        LANG_NL_NL     /* Dutch                       */
#define LANG_NOB        LANG_NO_BOK    /* Norwegian - Bokmal          */
#define LANG_NON        LANG_NO_NYN    /* Norwegian - Nynorsk         */
#define LANG_NOR        LANG_NO_NO     /* Norwegian - both            */
#define LANG_PTG        LANG_PT_PT     /* Portuguese                  */
#define LANG_PTB        LANG_PT_BR     /* Brazilian Portuguese        */
#define LANG_RUS        LANG_RU_RU     /* Russian                     */
#define LANG_SVE        LANG_SV_SE     /* Swedish                     */
#define LANG_THA        LANG_TH_TH     /* Thai                        */
#define LANG_CZE        LANG_CS_CZ     /* Czech                       */
#define LANG_HUN        LANG_HU_HU     /* Hungarian                   */
#define LANG_POL        LANG_PL_PL     /* Polish                      */
#define LANG_SLK        LANG_SK_SK     /* Slovak                      */
#define LANG_TUR        LANG_TR_TR     /* Turkish                     */


#endif                                 /* end of include switch       */

