/*====================================================================*/
/*  Name:     IMOAPIC.H                                               */
/*====================================================================*/
/*                                                                    */
/*  Licensed Materials - Property of IBM                              */
/*                                                                    */
/*  5765-IMT (C) Copyright IBM Corporation  1997, 1998                */
/*                                                                    */
/*  All rights reserved.                                              */
/*  US Government Users Restricted Rights -                           */
/*  Use, duplication or disclosure restricted by GSA ADP              */
/*  Schedule Contract with IBM Corporation.                           */
/*                                                                    */
/*  See Copyright Instructions.                                       */
/*                                                                    */
/*====================================================================*/
/*                                                                    */
/* Permission Notice                                                  */
/*                                                                    */
/* Permission is granted to copy, use, modify, and merge this         */
/* software into your applications and to permit others to do any of  */
/* the foregoing.                                                     */
/* You may further distribute these object classes for commercial     */
/* purposes only as part of your application that adds significant    */
/* value and function beyond that provided by these object classes.   */
/* You must include this permission statement and retain the          */
/* copyright notice in all copies and modified versions of this       */
/* software.                                                          */
/*                                                                    */
/*====================================================================*/

/*====================================================================*/
/*                                                                    */
/*  IBM TextMiner Application Programming Interface                   */
/*  Symbolic names definitions for use in C applications              */
/*                                                                    */
/*====================================================================*/
/* changes:                                                           */
/* p1,11/04/99, bae: add register/deregister Index                    */
/*====================================================================*/

#ifndef imoapic_h
#define imoapic_h

#if !defined(IMOAPIC_DEFINED)          /* already included  ?         */
#define IMOAPIC_DEFINED                /* no !                        */

/*--------------------------------------------------------------------*/
/*  Determine the host architecture                                   */
/*--------------------------------------------------------------------*/

#if defined(_M_I386) || defined(_M_IX86) || defined(i386) || defined (_IA64)
#define EHW_LITTLE_ENDIAN
#endif

#if defined(_M_PPC) || defined(_POWER)             \
 || defined(sparc)  || defined(_HP_UX) || defined(__hpux) \
 || defined (__OS_OE390__) || defined (AS400)
#define EHW_BIG_ENDIAN
#endif

/*--------------------------------------------------------------------*/
/*  Check for consistency                                             */
/*--------------------------------------------------------------------*/

#if  !defined(EHW_BIG_ENDIAN) && !defined(EHW_LITTLE_ENDIAN)
#error Please define host architecture!
#endif

#if  defined(EHW_BIG_ENDIAN) && defined(EHW_LITTLE_ENDIAN)
#error Ooops, something is wrong here!
#endif

/*--------------------------------------------------------------------*/
/*  Return Code values                                                */
/*--------------------------------------------------------------------*/
#define  RC_DONE                             0
#define  RC_CONTINUATION_MODE_ENTERED        1
#define  RC_END_OF_INFORMATION               2
#define  RC_EMPTY_LIST                       3
#define  RC_MORE_INFORMATION                 4
#define  RC_INDEX_GROUP_SEARCH_ERROR         7
#define  RC_INDEX_SPECIFIC_ERROR             8
#define  RC_DICTIONARY_NOT_FOUND             9
#define  RC_STOPWORD_IGNORED                10
#define  RC_PROCESSING_LIMIT_EXCEEDED       12
#define  RC_UNKNOWN_SERVER_NAME             16
#define  RC_INCORRECT_AUTHENTICATION        17
#define  RC_DATASTREAM_SYNTAX_ERROR         18
#define  RC_QUERY_SCOPE_TOO_COMPLEX         20
#define  RC_QUERY_TOO_COMPLEX               22
#define  RC_MEMBER_OF_INDEX_GROUP           23
#define  RC_UNKNOWN_INDEX_NAME              24
#define  RC_INCORRECT_HANDLE                25
#define  RC_INDEX_NOT_MEMBER_OF_GROUP       26
#define  RC_UNKNOWN_SESSION_POINTER         27
#define  RC_UNKNOWN_COMMUNICATION_TYPE      29
#define  RC_UNKNOWN_SERVER_INFORMATION      30
#define  RC_INVALID_MASKING_SYMBOL          31
#define  RC_UNEXPECTED_ERROR                32
#define  RC_SERVER_NOT_AVAILABLE            33
#define  RC_INDEX_ALREADY_OPENED            35
#define  RC_MAX_NUMBER_OF_OPEN_INDEXES      36
#define  RC_MAX_NUMBER_OF_RESULTS           37
#define  RC_INDEX_TO_DEREGISTER             38
#define  RC_CCS_NOT_SUPPORTED               41
#define  RC_LANGUAGE_NOT_SUPPORTED          42
#define  RC_CONFLICT_WITH_INDEX_TYPE        43
#define  RC_MAX_INPUT_SIZE_EXCEEDED         46
#define  RC_SERVER_BUSY                     47
#define  RC_SERVER_CONNECTION_LOST          48
#define  RC_SERVER_IN_ERROR                 49
#define  RC_REQUEST_IN_PROGRESS             50
#define  RC_UNKNOWN_INDEX_TYPE              51
#define  RC_INCORRECT_INDEX_NAME            52
#define  RC_INCORRECT_LS_EXECUTABLES        53
#define  RC_INCORRECT_LIBRARY_ID            54
#define  RC_INDEX_ALREADY_EXISTS            55
#define  RC_MAX_NUMBER_OF_INDEXES           56
#define  RC_INCORRECT_LOCATION              57
#define  RC_LOCATION_IN_USE                 58
#define  RC_UNKNOWN_CONDITION               59
#define  RC_INDEX_DELETED                   60
#define  RC_INDEX_SUSPENDED                 61
#define  RC_INDEX_NOT_ACCESSIBLE            62
#define  RC_MAX_NUMBER_OF_BUSY_INDEXES      63
#define  RC_CONFLICTING_TASK_RUNNING        64
#define  RC_NOT_ENOUGH_MEMORY               65
#define  RC_MAX_OUTPUT_SIZE_EXCEEDED        68
#define  RC_BROWSER_TIME_OUT                69
#define  RC_COMMUNICATION_PROBLEM           70
#define  RC_NO_ACTION_TAKEN                 71
#define  RC_EMPTY_INDEX                     72
#define  RC_EMPTY_QUERY                     73
#define  RC_INSTALLATION_PROBLEM            74
#define  RC_FUNCTION_DISABLED               75
#define  RC_FUNCTION_IN_ERROR               76
#define  RC_IO_PROBLEM                      77
#define  RC_WRITE_TO_DISK_ERROR             78
#define  RC_SERVER_VERSION_NOT_CURRENT      79
#define  RC_FUNCTION_NOT_SUPPORTED          80
#define  RC_RESULT_ALREADY_RANKED           81
#define  RC_RESULT_VIEW_EXISTS              82
#define  RC_INDEX_NOT_OPEN                  83
#define  RC_NO_RANKING_DATA_AVAILABLE       84
#define  RC_LINGUISTIC_SERVICE_FAILED       85
#define  RC_THESAURUS_PROBLEM               86

#define  RC_INVALID_IDENTIFIER              88
#define  RC_DOCUMENT_MODEL_ALREADY_EXISTS   89
#define  RC_UNKNOWN_SECTION_NAME            90
#define  RC_DOCMOD_READ_PROBLEM             91
#define  RC_UNKNOWN_DOCUMENT_MODEL_NAME     92
#define  RC_MISSING_DEFAULT_MODEL           93
#define  RC_SECTION_NAME_ALREADY_EXISTS     94
#define  RC_SECTION_TAG_ALREADY_EXISTS      95

#define  RC_MAX_NUMBER_OF_TASKS             96
#define  RC_LS_NOT_EXECUTABLE               97
#define  RC_LS_FUNCTION_FAILED              98
#define  RC_CAPACITY_LIMIT_EXCEEDED         99
#define  RC_DOCUMENT_NOT_ACCESSIBLE        100
#define  RC_DOCUMENT_CURR_NOT_ACCESSIBLE   101
#define  RC_DOCUMENT_NOT_TO_INDEX          102
#define  RC_DOCUMENT_NOT_FOUND             103
#define  RC_DOCUMENT_IN_ERROR              104
#define  RC_DOCUMENT_NOT_SUPPORTED         105
#define  RC_DOCUMENT_GROUP_NOT_FOUND       111
#define  RC_INVALID_ATTRIBUTE_VALUE        112
#define  RC_INVALID_SECTION_TYPE           113

#define  RC_INCORRECT_RELEVANCE_VALUE      120

#define  RC_NO_RAT_EXPANSION               130
#define  RC_DOCUMENT_NOT_IN_VIEW           131

#define  RC_EMPTY_CLUSTER                  200
#define  RC_CLUSTER_EXISTS                 201
#define  RC_DOC_NOT_CLUSTERED              202
#define  RC_STOPWORDLIST_NOT_ACCESSIBLE    203
#define  RC_CHANGE_SERVER_NOT_ALLOWED      204
/*--------------------------------------------------------------------*/
/*  Item Identifiers                                                  */
/*--------------------------------------------------------------------*/
#define  ID_INAM          5            /* instance name               */
#define  ID_IRS          10            /* IR server info              */
#define  ID_IRSN         11            /* -- server name              */
#define  ID_IRSL         12            /* -- server location          */
#define     IRSL_LOCAL       0x00      /*    -- local                 */
#define     IRSL_REMOTE      0x01      /*    -- remote                */
#define  ID_CTYP         15            /* -- communication type       */
#define     CTYP_PIPES       0x01      /*    -- name pipes            */
#define     CTYP_TCPIP       0x02      /*    -- TCP/IP                */
#define     CTYP_LOCAL       0x03      /*    -- local                 */
#define  ID_IRSID        16            /* -- server identifier        */
#define  ID_APPID        17            /* -- application identifier   */
#define  ID_ATC          20            /* authentication info         */
#define  ID_UID          30            /* -- user_id                  */
#define  ID_PWD          40            /* -- password                 */
#define  ID_IRX          50            /* index information           */
#define  ID_LIBNAM       55            /* library name                */
#define  ID_XNAM         60            /* -- index name               */
#define  ID_XTTL         61            /* -- index title              */
#define  ID_XTYP         62            /* -- index type               */
#define     XTYP_LINGUISTIC  0x01      /*    -- linguistic            */
#define     XTYP_PRECISE     0x03      /*    -- precise               */
#define     XTYP_GTR         0x05      /*    -- DBCS index (GTR)      */
#define  ID_LSCE         63            /* -- LS client executables    */
#define  ID_LSSE         64            /* -- LS server executables    */
#define  ID_LIBID        65            /* -- library identifier       */
#define  ID_XDESC        66            /* -- index description        */
#define  ID_XLOC         67            /* -- index location           */
#define  ID_WLOC         68            /* -- work location            */
#define  ID_XTADD        69            /* -- additional index feature */
#define    XTADD_CASE_ENABLED 0x03     /*    -- case sensitive (GTR)  */
#define    XTADD_NORMALIZED   0x04     /*    -- 8859 index     (NQ)   */
#define  ID_XTPROP       70            /* -- index properties         */
#define   XTPROP_SECTIONS_ENABLED 0x01 /*    -- structured document   */
#define  ID_XCCSID       72            /* -- index codepage (GTR)     */
#define  ID_XFLAG        73            /* -- index status flag        */
#define     XFLAG_READ_WRITE 0x02      /*    -- index active          */
#define     XFLAG_READ_ONLY  0x03      /*    -- suspended but queries */
                                       /*    -- are allowed           */
#define  ID_SCHDOCS      74            /* -- index queue size         */
#define  ID_PDOCS        75            /* -- docs in primary index    */
#define  ID_SDOCS        76            /* -- docs in second. index    */
#define  ID_DOCMSG       77            /* -- indexing messages        */
                                       /* function status items       */
#define  ID_TENBL        81            /* -- Time fct enabled         */
#define  ID_TDSBL        82            /* -- Time fct disabled        */
#define  ID_TSTOP        83            /* -- Time fct stopped         */
#define  ID_TLSTART      84            /* -- Time fct's last  start   */
#define  ID_TLEND        85            /* -- Time fct's last  end     */
#define  ID_TESTART      86            /* -- Time fct's exec  start   */
                                       /* query items:                */
#define  ID_TLIM        101            /* -- time limit               */
#define  ID_RLIM        102            /* -- result limit             */
#define  ID_RANK        103            /* -- rank switch              */
#define  ID_QSS         105            /* -- query scope              */
#define  ID_DID         106            /*    -- document identifier   */
#define  ID_DGID        107            /*    -- document group id.    */
#define  ID_NLID        108            /*    -- national language id  */
#define  ID_CCSID       115            /* -- coded character set id.  */
                                       /*    (see IMOLANG.H for a list*/
                                       /*     of supported CCSIDs)    */
#define  ID_LANG        116            /* -- language identifier      */
                                       /*    (see IMOLANG.H for a list*/
                                       /*     of valid language codes)*/
#define  ID_SUBQ        120            /* -- subquery                 */
#define  ID_AND         130            /* -- Boolean AND              */
#define  ID_LOR         140            /* -- Boolean OR               */
#define  ID_EXCL        151            /* -- Boolean NOT (exclude)    */
#define  ID_DOCP        170            /* -- document proximity       */
#define  ID_PARP        180            /* -- paragraph proximity      */
#define  ID_SENP        190            /* -- sentence proximity       */
#define  ID_SECLST      195            /* -- section name list        */
#define  ID_SECNAM      196            /* -- section name             */
#define  ID_SECTYPE     197            /* -- section type             */
#define     DATE_TYPE        0x01      /*    -- date type             */
#define     TIME_TYPE        0x02      /*    -- time type             */
#define     INTEGER_TYPE     0x03      /*    -- integer type          */
#define     FLOAT_TYPE       0x04      /*    -- float type            */
#define  ID_SARG        200            /* -- search argument (text)   */
#define  ID_TERM        211            /*    -- term (word or phrase) */
#define  ID_FTERM       212            /* -- free text term           */
#define  ID_SYN         221            /*    -- synonym option        */
#define  ID_PREC        222            /*    -- precision             */
#define     PREC_LEMMA_FORMS 0x01      /*       -- inflections        */
#define     PREC_VARY_PHRASE 0x02      /*       -- phrases & compounds*/
#define     PREC_PRECISE     0x03      /*       -- exact matches      */
#define     PREC_EXACT       0x07      /*       -- exact as possible  */
#define     PREC_FUZZY       0x08      /*       -- fuzzy as possible  */
#define  ID_SUBT        223            /*    -- subterm of left term  */

#define  ID_THES        224            /* thesaurus expansion of term */


#define  ID_SOUND       226            /* soundex expansion           */
#define  ID_THESNAME    227            /* thesaurus name              */
#define  ID_THESDEPTH   228            /* depth of thesaurus expansion*/

#define  ID_NOSEQ       230            /* no sequence of words        */
#define  ID_BOUND       232            /* resp. Hanguel word boundary */
#define  ID_CSENS       233            /* case sensitive srch for GTR */
#define  ID_ESTEM       234            /* english stemming srch (GTR) */
#define  ID_INFLECT     235            /* use inflections of word     */

/* defines for attribute search  */
#define  ID_ATTRIB      240            /* block delimiter             */
#define  ID_COND        241            /* comparison specification    */
#define  ID_EQ          242            /* equality                    */
#define  ID_GE          243            /* greater equal               */
#define  ID_LE          244            /* less equal                  */
#define  ID_GT          245            /* greater than                */
#define  ID_LT          246            /* less than                   */


#define  ID_CSM         350            /* -- mask: character sequence */
#define  ID_RCM         360            /* -- mask: required character */
#define  ID_FARG        380            /* -- free text search argument*/
                                       /* document / browse items:    */
#define  ID_DOC         410            /* -- document delimiter       */
#define  ID_DNAM        415            /* -- document name            */
#define  ID_DEL         420            /*   -- doc element delimiter  */
#define  ID_SNAM         80            /*     -- section name         */
#define  ID_PAR         430            /*     -- paragraph delimiter  */
#define  ID_TEXT        440            /*       -- text portion       */
#define  ID_NL          444            /*       -- new line indicator */
#define  ID_LINK        446            /*       -- hypermedia ref     */
#define  ID_MATCH       450            /*       -- hit information    */
#define  ID_SSP         480            /* sort criterion              */
#define  ID_SOA         490            /* -- ascending sort order     */
#define  ID_SOD         500            /* -- descending sort order    */
#define  ID_SFID        502            /* -- sort field identifier    */
#define     SFID_RVAL        0x01      /*    -- sort by rank value    */
#define     SFID_DNAM        0x02      /*    -- sort by document name */
#define     SFID_XNAM        0x04      /*    -- sort by index name    */
#define     SFID_DSIZE       0x08      /*    -- sort by document size */
#define     SFID_RCNT        0x10      /*    -- sort by rank count    */
#define  ID_TSRT        506            /* -- number of top sorted docs*/
#define  ID_RNKT        507            /* -- rank threshold           */
#define  ID_RCTT        508            /* -- rank count threshold     */
                                       /* other items:                */
#define  ID_ADD         510            /* -- doc to be added to index */
#define  ID_REM         520            /* -- doc to be removed from x */
#define  ID_RVAL        536            /* -- rank value               */
#define  ID_RCNT        537            /* -- rank count               */
#define  ID_DSIZE       538            /* -- # of words in document   */
#define  ID_XRC         539            /* -- index specific rc        */
#define  ID_DRELV       540            /* -- relevance value (default)*/
#define  ID_RELV        541            /* -- relevance value (single) */
                                       /*                             */
#define  ID_XMSG        550            /* indexing msg info delimiter */
#define  ID_REASON      551            /* indexing msg reason         */
#define  ID_TSTMP       552            /* time stamp                  */
                                       /* doc information table items */
#define  ID_DFLTRULE    555            /* --- default rule delimiter  */
#define  ID_DFMT        556            /* --- document format         */
#define  ID_DOCMOD      557            /* --- document model          */
#define  ID_MODLST      558            /* --- list of document models */
#define  ID_SECELST     559            /* --- section entry list      */
#define  ID_SECTAG      561            /* --- section tag in a model  */
#define  ID_CASE_IGNORE 562            /* --- case insensitive model  */

#define  ID_DGRP        701
#define  ID_INNODE      702
#define  ID_ICSIM       703
#define  ID_NBCHILD     704
#define  ID_TNBCHILD    705
#define  ID_TITLE       706
#define  ID_LA          707
#define  ID_LEAF        708
#define  ID_LAPROF      711
#define  ID_NBIT        712
#define  ID_NORM        713
#define  ID_FREQ        714
#define  ID_CLCRIT      721
#define  ID_DREG        722            /* deregistration indicator p1*/

/*--------------------------------------------------------------------*/
/*  Item Types                                                        */
/*--------------------------------------------------------------------*/
#define  IT_START       0xE2           /* start item                  */
#define  IT_END         0xC5           /* end item                    */
#define  IT_ATOMIC      0xC1           /* atomic item                 */

/*--------------------------------------------------------------------*/
/*  Coded Character Set Identfiers and Language Identifiers           */
/*--------------------------------------------------------------------*/
#include "imolang.h"                   /* CCSID/language definitions  */

/*--------------------------------------------------------------------*/
/*  Processing Conditions                                             */
/*--------------------------------------------------------------------*/
                                       /* get document text and hits  */
#define  MATCH_FAST             0      /* -- without dictionary       */
#define  MATCH_EXTENDED         1      /* -- use dictionary           */
                                       /* function identifiers        */
#define  FCT_SEARCH_INDEX       1      /* -- search index             */
#define  FCT_SCHEDULE_DOCUMENTS 2      /* -- schedule docs            */
#define  FCT_INDEX_DOCUMENTS    3      /* -- index documents          */
#define  FCT_MERGE_INDEX        4      /* -- reorganise index         */
                                       /* status actions              */
#define  ACT_ENABLE             1      /* -- enable function          */
#define  ACT_DISABLE            2      /* -- disable function         */
#define  ACT_RESET              3      /* -- reset fct in error       */

#define  SUSP_ALL            0         /* -- all requests             */
#define  SUSP_EXCEPT_SEARCH  1         /* -- all except search        */



/*--------------------------------------------------------------------*/
/*  Structure of Datastream Item                                      */
/*--------------------------------------------------------------------*/
struct Data_Item                       /* Datastream Item             */
  {
  unsigned short        ll;            /* -- item length              */
  unsigned short        id;            /* -- item identifier          */
  unsigned char         it;            /* -- item type                */
  unsigned char         value[1];      /* -- item value (if any)      */
  };

/*--------------------------------------------------------------------*/
/*  Macro Definitions for datastream item length, id, value (2 bytes) */
/*--------------------------------------------------------------------*/

#if defined(EHW_LITTLE_ENDIAN)

#define  VAL2(ptr)   (unsigned short )                                 \
                     (((((const unsigned char *)(ptr))[0]) << 8) +     \
                        ((const unsigned char *)(ptr))[1])

#define  VAL4(ptr)   (((((unsigned long)                               \
                        (((const unsigned char *)(ptr))[0])  << 8) +   \
                        ((((const unsigned char *)(ptr))[1])) << 8) +  \
                        ((((const unsigned char *)(ptr))[2])) << 8) +  \
                          ((const unsigned char *)(ptr))[3])

#define  ID(id)      ((unsigned short )(((id) - (unsigned short )      \
                     (((id) / 256) * 256)) * 256) + ((id) / 256))

#else    /* EHW_BIG_ENDIAN */

#if defined( _HP_UX)
#define  VAL2(ptr)   (unsigned short )                               \
                     (((unsigned char *)(ptr))[0]  * 256 +           \
                      ((unsigned char *)(ptr))[1] )

#define  VAL4(ptr)   (unsigned long )                                \
                     (((((unsigned char *)(ptr))[0]  * 256L +        \
                        ((unsigned char *)(ptr))[1]) * 256L +        \
                        ((unsigned char *)(ptr))[2]) * 256L +        \
                        ((unsigned char *)(ptr))[3])
#else
#define  VAL2(ptr)   (*(unsigned short *)(ptr))

#define  VAL4(ptr)   (*(unsigned long *)(ptr))
#endif

#define  ID(id)      (id)

#endif

/*--------------------------------------------------------------------*/
/*  API Services - parameter definitions                              */
/*--------------------------------------------------------------------*/
#define  HDL_NULL         0            /* null handle                 */

/*--------------------------------------------------------------------*/
/*  API Services - calling conventions                                */
/*--------------------------------------------------------------------*/
#if defined(__WINDOWS__) || defined(_WIN32)
   #if defined(_WIN32)
      #define  APICALL                 __cdecl
   #else
      #define  APICALL                 FAR PASCAL
   #endif
#elif defined(__UNIX__) || defined(_AIX) || defined(_HP_UX) || defined(__SOLARIS__) \
       || defined(AS400) || defined(__USLC__)
#define  APICALL
#else
#define  APICALL                    _System
#endif

/*--------------------------------------------------------------------*/
/*  API Services - mapping of external names to uppercase             */
/*--------------------------------------------------------------------*/
#define  EhwAddQueryScope              EHWADDQUERYSCOPE
#define  EhwAssignRelevance            EHWASSIGNRELEVANCE
#define  EhwBrowseDocument             EHWBROWSEDOCUMENT
#define  EhwCancelContinuation         EHWCANCELCONTINUATION
#define  EhwClearIndex                 EHWCLEARINDEX
#define  EhwClearScheduledDocuments    EHWCLEARSCHEDULEDDOCUMENTS
#define  EhwCloseDocument              EHWCLOSEDOCUMENT
#define  EhwCloseIndex                 EHWCLOSEINDEX
#define  EhwClusterResultView          EHWCLUSTERRESULTVIEW
#define  EhwCreateDocumentModel        EHWCREATEDOCUMENTMODEL
#define  EhwCreateIndex                EHWCREATEINDEX
#define  EhwCreateIndexGroup           EHWCREATEINDEXGROUP
#define  EhwCreateResultView           EHWCREATERESULTVIEW
#define  EhwDelIndexingMsgs            EHWDELINDEXINGMSGS
#define  EhwDeleteCluster              EHWDELETECLUSTER
#define  EhwDeleteDocumentModel        EHWDELETEDOCUMENTMODEL
#define  EhwDeleteIndex                EHWDELETEINDEX
#define  EhwDeleteIndexGroup           EHWDELETEINDEXGROUP
#define  EhwDeleteResult               EHWDELETERESULT
#define  EhwDeleteResultView           EHWDELETERESULTVIEW
#define  EhwRegisterIndex              EHWREGISTERINDEX
#define  EhwDeregisterIndex            EHWDEREGISTERINDEX
#define  EhwEndBrowseSession           EHWENDBROWSESESSION
#define  EhwEndSession                 EHWENDSESSION
#define  EhwGetBrowseData              EHWGETBROWSEDATA
#define  EhwGetCluster                 EHWGETCLUSTER
#define  EhwGetDefaultDocumentModel    EHWGETDEFAULTDOCUMENTMODEL
#define  EhwGetDocumentModel           EHWGETDOCUMENTMODEL
#define  EhwGetIndexingMsgs            EHWGETINDEXINGMSGS
#define  EhwGetIndexingRules           EHWGETINDEXINGRULES
#define  EhwGetIndexFunctionStatus     EHWGETINDEXFUNCTIONSTATUS
#define  EhwGetIndexInfo               EHWGETINDEXINFO
#define  EhwGetIndexStatus             EHWGETINDEXSTATUS
#define  EhwGetMatches                 EHWGETMATCHES
#define  EhwGetProblemInfo             EHWGETPROBLEMINFO
#define  EhwGetProfile                 EHWGETPROFILE
#define  EhwGetResultView              EHWGETRESULTVIEW
#define  EhwGetSimilarDocuments        EHWGETSIMILARDOCUMENTS
#define  EhwListDocumentModels         EHWLISTDOCUMENTMODELS
#define  EhwListIndexes                EHWLISTINDEXES
#define  EhwListResult                 EHWLISTRESULT
#define  EhwListServers                EHWLISTSERVERS
#define  EhwNarrowQuery                EHWNARROWQUERY
#define  EhwOpenDocument               EHWOPENDOCUMENT
#define  EhwOpenIndex                  EHWOPENINDEX
#define  EhwRank                       EHWRANK
#define  EhwReorgIndex                 EHWREORGINDEX
#define  EhwResumeIndex                EHWRESUMEINDEX
#define  EhwScheduleDocument           EHWSCHEDULEDOCUMENT
#define  EhwSelectResultView           EHWSELECTRESULTVIEW
#define  EhwSearch                     EHWSEARCH
#define  EhwSetDefaultDocumentModel    EHWSETDEFAULTMDOCUMENTODEL
#define  EhwSetIndexingRules           EHWSETINDEXINGRULES
#define  EhwSetIndexFunctionStatus     EHWSETINDEXFUNCTIONSTATUS
#define  EhwSort                       EHWSORT
#define  EhwStartBrowseSession         EHWSTARTBROWSESESSION
#define  EhwStartSession               EHWSTARTSESSION
#define  EhwStopServer                 EHWSTOPSERVER
#define  EhwSuspendIndex               EHWSUSPENDINDEX
#define  EhwUpdateIndex                EHWUPDATEINDEX

#define  EhwCreateResultList           EHWCREATERESULTVIEW
#define  EhwDeleteResultList           EHWDELETERESULTVIEW
#define  EhwGetResultList              EHWGETRESULTVIEW
#define  EhwSelectResultList           EHWSELECTRESULTVIEW

#define  RC_RESULT_LIST_EXISTS         RC_RESULT_VIEW_EXISTS
/*--------------------------------------------------------------------*/
/*  API Services - prototype statements                               */
/*--------------------------------------------------------------------*/
#ifdef  __cplusplus
extern "C"
{
#endif

unsigned long
APICALL  EhwAddQueryScope              /* Add Query scope             */
  (
  void             * pSession,         /* In  -- session pointer      */
  unsigned long      ulIndexGrHandle,  /* In  -- index group handle   */
  unsigned long      ulDataLength,     /* Out -- datastream length    */
  char             * pDataStream,      /* Out -- document text        */
  unsigned long    * pulDiagnosisInfo  /* Out -- diagnosis info       */
  );                                   /* function value: return code */

unsigned long
APICALL  EhwAssignRelevance           /* Assign a relevance value to a  */
                                      /* document or result list        */
  (
    void               *pvSession,       /* In  -- session pointer      */
    unsigned long      ulHandle,         /* In  -- handle resultview/doc*/
    unsigned long      ulDataLength,     /* In  -- ds length (bytes)    */
    char               *pDataStream,     /* In  -- pointer to ds        */
    unsigned long      *pDiagInfo        /* Out -- diagnosis info.      */
  );

unsigned long
APICALL  EhwBrowseDocument             /* Browse Document             */
  (
  void             * pSession,         /* In  -- session pointer      */
  unsigned long      ulResultHandle,   /* In  -- result handle        */
  unsigned long      ulLanguageId,     /* In  -- language identifier  */
  unsigned long      ulDataLength,     /* In  -- datastream length    */
  char             * pDataStream,      /* In  -- browse specifications*/
  unsigned long    * pulWindowHandle,  /* In/Out window handle        */
  unsigned long    * pulDiagnosisInfo  /* Out -- diagnosis info       */
  );                                   /* function value: return code */

unsigned long
APICALL  EhwCancelContinuation         /* Cancel Continuation Mode    */
  (
  void             * pSession,         /* In  -- session pointer      */
  unsigned long    * pulDiagnosisInfo  /* Out -- diagnosis info       */
  );                                   /* function value: return code */

unsigned long
APICALL  EhwClearIndex                 /* Clear Index                 */
  (
  void             * pSession,         /* In  -- session pointer      */
  unsigned long      ulIndexHandle,    /* In  -- index handle         */
  unsigned long    * pulDiagnosisInfo  /* Out -- diagnosis info       */
  );                                   /* function value: return code */

unsigned long
APICALL  EhwClearScheduledDocuments    /* Clear scheduled documents   */
  (
  void             * pSession,         /* In  -- session pointer      */
  unsigned long      ulIndexHandle,    /* In  -- index handle         */
  unsigned long    * pulDiagnosisInfo  /* Out -- diagnosis info       */
  );                                   /* function value: return code */

unsigned long
APICALL  EhwCloseDocument              /* Close Document              */
  (
  void             * pSession,         /* In  -- session pointer      */
  unsigned long      ulDocumentHandle, /* In  -- document handle      */
  unsigned long    * pulDiagnosisInfo  /* Out -- diagnosis info       */
  );                                   /* function value: return code */

unsigned long
APICALL  EhwCloseIndex                 /* Close Index                 */
  (
  void             * pSession,         /* In  -- session pointer      */
  unsigned long      ulIndexHandle,    /* In  -- index handle         */
  unsigned long    * pulDiagnosisInfo  /* Out -- diagnosis info       */
  );                                   /* function value: return code */

unsigned long
APICALL  EhwClusterResultView          /* Cluster Result View         */
  (
  void             * pSession,         /* In  -- session pointer      */
  unsigned long      ulRViewHandle,    /* In  -- result view handle   */
  unsigned long    * pulDiagnosisInfo  /* Out -- diagnosis info       */
  );                                   /* function value: return code */

unsigned long
APICALL  EhwCreateDocumentModel        /* Create a new Document Model */
  (
  void             *session_ptr,       /* In  -- session pointer      */
  unsigned long    ulIndexHandle,      /* In  -- index_handle         */
  unsigned long    ulDataLength,       /* In  -- length of datastream */
  char             *pDataStream,       /* In  -- datastream           */
  unsigned long    *pulDiagnosisInfo   /* Out -- diagnosis info       */
  );                                   /* function value: return_code */

unsigned long
APICALL  EhwCreateIndex                /* Create Index                */
  (
  void             * pSession,         /* In  -- session pointer      */
  unsigned long      ulDataLength,     /* In  -- datastream length    */
  char             * pDataStream,      /* In  -- index information    */
  unsigned long    * pulDiagnosisInfo  /* Out -- diagnosis info       */
  );                                   /* function value: return code */

unsigned long
APICALL  EhwRegisterIndex              /* Register Index              */
  (
  void             * pSession,         /* In  -- session pointer      */
  unsigned long      ulDataLength,     /* In  -- datastream length    */
  char             * pDataStream,      /* In  -- index information    */
  unsigned long    * pulDataLength,    /* Out -- datastream length    */
  char            ** ppDataStream,     /* Out -- index name           */
  unsigned long    * pulDiagnosisInfo  /* Out -- diagnosis info       */
  );                                   /* function value: return code */

unsigned long
APICALL  EhwCreateIndexGroup           /* Create Index Group          */
  (
  void             * pSession,         /* In  -- session pointer      */
  unsigned long      ulDataLength,     /* In  -- datastream length    */
  char             * pDataStream,      /* In  -- index information    */
  unsigned long    * pulGroupHandle,   /* Out -- index group handle   */
  unsigned long    * pulDiagnosisInfo  /* Out -- diagnosis info       */
  );                                   /* function value: return code */

unsigned long
APICALL  EhwCreateResultView           /* Create Result View          */
  (
  void             * pSession,         /* In  -- session pointer      */
  unsigned long      ulResultHandle,   /* In  -- result handle        */
  unsigned long    * pulResViewHandle, /* Out -- result view handle   */
  unsigned long    * pulResViewSize,   /* Out -- size of result list  */
  unsigned long    * pulDiagnosisInfo  /* Out -- diagnosis info       */
  );                                   /* function value: return code */

unsigned long
APICALL EhwDeleteCluster               /* Delete Cluster              */
  (
  void             *session_ptr,       /* In  -- session pointer      */
  unsigned long     rlist_hdl,         /* In  -- result list handle   */
  unsigned long    *info_ptr           /* Out -- diagnosis info       */
  ) ;                                  /* function value: return_code */

unsigned long
APICALL  EhwDeleteDocumentModel        /* Delete a Document Model     */
  (
  void             *session_ptr,       /* In  -- session pointer      */
  unsigned long    ulDataLength,       /* In  -- length of datastream */
  char             *pDataStream,       /* In  -- datastream           */
  unsigned long    *pulDiagnosisInfo   /* Out -- diagnosis info       */
  );                                   /* function value: return_code */

unsigned long
APICALL  EhwDeleteIndex                /* Delete Index                */
  (
  void             * pSession,         /* In  -- session pointer      */
  unsigned long      ulDataLength,     /* In  -- datastream length    */
  char             * pDataStream,      /* In  -- index information    */
  unsigned long    * pulDiagnosisInfo  /* Out -- diagnosis info       */
  );                                   /* function value: return code */


unsigned long
APICALL  EhwDeregisterIndex            /* Deregister Index            */
  (
  void             * pSession,         /* In  -- session pointer      */
  unsigned long      ulDataLength,     /* In  -- datastream length    */
  char             * pDataStream,      /* In  -- index information    */
  unsigned long    * pulDiagnosisInfo  /* Out -- diagnosis info       */
  );

unsigned long
APICALL  EhwDeleteIndexGroup           /* Delete Index Group          */
  (
  void             * pSession,         /* In  -- session pointer      */
  unsigned long      ulIndexGrHandle,  /* In  -- index handle         */
  unsigned long    * pulDiagnosisInfo  /* Out -- diagnosis info       */
  );                                   /* function value: return code */

unsigned long
APICALL  EhwDeleteResult               /* Delete Result               */
  (
  void             * pSession,         /* In  -- session pointer      */
  unsigned long      ulHandle,         /* In  -- result/index handle  */
  unsigned long    * pulDiagnosisInfo  /* Out -- diagnosis info       */
  );                                   /* function value: return code */

/* new api-syntax, effective May '97 */
unsigned long
APICALL  EhwDelIndexingMsgs            /* Delete Indexing Messages    */
  (
  void             *session_ptr,       /* In  -- session pointer      */
  unsigned long    ulIndexHandle,      /* In  -- index handle         */
  unsigned long    *pulDiagnosisInfo   /* Out -- diagnosis info       */
  );                                   /* function value: return_code */

unsigned long
APICALL  EhwDeleteResultView           /* Delete a result view        */
  (
  void             * pSession,         /* In  -- session pointer      */
  unsigned long      ulHandle,         /* In  -- result list  handle  */
  unsigned long    * pulDiagnosisInfo  /* Out -- diagnosis info       */
  );                                   /* function value: return code */

unsigned long
APICALL  EhwEndBrowseSession           /* End Browse Session          */
  (
  void             * pSession,         /* In  -- session pointer      */
  unsigned long    * pulDiagnosisInfo  /* Out -- diagnosis info       */
  );                                   /* function value: return code */

unsigned long
APICALL  EhwEndSession                 /* End Session                 */
  (
  void             * pSession,         /* In  -- session pointer      */
  unsigned long    * pulDiagnosisInfo  /* Out -- diagnosis info       */
  );                                   /* function value: return code */

unsigned long
APICALL  EhwGetBrowseData              /* Get Browse Data             */
  (
  void             * pSession,         /* In  -- session pointer      */
  unsigned long      ulResultHandle,   /* In  -- result handle        */
  unsigned long    * pulDataLength,    /* Out -- datastream length    */
  char            ** ppDataStream,     /* Out -- browse data          */
  unsigned long    * pulDiagnosisInfo  /* Out -- diagnosis info       */
  );                                   /* function value: return_code */

unsigned long
APICALL  EhwGetCluster                 /* Get Cluster                 */
  (
  void             *session_ptr,       /* In  -- session pointer      */
  unsigned long    ulRViewHandle,      /* In  -- result view handle   */
  unsigned long    *pDataLength,       /* Out -- length of datastream */
  char             **ppDataStream,     /* Out -- datastream           */
  unsigned long    *pulDiagnosisInfo   /* Out -- diagnosis info       */
  );                                   /* function value: return_code */

unsigned long
APICALL  EhwGetDefaultDocumentModel    /* Get Default Document Model  */
  (
  void             *session_ptr,       /* In  -- session pointer      */
  unsigned long    ulIndexHandle,      /* In  -- index_handle         */
  unsigned long    *pDataLength,       /* Out -- length of datastream */
  char             **ppDataStream,     /* Out -- datastream           */
  unsigned long    *pulDiagnosisInfo   /* Out -- diagnosis info       */
  );                                   /* function value: return_code */

unsigned long
APICALL  EhwGetDocumentModel           /* Get a Document Model        */
  (
  void             *session_ptr,       /* In  -- session pointer      */
  unsigned long    ulIndexHandle,      /* In  -- index_handle         */
  unsigned long    ulDataLength,       /* In  -- length of datastream */
  char             *pDataStream,       /* In  -- datastream (name)    */
  unsigned long    *pDataLength,       /* Out -- length of datastream */
  char             **ppDataStream,     /* Out -- datastream (model)   */
  unsigned long    *pulDiagnosisInfo   /* Out -- diagnosis info       */
  );                                   /* function value: return_code */

unsigned long
APICALL  EhwGetIndexingMsgs            /* Get Indexing Messages       */
  (
  void             *session_ptr,       /* In  -- session pointer      */
  unsigned long    ulIndexHandle,      /* In  -- index_handle         */
  unsigned long    *pDataLength,       /* Out -- length of datastream */
  char             **ppDataStream,     /* Out -- datastream           */
  unsigned long    *pulDiagnosisInfo   /* Out -- diagnosis info       */
  );                                   /* function value: return_code */

unsigned long
APICALL  EhwGetIndexingRules           /* Get Indexing Rules          */
  (
  void             *session_ptr,       /* In  -- session pointer      */
  unsigned long    ulIndexHandle,      /* In  -- index_handle         */
  unsigned long    *pDataLength,       /* Out -- length of datastream */
  char             **ppDataStream,     /* Out -- datastream           */
  unsigned long    *pulDiagnosisInfo   /* Out -- diagnosis info       */
  );                                   /* function value: return_code */

unsigned long
APICALL  EhwGetIndexFunctionStatus     /* Get status of a function    */
  (
   void            *session_ptr,       /* In  -- session pointer      */
   unsigned long   ulIndexHandle,      /* In  -- index_handle         */
   unsigned long   function_id,        /* In  -- function id          */
   unsigned long   *pDataLength,       /* Out -- datastream length    */
   char            **ppDataStream,     /* Out -- admin. function info */
   unsigned long   *pulDiagnosisInfo   /* Out -- diagnosis info       */
  );                                   /* function value: return_code */

unsigned long
APICALL  EhwGetIndexInfo               /* Get Index Information       */
  (
  void             * pSession,         /* In  -- session pointer      */
  unsigned long      ulIndexHandle,    /* In  -- index handle         */
  unsigned long    * pulDataLength,    /* Out -- datastream length    */
  char            ** ppDataStream,     /* Out -- index list           */
  unsigned long    * pulDiagnosisInfo  /* Out -- diagnosis info       */
  );                                   /* function value: return code */

unsigned long
APICALL  EhwGetIndexStatus             /* Get Index Status            */
  (
  void             *session_ptr,       /* In  -- session pointer      */
  unsigned long    ulIndexHandle,      /* In  -- index_handle         */
  unsigned long    *pDataLength,       /* Out -- length of datastream */
  char             **ppDataStream,     /* Out -- datastream           */
  unsigned long    *pulDiagnosisInfo   /* Out -- diagnosis info       */
  );                                   /* function value: return_code */

unsigned long
APICALL  EhwGetMatches                 /* Get Document Text and Hits  */
  (
  void             * pSession,         /* In  -- session pointer      */
  unsigned long      ulDocumentHandle, /* In  -- document handle      */
  unsigned long    * pulDataLength,    /* Out -- datastream length    */
  char            ** ppDataStream,     /* Out -- document text        */
  unsigned long    * pulDiagnosisInfo  /* Out -- diagnosis info       */
  );                                   /* function value: return code */

unsigned long
APICALL  EhwGetProblemInfo             /* Get Index Error RCs         */
  (
  void             * pSession,         /* In  -- session pointer      */
  unsigned long      ulProblemHandle,  /* In  -- handle               */
  unsigned long    * pulDataLength,    /* Out -- datastream length    */
  char            ** ppDataStream,     /* Out -- document text        */
  unsigned long    * pulDiagnosisInfo  /* Out -- diagnosis info       */
  );                                   /* function value: return code */

unsigned long
APICALL  EhwGetProfile                 /* Get Profile                 */
  (
  void             *session_ptr,       /* In  -- session pointer      */
  unsigned long    ulRViewHandle,      /* In  -- result view handle   */
  unsigned long    ulDataLength,       /* In  -- length of datastream */
  char             *pDataStream,       /* In  -- datastream: doc id   */
  unsigned long    *pulDataLength,     /* Out -- length of datastream */
  char             **ppDataStream,     /* Out -- datastream           */
  unsigned long    *pulDiagnosisInfo   /* Out -- diagnosis info       */
  );                                   /* function value: return_code */

unsigned long
APICALL  EhwGetResultView              /* Get Result View             */
  (
  void             * pSession,         /* In  -- session pointer      */
  unsigned long      ulResViewHandle,  /* In  -- result view handle   */
  unsigned long    * pulDataLength,    /* Out -- datastream length    */
  char            ** ppDataStream,     /* Out -- result view          */
  unsigned long    * pulDiagnosisInfo  /* Out -- diagnosis info       */
  );                                   /* function value: return code */

unsigned long
APICALL  EhwGetSimilarDocuments        /* Get Similar Documents       */
  (
  void             *session_ptr,       /* In  -- session pointer      */
  unsigned long    ulRViewHandle,      /* In  -- result view handle   */
  unsigned long    ulDataLength,       /* In  -- length of datastream */
  char             *pDataSream,        /* In  -- ds: similarity value */
  unsigned long    *pulDataLength,     /* Out -- length of datastream */
  char             **ppDataStream,     /* Out -- datastream           */
  unsigned long    *pulDiagnosisInfo   /* Out -- diagnosis info       */
  );                                   /* function value: return_code */

unsigned long
APICALL  EhwListDocumentModels         /* List Document Models        */
  (
  void             *session_ptr,       /* In  -- session pointer      */
  unsigned long    ulIndexHandle,      /* In  -- index_handle         */
  unsigned long    *pDataLength,       /* Out -- length of datastream */
  char             **ppDataStream,     /* Out -- datastream           */
  unsigned long    *pulDiagnosisInfo   /* Out -- diagnosis info       */
  );                                   /* function value: return_code */

unsigned long
APICALL  EhwListIndexes                /* List Indexes                */
  (
  void             * pSession,         /* In  -- session pointer      */
  unsigned long    * pulDataLength,    /* Out -- datastream length    */
  char            ** ppDataStream,     /* Out -- index list           */
  unsigned long    * pulDiagnosisInfo  /* Out -- diagnosis info       */
  );                                   /* function value: return code */

unsigned long
APICALL  EhwListResult                 /* List Result                 */
  (
  void             * pSession,         /* In  -- session pointer      */
  unsigned long      ulResultHandle,   /* In  -- result handle        */
  unsigned long    * pulDataLength,    /* Out -- datastream length    */
  char            ** ppDataStream,     /* Out -- result information   */
  unsigned long    * pulDiagnosisInfo  /* Out -- diagnosis info       */
  );                                   /* function value: return code */


unsigned long
APICALL  EhwListServers                /* List Servers                */
  (
  unsigned long    * pulDataLength,    /* Out -- datastream length    */
  char            ** ppDataStream,     /* Out -- server list          */
  unsigned long    * pulDiagnosisInfo  /* Out -- diagnosis info       */
  );                                   /* function value: return code */


unsigned long
APICALL  EhwNarrowQuery
(
  void               *pvSession,       /* In  -- session pointer      */
  unsigned long      ulResultHandle,   /* In  -- result handle        */
  unsigned long    * pulDataLength,    /* Out -- datastream length    */
  char            ** ppDataStream,     /* Out -- data stream          */
  unsigned long      *pulDiagnosisInfo /* Out -- diagnosis info.      */
);


unsigned long
APICALL  EhwOpenDocument               /* Open Document               */
  (
  void             * pSession,         /* In  -- session pointer      */
  unsigned long      ulResultHandle,   /* In  -- result handle        */
  unsigned long      ulDataLength,     /* In  -- datastream length    */
  char             * pDataStream,      /* In  -- browse specifications*/
  unsigned long      ulCondition,      /* In  -- processing condition */
  unsigned long    * pulDocumentHandle,/* Out -- document handle      */
  unsigned long    * pulDiagnosisInfo  /* Out -- diagnosis info       */
  );                                   /* function value: return code */

unsigned long
APICALL  EhwOpenIndex                  /* Open Index                  */
  (
  void             * pSession,         /* In  -- session pointer      */
  unsigned long      ulDataLength,     /* In  -- datastream length    */
  char             * pDataStream,      /* In  -- index info (name)    */
  unsigned long    * pulIndexHandle,   /* Out -- index handle         */
  unsigned long    * pulDiagnosisInfo  /* Out -- diagnosis info       */
  );                                   /* function value: return code */

unsigned long
APICALL  EhwRank                       /* Rank Result Information     */
  (
  void             * pSession,         /* In  -- session pointer      */
  unsigned long      ulResultHandle,   /* In  -- result handle        */
  unsigned long    * pulDiagnosisInfo  /* Out -- diagnosis info       */
  );                                   /* function value: return code */

unsigned long
APICALL  EhwRegisterIndex              /* Register Index              */
  (
  void             * pSession,         /* In  -- session pointer      */
  unsigned long      ulDataLength,     /* In  -- datastream length    */
  char             * pDataStream,      /* In  -- index information    */
  unsigned long    * pulDataLength,    /* Out -- datastream length    */
  char            ** ppDataStream,     /* Out -- index name           */
  unsigned long    * pulDiagnosisInfo  /* Out -- diagnosis info       */
  );                                   /* function value: return code */

unsigned long
APICALL  EhwReorgIndex                 /* Reorganize Index            */
  (
  void             * pSession,         /* In  -- session pointer      */
  unsigned long      ulIndexHandle,    /* In  -- index handle         */
  unsigned long    * pulDiagnosisInfo  /* Out -- diagnosis info       */
  );                                   /* function value: return code */

unsigned long
APICALL  EhwResumeIndex                /* Resume Index                */
  (
  void             * pSession,         /* In  -- session pointer      */
  unsigned long      ulDataLength,     /* In  -- datastream length    */
  char             * pDataStream,      /* In  -- index information    */
  unsigned long    * pulDiagnosisInfo  /* Out -- diagnosis info       */
  );                                   /* function value: return code */

unsigned long
APICALL  EhwScheduleDocument           /* Schedule Document           */
  (
  void             * pSession,         /* In  -- session pointer      */
  unsigned long      ulIndexHandle,    /* In  -- index handle         */
  unsigned long      ulDataLength,     /* In  -- datastream length    */
  char             * pDataStream,      /* In  -- scheduling list      */
  unsigned long    * pulDiagnosisInfo  /* Out -- diagnosis info       */
  );                                   /* function value: return code */

unsigned long
APICALL  EhwSearch                     /* Search Index                */
  (
  void             * pSession,         /* In  -- session pointer      */
  unsigned long      ulIndexHandle,    /* In  -- index handle         */
  unsigned long      ulDataLength,     /* In  -- datastream length    */
  char             * pDataStream,      /* In  -- query                */
  unsigned long    * pulResultHandle,  /* Out -- result handle        */
  unsigned long    * pulResultSize,    /* Out -- result size          */
  unsigned long    * pulDiagnosisInfo  /* Out -- diagnosis info       */
  );                                   /* function value: return code */

unsigned long
APICALL  EhwSelectResultView           /* Select Result View          */
  (
  void             * pSession,         /* In  -- session pointer      */
  unsigned long      ulResViewHandle,  /* In  -- result view handle   */
  unsigned long      ulDataLength,     /* In  -- datastream length    */
  char             * pDataStream,      /* In  -- selection parameters */
  unsigned long    * pulResViewHandle, /* Out -- result view handle   */
  unsigned long    * pulResViewSize,   /* Out -- size of result view  */
  unsigned long    * pulDiagnosisInfo  /* Out -- diagnosis info       */
  );                                   /* function value: return code */

unsigned long
APICALL  EhwSetDefaultDocumentModel    /* Set Default Document Model  */
  (
  void             *session_ptr,       /* In  -- session pointer      */
  unsigned long    ulIndexHandle,      /* In  -- index_handle         */
  unsigned long    ulDataLength,       /* In  -- length of datastream */
  char             *pDataStream,       /* In  -- datastream           */
  unsigned long    *pulDiagnosisInfo   /* Out -- diagnosis info       */
  );                                   /* function value: return_code */

unsigned long
APICALL  EhwSetIndexingRules           /* Set Indexing Rules          */
  (
  void             *session_ptr,       /* In  -- session pointer      */
  unsigned long    ulIndexHandle,      /* In  -- index_handle         */
  unsigned long    ulDataLength,       /* In  -- length of datastream */
  char             *pDataStream,       /* In  -- datastream           */
  unsigned long    *pulDiagnosisInfo   /* Out -- diagnosis info       */
  );                                   /* function value: return_code */

unsigned long
APICALL  EhwSetIndexFunctionStatus     /* set status of a function    */
  (
   void            *session_ptr,       /* In  -- session pointer      */
   unsigned long   ulIndexHandle,      /* In  -- index_handle         */
   unsigned long   function_id,        /* In  -- function id          */
   unsigned long   action_id,          /* In  -- action requested     */
   unsigned long   *pulDiagnosisInfo   /* Out -- diagnosis info       */
  );                                   /* function value: return_code */


unsigned long
APICALL  EhwSort                       /* Sort Result Information     */
  (
  void             * pSession,         /* In  -- session pointer      */
  unsigned long      ulResultHandle,   /* In  -- result handle        */
  unsigned long      ulDataLength,     /* In  -- datastream length    */
  char             * pDataStream,      /* In  -- sort specifications  */
  unsigned long    * pulDiagnosisInfo  /* Out -- diagnosis info       */
  );                                   /* function value: return code */

unsigned long
APICALL  EhwStartBrowseSession         /* Start Browse Session        */
  (
  unsigned long      pulDataLength,    /* In  -- datastream length    */
  char             * pDataStream,      /* In  -- browse data          */
  void            ** ppSession,        /* Out -- session pointer      */
  unsigned long    * pulDiagnosisInfo  /* Out -- diagnosis info       */
  );                                   /* function value: return_code */

unsigned long
APICALL  EhwStartSession               /* Start Session               */
  (
  unsigned long      ulDataLength,     /* In  -- datastream length    */
  char             * pDataStream,      /* In  -- session information  */
  void            ** ppSession,        /* Out -- session pointer      */
  unsigned long    * pulDiagnosisInfo  /* Out -- diagnosis info       */
  );                                   /* function value: return code */

unsigned long
APICALL  EhwStopServer                 /* Stop Server                 */
  (
  unsigned long      ulDataLength,     /* In  -- datastream length    */
  char             * pDataStream,      /* In  -- session information  */
  unsigned long    * pulDiagnosisInfo  /* Out -- diagnosis info       */
  );                                   /* function value: return code */

unsigned long
APICALL  EhwSuspendIndex               /* Suspend Index               */
  (
  void             * pSession,         /* In  -- session pointer      */
  unsigned long      ulDataLength,     /* In  -- datastream length    */
  char             * pDataStream,      /* In  -- index information    */
  unsigned long      ulSuspendCond,    /* In  -- suspend condition    */
  unsigned long    * pulDiagnosisInfo  /* Out -- diagnosis info       */
  );                                   /* function value: return code */

unsigned long
APICALL  EhwUpdateIndex                /* Update Index                */
  (
  void             * pSession,         /* In  -- session pointer      */
  unsigned long      ulIndexHandle,    /* In  -- index handle         */
  unsigned long    * pulDiagnosisInfo  /* Out -- diagnosis info       */
  );                                   /* function value: return code */
#ifdef  __cplusplus
}
#endif

/*
 The following defines refer to the feature index which is no longer
 supported.
 They remain in here to enable compilation of old applications - but code
 actually using them will no longer run.
*/

#define    XTADD_FEAT         0x01     /*    -- feature extraction    */
#define    XTADD_LING_EXT     0x02     /*    -- morph.functionality   */
#define    XTYP_DUAL          0x02     /*    -- dual                  */


#define     ID_FEAT          225       /* feature expansion           */
#define     FEAT_ALL         0x01
#define     FEAT_PERSON_NAME 0x02
#define     FEAT_ORG_NAME    0x03
#define     FEAT_PLACE_NAME  0x04
#define     FEAT_DOMAIN_TERM 0x05



#endif                                 /* end of include switch       */

#endif /* imoapic_h */
