
/*====================================================================*/
/*                                                                    */
/*  SearchManager API Sample Definitions                              */
/*                                                                    */
/*====================================================================*/
/*                                                                    */
/*  Name:               SMPAPIH2.H                                    */
/*  -----                                                             */
/*                                                                    */
/*  COPYRIGHT:                                                        */
/*  ----------                                                        */
/*   Copyright (C) International Business Machines Corp., 1993        */
/*                                                                    */
/*  DISCLAIMER OF WARRANTIES:                                         */
/*  -------------------------                                         */
/*   The following [enclosed] code is sample code created by IBM      */
/*   Corporation. This sample code is not part of any standard IBM    */
/*   product and is provided to you solely for the purpose of         */
/*   assisting you in the development of your applications.           */
/*   The code is provided "AS IS", without warranty of any kind.      */
/*   IBM shall not be liable for any damages arising out of your      */
/*   use of the sample code, even if they have been advised of the    */
/*   possibility of such damages.                                     */
/*                                                                    */
/*====================================================================*/

/*====================================================================*/
/*  smpapih2.h  (Include file for API sample application smpapia2.c)  */
/*====================================================================*/

#if !defined(SMPAPIH_DEFINED)          /* already included  ?         */
#define SMPAPIH_DEFINED                /* no !                        */

/*--------------------------------------------------------------------*/
/*  Extension of OS/2 and API definitions                             */
/*--------------------------------------------------------------------*/
typedef  PCHAR              *PPCHAR;   /* pointer to CHAR pointer     */
typedef  struct Data_Item    ITEM;     /* datastream item structure   */
typedef  ITEM               *PITEM;    /* pointer to datastream item  */

/*--------------------------------------------------------------------*/
/*  processing control definitions                                    */
/*--------------------------------------------------------------------*/
                                       /* function status code:       */
#define  RC_FALSE                 0    /* function failed             */
#define  RC_TRUE                  1    /* function succeeded          */

#define  SIZEOF_DATA_AREA    0x7fff    /* sizeof of work buffer       */
                                       /* definition for the session: */
                                       /* IRSL_LOCAL / IRSL_REMOTE    */
#define  SESSION_IRSL   IRSL_LOCAL     /* requested server location   */
                                       /* definition for the queries: */
#define  QUERY_CCSID    CCSID_00850    /* -- coded character set id   */
#define  QUERY_LANG     LANG_ENU       /* -- language id for English  */
#define  QUERY_WORD01   "Suchbegriff"  /* -- word 1                   */
#define  QUERY_WORD02   "timestamp"    /* -- word 2                   */

/*--------------------------------------------------------------------*/
/*  Limits                                                            */
/*--------------------------------------------------------------------*/
                                       /* index table  definition:    */
#define  LT_NUMBER_OF_INDEXES    10    /* maximum number of indexes   */
                                       /* must be greater than zero   */
#define  LT_NUMBER_OF_RESULTS    10    /* maximum number of results   */
                                       /* index info. definition:     */
#define  LT_SIZEOF_LSCE_ITEM     40    /* maximum length of client    */
                                       /* library services executable */
                                       /* result info. definition:    */
#define  LT_RESULT_DOCUMENTS     30    /* maximum number of documents */
                                       /* pointers in result info.    */

/*--------------------------------------------------------------------*/
/*  macro definitions                                                 */
/*--------------------------------------------------------------------*/
/*--------------------------------------------------------------------*/
/*  structure definitions                                             */
/*--------------------------------------------------------------------*/
typedef
struct DataList                        /* chaining data structure     */
  {
  struct
  DataList        *pNextData;          /* pointer to next data block  */
  ULONG            ulDataLength;       /* length of current data blk  */
  UCHAR            Data[1];            /* current block of data       */
                                       /* in datastream format        */
  }
  LIST, *PLIST;

typedef
struct DocumentInfo                    /* document information        */
  {
  PITEM            pIndex;             /* pointer to index item       */
  PITEM            pDocument;          /* pointer to document item    */
  PITEM            pRankValue;         /* pointer to rank value item  */
  PITEM            pWordCount;         /* pointer to number of words  */
  PITEM            pRankCount;         /* pointer to rank count item  */
  }
#ifndef _WIN32
  DOCINFO, *PDOCINFO;
#else
  *PDOCINFO;
#endif

typedef
struct ResultInfo                      /* result information          */
  {
  UCHAR            Header[8];          /* header text                 */
  ULONG            ulInfoLength;       /* result information length   */
  ULONG            ulHandle;           /* result handle               */
  ULONG            ulSize;             /* result size                 */
  ULONG            ulDataLength;       /* length of result datastream */
  PLIST            pData;              /* result list datastream ptr  */
  ULONG            ulDocumentCount;    /* number of document item ptr */
  PDOCINFO         pDocumentInfo;      /* index/document items        */
  }
  RESULT, *PRESULT, **PPRESULT;

typedef
struct IndexInfo                       /* index information           */
  {
  UCHAR            Header[8];          /* header text                 */
  ULONG            ulInfoLength;       /* length of index information */
  ULONG            ulHandle;           /* index handle                */
  UCHAR            Type;               /* index type                  */
  UCHAR            Property;           /* index property              */
  PITEM            pName;              /* pointer to index name item  */
  PITEM            pDLL;               /* pointer to LS DLL item      */
  ULONG            ulDataLength;       /* length of detail datastream */
  UCHAR            Data[1];            /* index detail datastream     */
  }
  INDEX, *PINDEX, **PPINDEX;

typedef
struct IndexTable                      /* index table                 */
  {
  UCHAR            Header[8];          /* header text                 */
  ULONG            ulTableLength;      /* total length of table       */
  USHORT           usIndexSlots;       /* total number of index slots */
  USHORT           usIndexCount;       /* number of used index slots  */
  USHORT           usResultCount;      /* number of used result slots */
                                       /* ptrs to result datastreams  */
  PRESULT          pResult[LT_NUMBER_OF_RESULTS];
  PINDEX           pIndex[1];          /* index information entries   */
  }
  XTBL, *PXTBL;

typedef
struct GroupTable                      /* index group table           */
  {
  UCHAR            Header[8];          /* header text                 */
  ULONG            ulTableLength;      /* total length of table       */
  USHORT           usHandleSlots;      /* total number of handle slots*/
  USHORT           usHandleCount;      /* number of used handle slots */
  ULONG            ulHandle[1];        /* index handle entries        */
  }
  HTBL, *PHTBL;

typedef
struct ServerInfo                      /* server information struct.  */
  {
  PVOID            pSession;           /* session pointer             */
  PXTBL            pIndexTable;        /* index table pointer         */
  PHTBL            pGroupTable;        /* index group table pointer   */
  UCHAR            Location;           /* server location             */
  USHORT           usNameLength;       /* length of server name       */
  UCHAR            Name[1];            /* server name                 */
  }
  SERV, *PSERVER;

typedef
struct ServerTable                     /* server table                */
  {
  UCHAR            Header[8];          /* header text                 */
  ULONG            ulTableLength;      /* total length of table       */
  USHORT           usServerCount;      /* number of table entries     */
  SERV           Server[1];          /* server table entries ...    */
  }
  SRVTBL, *PSRVTBL;

typedef
struct IndexProblem                    /* index problem info          */
  {
  PCHAR            IndexName;          /* Index Name                  */
  USHORT           usProblemRc;        /* return code                 */
  }
  INDEXPBL, *PINDEXPBL;

typedef
struct IndexProblemTable               /* index problem table         */
  {
  UCHAR            Header[8];          /* header text                 */
  ULONG            ulTableLength;      /* total length of table       */
  USHORT           usTableEntries;     /* number of table entries     */
  INDEXPBL         IdxProblem[1];      /* index problem entries...    */
  }
  PBLTBL, *PPBLTBL;

/*--------------------------------------------------------------------*/
/*  function calls                                                    */
/*--------------------------------------------------------------------*/
static
INT      WriteDataItem      (USHORT         usItemId,
                             UCHAR          ItemType,
                             USHORT         usValueLength,
                             PCHAR          pValue,
                             PULONG         pulAreaLength,
                             PPCHAR         ppArea
                            );
static
INT      ListServers        (SRVTBL       **ppServer);

static
INT      ListIndexes        (PVOID          pSession,
                             XTBL         **ppIndexTable
                            );
static
INT      OpenIndex          (PVOID          pSession,
                             INDEX        **ppIndex
                            );
static
INT      ListResult         (PVOID          pSession,
                             ULONG          ulResultHandle,
                             ULONG          ulResultSize,
                             ULONG          ulReferenceLimit,
                             PXTBL          pIndexTable
                            );
static
INT      DeleteResults       (PVOID         pSession,
                              ULONG         ulResultHandle,
                              PXTBL         pIndexTable
                             );

static
INT      GetProblemInfo      (PVOID         pSession,
                              ULONG         ulResultHandle,
                              PPBLTBL      *pProblemInfo
                             );

static
VOID     HandleExit          (PSRVTBL        pServerTable,
                              PCHAR          pArea
                             );

#endif                                 /* end of include switch       */

/*====================================================================*/

