/*====================================================================*/
/*                                                                    */
/*  IBM Text Search API Sample Definitions                            */
/*                                                                    */
/*====================================================================*/
/*                                                                    */
/*  Name:               ehwsmp01.h                                    */
/*  -----                                                             */
/*                                                                    */
/*  COPYRIGHT:                                                        */
/*  ----------                                                        */
/*   Digital Library Version 2 - 5648-A08.                            */
/*   (C) Copyright IBM Corp. 1996.                                    */
/*       All Rights Reserved                                          */
/*   US Government Users Restricted Rights                            */
/*   Use, duplication or disclosure restricted                        */
/*        by GSA ADP Schedule                                         */
/*   Contract with IBM Corp.                                          */
/*   Licensed Materials - Property of IBM                             */
/*                                                                    */
/*  DISCLAIMER OF WARRANTIES:                                         */
/*  -------------------------                                         */
/*   The following [enclosed] code is sample code created by IBM      */
/*   Corporation. This sample code is not part of any standard IBM    */
/*   product and is provided to you solely for the purpose of         */
/*   assisting you in the development of your applications.           */
/*   The code is provided "AS IS", without warranty of any kind.      */
/*   IBM shall not be liable for any damages arising out of your      */
/*   use of the sample code, even if they have been advised of the    */
/*   possibility of such damages.                                     */
/*                                                                    */
/*====================================================================*/

/*====================================================================*/
/*  ehwsmp01.h (Include file for API sample applications              */
/*             ehwsmp01.c ehwsmp02.c                                  */
/*====================================================================*/

#if !defined(SMPAPIH_DEFINED)          /* already included  ?         */
#define SMPAPIH_DEFINED                /* no !                        */

/*--------------------------------------------------------------------*/
/*  Extension API definitions                                         */
/*--------------------------------------------------------------------*/
typedef  PCHAR              *PPCHAR;   /* pointer to CHAR pointer     */
typedef  struct Data_Item    ITEM;     /* datastream item structure   */
typedef  ITEM               *PITEM;    /* pointer to datastream item  */

/*--------------------------------------------------------------------*/
/*  processing control definitions                                    */
/*--------------------------------------------------------------------*/
                                       /* function status code:       */
#define  RC_FALSE                 0    /* function failed             */
#define  RC_TRUE                  1    /* function succeeded          */

#define  SIZEOF_DATA_AREA    0x7fff    /* sizeof of work buffer       */
                                       /* definition for the session: */
                                       /* IRSL_LOCAL / IRSL_REMOTE    */
#define  START_INDEXING           1    /* function start indexing     */
#define  START_REORGANIZING       2    /* function start reorganizatio*/
#define  SESSION_IRSL   IRSL_LOCAL     /* requested server location   */
                                       /* definition for the queries: */
#define  QUERY_CCSID    CCSID_00850    /* -- coded character set id   */
#define  QUERY_LANG     LANG_ENU       /* -- language identifier      */
#define  QUERY_WORD01   "compete"       /* -- word 1                   */
#define  QUERY_WORD02   "application"   /* -- word 2                   */
/*--------------------------------------------------------------------*/
/*  Limits                                                            */
/*--------------------------------------------------------------------*/
                                       /* index table  definition:    */
#define  LT_NUMBER_OF_INDEXES    10    /* maximum number of indexes   */
                                       /* must be greater than zero   */
                                       /* index info. definition:     */
#define  LT_NUMBER_OF_RESULTS    10    /* maximum number of results   */
                                       /* index info. definition:     */
#define  LT_SIZEOF_LSCE_ITEM     40    /* maximum LSCE item length    */
                                       /* must be greater than zero   */
                                       /* result info. definition:    */
#define  LT_RESULT_DOCUMENTS     30    /* maximum number of document  */
                                       /* pointers in result info.    */
#define  INDEXING_LIMIT           1    /* number of indexing requests */
                                       /* on the indexing queue to    */
                                       /* trigger the start indexing  */
/*--------------------------------------------------------------------*/
/*  macro definitions                                                 */
/*--------------------------------------------------------------------*/
/*--------------------------------------------------------------------*/
/*  structure definitions                                             */
/*--------------------------------------------------------------------*/
typedef
struct DataList                        /* chaining data structure     */
  {
  struct
  DataList        *pNextData;          /* pointer to next data block  */
  ULONG            ulDataLength;       /* length of current data blk  */
  UCHAR            Data[1];            /* current block of data       */
                                       /* in datastream format        */
  }
  LIST, *PLIST;

typedef
struct ResultInfo                      /* result information          */
  {
  UCHAR            Header[8];          /* header text                 */
  ULONG            ulInfoLength;       /* result information length   */
  ULONG            ulHandle;           /* result handle               */
  ULONG            ulSize;             /* result size                 */
  ULONG            ulDataLength;       /* length of result datastream */
  PLIST            pData;              /* result list datastream ptr  */
  ULONG            ulDocumentCount;    /* number of document item ptr */
  PITEM            pDocument[1];       /* pointer to document item    */
  }
  RESULT, *PRESULT;

typedef
struct IndexInfo                       /* index information           */
  {
  UCHAR            Header[8];          /* header text                 */
  ULONG            ulInfoLength;       /* length of index information */
  ULONG            ulHandle;           /* index handle                */
  UCHAR            Type;               /* index type                  */
  UCHAR            Property;           /* index property              */
  PITEM            pName;              /* pointer to index name item  */
  PITEM            pDLLcl;             /* pointer to LS DLL item      */
  PITEM            pDLLsrv;            /* pointer to LS DLL item      */
  PRESULT          pResult;            /* recent result info. pointer */
  ULONG            ulDataLength;       /* length of detail datastream */
  UCHAR            Data[1];            /* index detail datastream     */
  }
  INDEX, *PINDEX, **PPINDEX;

typedef
struct IndexTable                      /* index table                 */
  {
  UCHAR            Header[8];          /* header text                 */
  ULONG            ulTableLength;      /* total length of table       */
  USHORT           usIndexSlots;       /* total number of index slots */
  USHORT           usIndexCount;       /* number of used index slots  */
  PINDEX           pIndex[1];          /* index information entries   */
  }
  XTBL, *PXTBL;

typedef
struct ServerInfo                      /* server information struct.  */
  {
  PVOID            pSession;           /* session pointer             */
  PXTBL            pIndexTable;        /* index table pointer         */
  UCHAR            Location;           /* server location             */
  USHORT           usNameLength;       /* length of server name       */
  UCHAR            Name[1];            /* server name                 */
  }
  SERVER, *PSERVER;

typedef
struct ServerTable                     /* server table                */
  {
  UCHAR            Header[8];          /* header text                 */
  ULONG            ulTableLength;      /* total length of table       */
  USHORT           usServerCount;      /* number of table entries     */
  SERVER           Server[1];          /* server table entries ...    */
  }
  SRVTBL, *PSRVTBL;

/*--------------------------------------------------------------------*/
/*  function calls                                                    */
/*--------------------------------------------------------------------*/
static
INT      WriteDataItem  (USHORT         usItemId,
                         UCHAR          ItemType,
                         USHORT         usValueLength,
                         PCHAR          pValue,
                         PULONG         pulAreaLength,
                         PPCHAR         ppArea
                        );
static
INT      ListServers    (SRVTBL       **ppServer);

static
INT      ListIndexes    (PVOID          pSession,
                         XTBL         **ppIndexTable
                        );
static
INT      OpenIndex      (PVOID          pSession,
                         INDEX        **ppIndex
                        );
static
INT      ListResult     (PVOID          pSession,
                         ULONG          ulResultHandle,
                         ULONG          ulResultSize,
                         ULONG          ulReferenceLimit,
                         PINDEX         pIndex
                        );
static
INT      DeleteResult   (PVOID          pSession,
                         PINDEX         pIndex
                        );

static
VOID     HandleError    (PSRVTBL        pServerTable,
                         PCHAR          pArea
                        );

#endif                                 /* end of include switch       */

/*====================================================================*/

