#include <stdio.h>
#include <stdlib.h>
#include <string.h>

#include "nvt.h"

HNVT hnvt;
int  inuse = 0;


void input(void)
{
  int   count;
  char  buf[MAXLINESIZE];
  int   bufsize;

  puts( "\n stdin ready" );

  while ( inuse )
  {
    gets( buf );
    bufsize = strlen( buf );

    buf[bufsize+1] = '\0';

    count = nvtputs( hnvt, buf, bufsize );

    if ( count != bufsize )
      puts( "\n nvtputs error" );
  }
}

void output(void)
{
  int   count;
  char  buf[MAXLINESIZE];

  puts( "\n stdout ready" );

  while ( inuse )
  {
    count = nvtgets( hnvt, buf, sizeof(buf) - 1 );

    if ( !count )
      break;
    else
    {
      if ( count < 0 )
        puts( "\n nvtgets error" );
      else
      {
        buf[count] = '\0';
        puts( buf );
      }
    }
  }
}

void task( void *parm )
{
  input();
  _endthread();
}

int main( int argc, char *argv[] )
{
  char *host;
  int   port;
  int   tid;

  if ( argc < 2 || argc > 3 )
  {
    puts( "syntax:   TNVT  hostname  [ port ]" );
    return 1;
  }

  host = argv[1];
  port = 0;

  if ( argc > 2 )
  {
    port = atoi( argv[2] );

    if ( !port )
      printf( "port parameter '%s' ignored \n", argv[2] );
  }

  hnvt = nvtopen( host, port );

  if ( !hnvt )
    puts( "\n nvtopen failed" );
  else
  {
    inuse = 1;
    tid = _beginthread( task, 0, 16*1024, 0 );

    if ( !tid )
      puts( "\n unable to start subtask" );
    else
      output();

    inuse = 0;

    nvtclose( hnvt );
  }

  puts( "\n ending" );
  return 0;
}
