require 'racc/parser'


require "rd/parser-util"
require "forwardable"
require "strscan"

module RD

class RDInlineParser < ::Racc::Parser

module_eval <<'..end rdinlineparser.ry modeval..id9d06b541e3', 'rdinlineparser.ry', 292
include ParserUtility
extend Forwardable

EM_OPEN = '((*'
EM_OPEN_RE = /\A#{Regexp.quote(EM_OPEN)}/
EM_CLOSE = '*))'
EM_CLOSE_RE = /\A#{Regexp.quote(EM_CLOSE)}/
CODE_OPEN = '(({'
CODE_OPEN_RE = /\A#{Regexp.quote(CODE_OPEN)}/
CODE_CLOSE = '}))'
CODE_CLOSE_RE = /\A#{Regexp.quote(CODE_CLOSE)}/
VAR_OPEN = '((|'
VAR_OPEN_RE = /\A#{Regexp.quote(VAR_OPEN)}/
VAR_CLOSE = '|))'
VAR_CLOSE_RE = /\A#{Regexp.quote(VAR_CLOSE)}/
KBD_OPEN = '((%'
KBD_OPEN_RE = /\A#{Regexp.quote(KBD_OPEN)}/
KBD_CLOSE = '%))'
KBD_CLOSE_RE = /\A#{Regexp.quote(KBD_CLOSE)}/
INDEX_OPEN = '((:'
INDEX_OPEN_RE = /\A#{Regexp.quote(INDEX_OPEN)}/
INDEX_CLOSE = ':))'
INDEX_CLOSE_RE = /\A#{Regexp.quote(INDEX_CLOSE)}/
REF_OPEN = '((<'
REF_OPEN_RE = /\A#{Regexp.quote(REF_OPEN)}/
REF_CLOSE = '>))'
REF_CLOSE_RE = /\A#{Regexp.quote(REF_CLOSE)}/
FOOTNOTE_OPEN = '((-'
FOOTNOTE_OPEN_RE = /\A#{Regexp.quote(FOOTNOTE_OPEN)}/
FOOTNOTE_CLOSE = '-))'
FOOTNOTE_CLOSE_RE = /\A#{Regexp.quote(FOOTNOTE_CLOSE)}/
VERB_OPEN = "(('"
VERB_OPEN_RE = /\A#{Regexp.quote(VERB_OPEN)}/
VERB_CLOSE = "'))"
VERB_CLOSE_RE = /\A#{Regexp.quote(VERB_CLOSE)}/

BAR = "|"
BAR_RE = /\A#{Regexp.quote(BAR)}/
QUOTE = '"'
QUOTE_RE = /\A#{Regexp.quote(QUOTE)}/
SLASH = "/"
SLASH_RE = /\A#{Regexp.quote(SLASH)}/
BACK_SLASH = "\\"
BACK_SLASH_RE = /\A#{Regexp.quote(BACK_SLASH)}/
URL = "URL:"
URL_RE = /\A#{Regexp.quote(URL)}/

# Workaround for Regexp option change of Ruby 1.5.x
other_re_mode = Regexp::EXTENDED
if RUBY_VERSION > "1.5"
  other_re_mode |= Regexp::MULTILINE
else
  other_re_mode |= Regexp::POSIXLINE
end

OTHER_RE = Regexp.new(
		  "\\A.+?(?=#{Regexp.quote(EM_OPEN)}|#{Regexp.quote(EM_CLOSE)}|
                  #{Regexp.quote(CODE_OPEN)}|#{Regexp.quote(CODE_CLOSE)}|
                  #{Regexp.quote(VAR_OPEN)}|#{Regexp.quote(VAR_CLOSE)}|
                  #{Regexp.quote(KBD_OPEN)}|#{Regexp.quote(KBD_CLOSE)}|
                  #{Regexp.quote(INDEX_OPEN)}|#{Regexp.quote(INDEX_CLOSE)}|
                  #{Regexp.quote(REF_OPEN)}|#{Regexp.quote(REF_CLOSE)}|
                #{Regexp.quote(FOOTNOTE_OPEN)}|#{Regexp.quote(FOOTNOTE_CLOSE)}|
                  #{Regexp.quote(VERB_OPEN)}|#{Regexp.quote(VERB_CLOSE)}|
                  #{Regexp.quote(BAR)}|
                  #{Regexp.quote(QUOTE)}|
                  #{Regexp.quote(SLASH)}|
                  #{Regexp.quote(BACK_SLASH)}|
                  #{Regexp.quote(URL)})", other_re_mode)

def initialize(bp)
  @blockp = bp
end

def_delegator(:@blockp, :tree)

def parse(src)
  @src = StringScanner.new(src)
  @pre = ""
  @yydebug = true
  do_parse
end

def next_token
  return [false, false] if @src.empty?
#  p @src.rest if @yydebug
  if ret = @src.scan(EM_OPEN_RE)
    @pre << ret
    [:EM_OPEN, ret]
  elsif ret = @src.scan(EM_CLOSE_RE)
    @pre << ret
    [:EM_CLOSE, ret]
  elsif ret = @src.scan(CODE_OPEN_RE)
    @pre << ret
    [:CODE_OPEN, ret]
  elsif ret = @src.scan(CODE_CLOSE_RE)
    @pre << ret
    [:CODE_CLOSE, ret]
  elsif ret = @src.scan(VAR_OPEN_RE)
    @pre << ret
    [:VAR_OPEN, ret]
  elsif ret = @src.scan(VAR_CLOSE_RE)
    @pre << ret
    [:VAR_CLOSE, ret]
  elsif ret = @src.scan(KBD_OPEN_RE)
    @pre << ret
    [:KBD_OPEN, ret]
  elsif ret = @src.scan(KBD_CLOSE_RE)
    @pre << ret
    [:KBD_CLOSE, ret]
  elsif ret = @src.scan(INDEX_OPEN_RE)
    @pre << ret
    [:INDEX_OPEN, ret]
  elsif ret = @src.scan(INDEX_CLOSE_RE)
    @pre << ret
    [:INDEX_CLOSE, ret]
  elsif ret = @src.scan(REF_OPEN_RE)
    @pre << ret
    [:REF_OPEN, ret]
  elsif ret = @src.scan(REF_CLOSE_RE)
    @pre << ret
    [:REF_CLOSE, ret]
  elsif ret = @src.scan(FOOTNOTE_OPEN_RE)
    @pre << ret
    [:FOOTNOTE_OPEN, ret]
  elsif ret = @src.scan(FOOTNOTE_CLOSE_RE)
    @pre << ret
    [:FOOTNOTE_CLOSE, ret]
  elsif ret = @src.scan(VERB_OPEN_RE)
    @pre << ret
    [:VERB_OPEN, ret]
  elsif ret = @src.scan(VERB_CLOSE_RE)
    @pre << ret
    [:VERB_CLOSE, ret]
  elsif ret = @src.scan(BAR_RE)
    @pre << ret
    [:BAR, ret]
  elsif ret = @src.scan(QUOTE_RE)
    @pre << ret
    [:QUOTE, ret]
  elsif ret = @src.scan(SLASH_RE)
    @pre << ret
    [:SLASH, ret]
  elsif ret = @src.scan(BACK_SLASH_RE)
    @pre << ret
    [:BACK_SLASH, ret]
  elsif ret = @src.scan(URL_RE)
    @pre << ret
    [:URL, ret]
  elsif ret = @src.scan(OTHER_RE)
    @pre << ret
    [:OTHER, ret]
  else
    ret = @src.rest
    @pre << ret
    @src.clear
    [:OTHER, ret]
  end
end

def make_reference_from_label(label)
#  Reference.new_from_label_under_document_struct(label, tree.document_struct)
  Reference.new_from_label_without_document_struct(label)
end

def on_error(et, ev, values)
  lines_of_rest = @src.rest.to_a.length
  prev_words = prev_words_on_error(ev)
  at = 4 + prev_words.length
  message = <<-MSG
RD syntax error: line #{@blockp.line_index - lines_of_rest}:
...#{prev_words} #{(ev||'')} #{next_words_on_error()} ...
  MSG
  message << " " * at + "^" * (ev ? ev.length : 0) + "\n"
  raise ParseError, message
end

def prev_words_on_error(ev)
  pre = @pre
  if ev and /#{Regexp.quote(ev)}$/ =~ pre
    pre = $`
  end
  last_line(pre)
end

def last_line(src)
  if n = src.rindex("\n")
    src[(n+1) .. -1]
  else
    src
  end
end
private :last_line

def next_words_on_error
  if n = @src.rest.index("\n")
    @src.rest[0 .. (n-1)]
  else
    @src.rest
  end
end

..end rdinlineparser.ry modeval..id9d06b541e3

##### racc 1.3.9 generates ###

racc_reduce_table = [
 0, 0, :racc_error,
 1, 27, :_reduce_none,
 2, 28, :_reduce_2,
 1, 28, :_reduce_3,
 1, 29, :_reduce_none,
 1, 29, :_reduce_none,
 1, 29, :_reduce_none,
 1, 29, :_reduce_none,
 1, 29, :_reduce_none,
 1, 29, :_reduce_none,
 1, 29, :_reduce_none,
 1, 29, :_reduce_none,
 1, 29, :_reduce_none,
 3, 30, :_reduce_13,
 3, 31, :_reduce_14,
 3, 32, :_reduce_15,
 3, 33, :_reduce_16,
 3, 34, :_reduce_17,
 4, 35, :_reduce_18,
 3, 35, :_reduce_19,
 2, 40, :_reduce_20,
 2, 40, :_reduce_21,
 1, 40, :_reduce_22,
 1, 40, :_reduce_23,
 2, 41, :_reduce_24,
 2, 41, :_reduce_25,
 1, 41, :_reduce_26,
 1, 41, :_reduce_27,
 2, 39, :_reduce_none,
 4, 39, :_reduce_29,
 4, 39, :_reduce_30,
 2, 43, :_reduce_none,
 4, 43, :_reduce_32,
 1, 44, :_reduce_33,
 3, 44, :_reduce_34,
 1, 45, :_reduce_none,
 3, 45, :_reduce_36,
 3, 45, :_reduce_37,
 2, 46, :_reduce_38,
 2, 46, :_reduce_39,
 1, 46, :_reduce_40,
 1, 46, :_reduce_41,
 1, 47, :_reduce_none,
 2, 51, :_reduce_43,
 1, 51, :_reduce_44,
 2, 53, :_reduce_45,
 1, 53, :_reduce_46,
 1, 50, :_reduce_none,
 1, 50, :_reduce_none,
 1, 50, :_reduce_none,
 1, 50, :_reduce_none,
 1, 50, :_reduce_none,
 1, 50, :_reduce_none,
 1, 54, :_reduce_none,
 1, 54, :_reduce_none,
 1, 55, :_reduce_none,
 1, 55, :_reduce_none,
 1, 56, :_reduce_57,
 1, 52, :_reduce_58,
 1, 57, :_reduce_59,
 2, 58, :_reduce_60,
 1, 58, :_reduce_none,
 2, 49, :_reduce_62,
 1, 49, :_reduce_none,
 2, 48, :_reduce_64,
 1, 48, :_reduce_none,
 1, 60, :_reduce_none,
 1, 60, :_reduce_none,
 1, 60, :_reduce_none,
 1, 60, :_reduce_none,
 1, 60, :_reduce_none,
 1, 62, :_reduce_none,
 1, 62, :_reduce_none,
 1, 59, :_reduce_none,
 1, 59, :_reduce_none,
 1, 61, :_reduce_none,
 1, 61, :_reduce_none,
 1, 61, :_reduce_none,
 2, 42, :_reduce_78,
 1, 42, :_reduce_none,
 1, 63, :_reduce_none,
 2, 63, :_reduce_none,
 1, 63, :_reduce_none,
 1, 63, :_reduce_none,
 1, 63, :_reduce_none,
 1, 63, :_reduce_none,
 1, 63, :_reduce_none,
 1, 63, :_reduce_none,
 1, 63, :_reduce_none,
 1, 63, :_reduce_none,
 1, 63, :_reduce_none,
 1, 63, :_reduce_none,
 1, 63, :_reduce_none,
 1, 63, :_reduce_none,
 1, 63, :_reduce_none,
 1, 63, :_reduce_none,
 1, 63, :_reduce_none,
 1, 63, :_reduce_none,
 1, 63, :_reduce_none,
 1, 63, :_reduce_none,
 1, 63, :_reduce_none,
 3, 36, :_reduce_101,
 3, 37, :_reduce_102,
 1, 65, :_reduce_none,
 1, 65, :_reduce_none,
 1, 65, :_reduce_none,
 1, 65, :_reduce_none,
 1, 65, :_reduce_none,
 1, 65, :_reduce_none,
 2, 66, :_reduce_109,
 1, 66, :_reduce_none,
 1, 38, :_reduce_111,
 1, 67, :_reduce_none,
 2, 67, :_reduce_113,
 2, 67, :_reduce_114,
 2, 67, :_reduce_115,
 1, 68, :_reduce_none,
 1, 68, :_reduce_none,
 1, 68, :_reduce_none,
 1, 68, :_reduce_none,
 1, 68, :_reduce_none,
 1, 68, :_reduce_none,
 1, 68, :_reduce_none,
 1, 68, :_reduce_none,
 1, 68, :_reduce_none,
 1, 68, :_reduce_none,
 1, 68, :_reduce_none,
 1, 68, :_reduce_none,
 1, 68, :_reduce_none,
 1, 68, :_reduce_none,
 1, 68, :_reduce_none,
 1, 68, :_reduce_none,
 1, 68, :_reduce_none,
 1, 68, :_reduce_none,
 1, 68, :_reduce_none,
 1, 68, :_reduce_none,
 2, 64, :_reduce_136,
 1, 64, :_reduce_none ]

racc_reduce_n = 138

racc_shift_n = 179

racc_action_table = [
   129,   131,   134,   137,   139,   120,   122,   124,   127,   117,
   133,   136,   138,   119,   123,   125,   128,   130,   132,   135,
   147,   118,   121,   129,   131,   134,   137,   139,   120,   122,
   124,   127,   164,   133,   136,   138,   119,   123,   125,   128,
   130,   132,   135,   165,   118,   121,   129,   131,   134,   137,
   139,   120,   122,   124,   127,    89,   133,   136,   138,   119,
   123,   125,   128,   130,   132,   135,   153,   118,   121,    40,
    42,    46,    88,    50,    31,    33,    35,    38,   148,    45,
    48,    52,    30,    34,    36,    39,    41,    44,    47,    51,
    29,    86,   129,   131,   134,   137,   139,   120,   122,   124,
   127,    90,   133,   136,   138,   119,   123,   125,   128,   130,
   132,   135,   149,   118,   121,    40,    42,    46,    49,    50,
    31,    33,    35,    38,   160,    45,    48,    52,    30,    34,
    36,    39,    41,    44,    47,    51,    29,    84,    11,    15,
    18,    23,    26,     1,     5,     9,   171,   172,    20,   173,
    27,    89,     6,   175,    12,    79,    19,    94,   151,     2,
    69,   100,    53,    55,    59,    62,   152,    20,   172,    27,
   150,     6,   nil,    12,   nil,    19,   nil,   nil,     2,    11,
    15,    18,    23,    26,     1,     5,     9,   nil,   nil,    20,
   nil,    27,   nil,     6,   nil,    12,   nil,    19,   nil,   nil,
     2,    11,    15,    18,    23,    26,     1,     5,     9,   nil,
   nil,    20,   nil,    27,   nil,     6,   nil,    12,   nil,    19,
   nil,   nil,     2,    11,    15,    18,    23,    26,     1,     5,
     9,   nil,   nil,    20,   nil,    27,   nil,     6,   nil,    12,
   nil,    19,   nil,   nil,     2,    11,    15,    18,    23,    26,
     1,     5,     9,   nil,   nil,    20,   nil,    27,   nil,     6,
   nil,    12,   nil,    19,   nil,   nil,     2,    11,    15,    18,
    23,    26,     1,     5,     9,   nil,   nil,    20,   nil,    27,
   nil,     6,   nil,    12,   nil,    19,   nil,   nil,     2,    11,
    15,    18,    23,    26,     1,     5,     9,   nil,   nil,    20,
   nil,    27,   nil,     6,   nil,    12,   nil,    19,   nil,   nil,
     2,    40,    42,    46,    49,    50,    31,    33,    35,    38,
   nil,    45,    48,    52,    30,    34,    36,    39,    41,    44,
    47,    51,    29,    94,   nil,   nil,    69,   100,    53,    55,
    59,    62,   nil,    20,   nil,    27,   nil,     6,   nil,    12,
   nil,    19,    94,   nil,     2,    69,   100,    53,    55,    59,
    62,   nil,    20,   nil,    27,   nil,     6,   nil,    12,   nil,
    19,    63,   nil,     2,    69,    73,    53,    55,    59,    62,
   nil,    20,   nil,    27,   nil,     6,   nil,    12,   112,    19,
   nil,    69,     2,    53,    55,    59,    62,   nil,    20,   nil,
    27,   nil,     6,   nil,    12,   nil,    19,    94,   nil,     2,
    69,   100,    53,    55,    59,    62,   nil,    20,   nil,    27,
   nil,     6,   nil,    12,   nil,    19,   nil,   nil,     2,    11,
    15,    18,    23,    26,     1,     5,     9,   nil,   nil,    20,
   nil,    27,   nil,     6,   nil,    12,   nil,    19,   nil,   nil,
     2,   104,   105,    69,   100,    53,    55,    59,    62,   nil,
    20,   nil,    27,   nil,     6,   nil,    12,   nil,    19,   nil,
   nil,     2,   104,   105,    69,   100,    53,    55,    59,    62,
   nil,    20,   nil,    27,   nil,     6,   nil,    12,   nil,    19,
   nil,   nil,     2,   104,   105,    69,   100,    53,    55,    59,
    62,   nil,    20,   nil,    27,   nil,     6,   nil,    12,   nil,
    19,    94,   nil,     2,    69,   100,    53,    55,    59,    62,
   168,   nil,   nil,    69,   nil,    53,    55,    59,    62,   143,
   nil,   nil,    69,   146,    53,    55,    59,    62,    94,   nil,
   nil,    69,   100,    53,    55,    59,    62,   174,   104,   105,
    69,   100,    53,    55,    59,    62,   156,   104,   105,    69,
   100,    53,    55,    59,    62,   176,   104,   105,    69,   100,
    53,    55,    59,    62,   178,   104,   105,    69,   100,    53,
    55,    59,    62,   104,   105,    69,   100,    53,    55,    59,
    62,   104,   105,    69,   100,    53,    55,    59,    62,   104,
   105,    69,   100,    53,    55,    59,    62,    11,    15,    18,
    23,    26,     1 ]

racc_action_check = [
   146,   146,   146,   146,   146,   146,   146,   146,   146,    71,
   146,   146,   146,   146,   146,   146,   146,   146,   146,   146,
    75,   146,   146,   126,   126,   126,   126,   126,   126,   126,
   126,   126,   137,   126,   126,   126,   126,   126,   126,   126,
   126,   126,   126,   141,   126,   126,    73,    73,    73,    73,
    73,    73,    73,    73,    73,   142,    73,    73,    73,    73,
    73,    73,    73,    73,    73,    73,    83,    73,    73,    49,
    49,    49,    49,    49,    49,    49,    49,    49,    77,    49,
    49,    49,    49,    49,    49,    49,    49,    49,    49,    49,
    49,    49,   170,   170,   170,   170,   170,   170,   170,   170,
   170,    58,   170,   170,   170,   170,   170,   170,   170,   170,
   170,   170,    78,   170,   170,    32,    32,    32,    32,    32,
    32,    32,    32,    32,   110,    32,    32,    32,    32,    32,
    32,    32,    32,    32,    32,    32,    32,    32,     0,     0,
     0,     0,     0,     0,     0,     0,   156,   156,     0,   160,
     0,    57,     0,   162,     0,    14,     0,    96,    81,     0,
    96,    96,    96,    96,    96,    96,    82,    96,   176,    96,
    79,    96,   nil,    96,   nil,    96,   nil,   nil,    96,    17,
    17,    17,    17,    17,    17,    17,    17,   nil,   nil,    17,
   nil,    17,   nil,    17,   nil,    17,   nil,    17,   nil,   nil,
    17,    19,    19,    19,    19,    19,    19,    19,    19,   nil,
   nil,    19,   nil,    19,   nil,    19,   nil,    19,   nil,    19,
   nil,   nil,    19,    20,    20,    20,    20,    20,    20,    20,
    20,   nil,   nil,    20,   nil,    20,   nil,    20,   nil,    20,
   nil,    20,   nil,   nil,    20,    27,    27,    27,    27,    27,
    27,    27,    27,   nil,   nil,    27,   nil,    27,   nil,    27,
   nil,    27,   nil,    27,   nil,   nil,    27,     9,     9,     9,
     9,     9,     9,     9,     9,   nil,   nil,     9,   nil,     9,
   nil,     9,   nil,     9,   nil,     9,   nil,   nil,     9,     6,
     6,     6,     6,     6,     6,     6,     6,   nil,   nil,     6,
   nil,     6,   nil,     6,   nil,     6,   nil,     6,   nil,   nil,
     6,     2,     2,     2,     2,     2,     2,     2,     2,     2,
   nil,     2,     2,     2,     2,     2,     2,     2,     2,     2,
     2,     2,     2,    66,   nil,   nil,    66,    66,    66,    66,
    66,    66,   nil,    66,   nil,    66,   nil,    66,   nil,    66,
   nil,    66,    61,   nil,    66,    61,    61,    61,    61,    61,
    61,   nil,    61,   nil,    61,   nil,    61,   nil,    61,   nil,
    61,     5,   nil,    61,     5,     5,     5,     5,     5,     5,
   nil,     5,   nil,     5,   nil,     5,   nil,     5,    64,     5,
   nil,    64,     5,    64,    64,    64,    64,   nil,    64,   nil,
    64,   nil,    64,   nil,    64,   nil,    64,   116,   nil,    64,
   116,   116,   116,   116,   116,   116,   nil,   116,   nil,   116,
   nil,   116,   nil,   116,   nil,   116,   nil,   nil,   116,    12,
    12,    12,    12,    12,    12,    12,    12,   nil,   nil,    12,
   nil,    12,   nil,    12,   nil,    12,   nil,    12,   nil,   nil,
    12,   112,   112,   112,   112,   112,   112,   112,   112,   nil,
   112,   nil,   112,   nil,   112,   nil,   112,   nil,   112,   nil,
   nil,   112,    63,    63,    63,    63,    63,    63,    63,    63,
   nil,    63,   nil,    63,   nil,    63,   nil,    63,   nil,    63,
   nil,   nil,    63,   107,   107,   107,   107,   107,   107,   107,
   107,   nil,   107,   nil,   107,   nil,   107,   nil,   107,   nil,
   107,    65,   nil,   107,    65,    65,    65,    65,    65,    65,
   144,   nil,   nil,   144,   nil,   144,   144,   144,   144,    74,
   nil,   nil,    74,    74,    74,    74,    74,    74,    92,   nil,
   nil,    92,    92,    92,    92,    92,    92,   161,   161,   161,
   161,   161,   161,   161,   161,   161,   101,   101,   101,   101,
   101,   101,   101,   101,   101,   166,   166,   166,   166,   166,
   166,   166,   166,   166,   177,   177,   177,   177,   177,   177,
   177,   177,   177,   143,   143,   143,   143,   143,   143,   143,
   143,   158,   158,   158,   158,   158,   158,   158,   158,   168,
   168,   168,   168,   168,   168,   168,   168,     8,     8,     8,
     8,     8,     8 ]

racc_action_pointer = [
   135,   nil,   308,   nil,   nil,   368,   286,   nil,   604,   264,
   nil,   nil,   426,   nil,   155,   nil,   nil,   176,   nil,   198,
   220,   nil,   nil,   nil,   nil,   nil,   nil,   242,   nil,   nil,
   nil,   nil,   112,   nil,   nil,   nil,   nil,   nil,   nil,   nil,
   nil,   nil,   nil,   nil,   nil,   nil,   nil,   nil,   nil,    66,
   nil,   nil,   nil,   nil,   nil,   nil,   nil,   146,    78,   nil,
   nil,   349,   nil,   468,   385,   508,   330,   nil,   nil,   nil,
   nil,     5,   nil,    43,   526,     2,   nil,    67,    92,   170,
   nil,   136,   152,    50,   nil,   nil,   nil,   nil,   nil,   nil,
   nil,   nil,   535,   nil,   nil,   nil,   154,   nil,   nil,   nil,
   nil,   553,   nil,   nil,   nil,   nil,   nil,   489,   nil,   nil,
   121,   nil,   447,   nil,   nil,   nil,   404,   nil,   nil,   nil,
   nil,   nil,   nil,   nil,   nil,   nil,    20,   nil,   nil,   nil,
   nil,   nil,   nil,   nil,   nil,   nil,   nil,    26,   nil,   nil,
   nil,    20,    50,   579,   517,   nil,    -3,   nil,   nil,   nil,
   nil,   nil,   nil,   nil,   nil,   nil,   142,   nil,   587,   nil,
   145,   544,   150,   nil,   nil,   nil,   562,   nil,   595,   nil,
    89,   nil,   nil,   nil,   nil,   nil,   163,   571,   nil ]

racc_action_default = [
  -138,  -103,  -138,    -6,  -110,  -138,  -138,    -7,  -111,  -138,
    -8,  -104,  -138,    -9,  -138,  -105,   -10,    -1,  -106,  -138,
  -138,   -11,    -3,  -107,   -12,    -4,  -108,  -138,    -5,  -134,
  -123,  -116,  -138,  -130,  -124,  -132,  -125,  -137,  -133,  -126,
  -117,  -127,  -118,  -112,  -128,  -120,  -119,  -129,  -121,  -138,
  -135,  -131,  -122,   -66,   -49,   -68,   -50,   -58,  -138,   -69,
   -51,   -41,   -70,  -138,   -27,   -63,   -40,   -52,   -26,   -67,
   -47,   -35,   -48,  -138,  -138,  -138,  -109,  -138,  -138,  -138,
    -2,  -138,  -138,  -138,  -102,  -136,  -114,  -113,  -115,   -31,
   -19,   -54,   -57,   -53,   -74,   -61,   -38,   -71,   -73,   -44,
   -72,   -59,   -56,   -55,   -76,   -77,   -65,   -42,   -75,   -46,
  -138,   -58,  -138,   -25,   -35,   -62,   -39,   -28,   -99,   -89,
   -80,  -100,   -96,   -90,   -97,   -91,   -24,   -98,   -92,   -85,
   -93,   -84,   -94,   -86,   -83,   -95,   -87,  -138,   -88,   -82,
   -79,  -138,   -33,  -138,   -23,   -22,  -138,   -15,  -101,   -16,
   179,   -17,   -13,   -14,   -60,   -43,   -37,   -64,   -59,   -45,
   -36,   -59,  -138,   -78,   -81,   -18,  -138,   -33,  -138,   -21,
   -20,   -30,   -32,   -29,   -37,   -36,   -34,  -138,   -34 ]

racc_goto_table = [
    57,    65,   101,    61,   126,   145,    68,   157,   110,    64,
    37,   163,    71,   155,   154,    96,    14,   141,   115,    98,
   116,   159,    75,    98,    98,    77,    74,    58,    78,    32,
    76,    80,    87,   155,   nil,    81,    82,   154,   nil,   nil,
    85,   nil,   nil,    83,   nil,   nil,   158,   nil,   nil,   nil,
    98,   161,   nil,   nil,    98,   163,   nil,   162,   nil,   111,
    65,   103,    61,   nil,   157,   113,   nil,   157,   nil,   142,
    65,   114,   157,    98,    98,   169,   nil,   170,   144,     7,
   nil,   nil,   166,   157,   nil,     7,   nil,   nil,     7,   nil,
   nil,     7,   nil,   nil,   nil,   nil,     7,   nil,     7,     7,
   nil,   nil,    25,   nil,   nil,   103,     7,   177,    25,   nil,
   103,    25,   nil,   nil,    25,   nil,   nil,   nil,    28,    25,
   nil,    25,    25,   nil,    28,   nil,   nil,    28,   nil,    25,
    28,   nil,   nil,   nil,   nil,    28,   nil,    28,    28,   167,
    65,    21,   nil,   nil,   nil,    28,   nil,    21,   nil,   nil,
    21,   nil,   nil,    21,   nil,   nil,   nil,     3,    21,   nil,
    21,    21,   nil,     3,   nil,   nil,     3,   nil,    21,     3,
   nil,   nil,   nil,    10,     3,   nil,     3,     3,   nil,    10,
   nil,   nil,    10,   nil,     3,    10,   nil,   nil,   nil,   nil,
    10,   nil,    10,    10,   nil,   nil,   nil,   nil,   nil,   nil,
    10 ]

racc_goto_check = [
    23,    34,    22,    24,    16,    18,    19,    35,    21,    17,
    41,    37,    20,    28,    33,    25,     1,    14,    32,    36,
    25,    29,     1,    36,    36,     1,    13,    15,     1,    38,
    39,     3,    42,    28,   nil,     1,     1,    33,   nil,   nil,
    41,   nil,   nil,     1,   nil,   nil,    22,   nil,   nil,   nil,
    36,    22,   nil,   nil,    36,    37,   nil,    21,   nil,    23,
    34,    24,    24,   nil,    35,    19,   nil,    35,   nil,    23,
    34,    20,    35,    36,    36,    18,   nil,    16,    17,     7,
   nil,   nil,    22,    35,   nil,     7,   nil,   nil,     7,   nil,
   nil,     7,   nil,   nil,   nil,   nil,     7,   nil,     7,     7,
   nil,   nil,     4,   nil,   nil,    24,     7,    22,     4,   nil,
    24,     4,   nil,   nil,     4,   nil,   nil,   nil,     5,     4,
   nil,     4,     4,   nil,     5,   nil,   nil,     5,   nil,     4,
     5,   nil,   nil,   nil,   nil,     5,   nil,     5,     5,    23,
    34,    11,   nil,   nil,   nil,     5,   nil,    11,   nil,   nil,
    11,   nil,   nil,    11,   nil,   nil,   nil,     6,    11,   nil,
    11,    11,   nil,     6,   nil,   nil,     6,   nil,    11,     6,
   nil,   nil,   nil,     8,     6,   nil,     6,     6,   nil,     8,
   nil,   nil,     8,   nil,     6,     8,   nil,   nil,   nil,   nil,
     8,   nil,     8,     8,   nil,   nil,   nil,   nil,   nil,   nil,
     8 ]

racc_goto_pointer = [
   nil,    16,   nil,    14,   102,   118,   157,    79,   173,   nil,
   nil,   141,   nil,    21,   -57,    22,   -69,     4,   -69,     1,
     7,   -55,   -61,    -5,    -2,   -46,   nil,   nil,   -83,   -86,
   nil,   nil,   -47,   -78,    -4,   -94,   -42,  -115,    27,    22,
   nil,     8,   -17 ]

racc_goto_default = [
   nil,   nil,    17,    22,    70,    72,    54,    56,    60,    13,
    16,    67,    24,   nil,   nil,   nil,   nil,   nil,   nil,   nil,
   nil,   nil,   nil,   nil,    93,   nil,    66,   107,    99,   109,
    91,   102,    92,    95,    97,   106,   108,   140,   nil,     4,
     8,   nil,    43 ]

racc_token_table = {
 false => 0,
 Object.new => 1,
 :EX_LOW => 2,
 :QUOTE => 3,
 :BAR => 4,
 :SLASH => 5,
 :BACK_SLASH => 6,
 :URL => 7,
 :OTHER => 8,
 :REF_OPEN => 9,
 :FOOTNOTE_OPEN => 10,
 :FOOTNOTE_CLOSE => 11,
 :EX_HIGH => 12,
 :EM_OPEN => 13,
 :EM_CLOSE => 14,
 :CODE_OPEN => 15,
 :CODE_CLOSE => 16,
 :VAR_OPEN => 17,
 :VAR_CLOSE => 18,
 :KBD_OPEN => 19,
 :KBD_CLOSE => 20,
 :INDEX_OPEN => 21,
 :INDEX_CLOSE => 22,
 :REF_CLOSE => 23,
 :VERB_OPEN => 24,
 :VERB_CLOSE => 25 }

racc_use_result_var = true

racc_nt_base = 26

Racc_arg = [
 racc_action_table,
 racc_action_check,
 racc_action_default,
 racc_action_pointer,
 racc_goto_table,
 racc_goto_check,
 racc_goto_default,
 racc_goto_pointer,
 racc_nt_base,
 racc_reduce_table,
 racc_token_table,
 racc_shift_n,
 racc_reduce_n,
 racc_use_result_var ]

Racc_token_to_s_table = [
'$end',
'error',
'EX_LOW',
'QUOTE',
'BAR',
'SLASH',
'BACK_SLASH',
'URL',
'OTHER',
'REF_OPEN',
'FOOTNOTE_OPEN',
'FOOTNOTE_CLOSE',
'EX_HIGH',
'EM_OPEN',
'EM_CLOSE',
'CODE_OPEN',
'CODE_CLOSE',
'VAR_OPEN',
'VAR_CLOSE',
'KBD_OPEN',
'KBD_CLOSE',
'INDEX_OPEN',
'INDEX_CLOSE',
'REF_CLOSE',
'VERB_OPEN',
'VERB_CLOSE',
'$start',
'content',
'elements',
'element',
'emphasis',
'code',
'var',
'keyboard',
'index',
'reference',
'footnote',
'verb',
'normal_str_ele',
'substitute',
'ref_label',
'ref_label2',
'ref_url_strings',
'filename',
'element_label',
'element_label2',
'ref_subst_content',
'ref_subst_content_q',
'ref_subst_strings_q',
'ref_subst_strings_first',
'ref_subst_ele2',
'ref_subst_eles',
'ref_subst_str_ele_first',
'ref_subst_eles_q',
'ref_subst_ele',
'ref_subst_ele_q',
'ref_subst_str_ele',
'ref_subst_str_ele_q',
'ref_subst_strings',
'ref_subst_string3',
'ref_subst_string',
'ref_subst_string_q',
'ref_subst_string2',
'ref_url_string',
'verb_strings',
'normal_string',
'normal_strings',
'verb_string',
'verb_normal_string']

Racc_debug_parser = false

##### racc system variables end #####

 # reduce 0 omitted

 # reduce 1 omitted

module_eval <<'.,.,', 'rdinlineparser.ry', 23
  def _reduce_2( val, _values, result )
 result.push(val[1])
   result
  end
.,.,

module_eval <<'.,.,', 'rdinlineparser.ry', 24
  def _reduce_3( val, _values, result )
 result = val
   result
  end
.,.,

 # reduce 4 omitted

 # reduce 5 omitted

 # reduce 6 omitted

 # reduce 7 omitted

 # reduce 8 omitted

 # reduce 9 omitted

 # reduce 10 omitted

 # reduce 11 omitted

 # reduce 12 omitted

module_eval <<'.,.,', 'rdinlineparser.ry', 38
  def _reduce_13( val, _values, result )
		result = Emphasis.new
                add_children_to_element(result, *val[1])
   result
  end
.,.,

module_eval <<'.,.,', 'rdinlineparser.ry', 43
  def _reduce_14( val, _values, result )
		result = Code.new
                add_children_to_element(result, *val[1])
   result
  end
.,.,

module_eval <<'.,.,', 'rdinlineparser.ry', 48
  def _reduce_15( val, _values, result )
		result = Var.new
                add_children_to_element(result, *val[1])
   result
  end
.,.,

module_eval <<'.,.,', 'rdinlineparser.ry', 53
  def _reduce_16( val, _values, result )
		result = Keyboard.new
                add_children_to_element(result, *val[1])
   result
  end
.,.,

module_eval <<'.,.,', 'rdinlineparser.ry', 58
  def _reduce_17( val, _values, result )
		result = Index.new
                add_children_to_element(result, *val[1])
   result
  end
.,.,

module_eval <<'.,.,', 'rdinlineparser.ry', 67
  def _reduce_18( val, _values, result )
 result = Reference.new(val[2])
                          add_children_to_element(result, *val[1])
   result
  end
.,.,

module_eval <<'.,.,', 'rdinlineparser.ry', 72
  def _reduce_19( val, _values, result )
                          result = make_reference_from_label(val[1])
   result
  end
.,.,

module_eval <<'.,.,', 'rdinlineparser.ry', 76
  def _reduce_20( val, _values, result )
 result = Reference::URL.new(val[1])
   result
  end
.,.,

module_eval <<'.,.,', 'rdinlineparser.ry', 78
  def _reduce_21( val, _values, result )
 result = Reference::TemporaryLabel.new(val[1],
			           val[0])
   result
  end
.,.,

module_eval <<'.,.,', 'rdinlineparser.ry', 81
  def _reduce_22( val, _values, result )
 result = Reference::TemporaryLabel.new(val[0])
   result
  end
.,.,

module_eval <<'.,.,', 'rdinlineparser.ry', 82
  def _reduce_23( val, _values, result )
 result = Reference::TemporaryLabel.new([], val[0])
   result
  end
.,.,

module_eval <<'.,.,', 'rdinlineparser.ry', 84
  def _reduce_24( val, _values, result )
 result = Reference::URL.new(val[1])
   result
  end
.,.,

module_eval <<'.,.,', 'rdinlineparser.ry', 86
  def _reduce_25( val, _values, result )
 result = Reference::TemporaryLabel.new(val[1],
				   val[0])
   result
  end
.,.,

module_eval <<'.,.,', 'rdinlineparser.ry', 89
  def _reduce_26( val, _values, result )
 result = Reference::TemporaryLabel.new(val[0])
   result
  end
.,.,

module_eval <<'.,.,', 'rdinlineparser.ry', 90
  def _reduce_27( val, _values, result )
 result = Reference::TemporaryLabel.new([],
				     val[0])
   result
  end
.,.,

 # reduce 28 omitted

module_eval <<'.,.,', 'rdinlineparser.ry', 95
  def _reduce_29( val, _values, result )
 result = val[1]
   result
  end
.,.,

module_eval <<'.,.,', 'rdinlineparser.ry', 97
  def _reduce_30( val, _values, result )
 result = [StringElement.new(val[1])]
   result
  end
.,.,

 # reduce 31 omitted

module_eval <<'.,.,', 'rdinlineparser.ry', 102
  def _reduce_32( val, _values, result )
 result = val[1]
   result
  end
.,.,

module_eval <<'.,.,', 'rdinlineparser.ry', 107
  def _reduce_33( val, _values, result )
 result = [StringElement.new(val[0])]
   result
  end
.,.,

module_eval <<'.,.,', 'rdinlineparser.ry', 109
  def _reduce_34( val, _values, result )
 result = [StringElement.new(val[1])]
   result
  end
.,.,

 # reduce 35 omitted

module_eval <<'.,.,', 'rdinlineparser.ry', 115
  def _reduce_36( val, _values, result )
 result = val[1]
   result
  end
.,.,

module_eval <<'.,.,', 'rdinlineparser.ry', 117
  def _reduce_37( val, _values, result )
 result = [StringElement.new(val[1])]
   result
  end
.,.,

module_eval <<'.,.,', 'rdinlineparser.ry', 121
  def _reduce_38( val, _values, result )
 result = val[1].unshift(val[0])
   result
  end
.,.,

module_eval <<'.,.,', 'rdinlineparser.ry', 123
  def _reduce_39( val, _values, result )
 result = val[1].unshift(val[0])
   result
  end
.,.,

module_eval <<'.,.,', 'rdinlineparser.ry', 125
  def _reduce_40( val, _values, result )
 result = val
   result
  end
.,.,

module_eval <<'.,.,', 'rdinlineparser.ry', 126
  def _reduce_41( val, _values, result )
 result = val
   result
  end
.,.,

 # reduce 42 omitted

module_eval <<'.,.,', 'rdinlineparser.ry', 131
  def _reduce_43( val, _values, result )
 result.push(val[1])
   result
  end
.,.,

module_eval <<'.,.,', 'rdinlineparser.ry', 132
  def _reduce_44( val, _values, result )
 result = val
   result
  end
.,.,

module_eval <<'.,.,', 'rdinlineparser.ry', 135
  def _reduce_45( val, _values, result )
 result.push(val[1])
   result
  end
.,.,

module_eval <<'.,.,', 'rdinlineparser.ry', 136
  def _reduce_46( val, _values, result )
 result = val
   result
  end
.,.,

 # reduce 47 omitted

 # reduce 48 omitted

 # reduce 49 omitted

 # reduce 50 omitted

 # reduce 51 omitted

 # reduce 52 omitted

 # reduce 53 omitted

 # reduce 54 omitted

 # reduce 55 omitted

 # reduce 56 omitted

module_eval <<'.,.,', 'rdinlineparser.ry', 153
  def _reduce_57( val, _values, result )
 result = StringElement.new(val[0])
   result
  end
.,.,

module_eval <<'.,.,', 'rdinlineparser.ry', 156
  def _reduce_58( val, _values, result )
 result = StringElement.new(val[0])
   result
  end
.,.,

module_eval <<'.,.,', 'rdinlineparser.ry', 159
  def _reduce_59( val, _values, result )
 result = StringElement.new(val[0])
   result
  end
.,.,

module_eval <<'.,.,', 'rdinlineparser.ry', 163
  def _reduce_60( val, _values, result )
 result << val[1]
   result
  end
.,.,

 # reduce 61 omitted

module_eval <<'.,.,', 'rdinlineparser.ry', 169
  def _reduce_62( val, _values, result )
 result << val[1]
   result
  end
.,.,

 # reduce 63 omitted

module_eval <<'.,.,', 'rdinlineparser.ry', 173
  def _reduce_64( val, _values, result )
 result << val[1]
   result
  end
.,.,

 # reduce 65 omitted

 # reduce 66 omitted

 # reduce 67 omitted

 # reduce 68 omitted

 # reduce 69 omitted

 # reduce 70 omitted

 # reduce 71 omitted

 # reduce 72 omitted

 # reduce 73 omitted

 # reduce 74 omitted

 # reduce 75 omitted

 # reduce 76 omitted

 # reduce 77 omitted

module_eval <<'.,.,', 'rdinlineparser.ry', 196
  def _reduce_78( val, _values, result )
 result << val[1]
   result
  end
.,.,

 # reduce 79 omitted

 # reduce 80 omitted

 # reduce 81 omitted

 # reduce 82 omitted

 # reduce 83 omitted

 # reduce 84 omitted

 # reduce 85 omitted

 # reduce 86 omitted

 # reduce 87 omitted

 # reduce 88 omitted

 # reduce 89 omitted

 # reduce 90 omitted

 # reduce 91 omitted

 # reduce 92 omitted

 # reduce 93 omitted

 # reduce 94 omitted

 # reduce 95 omitted

 # reduce 96 omitted

 # reduce 97 omitted

 # reduce 98 omitted

 # reduce 99 omitted

 # reduce 100 omitted

module_eval <<'.,.,', 'rdinlineparser.ry', 227
  def _reduce_101( val, _values, result )
		result = Footnote.new
                add_children_to_element(result, *val[1])
   result
  end
.,.,

module_eval <<'.,.,', 'rdinlineparser.ry', 232
  def _reduce_102( val, _values, result )
				result = Verb.new(val[1])
   result
  end
.,.,

 # reduce 103 omitted

 # reduce 104 omitted

 # reduce 105 omitted

 # reduce 106 omitted

 # reduce 107 omitted

 # reduce 108 omitted

module_eval <<'.,.,', 'rdinlineparser.ry', 246
  def _reduce_109( val, _values, result )
 result << val[1]
   result
  end
.,.,

 # reduce 110 omitted

module_eval <<'.,.,', 'rdinlineparser.ry', 251
  def _reduce_111( val, _values, result )
 result = StringElement.new(val[0])
   result
  end
.,.,

 # reduce 112 omitted

module_eval <<'.,.,', 'rdinlineparser.ry', 256
  def _reduce_113( val, _values, result )
 result = val[1]
   result
  end
.,.,

module_eval <<'.,.,', 'rdinlineparser.ry', 257
  def _reduce_114( val, _values, result )
 result = val[1]
   result
  end
.,.,

module_eval <<'.,.,', 'rdinlineparser.ry', 258
  def _reduce_115( val, _values, result )
 result = val[1]
   result
  end
.,.,

 # reduce 116 omitted

 # reduce 117 omitted

 # reduce 118 omitted

 # reduce 119 omitted

 # reduce 120 omitted

 # reduce 121 omitted

 # reduce 122 omitted

 # reduce 123 omitted

 # reduce 124 omitted

 # reduce 125 omitted

 # reduce 126 omitted

 # reduce 127 omitted

 # reduce 128 omitted

 # reduce 129 omitted

 # reduce 130 omitted

 # reduce 131 omitted

 # reduce 132 omitted

 # reduce 133 omitted

 # reduce 134 omitted

 # reduce 135 omitted

module_eval <<'.,.,', 'rdinlineparser.ry', 283
  def _reduce_136( val, _values, result )
 result << val[1]
   result
  end
.,.,

 # reduce 137 omitted

 def _reduce_none( val, _values, result )
  result
 end

end   # class RDInlineParser

end # end of module RD

