require 'racc/parser'

require "rd/rdinlineparser.tab.rb"
require "rd/parser-util"

module RD

class RDParser < ::Racc::Parser

module_eval <<'..end rd/rdblockparser.ry modeval..id471b4dfcb3', 'rd/rdblockparser.ry', 231
include ParserUtility

TMPFILE = ["rdtmp", $$, 0]

attr_reader :tree

def initialize
  @inline_parser = RDInlineParser.new(self)
end

def parse(src, tree)
  @src = src
  @src.push(false)
  # RDtree
  @tree = tree
  
  # @i: index(line no.) of src
  @i = 0
  # stack for current indentation
  @indent_stack = []
  # how indented.
  @current_indent = @indent_stack.join("")
  # RDParser for tmp src
  @subparser = nil
  # which part is in now
  @in_part = nil
  @part_content = []

  @in_verbatim = false

  @yydebug = true
  do_parse
end

def next_token
  # preprocessing
  # if it is not in RD part
  # => method
  while @in_part != "rd"
    line = @src[@i]
    @i += 1 # next line
    
    case line
    # src end
    when false
      return [false, false]
    # RD part begin
    when /^=begin\s*(?:\bRD\b.*)?\s*$/
      if @in_part # if in non-RD part
	@part_content.push(line)
      else
	@in_part = "rd"
	return [:WHITELINE, "=begin\n"] # <= for textblockand
      end
    # non-RD part begin
    when /^=begin\s+(\w+)/
      part = $1
      if @in_part # if in non-RD part
	@part_content.push(line)
      else
	@in_part = part if @tree.filter[part] # if filter exists
#	p "BEGIN_PART: #{@in_part}" # DEBUG
      end
    # non-RD part end
    when /^=end/
      if @in_part # if in non-RD part
#	p "END_PART: #{@in_part}" # DEBUG
	# make Part-in object
	part = RD::Part.new(@part_content.join(""), @tree, "r")
	@part_content.clear
	# call filter, part_out is output(Part object)
	part_out = @tree.filter[@in_part].call(part)
	
	if @tree.filter[@in_part].mode == :rd # if output is RD formated
	  subtree = parse_subtree(part_out.to_a)
	else # if output is target formated
	  basename = TMPFILE.join('.')
	  TMPFILE[-1] += 1
	  tmpfile = open(@tree.tmp_dir + "/" + basename + ".#{@in_part}", "w")
	  tmpfile.print(part_out)
	  tmpfile.close
	  subtree = parse_subtree(["=begin\n", "<<< #{basename}\n", "=end\n"])
	end
	@in_part = nil
	return [:SUBTREE, subtree]
      end
    else
      if @in_part # if in non-RD part
	@part_content.push(line)
      end
    end
  end

  @current_indent = @indent_stack.join("")
  line = @src[@i]
  case line
  when false
    if_current_indent_equal("") do
      [false, false]
    end
  when /^=end/
    if_current_indent_equal("") do
      @in_part = nil
      [:WHITELINE, "=end"] # MUST CHANGE??
    end
  when /^\s*$/
    @i += 1 # next line
    return [:WHITELINE, ':WHITELINE']
  when /^\#/  # comment line
    @i += 1 # next line
    return [:WHITELINE, '(:COMMENT) ' + $']
  when /^(={1,4})(?!=)\s*(?=\S)/, /^(\+{1,2})(?!\+)\s*(?=\S)/
    rest = $'                    # '
    rest.chomp!
    mark = $1
    if_current_indent_equal("") do
      return [:HEADLINE, [Headline.mark_to_level(mark), rest]]
    end
  when /^<<<\s*(\S+)/
    file = $1
    if_current_indent_equal("") do
      suffix = file[-3 .. -1] 
      if suffix == ".rd" or suffix == ".rb"
	subtree = parse_subtree(get_included(file))
	[:SUBTREE, subtree]
      else
	[:INCLUDE, file]
      end
    end
  when /^(\s*)\*(\s*)/
    rest = $'                   # '
    newIndent = $2
    if_current_indent_equal($1) do
      if @in_verbatim
	[:STRINGLINE, line]
      else
	@indent_stack.push("\s" << newIndent)
	[:ITEMLISTLINE, rest]
      end
    end
  when /^(\s*)(\(\d+\))(\s*)/
    rest = $'                     # '
    mark = $2
    newIndent = $3
    if_current_indent_equal($1) do
      if @in_verbatim
	[:STRINGLINE, line]
      else
	@indent_stack.push("\s" * mark.size << newIndent)
	[:ENUMLISTLINE, rest]
      end
    end
  when /^(\s*):(\s*)/
    rest = $'                    # '
    newIndent = $2
    if_current_indent_equal($1) do
      if @in_verbatim
	[:STRINGLINE, line]
      else
	@indent_stack.push("\s" <<$2)
	[:DESCLISTLINE, rest]
      end
    end
  when /^(\s*)---(?!-)/
    indent = $1
    rest = $'
    /\s*/ === rest
    term = $'
    new_indent = $&
    if_current_indent_equal(indent) do
      if @in_verbatim
	[:STRINGLINE, line]
      else
	@indent_stack.push("\s\s\s" + new_indent)
	[:METHODLISTLINE, term]
      end
    end
  when /^(\s*)/
    if_current_indent_equal($1) do
      [:STRINGLINE, line]
    end
  else
    raise "[BUG] parsing error may occured."
  end
end

=begin private
  --- RDParser#if_current_indent_equal(indent)
        if (({@current_indent == ((|indent|))})) then yield block, otherwise
        process indentation.
=end
def if_current_indent_equal(indent)
  if @current_indent == indent
    @i += 1 # next line
    yield
  elsif indent.index(@current_indent) == 0
    @indent_stack.push(indent[@current_indent.size .. -1])
    [:INDENT, ":INDENT"]
  else
    @indent_stack.pop
    [:DEDENT, ":DEDENT"]
  end
end
private :if_current_indent_equal

def cut_off(src)
  ret = []
  whiteline_buf = []
  line = src.shift
  /^\s*/ =~ line
  indent = Regexp.quote($&)
  ret.push($')                 # '
  while line = src.shift
    if /^(\s*)$/ =~ line
      whiteline_buf.push(line)
    elsif /^#{indent}/ =~ line
      unless whiteline_buf.empty?
	ret.concat(whiteline_buf)
	whiteline_buf.clear
      end
      ret.push($')            # '
    else
      raise "[BUG]: probably Parser Error while cutting off.\n"
    end
  end
  ret
end
private :cut_off

def set_term_to_element(parent, term)
#  parent.set_term_under_document_struct(term, @tree.document_struct)
  parent.set_term_without_document_struct(term)
end
private :set_term_to_element

def on_error( et, ev, _values )
  line = @src[@i]
  prv, cur, nxt = format_line_num(@i, @i+1, @i+2)
  
  raise ParseError, <<Msg

RD syntax error: line #{@i+1}:
  #{prv}  |#{@src[@i-1].chomp}
  #{cur}=>|#{@src[@i].chomp}
  #{nxt}  |#{@src[@i+1].chomp}

Msg
end

def line_index
  @i
end

def parse_subtree(src)
  @subparser = RD::RDParser.new() unless @subparser
  
  @subparser.parse(src, @tree)
end
private :parse_subtree

def get_included(file)
  included = ""
  @tree.include_path.each do |dir|
    file_name = dir + "/" + file
    if test(?e, file_name)
      included = IO.readlines(file_name)
      break
    end
  end
  included
end
private :get_included

def format_line_num(*args)
  width = args.collect{|i| i.to_s.length }.max
  args.collect{|i| sprintf("%#{width}d", i) }
end
private :format_line_num

..end rd/rdblockparser.ry modeval..id471b4dfcb3

##### racc 1.3.9 generates ###

racc_reduce_table = [
 0, 0, :racc_error,
 1, 15, :_reduce_1,
 0, 15, :_reduce_2,
 2, 16, :_reduce_3,
 1, 16, :_reduce_none,
 1, 17, :_reduce_5,
 1, 17, :_reduce_6,
 1, 17, :_reduce_none,
 1, 17, :_reduce_8,
 1, 17, :_reduce_9,
 1, 17, :_reduce_10,
 1, 17, :_reduce_11,
 1, 21, :_reduce_12,
 1, 22, :_reduce_13,
 1, 18, :_reduce_14,
 2, 23, :_reduce_15,
 1, 23, :_reduce_16,
 3, 19, :_reduce_17,
 1, 25, :_reduce_18,
 2, 24, :_reduce_19,
 4, 24, :_reduce_20,
 2, 24, :_reduce_21,
 1, 24, :_reduce_22,
 1, 26, :_reduce_none,
 1, 26, :_reduce_none,
 1, 26, :_reduce_none,
 1, 26, :_reduce_none,
 1, 20, :_reduce_none,
 3, 20, :_reduce_28,
 4, 20, :_reduce_29,
 2, 31, :_reduce_30,
 1, 31, :_reduce_31,
 1, 27, :_reduce_32,
 2, 32, :_reduce_33,
 1, 32, :_reduce_34,
 3, 33, :_reduce_35,
 1, 28, :_reduce_36,
 2, 36, :_reduce_37,
 1, 36, :_reduce_38,
 3, 37, :_reduce_39,
 1, 29, :_reduce_40,
 2, 39, :_reduce_41,
 1, 39, :_reduce_42,
 3, 40, :_reduce_43,
 1, 30, :_reduce_44,
 2, 42, :_reduce_45,
 1, 42, :_reduce_46,
 3, 43, :_reduce_47,
 3, 41, :_reduce_48,
 2, 41, :_reduce_49,
 4, 41, :_reduce_50,
 1, 41, :_reduce_51,
 2, 45, :_reduce_52,
 1, 45, :_reduce_none,
 1, 46, :_reduce_54,
 1, 46, :_reduce_55,
 1, 46, :_reduce_none,
 1, 46, :_reduce_57,
 1, 44, :_reduce_none,
 0, 44, :_reduce_none,
 2, 47, :_reduce_none,
 1, 47, :_reduce_none,
 2, 34, :_reduce_62,
 1, 34, :_reduce_63,
 2, 38, :_reduce_64,
 1, 38, :_reduce_65,
 2, 35, :_reduce_66,
 2, 35, :_reduce_67,
 2, 35, :_reduce_68,
 1, 35, :_reduce_69,
 1, 35, :_reduce_none,
 1, 35, :_reduce_71,
 0, 35, :_reduce_72 ]

racc_reduce_n = 73

racc_shift_n = 89

racc_action_table = [
    13,    18,    23,    27,    33,    59,    80,    49,    49,    21,
    88,    13,    18,    23,    27,    48,    13,    18,    23,    27,
    48,    74,    13,    18,    23,    27,    33,    59,    49,    76,
    23,    21,    13,    18,    23,    27,    33,    59,    79,    57,
    81,    21,    13,    18,    23,    27,    66,    39,    18,    33,
    48,    21,    13,    18,    23,    27,    33,    59,    58,    84,
    33,    21,    13,    18,    23,    27,    33,    59,    27,    57,
    13,    21,    13,    18,    23,    27,    33,     3,     6,    11,
    16,    21,    13,    18,    23,    27,    33,    59,    57,   nil,
   nil,    21,    13,    18,    23,    27,    33,    59,   nil,   nil,
   nil,    21,    13,    18,    23,    27,    33,    59,   nil,   nil,
   nil,    21,    13,    18,    23,    27,   nil,    39,   nil,   nil,
   nil,    21,    13,    18,    23,    27,    33,    59,   nil,   nil,
   nil,    21,    13,    18,    23,    27,    33,    59,   nil,   nil,
   nil,    21,    13,    18,    23,    27,    33,     3,     6,    11,
    16,    21,    71,    68,    71,    68,   nil,    69,    70,    69,
    87,    71,    68,    33,   nil,   nil,    69,   nil,    78,    13,
    18,    23,    27 ]

racc_action_check = [
    86,    86,    86,    86,    86,    86,    54,    27,    23,    86,
    86,    47,    47,    47,    47,    47,    21,    21,    21,    21,
    21,    47,    65,    65,    65,    65,    65,    65,    49,    50,
    31,    65,    78,    78,    78,    78,    78,    78,    53,    44,
    58,    78,     9,     9,     9,     9,    41,     9,    19,    18,
    69,     9,    77,    77,    77,    77,    77,    77,    35,    73,
    13,    77,    67,    67,    67,    67,    67,    67,     8,    34,
     2,    67,     4,     4,     4,     4,     4,     4,     4,     4,
     4,     4,    63,    63,    63,    63,    63,    63,    43,   nil,
   nil,    63,    85,    85,    85,    85,    85,    85,   nil,   nil,
   nil,    85,    39,    39,    39,    39,    39,    39,   nil,   nil,
   nil,    39,    28,    28,    28,    28,   nil,    28,   nil,   nil,
   nil,    28,    42,    42,    42,    42,    42,    42,   nil,   nil,
   nil,    42,    40,    40,    40,    40,    40,    40,   nil,   nil,
   nil,    40,     0,     0,     0,     0,     0,     0,     0,     0,
     0,     0,    46,    46,    83,    83,   nil,    46,    46,    83,
    83,    72,    72,    51,   nil,   nil,    72,   nil,    51,    32,
    32,    32,    32 ]

racc_action_pointer = [
   139,   nil,    67,   nil,    69,   nil,   nil,   nil,    62,    39,
   nil,   nil,   nil,    53,   nil,   nil,   nil,   nil,    42,    44,
   nil,    13,   nil,     0,   nil,   nil,   nil,    -1,   109,   nil,
   nil,    25,   166,   nil,    62,    58,   nil,   nil,   nil,    99,
   129,    33,   119,    81,    32,   nil,   145,     8,   nil,    20,
    16,   156,   nil,    25,    -7,   nil,   nil,   nil,    40,   nil,
   nil,   nil,   nil,    79,   nil,    19,   nil,    59,   nil,    43,
   nil,   nil,   154,    46,   nil,   nil,   nil,    49,    29,   nil,
   nil,   nil,   nil,   147,   nil,    89,    -3,   nil,   nil ]

racc_action_default = [
    -2,   -42,   -32,   -10,    -1,   -34,   -11,    -4,   -44,   -72,
   -31,   -12,    -5,   -63,   -46,   -23,   -13,    -6,   -65,   -36,
   -24,   -73,    -7,   -59,   -38,   -25,    -8,   -59,   -72,   -26,
    -9,   -40,   -27,   -16,   -14,   -73,   -33,    -3,   -45,   -71,
   -69,   -73,   -70,   -62,   -64,   -37,   -73,   -73,   -22,   -61,
   -73,   -51,   -58,   -73,   -73,   -41,   -30,   -15,   -73,   -57,
   -54,   -55,   -56,   -68,   -53,   -66,   -35,   -67,   -21,   -73,
   -17,   -19,   -18,   -73,   -28,   -60,   -43,   -49,   -73,   -47,
   -39,    89,   -52,   -73,   -29,   -48,   -73,   -20,   -50 ]

racc_goto_table = [
    12,    46,    63,    65,    12,    67,    17,    22,    56,    41,
    17,    22,    43,    47,    50,    40,    42,    44,    53,    36,
    82,     7,    82,    56,    82,    37,    45,    72,    54,    55,
    73,    38,    35,     4,    40,    42,    75,   nil,   nil,   nil,
    85,    86,    82,    82,   nil,   nil,   nil,   nil,   nil,    83,
   nil,    77 ]

racc_goto_check = [
     4,    10,    31,    31,     4,    31,     5,     6,    12,    21,
     5,     6,     9,    17,    27,     5,     6,     9,    27,    19,
    32,     3,    32,    12,    32,     3,    23,    10,    21,    26,
    11,    29,     1,     2,     5,     6,    33,   nil,   nil,   nil,
    31,    31,    32,    32,   nil,   nil,   nil,   nil,   nil,    10,
   nil,     4 ]

racc_goto_pointer = [
   nil,    32,    33,    21,     0,     6,     7,   nil,   nil,    -1,
   -20,   -17,   -24,   nil,   nil,   nil,   nil,    -8,   nil,    17,
   nil,     0,   nil,     7,   nil,   nil,    -2,    -9,   nil,    23,
   nil,   -37,   -43,   -13 ]

racc_goto_default = [
   nil,   nil,   nil,   nil,    60,    61,    62,    26,    30,    34,
   nil,   nil,    10,    15,    20,    25,    29,    32,     2,     5,
     9,   nil,    19,    24,    28,    31,     1,   nil,     8,    14,
    51,   nil,    64,    52 ]

racc_token_table = {
 false => 0,
 Object.new => 1,
 :DUMMY => 2,
 :ITEMLISTLINE => 3,
 :ENUMLISTLINE => 4,
 :DESCLISTLINE => 5,
 :METHODLISTLINE => 6,
 :STRINGLINE => 7,
 :WHITELINE => 8,
 :SUBTREE => 9,
 :HEADLINE => 10,
 :INCLUDE => 11,
 :INDENT => 12,
 :DEDENT => 13 }

racc_use_result_var = true

racc_nt_base = 14

Racc_arg = [
 racc_action_table,
 racc_action_check,
 racc_action_default,
 racc_action_pointer,
 racc_goto_table,
 racc_goto_check,
 racc_goto_default,
 racc_goto_pointer,
 racc_nt_base,
 racc_reduce_table,
 racc_token_table,
 racc_shift_n,
 racc_reduce_n,
 racc_use_result_var ]

Racc_token_to_s_table = [
'$end',
'error',
'DUMMY',
'ITEMLISTLINE',
'ENUMLISTLINE',
'DESCLISTLINE',
'METHODLISTLINE',
'STRINGLINE',
'WHITELINE',
'SUBTREE',
'HEADLINE',
'INCLUDE',
'INDENT',
'DEDENT',
'$start',
'document',
'blocks',
'block',
'textblock',
'verbatim',
'lists',
'headline',
'include',
'textblockcontent',
'verbatimcontent',
'verbatim_after_lists',
'list',
'itemlist',
'enumlist',
'desclist',
'methodlist',
'lists2',
'itemlistitems',
'itemlistitem',
'first_textblock_in_itemlist',
'other_blocks_in_list',
'enumlistitems',
'enumlistitem',
'first_textblock_in_enumlist',
'desclistitems',
'desclistitem',
'description_part',
'methodlistitems',
'methodlistitem',
'whitelines',
'blocks_in_list',
'block_in_list',
'whitelines2']

Racc_debug_parser = false

##### racc system variables end #####

 # reduce 0 omitted

module_eval <<'.,.,', 'rd/rdblockparser.ry', 12
  def _reduce_1( val, _values, result )
 result = DocumentElement.new
		       add_children_to_element(result, *val[0])
   result
  end
.,.,

module_eval <<'.,.,', 'rd/rdblockparser.ry', 16
  def _reduce_2( val, _values, result )
                         raise ParseError,
                         "Error: file empty or doesn't have `=begin', `=end'."
   result
  end
.,.,

module_eval <<'.,.,', 'rd/rdblockparser.ry', 20
  def _reduce_3( val, _values, result )
 result.concat(val[1])
   result
  end
.,.,

 # reduce 4 omitted

module_eval <<'.,.,', 'rd/rdblockparser.ry', 23
  def _reduce_5( val, _values, result )
 result = val
   result
  end
.,.,

module_eval <<'.,.,', 'rd/rdblockparser.ry', 24
  def _reduce_6( val, _values, result )
 result = val
   result
  end
.,.,

 # reduce 7 omitted

module_eval <<'.,.,', 'rd/rdblockparser.ry', 26
  def _reduce_8( val, _values, result )
 result = val
   result
  end
.,.,

module_eval <<'.,.,', 'rd/rdblockparser.ry', 27
  def _reduce_9( val, _values, result )
 result = val
   result
  end
.,.,

module_eval <<'.,.,', 'rd/rdblockparser.ry', 28
  def _reduce_10( val, _values, result )
 result = []
   result
  end
.,.,

module_eval <<'.,.,', 'rd/rdblockparser.ry', 29
  def _reduce_11( val, _values, result )
 result = val[0].blocks
   result
  end
.,.,

module_eval <<'.,.,', 'rd/rdblockparser.ry', 32
  def _reduce_12( val, _values, result )
 # val[0] is like [level, title]
			  title = @inline_parser.parse(val[0][1])
			  result = Headline.new(val[0][0])
			  add_children_to_element(result, *title)
   result
  end
.,.,

module_eval <<'.,.,', 'rd/rdblockparser.ry', 38
  def _reduce_13( val, _values, result )
 result = Include.new(val[0])
   result
  end
.,.,

module_eval <<'.,.,', 'rd/rdblockparser.ry', 42
  def _reduce_14( val, _values, result )
 # val[0] is Array of String
			  content = cut_off(val[0]).join("")
			  contents = @inline_parser.parse(content)
			  result = TextBlock.new()
			  add_children_to_element(result, *contents)
   result
  end
.,.,

module_eval <<'.,.,', 'rd/rdblockparser.ry', 50
  def _reduce_15( val, _values, result )
 result.push(val[1])
   result
  end
.,.,

module_eval <<'.,.,', 'rd/rdblockparser.ry', 51
  def _reduce_16( val, _values, result )
 result = val
   result
  end
.,.,

module_eval <<'.,.,', 'rd/rdblockparser.ry', 55
  def _reduce_17( val, _values, result )
 # val[1] is Array of String
			  content = cut_off(val[1])
			  result = Verbatim.new(content)
			  # imform to lexer.
			  @in_verbatim = false
   result
  end
.,.,

module_eval <<'.,.,', 'rd/rdblockparser.ry', 62
  def _reduce_18( val, _values, result )
 # val[0] is Array of String
			  content = cut_off(val[0])
			  result = Verbatim.new(content)
			  # imform to lexer.
			  @in_verbatim = false
   result
  end
.,.,

module_eval <<'.,.,', 'rd/rdblockparser.ry', 69
  def _reduce_19( val, _values, result )
 result.push(val[1])
   result
  end
.,.,

module_eval <<'.,.,', 'rd/rdblockparser.ry', 71
  def _reduce_20( val, _values, result )
 result.concat(val[2])
   result
  end
.,.,

module_eval <<'.,.,', 'rd/rdblockparser.ry', 73
  def _reduce_21( val, _values, result )
 result.push("\n")
   result
  end
.,.,

module_eval <<'.,.,', 'rd/rdblockparser.ry', 74
  def _reduce_22( val, _values, result )
 result = val
					# imform to lexer.
					@in_verbatim = true
   result
  end
.,.,

 # reduce 23 omitted

 # reduce 24 omitted

 # reduce 25 omitted

 # reduce 26 omitted

 # reduce 27 omitted

module_eval <<'.,.,', 'rd/rdblockparser.ry', 85
  def _reduce_28( val, _values, result )
 result = val[1]
   result
  end
.,.,

module_eval <<'.,.,', 'rd/rdblockparser.ry', 87
  def _reduce_29( val, _values, result )
 result = val[1].push(val[2])
   result
  end
.,.,

module_eval <<'.,.,', 'rd/rdblockparser.ry', 90
  def _reduce_30( val, _values, result )
 result.push(val[1])
   result
  end
.,.,

module_eval <<'.,.,', 'rd/rdblockparser.ry', 91
  def _reduce_31( val, _values, result )
 result = val
   result
  end
.,.,

module_eval <<'.,.,', 'rd/rdblockparser.ry', 95
  def _reduce_32( val, _values, result )
                          result = ItemList.new
			  add_children_to_element(result, *val[0])
   result
  end
.,.,

module_eval <<'.,.,', 'rd/rdblockparser.ry', 100
  def _reduce_33( val, _values, result )
 result.push(val[1])
   result
  end
.,.,

module_eval <<'.,.,', 'rd/rdblockparser.ry', 101
  def _reduce_34( val, _values, result )
 result = val
   result
  end
.,.,

module_eval <<'.,.,', 'rd/rdblockparser.ry', 105
  def _reduce_35( val, _values, result )
                  result = ItemListItem.new
		  add_children_to_element(result, val[0], *val[1])
   result
  end
.,.,

module_eval <<'.,.,', 'rd/rdblockparser.ry', 111
  def _reduce_36( val, _values, result )
                          result = EnumList.new
			  add_children_to_element(result, *val[0])
   result
  end
.,.,

module_eval <<'.,.,', 'rd/rdblockparser.ry', 116
  def _reduce_37( val, _values, result )
 result.push(val[1])
   result
  end
.,.,

module_eval <<'.,.,', 'rd/rdblockparser.ry', 117
  def _reduce_38( val, _values, result )
 result = val
   result
  end
.,.,

module_eval <<'.,.,', 'rd/rdblockparser.ry', 121
  def _reduce_39( val, _values, result )
                  result = EnumListItem.new
		  add_children_to_element(result, val[0], *val[1])
   result
  end
.,.,

module_eval <<'.,.,', 'rd/rdblockparser.ry', 127
  def _reduce_40( val, _values, result )
                          result = DescList.new
			  add_children_to_element(result, *val[0])
   result
  end
.,.,

module_eval <<'.,.,', 'rd/rdblockparser.ry', 132
  def _reduce_41( val, _values, result )
			result.push(val[1])
   result
  end
.,.,

module_eval <<'.,.,', 'rd/rdblockparser.ry', 133
  def _reduce_42( val, _values, result )
 result = val
   result
  end
.,.,

module_eval <<'.,.,', 'rd/rdblockparser.ry', 137
  def _reduce_43( val, _values, result )
                          term = DescListItem::Term.new
                          term_contents = @inline_parser.parse(val[0])
			  add_children_to_element(term, *term_contents)

			  result = DescListItem.new
                          set_term_to_element(result, term)
		          add_children_to_element(result, *val[1])
   result
  end
.,.,

module_eval <<'.,.,', 'rd/rdblockparser.ry', 148
  def _reduce_44( val, _values, result )
                          result = MethodList.new
			  add_children_to_element(result, *val[0])
   result
  end
.,.,

module_eval <<'.,.,', 'rd/rdblockparser.ry', 153
  def _reduce_45( val, _values, result )
 result.push(val[1])
   result
  end
.,.,

module_eval <<'.,.,', 'rd/rdblockparser.ry', 154
  def _reduce_46( val, _values, result )
 result = val
   result
  end
.,.,

module_eval <<'.,.,', 'rd/rdblockparser.ry', 158
  def _reduce_47( val, _values, result )
			  term = MethodListItem::Term.new(val[0].strip)
			  result = MethodListItem.new
                          set_term_to_element(result, term)
			  add_children_to_element(result, *val[1])
   result
  end
.,.,

module_eval <<'.,.,', 'rd/rdblockparser.ry', 166
  def _reduce_48( val, _values, result )
 result = [val[1]].concat(val[2])
   result
  end
.,.,

module_eval <<'.,.,', 'rd/rdblockparser.ry', 167
  def _reduce_49( val, _values, result )
 result = [val[1]]
   result
  end
.,.,

module_eval <<'.,.,', 'rd/rdblockparser.ry', 169
  def _reduce_50( val, _values, result )
 result = val[2]
   result
  end
.,.,

module_eval <<'.,.,', 'rd/rdblockparser.ry', 170
  def _reduce_51( val, _values, result )
 result = []
   result
  end
.,.,

module_eval <<'.,.,', 'rd/rdblockparser.ry', 173
  def _reduce_52( val, _values, result )
 result.concat(val[1])
   result
  end
.,.,

 # reduce 53 omitted

module_eval <<'.,.,', 'rd/rdblockparser.ry', 176
  def _reduce_54( val, _values, result )
 result = val
   result
  end
.,.,

module_eval <<'.,.,', 'rd/rdblockparser.ry', 177
  def _reduce_55( val, _values, result )
 result = val
   result
  end
.,.,

 # reduce 56 omitted

module_eval <<'.,.,', 'rd/rdblockparser.ry', 179
  def _reduce_57( val, _values, result )
 result = []
   result
  end
.,.,

 # reduce 58 omitted

 # reduce 59 omitted

 # reduce 60 omitted

 # reduce 61 omitted

module_eval <<'.,.,', 'rd/rdblockparser.ry', 190
  def _reduce_62( val, _values, result )
 content = cut_off([val[0]].concat(val[1])).join("")
		  contents = @inline_parser.parse(content)
                  result = TextBlock.new()
		  add_children_to_element(result, *contents)
   result
  end
.,.,

module_eval <<'.,.,', 'rd/rdblockparser.ry', 197
  def _reduce_63( val, _values, result )
 content = cut_off([val[0]]).join("")
		  contents = @inline_parser.parse(content)
		  result = TextBlock.new()
		  add_children_to_element(result, *contents)
   result
  end
.,.,

module_eval <<'.,.,', 'rd/rdblockparser.ry', 205
  def _reduce_64( val, _values, result )
 content = cut_off([val[0]].concat(val[1])).join("")
		  contents = @inline_parser.parse(content)
	          result = TextBlock.new()
		  add_children_to_element(result, *contents)
   result
  end
.,.,

module_eval <<'.,.,', 'rd/rdblockparser.ry', 212
  def _reduce_65( val, _values, result )
 content = cut_off([val[0]]).join("")
		  contents = @inline_parser.parse(content)
	          result = TextBlock.new()
		  add_children_to_element(result, *contents)
   result
  end
.,.,

module_eval <<'.,.,', 'rd/rdblockparser.ry', 219
  def _reduce_66( val, _values, result )
 result = [val[0]].concat(val[1])
   result
  end
.,.,

module_eval <<'.,.,', 'rd/rdblockparser.ry', 220
  def _reduce_67( val, _values, result )
 result.concat(val[1])
   result
  end
.,.,

module_eval <<'.,.,', 'rd/rdblockparser.ry', 221
  def _reduce_68( val, _values, result )
 result = val[1]
   result
  end
.,.,

module_eval <<'.,.,', 'rd/rdblockparser.ry', 222
  def _reduce_69( val, _values, result )
 result = val
   result
  end
.,.,

 # reduce 70 omitted

module_eval <<'.,.,', 'rd/rdblockparser.ry', 224
  def _reduce_71( val, _values, result )
 result = []
   result
  end
.,.,

module_eval <<'.,.,', 'rd/rdblockparser.ry', 225
  def _reduce_72( val, _values, result )
 result = []
   result
  end
.,.,

 def _reduce_none( val, _values, result )
  result
 end

end   # class RDParser

end # end of module RD 
