#
# raccp.rb
#
#   Copyright (c) 1999-2001 Minero Aoki <aamine@dp.u-netsurf.ne.jp>
#
#   This program is free software.
#   You can distribute/modify this program under the terms of
#   the GNU Lesser General Public License version 2.
#

require 'racc/parser'
require 'racc/raccs'
require 'racc/ucodep'


module Racc

  class RaccParser < Parser

    def initialize( racc )
      @yydebug     = racc.d_parse && Racc_debug_parser
      @ruletable   = racc.ruletable
      @symboltable = racc.symboltable

      @class_name = nil
      @super_class = nil
    end

    attr :class_name
    attr :super_class

    def parse( str )
      @scanner = RaccScanner.new( str )
      @scanner.debug = @yydebug

      do_parse
    end


    private

    def next_token
      @scanner.scan
    end

    def on_error( tok, val, _values )
      if val.respond_to? :id2name then
        v = val.id2name
      elsif String === val then
        v = val
      else
        v = val.inspect
      end
      raise ParseError, "#{@scanner.lineno}: unexpected token '#{v}'"
    end


##### racc 1.3.7 generates ###

racc_reduce_table = [
 0, 0, :racc_error,
 6, 25, :_reduce_1,
 1, 26, :_reduce_2,
 3, 26, :_reduce_3,
 1, 29, :_reduce_4,
 4, 29, :_reduce_5,
 0, 27, :_reduce_none,
 2, 27, :_reduce_none,
 3, 30, :_reduce_8,
 1, 30, :_reduce_none,
 2, 30, :_reduce_10,
 2, 30, :_reduce_11,
 2, 30, :_reduce_12,
 2, 30, :_reduce_13,
 2, 31, :_reduce_14,
 3, 31, :_reduce_15,
 3, 32, :_reduce_16,
 3, 32, :_reduce_17,
 1, 36, :_reduce_none,
 2, 36, :_reduce_none,
 2, 37, :_reduce_20,
 2, 37, :_reduce_21,
 2, 37, :_reduce_22,
 1, 34, :_reduce_23,
 2, 34, :_reduce_24,
 2, 34, :_reduce_none,
 1, 33, :_reduce_26,
 1, 33, :_reduce_27,
 1, 28, :_reduce_28,
 0, 28, :_reduce_none,
 1, 38, :_reduce_30,
 2, 38, :_reduce_31,
 2, 38, :_reduce_32,
 2, 38, :_reduce_33,
 1, 39, :_reduce_none,
 1, 39, :_reduce_35,
 2, 39, :_reduce_36,
 1, 39, :_reduce_37,
 1, 35, :_reduce_38,
 2, 35, :_reduce_39 ]

racc_reduce_n = 40

racc_shift_n = 65

racc_action_table = [
    30,    60,    30,    30,    30,    30,    42,     9,    29,    10,
    29,    29,    29,    29,    56,    57,    58,    59,    52,    52,
    30,    30,    50,    10,    30,    30,    48,    40,    29,    29,
    36,    17,    29,    29,    52,    52,    13,    14,    15,    16,
    18,    30,    30,    20,    11,    30,    30,    30,    53,    29,
    29,    54,    22,    29,    29,    29,    47,     6,    23,    24,
    25,    62,    23,    24,    25,    23,    24,    25,    23,    24,
    25,     7,     6,     3,    63,     2 ]

racc_action_check = [
    39,    39,    14,    24,    43,    44,    22,     5,    39,     5,
    14,    24,    43,    44,    39,    39,    39,    39,    43,    44,
    45,    34,    31,    21,    31,    13,    28,    18,    45,    34,
    16,     8,    31,    13,    45,    34,     8,     8,     8,     8,
     8,    23,    15,     8,     8,    25,    17,    58,    35,    23,
    15,    38,    10,    25,    17,    58,    26,     9,    26,    26,
    26,    41,    41,    41,    41,    20,    20,    20,    11,    11,
    11,     3,     2,     1,    49,     0 ]

racc_action_pointer = [
    73,    73,    66,    71,   nil,     2,   nil,   nil,    28,    51,
    45,    51,   nil,    19,    -4,    36,    24,    40,    14,   nil,
    48,    16,     0,    35,    -3,    39,    41,   nil,    12,   nil,
   nil,    18,   nil,   nil,    15,    42,   nil,   nil,    47,    -6,
   nil,    45,   nil,    -2,    -1,    14,   nil,   nil,   nil,    60,
   nil,   nil,   nil,   nil,   nil,   nil,   nil,   nil,    41,   nil,
   nil,   nil,   nil,   nil,   nil ]

racc_action_default = [
   -40,   -40,   -40,   -40,    -6,    -2,    -4,    65,   -40,   -40,
   -40,   -40,    -9,   -40,   -40,   -40,   -40,   -29,   -40,    -7,
   -40,    -3,   -40,   -40,   -40,   -40,   -40,   -18,   -40,   -27,
   -26,   -40,   -10,   -23,   -11,   -12,   -38,   -30,   -40,   -28,
   -13,   -40,    -5,   -20,   -21,   -22,   -19,   -17,   -14,   -40,
    -8,   -24,   -25,   -39,    -1,   -34,   -35,   -32,   -40,   -37,
   -33,   -31,   -16,   -15,   -36 ]

racc_goto_table = [
    28,    32,    46,    34,    37,    26,    12,    31,     5,    19,
     1,    43,    44,    45,    41,    21,    38,    46,    49,    35,
     8,    51,     4,    39,    61,   nil,    55,   nil,   nil,   nil,
    51,    51,    51,   nil,   nil,   nil,   nil,   nil,   nil,   nil,
   nil,   nil,   nil,   nil,   nil,    64 ]

racc_goto_check = [
     9,     9,    13,    10,     9,    12,     8,     7,     5,     6,
     1,    10,    10,    10,    12,     5,     4,    13,     9,    11,
     3,     9,     2,    14,    15,   nil,     9,   nil,   nil,   nil,
     9,     9,     9,   nil,   nil,   nil,   nil,   nil,   nil,   nil,
   nil,   nil,   nil,   nil,   nil,     9 ]

racc_goto_pointer = [
   nil,    10,    20,    16,    -1,     6,     1,    -6,    -2,   -13,
   -12,     3,    -6,   -24,     6,   -15 ]

racc_goto_default = [
   nil,   nil,   nil,   nil,   nil,   nil,   nil,   nil,   nil,    33,
   nil,   nil,   nil,    27,   nil,   nil ]

racc_token_table = {
 false => 0,
 Object.new => 1,
 :XCLASS => 2,
 :XRULE => 3,
 :XEND => 4,
 "<" => 5,
 :XSYMBOL => 6,
 ":" => 7,
 :XCONV => 8,
 :XSTART => 9,
 :XTOKEN => 10,
 :XOPTION => 11,
 :XEXPECT => 12,
 :DIGIT => 13,
 :STRING => 14,
 :XPRECHIGH => 15,
 :XPRECLOW => 16,
 :XLEFT => 17,
 :XRIGHT => 18,
 :XNONASSOC => 19,
 "|" => 20,
 ";" => 21,
 "=" => 22,
 :ACTION => 23 }

racc_use_result_var = true

racc_nt_base = 24

Racc_arg = [
 racc_action_table,
 racc_action_check,
 racc_action_default,
 racc_action_pointer,
 racc_goto_table,
 racc_goto_check,
 racc_goto_default,
 racc_goto_pointer,
 racc_nt_base,
 racc_reduce_table,
 racc_token_table,
 racc_shift_n,
 racc_reduce_n,
 racc_use_result_var ]

Racc_token_to_s_table = [
'$end',
'error',
'XCLASS',
'XRULE',
'XEND',
'"<"',
'XSYMBOL',
'":"',
'XCONV',
'XSTART',
'XTOKEN',
'XOPTION',
'XEXPECT',
'DIGIT',
'STRING',
'XPRECHIGH',
'XPRECLOW',
'XLEFT',
'XRIGHT',
'XNONASSOC',
'"|"',
'";"',
'"="',
'ACTION',
'$start',
'xclass',
'class',
'params',
'rules',
'rubyconst',
'param_seg',
'convdefs',
'xprec',
'symbol',
'symbol_list',
'bare_symlist',
'preclines',
'precline',
'rules_core',
'rule_item']

Racc_debug_parser = false

##### racc system variables end #####

 # reduce 0 omitted

module_eval <<'.,.,', '(build)', 80
  def _reduce_1( val, _values, result )
      @ruletable.end_register_rule
   result
  end
.,.,

module_eval <<'.,.,', '(build)', 84
  def _reduce_2( val, _values, result )
      @class_name = val[0]
   result
  end
.,.,

module_eval <<'.,.,', '(build)', 87
  def _reduce_3( val, _values, result )
      @class_name = val[0]
      @super_class = val[2]
   result
  end
.,.,

module_eval <<'.,.,', '(build)', 92
  def _reduce_4( val, _values, result )
      result = result.id2name
   result
  end
.,.,

module_eval <<'.,.,', '(build)', 95
  def _reduce_5( val, _values, result )
      result << '::' << val[3].id2name
   result
  end
.,.,

 # reduce 6 omitted

 # reduce 7 omitted

module_eval <<'.,.,', '(build)', 105
  def _reduce_8( val, _values, result )
      @symboltable.end_register_conv
   result
  end
.,.,

 # reduce 9 omitted

module_eval <<'.,.,', '(build)', 111
  def _reduce_10( val, _values, result )
      @ruletable.register_start val[1]
   result
  end
.,.,

module_eval <<'.,.,', '(build)', 115
  def _reduce_11( val, _values, result )
      @symboltable.register_token val[1]
   result
  end
.,.,

module_eval <<'.,.,', '(build)', 119
  def _reduce_12( val, _values, result )
      val[1].each do |s|
        @ruletable.register_option s.to_s
      end
   result
  end
.,.,

module_eval <<'.,.,', '(build)', 124
  def _reduce_13( val, _values, result )
      @ruletable.expect val[1]
   result
  end
.,.,

module_eval <<'.,.,', '(build)', 129
  def _reduce_14( val, _values, result )
      @symboltable.register_conv( val[0], val[1] )
   result
  end
.,.,

module_eval <<'.,.,', '(build)', 133
  def _reduce_15( val, _values, result )
      @symboltable.register_conv( val[1], val[2] )
   result
  end
.,.,

module_eval <<'.,.,', '(build)', 138
  def _reduce_16( val, _values, result )
      @symboltable.end_register_prec( true )
   result
  end
.,.,

module_eval <<'.,.,', '(build)', 142
  def _reduce_17( val, _values, result )
      @symboltable.end_register_prec( false )
   result
  end
.,.,

 # reduce 18 omitted

 # reduce 19 omitted

module_eval <<'.,.,', '(build)', 152
  def _reduce_20( val, _values, result )
      @symboltable.register_prec( :Left, val[1] )
   result
  end
.,.,

module_eval <<'.,.,', '(build)', 156
  def _reduce_21( val, _values, result )
      @symboltable.register_prec( :Right, val[1] )
   result
  end
.,.,

module_eval <<'.,.,', '(build)', 160
  def _reduce_22( val, _values, result )
      @symboltable.register_prec( :Nonassoc, val[1] )
   result
  end
.,.,

module_eval <<'.,.,', '(build)', 165
  def _reduce_23( val, _values, result )
      result = val
   result
  end
.,.,

module_eval <<'.,.,', '(build)', 169
  def _reduce_24( val, _values, result )
      result.push val[1]
   result
  end
.,.,

 # reduce 25 omitted

module_eval <<'.,.,', '(build)', 175
  def _reduce_26( val, _values, result )
      result = @symboltable.get( result )
   result
  end
.,.,

module_eval <<'.,.,', '(build)', 179
  def _reduce_27( val, _values, result )
      result = @symboltable.get( eval '"' + val[0] + '"' )
   result
  end
.,.,

module_eval <<'.,.,', '(build)', 184
  def _reduce_28( val, _values, result )
      unless result.empty? then
        @ruletable.register_rule_from_array result
      end
   result
  end
.,.,

 # reduce 29 omitted

module_eval <<'.,.,', '(build)', 193
  def _reduce_30( val, _values, result )
      result = val
   result
  end
.,.,

module_eval <<'.,.,', '(build)', 197
  def _reduce_31( val, _values, result )
      result.push val[1]
   result
  end
.,.,

module_eval <<'.,.,', '(build)', 201
  def _reduce_32( val, _values, result )
      unless result.empty? then
        @ruletable.register_rule_from_array result
      end
      result.clear
   result
  end
.,.,

module_eval <<'.,.,', '(build)', 208
  def _reduce_33( val, _values, result )
      pre = result.pop
      unless result.empty? then
        @ruletable.register_rule_from_array result
      end
      result = [pre]
   result
  end
.,.,

 # reduce 34 omitted

module_eval <<'.,.,', '(build)', 219
  def _reduce_35( val, _values, result )
      result = OrMark.new( @scanner.lineno )
   result
  end
.,.,

module_eval <<'.,.,', '(build)', 223
  def _reduce_36( val, _values, result )
      result = Prec.new( val[1], @scanner.lineno )
   result
  end
.,.,

module_eval <<'.,.,', '(build)', 227
  def _reduce_37( val, _values, result )
      result = UserAction.new( *result )
   result
  end
.,.,

module_eval <<'.,.,', '(build)', 231
  def _reduce_38( val, _values, result )
      result = [ result.id2name ]
   result
  end
.,.,

module_eval <<'.,.,', '(build)', 234
  def _reduce_39( val, _values, result )
      result.push val[1].id2name
   result
  end
.,.,

 def _reduce_none( val, _values, result )
  result
 end

  end   # class RaccParser

end   # module Racc
