#
# rbparam.rb
#
#   Copyright (c) 1999,2000 Minero Aoki <aamine@dp.u-netsurf.ne.jp>
#
#   This program is free software.
#   You can distribute/modify this program under the terms of
#   the GNU General Public License version 2 or later.
#

require 'rbconfig'


module RubyParams

  CONFIG     = Config::CONFIG

  RUBY       = CONFIG['ruby_install_name']

  MAJOR_VERSION = CONFIG['MAJOR'].to_i
  MINOR_VERSION = CONFIG['MINOR'].to_i
  TEENY_VERSION = CONFIG['TEENY'].to_i
  VERSION = CONFIG['MAJOR'] + '.' + CONFIG['MINOR']

  BINDIR     = File.join( CONFIG['bindir'] )
  LIBDIR     = File.join( CONFIG['libdir'], 'ruby' )
  DATADIR    = File.join( CONFIG['datadir'] )

  ARCH       = CONFIG['arch']

  NEW_LIB_PATH = ((MAJOR_VERSION >= 2) or
                  ((MAJOR_VERSION == 1) and
                   ((MINOR_VERSION >= 5) or
                    ((MINOR_VERSION == 4) and (TEENY_VERSION >= 4)))))
    
  if NEW_LIB_PATH then
    SITELIBDIR = File.join( LIBDIR, 'site_ruby', VERSION )
  else
    SITELIBDIR = File.join( LIBDIR, VERSION, 'site_ruby' )
  end

  STDLIBDIR  = File.join( LIBDIR, VERSION )
  RBDIR      = File.join( STDLIBDIR )
  SODIR      = File.join( STDLIBDIR, ARCH )

  SITE_RB    = File.join( SITELIBDIR )
  SITE_SO    = File.join( SITELIBDIR, ARCH )

  RUBY_PATH  = File.join( BINDIR, RUBY )

  DLEXT      = CONFIG['DLEXT']
  Extentions = [ 'rb', DLEXT ]

end
