#
# getdep.rb
#
#   Copyright (c) 1999,2000 Minero Aoki <aamine@dp.u-netsurf.ne.jp>
#
#   This program is free software.
#   You can distribute/modify this program under the terms of
#   the GNU General Public License version 2 or later.
#

require 'amstd/rubyemu'
require 'amstd/rbparams'


module Getdep

  DL_EXT_EXP = /\.#{RubyParams::DLEXT}\z/o

  def getdep( fn, done = {} )
    unless DL_EXT_EXP === fn then   # don't grep binary file
      new = []
      File.foreach( fn ) do |line|
        if m = /require\s+['"]([^'"]+)['"]/.match(line) then
          dep = m[1]
          unless done.key? dep then
            done[dep] = true
            new.push dep
          end
        end
      end

      new.each do |feature|
        unless path = RubyEmurator.find_feature(feature) then
          $stderr.puts "warn: can't find feature path for #{feature}"
        else
          done[feature] = path
          getdep path, done
        end
      end
    end

    done
  end

  module_function :getdep

end
