#
# errutil.rb
#
#   Copyright (c) 1999,2000 Minero Aoki <aamine@dp.u-netsurf.ne.jp>
#
#   This program is free software.
#   You can distribute/modify this program under the terms of
#   the GNU General Public License version 2 or later.
#

def _print_bt_all( err )
  $stderr.print err.to_s, " (#{err.type})\n"
  err.backtrace.each {|i| $stderr.puts i }
end


def protect( place = nil )
  begin
    yield
  rescue StandardError, ScriptError
    $stderr.puts 'Error in ' + place if place
    _print_bt_all $!
    nil
  end
end
