#define  INCL_BASE
#define  INCL_WIN
#include <os2.h>
#include <stdio.h>
#include <string.h>
#include <stdlib.h>
#include <ctype.h>
#include "report.h"
#include "demo.h"

HAB        hab;            /*Handle to the anchor block*/
HMQ        hmq;            /*Handle to the message queue*/
HWND       hwndFrame;      /*handle to the Main Frame Window*/
HWND       hwndClient;     /*handle to the Client Window*/
HWND       hwndReport;
USHORT     usChecked = IDM_100;

#define    szFileName  "demo.doc"

#define INFO(hwnd,message)  WinMessageBox(HWND_DESKTOP,hwnd,\
                                          message,\
                                          "Information",\
                                           1,\
                                           MB_CANCEL|MB_INFORMATION|\
                                           MB_MOVEABLE)

VOID    DoScale(USHORT usScale);
HWND    CreateMainFrame(VOID);
MRESULT EXPENTRY ClientWndProc(HWND hwnd,USHORT msg,MPARAM mp1,MPARAM mp2);
int     main(void);

/*----------------------------------------------------------------------*/
                   /* Main () Creates the Editor Window */
/*----------------------------------------------------------------------*/
main()
{
QMSG qmsg;
 /*Initialize PM*/

    hab= WinInitialize(0);

 /*Create the Message Queue*/

    hmq= WinCreateMsgQueue(hab,100);

    RptRegisterClass(hab);

    CreateMainFrame();

    while (WinGetMsg(hab,
                 &qmsg,
                 (ULONG)NULL,
                 (USHORT)NULL,
                 (USHORT)NULL))
           WinDispatchMsg(hab, &qmsg);

   WinDestroyWindow(hwndFrame);
   WinDestroyMsgQueue(hmq);
   WinTerminate(hab);
   return(0);
}

/*----------------------------------------------------------------------*/
/* Create Main Frame Window */
/*----------------------------------------------------------------------*/
HWND  CreateMainFrame()
{
ULONG   fulCreate=FCF_TITLEBAR | FCF_SYSMENU | FCF_MINMAX | FCF_SIZEBORDER |
                  FCF_TASKLIST|FCF_SHELLPOSITION|FCF_NOBYTEALIGN|FCF_MENU;


        WinRegisterClass(hab,
                         "Main Class",
                         (PFNWP)ClientWndProc,
                          CS_SIZEREDRAW|CS_CLIPCHILDREN|CS_CLIPSIBLINGS,
                          0);


        hwndFrame = WinCreateStdWindow(HWND_DESKTOP,
                                       WS_VISIBLE,
                                       &fulCreate,
                                       (PSZ)"Main Class",
                                       (PSZ)"",
                                       0,
                                       (HMODULE)NULL,
                                       ID_RESOURCE,
                                       &hwndClient);

        return (hwndFrame);
}
//------------------------------------------------------------------------//
//                      Client Window Procedure                           //
//------------------------------------------------------------------------//
MRESULT EXPENTRY ClientWndProc(HWND hwnd,USHORT msg,MPARAM mp1,MPARAM mp2)
{
RECTL        rectl;
HPS          hps;
ULONG        ulPageWidth,ulPageHeight;
CHAR         szBuffer[400]="";

      switch(msg)
           {
            case WM_DESTROY:
                 WinDestroyWindow(hwndReport);
                 break;

            case WM_CREATE:
                 WinSetPointer(HWND_DESKTOP,
                               WinQuerySysPointer(HWND_DESKTOP,
                               SPTR_WAIT,FALSE));


                 hwndReport=WinCreateWindow(hwnd,
                                             szReportClass,
                                             (PSZ) "",
                                             WS_VISIBLE,
                                             0,
                                             0,
                                             0,
                                             0,
                                             hwnd,
                                             HWND_TOP,
                                             10,
                                             NULL,
                                             NULL);

                 WinSendMsg(hwndReport,
                            RPM_QUERYPAGESIZE,
                            MPFROMP(&ulPageWidth),
                            MPFROMP(&ulPageHeight));

                 WinSendMsg(hwndReport,
                            RPM_SETMARGINVIEW,
                            MPFROMSHORT(TRUE),
                            NULL);

                 WinSendMsg(hwndReport,
                            RPM_SETFILE,
                            MPFROMP(szFileName),
                            NULL);

                 WinSetPointer(HWND_DESKTOP,
                               WinQuerySysPointer(HWND_DESKTOP,
                               SPTR_ARROW,FALSE));

                 return(MRFROMSHORT(FALSE));

            case WM_CONTROL:
                 if(SHORT1FROMMP(mp1) == 10)
                   {
                    if(SHORT2FROMMP(mp2) == 6)
                      {
                       sprintf(szBuffer,"Notification ID:%d,  Subcode:%d,Line# %d. Please see report.h for more detail.",
                            SHORT2FROMMP(mp1),SHORT1FROMMP(mp2),SHORT2FROMMP(mp2));
                       INFO(hwnd,szBuffer);
                      }
                   }

                 break;

            //------------------------------------//
            //             WM_PAINT               //
            //------------------------------------//
            case WM_PAINT:
                 hps=WinBeginPaint(hwnd,NULLHANDLE,&rectl);
                 WinFillRect(hps,&rectl,CLR_DARKGRAY);
                 WinEndPaint(hps);
                 return(MRFROMSHORT(FALSE));

            //------------------------------------//
            //             WM_SIZE                //
            //------------------------------------//

            case WM_SIZE:

                 //Make Sure the Report Control's top left corner is
                 //aligned with the frames top left corner.

                 WinSetWindowPos(hwndReport,
                                 HWND_TOP,
                                 0,
                                 0,
                                 SHORT1FROMMP(mp2),
                                 SHORT2FROMMP(mp2),
                                 SWP_MOVE|SWP_SIZE);

                 return(MRFROMSHORT(FALSE));

            //------------------------------------//
            //             WM_COMMAND             //
            //------------------------------------//
            case WM_COMMAND:
                switch(SHORT1FROMMP(mp1))
                    {
                     case  IDM_PRINT:
                           WinSetPointer(HWND_DESKTOP,
                                         WinQuerySysPointer(HWND_DESKTOP,
                                         SPTR_WAIT,FALSE));

                           WinSendMsg(hwndReport,
                                      RPM_PRINT,
                                      NULL,
                                      NULL);

                           WinSetPointer(HWND_DESKTOP,
                                         WinQuerySysPointer(HWND_DESKTOP,
                                         SPTR_ARROW,FALSE));
                           break;

                     case IDM_100:
                     case IDM_50:
                     case IDM_75:
                     case IDM_150:
                     case IDM_200:
                     case IDM_FITALL:
                          DoScale(SHORT1FROMMP(mp1));
                          break;
                    }
        }

  return(WinDefWindowProc(hwnd, msg, mp1, mp2));
}

VOID DoScale(USHORT usScale)
{
div_t   divResult;
FIXED   fx;
FIXED   fy;

  WinCheckMenuItem(WinWindowFromID(hwndFrame,FID_MENU),usChecked,FALSE);
  WinCheckMenuItem(WinWindowFromID(hwndFrame,FID_MENU),usScale,TRUE);

  usChecked = usScale;

  if(usScale == IDM_FITALL)
    {
     fx = fy = MAKEFIXED(0,0);
    }
  else
    {
     divResult = div(usScale,100);
     fx        = MAKEFIXED(divResult.quot, (65536 * divResult.rem)/100);
     fy        = MAKEFIXED(divResult.quot, (65536 * divResult.rem)/100);
    }

  WinSendMsg(hwndReport,
             RPM_SETVIEWSCALE,
             (MPARAM)fx,
             (MPARAM)fy);
  return;
}
