#include <io.h>
#include <stdio.h>
#include <stdlib.h>
#include <string.h>

   // Function Prototypes

extern int main ( int argc, char *argv[] ) ;


   // Graphics Character Global Identifiers (IBM)

enum GCGID {
   SS000000 = 1,
   SS010000,
   SS020000,
   SS030000,
   SS040000,
   SS050000,
   SM570000,
   SM570001,
   SM750000,
   SM750002,
   SM280000,
   SM290000,
   SM930000,
   SM910000,
   SM690000,
   SM590000,
   SM630000,
   SM760000,
   SP330000,
   SM250000,
   SM240000,
   SM700000,
   SM770000,
   SM320000,
   SM330000,
   SM310000,
   SM300000,
   SA420000,
   SM780000,
   SM600000,
   SV040000,
   SP010000,
   SP020000,
   SP040000,
   SM010000,
   SC030000,
   SM020000,
   SM030000,
   SP050000,
   SP060000,
   SP070000,
   SM040000,
   SA010000,
   SP080000,
   SP100000,
   SP110000,
   SP120000,
   ND100000,
   ND010000,
   ND020000,
   ND030000,
   ND040000,
   ND050000,
   ND060000,
   ND070000,
   ND080000,
   ND090000,
   SP130000,
   SP140000,
   SA030000,
   SA040000,
   SA050000,
   SP150000,
   SM050000,
   LA020000,
   LB020000,
   LC020000,
   LD020000,
   LE020000,
   LF020000,
   LG020000,
   LH020000,
   LI020000,
   LJ020000,
   LK020000,
   LL020000,
   LM020000,
   LN020000,
   LO020000,
   LP020000,
   LQ020000,
   LR020000,
   LS020000,
   LT020000,
   LU020000,
   LV020000,
   LW020000,
   LX020000,
   LY020000,
   LZ020000,
   SM060000,
   SM070000,
   SM080000,
   SD150000,
   SP090000,
   SD130000,
   LA010000,
   LB010000,
   LC010000,
   LD010000,
   LE010000,
   LF010000,
   LG010000,
   LH010000,
   LI010000,
   LJ010000,
   LK010000,
   LL010000,
   LM010000,
   LN010000,
   LO010000,
   LP010000,
   LQ010000,
   LR010000,
   LS010000,
   LT010000,
   LU010000,
   LV010000,
   LW010000,
   LX010000,
   LY010000,
   LZ010000,
   SM110000,
   SM130000,
   SM140000,
   SD190000,
   SM790000,
   LC420000,
   LU170000,
   LE110000,
   LA150000,
   LA170000,
   LA130000,
   LA270000,
   LC410000,
   LE150000,
   LE170000,
   LE130000,
   LI170000,
   LI150000,
   LI130000,
   LA180000,
   LA280000,
   LE120000,
   LA510000,
   LA520000,
   LO150000,
   LO170000,
   LO130000,
   LU150000,
   LU130000,
   LY170000,
   LO180000,
   LU180000,
   LO610000,
   SC020000,
   LO620000,
   SA070000,
   SC070000,
   LA110000,
   LI110000,
   LO110000,
   LU110000,
   LN190000,
   LN200000,
   SM210000,
   SM200000,
   SP160000,
   SM530000,
   SM660000,
   NF010000,
   NF040000,
   SP030000,
   SP170000,
   SP180000,
   SF140000,
   SF150000,
   SF160000,
   SF110000,
   SF090000,
   LA120000,
   LA160000,
   LA140000,
   SM520000,
   SF230000,
   SF240000,
   SF250000,
   SF260000,
   SC040000,
   SC050000,
   SF030000,
   SF020000,
   SF070000,
   SF060000,
   SF080000,
   SF100000,
   SF050000,
   LA190000,
   LA200000,
   SF380000,
   SF390000,
   SF400000,
   SF410000,
   SF420000,
   SF430000,
   SF440000,
   SC010000,
   LD630000,
   LD620000,
   LE160000,
   LE180000,
   LE140000,
   LI610000,
   LI120000,
   LI160000,
   LI180000,
   SF040000,
   SF010000,
   SF610000,
   SF570000,
   SM650000,
   LI140000,
   SF600000,
   LO120000,
   LS610000,
   LO160000,
   LO140000,
   LO190000,
   LO200000,
   SM170000,
   LT630000,
   LT640000,
   LU120000,
   LU160000,
   LU140000,
   LY110000,
   LY120000,
   SM150000,
   SD110000,
   SP320000,
   SA020000,
   SM100000,
   NF050000,
   SM250000_D,
   SM240000_D,
   SA060000,
   SD410000,
   SM190000,
   SD170000,
   SD630000,
   ND011000,
   ND031000,
   ND021000,
   SM470000,
   SP300000,
   SC060000,
   SM680000,
   SF190000,
   SF200000,
   SF210000,
   SF220000,
   SF270000,
   SF280000,
   SF360000,
   SF370000,
   SF450000,
   SF460000,
   SF470000,
   SF480000,
   SF490000,
   SF500000,
   SF510000,
   SF520000,
   SF530000,
   SF540000,
   SF580000,
   SF590000,
   GA010000,
   GG020000,
   GP010000,
   GS020000,
   GS010000,
   GT010000,
   GF020000,
   GT620000,
   GO320000,
   GD010000,
   SA450000,
   GF010000,
   GE010000,
   SA380000,
   SA480000,
   SA530000,
   SA520000,
   SS260000,
   SS270000,
   SA700000,
   SA790000,
   SA800000,
   LN011000,
   SD310000,
   SD230000,
   SD290000,
   SD270000,
   SD250000,
   SD430000,
   SD210000,
   SP190000,
   SP200000,
   SP210000,
   SP220000,
   SS680000,
   SM900000,
   SD150000_D,
   SD190000_D,
   SP260000,
   SP230000,
   SV520000,
   SM340000,
   SM350000,
   SD150100,
   SM560000,
   LS220000,
   SP270000,
   LO520000,
   SD190100,
   SM540000,
   LS210000,
   SP280000,
   LO510000,
   LY180000,
   LG230000,
   LG240000,
   LI300000,
   LS410000,
   LS420000,
   LA230000,
   LA240000,
   LA430000,
   LA440000,
   LC110000,
   LC120000,
   LC210000,
   LC220000,
   LD210000,
   LD220000,
   LD610000,
   LE210000,
   LE220000,
   LE430000,
   LE440000,
   LL110000,
   LL120000,
   LL210000,
   LL220000,
   LL610000,
   LL620000,
   LN110000,
   LN120000,
   LN210000,
   LN220000,
   LO250000,
   LO260000,
   LR110000,
   LR120000,
   LR210000,
   LR220000,
   LS110000,
   LS120000,
   LT210000,
   LT220000,
   LT410000,
   LT420000,
   LU250000,
   LU260000,
   LU270000,
   LU280000,
   LZ110000,
   LZ120000,
   LZ210000,
   LZ220000,
   LZ290000,
   LZ300000
} ;


   // Codepage 437 - United States PC

unsigned CodePage437 [256] = {
   0,	      SS000000,  SS010000,  SS020000,
   SS030000,  SS040000,  SS050000,  SM570000,
   SM570001,  SM750000,  SM750002,  SM280000,
   SM290000,  SM930000,  SM910000,  SM690000,
   SM590000,  SM630000,  SM760000,  SP330000,
   SM250000,  SM240000,  SM700000,  SM770000,
   SM320000,  SM330000,  SM310000,  SM300000,
   SA420000,  SM780000,  SM600000,  SV040000,
   SP010000,  SP020000,  SP040000,  SM010000,
   SC030000,  SM020000,  SM030000,  SP050000,
   SP060000,  SP070000,  SM040000,  SA010000,
   SP080000,  SP100000,  SP110000,  SP120000,
   ND100000,  ND010000,  ND020000,  ND030000,
   ND040000,  ND050000,  ND060000,  ND070000,
   ND080000,  ND090000,  SP130000,  SP140000,
   SA030000,  SA040000,  SA050000,  SP150000,
   SM050000,  LA020000,  LB020000,  LC020000,
   LD020000,  LE020000,  LF020000,  LG020000,
   LH020000,  LI020000,  LJ020000,  LK020000,
   LL020000,  LM020000,  LN020000,  LO020000,
   LP020000,  LQ020000,  LR020000,  LS020000,
   LT020000,  LU020000,  LV020000,  LW020000,
   LX020000,  LY020000,  LZ020000,  SM060000,
   SM070000,  SM080000,  SD150000,  SP090000,
   SD130000,  LA010000,  LB010000,  LC010000,
   LD010000,  LE010000,  LF010000,  LG010000,
   LH010000,  LI010000,  LJ010000,  LK010000,
   LL010000,  LM010000,  LN010000,  LO010000,
   LP010000,  LQ010000,  LR010000,  LS010000,
   LT010000,  LU010000,  LV010000,  LW010000,
   LX010000,  LY010000,  LZ010000,  SM110000,
   SM130000,  SM140000,  SD190000,  SM790000,
   LC420000,  LU170000,  LE110000,  LA150000,  // 0x80
   LA170000,  LA130000,  LA270000,  LC410000,
   LE150000,  LE170000,  LE130000,  LI170000,
   LI150000,  LI130000,  LA180000,  LA280000,
   LE120000,  LA510000,  LA520000,  LO150000,  // 0x90
   LO170000,  LO130000,  LU150000,  LU130000,
   LY170000,  LO180000,  LU180000,  SC040000,
   SC020000,  SC050000,  SC060000,  SC070000,
   LA110000,  LI110000,  LO110000,  LU110000,  // 0xA0
   LN190000,  LN200000,  SM210000,  SM200000,
   SM680000,  SM530000,  SM660000,  NF010000,
   SP010000,  SP030000,  SP170000,  SP180000,
   SF140000,  SF150000,  SF160000,  SF110000,  // 0xB0
   SF090000,  SF190000,  SF200000,  SF210000,
   SF220000,  SF230000,  SF240000,  SF250000,
   SF260000,  SF270000,  SF280000,  SF030000,
   SF020000,  SF070000,  SF060000,  SF080000,  // 0xC0
   SF100000,  SF050000,  SF360000,  SF370000,
   SF380000,  SF390000,  SF400000,  SF410000,
   SF420000,  SF430000,  SF440000,  SF450000,
   SF460000,  SF470000,  SF480000,  SF490000,  // 0xD0
   SF500000,  SF510000,  SF520000,  SF530000,
   SF540000,  SF040000,  SF010000,  SF610000,
   SF570000,  SF580000,  SF590000,  SF600000,
   GA010000,  LS610000,  GG020000,  GP010000,  // 0xE0
   GS020000,  GS010000,  SM170000,  GT010000,
   GF020000,  GT620000,  GO320000,  GD010000,
   SA450000,  GF010000,  GE010000,  SA380000,
   SA480000,  SA020000,  SA530000,  SA520000,  // 0xF0
   SS260000,  SS270000,  SA060000,  SA700000,
   SM190000,  SA790000,  SD630000,  SA800000,
   LN011000,  ND021000,  SM470000,  SP300000,
} ;

   // Codepage 819 - ISO-8859-1 Standard

unsigned CodePage819 [256] = {
   0,	      SS000000,  SS010000,  SS020000,
   SS030000,  SS040000,  SS050000,  SM570000,
   SM570001,  SM750000,  SM750002,  SM280000,
   SM290000,  SM930000,  SM910000,  SM690000,
   SM590000,  SM630000,  SM760000,  SP330000,
   SM250000,  SM240000,  SM700000,  SM770000,
   SM320000,  SM330000,  SM310000,  SM300000,
   SA420000,  SM780000,  SM600000,  SV040000,
   SP010000,  SP020000,  SP040000,  SM010000,
   SC030000,  SM020000,  SM030000,  SP050000,
   SP060000,  SP070000,  SM040000,  SA010000,
   SP080000,  SP100000,  SP110000,  SP120000,
   ND100000,  ND010000,  ND020000,  ND030000,
   ND040000,  ND050000,  ND060000,  ND070000,
   ND080000,  ND090000,  SP130000,  SP140000,
   SA030000,  SA040000,  SA050000,  SP150000,
   SM050000,  LA020000,  LB020000,  LC020000,
   LD020000,  LE020000,  LF020000,  LG020000,
   LH020000,  LI020000,  LJ020000,  LK020000,
   LL020000,  LM020000,  LN020000,  LO020000,
   LP020000,  LQ020000,  LR020000,  LS020000,
   LT020000,  LU020000,  LV020000,  LW020000,
   LX020000,  LY020000,  LZ020000,  SM060000,
   SM070000,  SM080000,  SD150000,  SP090000,
   SD130000,  LA010000,  LB010000,  LC010000,
   LD010000,  LE010000,  LF010000,  LG010000,
   LH010000,  LI010000,  LJ010000,  LK010000,
   LL010000,  LM010000,  LN010000,  LO010000,
   LP010000,  LQ010000,  LR010000,  LS010000,
   LT010000,  LU010000,  LV010000,  LW010000,
   LX010000,  LY010000,  LZ010000,  SM110000,
   SM130000,  SM140000,  SD190000,  SM790000,
   SP010000,  SP010000,  SP010000,  SP010000,  // 0x80
   SP010000,  SP010000,  SP010000,  SP010000,
   SP010000,  SP010000,  SP010000,  SP010000,
   SP010000,  SP010000,  SP010000,  SP010000,
   SP010000,  SP010000,  SP010000,  SP010000,  // 0x90
   SP010000,  SP010000,  SP010000,  SP010000,
   SP010000,  SP010000,  SP010000,  SP010000,
   SP010000,  SP010000,  SP010000,  SP010000,
   SP300000,  SP030000,  SC040000,  SC020000,  // 0xA0
   SC010000,  SC050000,  SM650000,  SM240000,
   SD170000,  SM520000,  SM210000,  SP170000,
   SM660000,  SP320000,  SM530000,  SD310000,
   SM190000,  SA020000,  ND021000,  ND031000,  // 0xB0
   SD110000,  SM170000,  SM250000,  SD290000,
   SD410000,  ND011000,  SM200000,  SP180000,
   NF040000,  NF010000,  NF050000,  SP160000,
   LA140000,  LA120000,  LA160000,  LA200000,  // 0xC0
   LA180000,  LA280000,  LA520000,  LC420000,
   LE140000,  LE120000,  LE160000,  LE180000,
   LI140000,  LI120000,  LI160000,  LI180000,
   LD620000,  LN200000,  LO140000,  LO120000,  // 0xD0
   LO160000,  LO200000,  LO180000,  SA070000,
   LO620000,  LU140000,  LU120000,  LU160000,
   LU180000,  LY120000,  LT640000,  LS610000,
   LA130000,  LA110000,  LA150000,  LA190000,  // 0xE0
   LA170000,  LA270000,  LA510000,  LC410000,
   LE130000,  LE110000,  LE150000,  LE170000,
   LI130000,  LI110000,  LI150000,  LI170000,
   LD630000,  LN190000,  LO130000,  LO110000,  // 0xF0
   LO150000,  LO190000,  LO170000,  SA060000,
   LO610000,  LU130000,  LU110000,  LU150000,
   LU170000,  LY110000,  LT630000,  LY170000,
} ;


   // Codepage 850 - Multilingual

unsigned CodePage850 [256] = {
   0,	      SS000000,  SS010000,  SS020000,
   SS030000,  SS040000,  SS050000,  SM570000,
   SM570001,  SM750000,  SM750002,  SM280000,
   SM290000,  SM930000,  SM910000,  SM690000,
   SM590000,  SM630000,  SM760000,  SP330000,
   SM250000,  SM240000,  SM700000,  SM770000,
   SM320000,  SM330000,  SM310000,  SM300000,
   SA420000,  SM780000,  SM600000,  SV040000,
   SP010000,  SP020000,  SP040000,  SM010000,
   SC030000,  SM020000,  SM030000,  SP050000,
   SP060000,  SP070000,  SM040000,  SA010000,
   SP080000,  SP100000,  SP110000,  SP120000,
   ND100000,  ND010000,  ND020000,  ND030000,
   ND040000,  ND050000,  ND060000,  ND070000,
   ND080000,  ND090000,  SP130000,  SP140000,
   SA030000,  SA040000,  SA050000,  SP150000,
   SM050000,  LA020000,  LB020000,  LC020000,
   LD020000,  LE020000,  LF020000,  LG020000,
   LH020000,  LI020000,  LJ020000,  LK020000,
   LL020000,  LM020000,  LN020000,  LO020000,
   LP020000,  LQ020000,  LR020000,  LS020000,
   LT020000,  LU020000,  LV020000,  LW020000,
   LX020000,  LY020000,  LZ020000,  SM060000,
   SM070000,  SM080000,  SD150000,  SP090000,
   SD130000,  LA010000,  LB010000,  LC010000,
   LD010000,  LE010000,  LF010000,  LG010000,
   LH010000,  LI010000,  LJ010000,  LK010000,
   LL010000,  LM010000,  LN010000,  LO010000,
   LP010000,  LQ010000,  LR010000,  LS010000,
   LT010000,  LU010000,  LV010000,  LW010000,
   LX010000,  LY010000,  LZ010000,  SM110000,
   SM130000,  SM140000,  SD190000,  SM790000,
   LC420000,  LU170000,  LE110000,  LA150000,  // 0x80
   LA170000,  LA130000,  LA270000,  LC410000,
   LE150000,  LE170000,  LE130000,  LI170000,
   LI150000,  LI130000,  LA180000,  LA280000,
   LE120000,  LA510000,  LA520000,  LO150000,  // 0x90
   LO170000,  LO130000,  LU150000,  LU130000,
   LY170000,  LO180000,  LU180000,  LO610000,
   SC020000,  LO620000,  SA070000,  SC070000,
   LA110000,  LI110000,  LO110000,  LU110000,  // 0xA0
   LN190000,  LN200000,  SM210000,  SM200000,
   SP160000,  SM530000,  SM660000,  NF010000,
   NF040000,  SP030000,  SP170000,  SP180000,
   SF140000,  SF150000,  SF160000,  SF110000,  // 0xB0
   SF090000,  LA120000,  LA160000,  LA140000,
   SM520000,  SF230000,  SF240000,  SF250000,
   SF260000,  SC040000,  SC050000,  SF030000,
   SF020000,  SF070000,  SF060000,  SF080000,  // 0xC0
   SF100000,  SF050000,  LA190000,  LA200000,
   SF380000,  SF390000,  SF400000,  SF410000,
   SF420000,  SF430000,  SF440000,  SC010000,
   LD630000,  LD620000,  LE160000,  LE180000,  // 0xD0
   LE140000,  LI610000,  LI120000,  LI160000,
   LI180000,  SF040000,  SF010000,  SF610000,
   SF570000,  SM650000,  LI140000,  SF600000,
   LO120000,  LS610000,  LO160000,  LO140000,  // 0xE0
   LO190000,  LO200000,  SM170000,  LT630000,
   LT640000,  LU120000,  LU160000,  LU140000,
   LY110000,  LY120000,  SM150000,  SD110000,
   SP320000,  SA020000,  SM100000,  NF050000,  // 0xF0
   SM250000,  SM240000,  SA060000,  SD410000,
   SM190000,  SD170000,  SD630000,  ND011000,
   ND031000,  ND021000,  SM470000,  SP300000,
} ;


   // Codepage 860 - Portuguese

unsigned CodePage860 [256] = {
   0,	      SS000000,  SS010000,  SS020000,
   SS030000,  SS040000,  SS050000,  SM570000,
   SM570001,  SM750000,  SM750002,  SM280000,
   SM290000,  SM930000,  SM910000,  SM690000,
   SM590000,  SM630000,  SM760000,  SP330000,
   SM250000,  SM240000,  SM700000,  SM770000,
   SM320000,  SM330000,  SM310000,  SM300000,
   SA420000,  SM780000,  SM600000,  SV040000,
   SP010000,  SP020000,  SP040000,  SM010000,
   SC030000,  SM020000,  SM030000,  SP050000,
   SP060000,  SP070000,  SM040000,  SA010000,
   SP080000,  SP100000,  SP110000,  SP120000,
   ND100000,  ND010000,  ND020000,  ND030000,
   ND040000,  ND050000,  ND060000,  ND070000,
   ND080000,  ND090000,  SP130000,  SP140000,
   SA030000,  SA040000,  SA050000,  SP150000,
   SM050000,  LA020000,  LB020000,  LC020000,
   LD020000,  LE020000,  LF020000,  LG020000,
   LH020000,  LI020000,  LJ020000,  LK020000,
   LL020000,  LM020000,  LN020000,  LO020000,
   LP020000,  LQ020000,  LR020000,  LS020000,
   LT020000,  LU020000,  LV020000,  LW020000,
   LX020000,  LY020000,  LZ020000,  SM060000,
   SM070000,  SM080000,  SD150000,  SP090000,
   SD130000,  LA010000,  LB010000,  LC010000,
   LD010000,  LE010000,  LF010000,  LG010000,
   LH010000,  LI010000,  LJ010000,  LK010000,
   LL010000,  LM010000,  LN010000,  LO010000,
   LP010000,  LQ010000,  LR010000,  LS010000,
   LT010000,  LU010000,  LV010000,  LW010000,
   LX010000,  LY010000,  LZ010000,  SM110000,
   SM130000,  SM140000,  SD190000,  SM790000,
   LC420000,  LU170000,  LE110000,  LA150000,  // 0x80
   LA170000,  LA130000,  LA120000,  LC410000,
   LE150000,  LE160000,  LE130000,  LI120000,
   LO160000,  LI130000,  LA200000,  LA160000,
   LE120000,  LA140000,  LE140000,  LO150000,  // 0x90
   LO170000,  LO130000,  LU120000,  LU130000,
   LI140000,  LO180000,  LU180000,  SC040000,
   SC020000,  LU140000,  SC060000,  LO120000,
   LA110000,  LI110000,  LO110000,  LU110000,  // 0xA0
   LN190000,  LN200000,  SM210000,  SM200000,
   SM680000,  LO140000,  SM660000,  NF010000,
   SP010000,  SP030000,  SP170000,  SP180000,
   SF140000,  SF150000,  SF160000,  SF110000,  // 0xB0
   SF090000,  SF190000,  SF200000,  SF210000,
   SF220000,  SF230000,  SF240000,  SF250000,
   SF260000,  SF270000,  SF280000,  SF030000,
   SF020000,  SF070000,  SF060000,  SF080000,  // 0xC0
   SF100000,  SF050000,  SF360000,  SF370000,
   SF380000,  SF390000,  SF400000,  SF410000,
   SF420000,  SF430000,  SF440000,  SF450000,
   SF460000,  SF470000,  SF480000,  SF490000,  // 0xD0
   SF500000,  SF510000,  SF520000,  SF530000,
   SF540000,  SF040000,  SF010000,  SF610000,
   SF570000,  SF580000,  SF590000,  SF600000,
   GA010000,  LS610000,  GG020000,  GP010000,  // 0xE0
   GS020000,  GS010000,  SM170000,  GT010000,
   GF020000,  GT620000,  GO320000,  GD010000,
   SA450000,  GF010000,  GE010000,  SA380000,
   SA480000,  SA020000,  SA530000,  SA520000,  // 0xF0
   SS260000,  SS270000,  SA060000,  SA700000,
   SM190000,  SA790000,  SD630000,  SA800000,
   LN011000,  ND021000,  SM470000,  SP300000,
} ;


   // Codepage 863 - French-Canadian

unsigned CodePage863 [256] = {
   0,	      SS000000,  SS010000,  SS020000,
   SS030000,  SS040000,  SS050000,  SM570000,
   SM570001,  SM750000,  SM750002,  SM280000,
   SM290000,  SM930000,  SM910000,  SM690000,
   SM590000,  SM630000,  SM760000,  SP330000,
   SM250000,  SM240000,  SM700000,  SM770000,
   SM320000,  SM330000,  SM310000,  SM300000,
   SA420000,  SM780000,  SM600000,  SV040000,
   SP010000,  SP020000,  SP040000,  SM010000,
   SC030000,  SM020000,  SM030000,  SP050000,
   SP060000,  SP070000,  SM040000,  SA010000,
   SP080000,  SP100000,  SP110000,  SP120000,
   ND100000,  ND010000,  ND020000,  ND030000,
   ND040000,  ND050000,  ND060000,  ND070000,
   ND080000,  ND090000,  SP130000,  SP140000,
   SA030000,  SA040000,  SA050000,  SP150000,
   SM050000,  LA020000,  LB020000,  LC020000,
   LD020000,  LE020000,  LF020000,  LG020000,
   LH020000,  LI020000,  LJ020000,  LK020000,
   LL020000,  LM020000,  LN020000,  LO020000,
   LP020000,  LQ020000,  LR020000,  LS020000,
   LT020000,  LU020000,  LV020000,  LW020000,
   LX020000,  LY020000,  LZ020000,  SM060000,
   SM070000,  SM080000,  SD150000,  SP090000,
   SD130000,  LA010000,  LB010000,  LC010000,
   LD010000,  LE010000,  LF010000,  LG010000,
   LH010000,  LI010000,  LJ010000,  LK010000,
   LL010000,  LM010000,  LN010000,  LO010000,
   LP010000,  LQ010000,  LR010000,  LS010000,
   LT010000,  LU010000,  LV010000,  LW010000,
   LX010000,  LY010000,  LZ010000,  SM110000,
   SM130000,  SM140000,  SD190000,  SM790000,
   LC420000,  LU170000,  LE110000,  LA150000,  // 0x80
   LA160000,  LA130000,  SM250000,  LC410000,
   LE150000,  LE170000,  LE130000,  LI170000,
   LI150000,  SA040000,  LA140000,  SM240000,
   LE120000,  LE140000,  LE160000,  LO150000,  // 0x90
   LE180000,  LI180000,  LU150000,  LU130000,
   SC010000,  LO160000,  LU180000,  SC040000,
   SC020000,  LU140000,  LU160000,  SC070000,
   SM650000,  SD110000,  LO110000,  LU110000,  // 0xA0
   SD170000,  SD410000,  ND031000,  SM150000,
   LI160000,  SM530000,  SM660000,  NF010000,
   SP010000,  NF050000,  SP170000,  SP180000,
   SF140000,  SF150000,  SF160000,  SF110000,  // 0xB0
   SF090000,  SF190000,  SF200000,  SF210000,
   SF220000,  SF230000,  SF240000,  SF250000,
   SF260000,  SF270000,  SF280000,  SF030000,
   SF020000,  SF070000,  SF060000,  SF080000,  // 0xC0
   SF100000,  SF050000,  SF360000,  SF370000,
   SF380000,  SF390000,  SF400000,  SF410000,
   SF420000,  SF430000,  SF440000,  SF450000,
   SF460000,  SF470000,  SF480000,  SF490000,  // 0xD0
   SF500000,  SF510000,  SF520000,  SF530000,
   SF540000,  SF040000,  SF010000,  SF610000,
   SF570000,  SF580000,  SF590000,  SF600000,
   GA010000,  LS610000,  GG020000,  GP010000,  // 0xE0
   GS020000,  GS010000,  SM170000,  GT010000,
   GF020000,  GT620000,  GO320000,  GD010000,
   SA450000,  GF010000,  GE010000,  SA380000,
   SA480000,  SA020000,  SA530000,  SA520000,  // 0xF0
   SS260000,  SS270000,  SA060000,  SA700000,
   SM190000,  SA790000,  SD630000,  SA800000,
   LN011000,  ND021000,  SM470000,  SP300000,
} ;


   // Codepage 865 - Nordic

unsigned CodePage865 [256] = {
   0,	      SS000000,  SS010000,  SS020000,
   SS030000,  SS040000,  SS050000,  SM570000,
   SM570001,  SM750000,  SM750002,  SM280000,
   SM290000,  SM930000,  SM910000,  SM690000,
   SM590000,  SM630000,  SM760000,  SP330000,
   SM250000,  SM240000,  SM700000,  SM770000,
   SM320000,  SM330000,  SM310000,  SM300000,
   SA420000,  SM780000,  SM600000,  SV040000,
   SP010000,  SP020000,  SP040000,  SM010000,
   SC030000,  SM020000,  SM030000,  SP050000,
   SP060000,  SP070000,  SM040000,  SA010000,
   SP080000,  SP100000,  SP110000,  SP120000,
   ND100000,  ND010000,  ND020000,  ND030000,
   ND040000,  ND050000,  ND060000,  ND070000,
   ND080000,  ND090000,  SP130000,  SP140000,
   SA030000,  SA040000,  SA050000,  SP150000,
   SM050000,  LA020000,  LB020000,  LC020000,
   LD020000,  LE020000,  LF020000,  LG020000,
   LH020000,  LI020000,  LJ020000,  LK020000,
   LL020000,  LM020000,  LN020000,  LO020000,
   LP020000,  LQ020000,  LR020000,  LS020000,
   LT020000,  LU020000,  LV020000,  LW020000,
   LX020000,  LY020000,  LZ020000,  SM060000,
   SM070000,  SM080000,  SD150000,  SP090000,
   SD130000,  LA010000,  LB010000,  LC010000,
   LD010000,  LE010000,  LF010000,  LG010000,
   LH010000,  LI010000,  LJ010000,  LK010000,
   LL010000,  LM010000,  LN010000,  LO010000,
   LP010000,  LQ010000,  LR010000,  LS010000,
   LT010000,  LU010000,  LV010000,  LW010000,
   LX010000,  LY010000,  LZ010000,  SM110000,
   SM130000,  SM140000,  SD190000,  SM790000,
   LC420000,  LU170000,  LE110000,  LA150000,  // 0x80
   LA170000,  LA130000,  LA270000,  LC410000,
   LE150000,  LE170000,  LE130000,  LI170000,
   LI150000,  LI130000,  LA180000,  LA280000,
   LE120000,  LA510000,  LA520000,  LO150000,  // 0x90
   LO170000,  LO130000,  LU150000,  LU130000,
   LY170000,  LO180000,  LU180000,  LO610000,
   SC020000,  LO620000,  SC060000,  SC070000,
   LA110000,  LI110000,  LO110000,  LU110000,  // 0xA0
   LN190000,  LN200000,  SM210000,  SM200000,
   SM680000,  SM530000,  SM660000,  NF010000,
   SP010000,  SP030000,  SP170000,  SC010000,
   SF140000,  SF150000,  SF160000,  SF110000,  // 0xB0
   SF090000,  SF190000,  SF200000,  SF210000,
   SF220000,  SF230000,  SF240000,  SF250000,
   SF260000,  SF270000,  SF280000,  SF030000,
   SF020000,  SF070000,  SF060000,  SF080000,  // 0xC0
   SF100000,  SF050000,  SF360000,  SF370000,
   SF380000,  SF390000,  SF400000,  SF410000,
   SF420000,  SF430000,  SF440000,  SF450000,
   SF460000,  SF470000,  SF480000,  SF490000,  // 0xD0
   SF500000,  SF510000,  SF520000,  SF530000,
   SF540000,  SF040000,  SF010000,  SF610000,
   SF570000,  SF580000,  SF590000,  SF600000,
   GA010000,  LS610000,  GG020000,  GP010000,  // 0xE0
   GS020000,  GS010000,  SM170000,  GT010000,
   GF020000,  GT620000,  GO320000,  GD010000,
   SA450000,  GF010000,  GE010000,  SA380000,
   SA480000,  SA020000,  SA530000,  SA520000,  // 0xF0
   SS260000,  SS270000,  SA060000,  SA700000,
   SM190000,  SA790000,  SD630000,  SA800000,
   LN011000,  ND021000,  SM470000,  SP300000,
} ;


   // Code Page List

struct {
  int CodePage ;
  unsigned *Table ;
} Tables [] = {
  { 437, CodePage437 },
  { 819, CodePage819 },
  { 850, CodePage850 },
  { 860, CodePage860 },
  { 863, CodePage863 },
  { 865, CodePage865 },
} ;


   // Main Program

extern int main ( int argc, char *argv[] ) {

   int From = 0 ;
   int To = 0 ;
   char Filename [_MAX_PATH] = { 0 } ;
   FILE *File ;
   int Byte ;
   unsigned *FromTable ;
   unsigned *ToTable ;
   int i, j ;
   unsigned char TranslationTable [256] ;
   int Error ;

   while ( --argc ) {
      argv ++ ;
      strupr ( *argv ) ;

      if ( *argv[0] == '?' ) {
         printf ( "RECODE: Convert text from codepage to codepage\n"
            "\n"
            "Parameters:\n"
            "  FROM=Codepage  Original codepage (default 819 (ISO-8859-1)).\n"
            "  TO=Codepage    New codepage (default 850).\n"
	    "  Filename       Name of file to convert.\n"
	    "\n"
	    "Result is sent to standard output and may be redirected."
	    "\n"
	    "Currently supported codepages:\n"
	    "  437 - United States PC\n"
	    "  819 - ISO-8859/1\n"
	    "  850 - Multilingual\n"
	    "  860 - Portuguese\n"
	    "  863 - French-Canadian\n"
	    "  865 - Nordic\n"
         ) ;
         return ( 0 ) ;
      } /* endif */

      if ( !strncmp ( *argv, "FROM=", 5 ) ) {
         if ( From ) {
            fprintf ( stderr, "ERROR: Origin codepage already specified." ) ;
            return ( 1 ) ;
         } /* endif */
         From = atoi ( *argv+5 ) ;
         continue ;
      } /* endif */

      if ( !strncmp ( *argv, "TO=", 3 ) ) {
         if ( To ) {
            fprintf ( stderr, "ERROR: Destination codepage already specified." ) ;
            return ( 1 ) ;
         } /* endif */
         To = atoi ( *argv+3 ) ;
         continue ;
      } /* endif */

      if ( Filename[0] == 0 ) {
         strcpy ( Filename, *argv ) ;
         if ( access ( Filename, 0 ) ) {
            fprintf ( stderr, "ERROR: File '%s' doesn't exist.", Filename ) ;
            return ( 1 ) ;
         } /* endif */
         continue ;
      } /* endif */

      fprintf ( stderr, "ERROR: Unrecognized option '%s'.", *argv ) ;
      return ( 1 ) ;

   } /* endwhile */

   if ( From == 0 )
      From = 819 ;

   if ( To == 0 )
      To = 850 ;

   FromTable = 0 ;
   for ( i=0; i<sizeof(Tables)/sizeof(Tables[0]); i++ ) {
      if ( Tables[i].CodePage == From ) {
	 FromTable = Tables[i].Table ;
	 break ;
      } /* endif */
   } /* endfor */
   if ( FromTable == 0 ) {
      fprintf ( stderr, "ERROR: Unsupported source code page %i.", From ) ;
      return ( 1 ) ;
   } /* endif */

   ToTable = 0 ;
   for ( i=0; i<sizeof(Tables)/sizeof(Tables[0]); i++ ) {
      if ( Tables[i].CodePage == To ) {
	 ToTable = Tables[i].Table ;
	 break ;
      } /* endif */
   } /* endfor */
   if ( ToTable == 0 ) {
      fprintf ( stderr, "ERROR: Unsupported source code page %i.", To ) ;
      return ( 1 ) ;
   } /* endif */

   memset ( TranslationTable, 0, sizeof(TranslationTable) ) ;
   for ( i=0; i<256; i++ ) {
      for ( j=0; j<256; j++ ) {
	 if ( FromTable[i] == ToTable[j] ) {
	    TranslationTable[i] = (unsigned char) j ;
	    break ;
	 } /* endif */
      } /* endif */
   } /* endfor */

   if ( Filename[0] == 0 ) {
      fprintf ( stderr, "ERROR: No filename specified." ) ;
      return ( 1 ) ;
   } /* endif */

   File = fopen ( Filename, "r" ) ;
   if ( File == 0 ) {
      fprintf ( stderr, "ERROR: Unable to open file." ) ;
      return ( 1 ) ;
   } /* endif */

   Error = 0 ;
   while ( ( Byte = fgetc ( File ) ) >= 0 ) {
      unsigned char NewByte = TranslationTable [ Byte ] ;
      if ( Byte && !NewByte ) {
	 NewByte = ' ' ;
	 Error = 1 ;
      } /* endif */
      fputc ( NewByte, stdout ) ;
   } /* endwhile */

   fclose ( File ) ;

   if ( Error )
      fprintf ( stderr, "WARNING: There were untranslatable characters." ) ;

   return ( Error ) ;
}
