/*****************************************************************************
   MODULE: rputs.c
  PURPOSE: recio character delimited string and char output functions
COPYRIGHT: (C) 1994-1995, William Pierpoint
 COMPILER: Borland C Version 3.1
       OS: MSDOS Version 6.2
  VERSION: 2.13
  RELEASE: September 4, 1995
*****************************************************************************/

#include <stdio.h>
#include <stdlib.h>
#include <string.h>

#include "recio.h"

extern int _risready(REC *rp, int mode);
extern int _rputc(REC *rp, int ch);

#define rflags(rp)       ((rp)->r_flags)
#define rfp(rp)          ((rp)->r_fp)
#define rcol(rp)         ((rp)->r_colno)
#define rfldch(rp)       ((rp)->r_fldch)
#define rtxtch(rp)       ((rp)->r_txtch)

/****************************************************************************/
int                          /* return 0 on success; !0 on error            */
    _rputc(                  /* put character to record stream              */
        REC *rp,             /* record pointer                              */
        int  ch)             /* character to put to record stream           */
/****************************************************************************/
{
    int err = fputc(ch, rfp(rp));
    if (err==EOF) {
        rseterr(rp, R_ENOPUT);
    } else {
        rcol(rp)++;
        err = 0;
    }
    return err;
}

/****************************************************************************/
void                         /* returns nothing                             */
    rputc(                   /* put character to record stream              */
        REC *rp,             /* record pointer                              */
        int  ch)             /* character to put to record stream           */
/****************************************************************************/
{
    if (_risready(rp, R_WRITE)) {
        rfldno(rp)++;
        rflags(rp) &= ~_R_TXT;

        /* if not first field, put field separator if not null */
        if (rfldno(rp) > 1 && rfldch(rp)) {
            if (_rputc(rp, rfldch(rp))) goto done;
        }

        /* put character */
        _rputc(rp, ch);
    }
done:
    return;
}

/****************************************************************************/
void                         /* returns nothing                             */
    rputs(                   /* put string to record stream                 */
        REC  *rp,            /* record pointer                              */
  const char *str)           /* pointer to string                           */
/****************************************************************************/
/* note: assumes str does not contain a newline character */
{
    size_t sl;               /* string length */

    if (_risready(rp, R_WRITE)) {
        rfldno(rp)++;
        rflags(rp) &= ~_R_TXT;

        /* if not first field, put field separator if not null */
        if (rfldno(rp) > 1 && rfldch(rp)) {
            if (_rputc(rp, rfldch(rp))) goto done;
        }

        /* if text delimiter not space or null, put leading text delimiter */
        if (!(rtxtch(rp)==' ' || rtxtch(rp)=='\0')) {
            if (_rputc(rp, rtxtch(rp))) {
                rflags(rp) |= _R_TXT;
                goto done;
            }
        }

        /* put string */
        sl = strlen(str);
        if (fputs(str, rfp(rp)) != EOF) { 
            rcol(rp) += sl;
        } else {
            rseterr(rp, R_ENOPUT);
            goto done;
        }

        /* if text delimiter not space or null, put trailing text delimiter */
        if (!(rtxtch(rp)==' ' || rtxtch(rp)=='\0')) {
            _rputc(rp, rtxtch(rp));
        }
    }
done:
}
