#!/usr/bin/perl

require 5.000;

if (@ARGV and $ARGV[0] eq '--keep-ord') {
  shift;
  $do_ords = 1;
}

&usage, exit unless @ARGV > 1;

$tmpc = "tmptmpc.c";
$lib = shift;

$incldir = '';

while ($ARGV[0] =~ /^-[ID]/) {
  if ($ARGV[0] eq '-I') {
    $incldir .= " -I $ARGV[1]";
    shift;
  } else {
    $incldir .= " $ARGV[0]";
  }
  shift;
}

open(C, ">$tmpc") or die "Cannot open `$tmpc' for write: $!\n";
foreach (@ARGV) {
  /[\"<]/ or $_ = "<$_>";
  print C "#include $_\n";
}
close(C) or die "Cannot close `$tmpc' for write: $!\n";

$cc = $ENV{CC} || 'gcc';
open(CPP, "$cc -E $incldir $tmpc |") 
  or die "Cannot open pipe from `$cc -E $tmpc': $!\n";

while (<CPP>) {
  if ( /\btypedef\b/ ) {
    next;
  } elsif ( /\(/ ) {
    push @list, /(\w+)\s*\(/g;
    $was = 1;
  } elsif ( /\bextern\b/ or $contination == 2) {
    push @list, /(\w+)\s*(?:\[[^\]]*\]\s*)?[,;()\n]/g;
    $was = 2;
  }
  $continuation = $was unless /;/ ;
  $was = 0;
}

close(CPP) or die "Cannot close pipe from `$cc -E $tmpc': $!\n";
unlink $tmpc or warn "Cannot delete `$tmpc'\n";

foreach (@list) {
  $seen_from_h{$_}++;
}

@preamble = ();

$maxord = 0;

if ($do_ords and -r "$lib.ord" or -r "$lib.def") {
  my $exp = 0;
  my $file = -r "$lib.ord" ? "$lib.ord" : "$lib.def";
  open(DEF, "$file") or die "Cannot open `$file' for read: $!";
  while (<DEF>) {
    $exp = 1 if s/\bEXPORTS\b// ;
    next if /^\s*;/ or not $exp;
    if (/^\s*(\"?)(\w+)\1\s+\@(\d+)/) {
      $by_ordinal{$3} = $2;
      $ordinal{$2} = $3;
      $maxord = $3 if $maxord < $3;
    }
  }
  close(DEF) or die "Cannot close `$file' for read: $!";
}

if (-r "$lib.def") {
  $wasdef = 1;
  my $exp = 0;
  open(DEF, "$lib.def") or die "Cannot open `$lib.def' for read: $!";
  while (<DEF>) {
    $exp = 1 if s/\bEXPORTS\b// ;
    push @preamble, $_ unless $exp;
    next if /^\s*;/ or not $exp;
    if (/^\s*\"?(\w+)/) {
      $seen_in_def{$1}++;
    }
  }
  close(DEF) or die "Cannot close `$lib.def' for read: $!";
  unlink "$lib.def.old" 
    or die "Cannot delete `$lib.def.old': $!" if -f "$lib.def.old" ;
  rename "$lib.def", "$lib.def.old" 
    or die "Cannot move `$lib.def' to `$lib.def.old': $!";
  open(DEF, ">$lib.def") or die "Cannot open `$lib.def' for write: $!";
  $write = \*DEF;
} else {
  warn "Did not find `$lib.def', dumping all symbols!\n";
  $write = \*STDOUT;
}

$i = 0;
print $write @preamble;
print $write "EXPORTS\n";

if ($wasdef) {
  foreach (sort {$a <=> $b} keys %by_ordinal) {
    if ($seen_from_h{$by_ordinal{$_}}) {
      $i++;
      print $write "  \"$by_ordinal{$_}\" \@$_\n";
    } else {
      $not_seen_from_h{$by_ordinal{$_}}++;
    }
  }
  if (%by_ordinal) {
    print $write "  ;;; End of preserved ordinals\n";
  }
  if (%not_seen_from_h) {
    print $write <<EOF;
  ;;; The following symbols with old ordinals are not seen
  ;;;  from @ARGV
EOF
    foreach (sort {$ordinal{$a} <=> $ordinal{$b}} keys %not_seen_from_h) {
      print $write "  ; \"$_\" \@$ordinal{$_}\n";
    }
    %not_seen_from_h = ();
  }
  print $write <<EOF if %by_ordinal;
  ;;; End of symbols with old ordinals
EOF
  $i = $maxord;
  foreach (sort keys %seen_in_def) {
    next if exists $ordinal{$_}; # Done already
    if ($seen_from_h{$_}) {
      $i++;
      print $write "  \"$_\" \@$i\n";
    } else {
      $not_seen_from_h{$_}++;
    }
  }
  if (%not_seen_from_h) {
    print $write "  ;;; The following exportable symbols are not seen \n" .
      "  ;;;  from @ARGV\n";
    foreach (sort keys %not_seen_from_h) {
      print $write "  ; \"$_\"\n";
    }
  }
} else {
  foreach (@list) {
    print $write "  \"$_\"\n" 
      if not $seen{$_}++;	# multiple includes!
  }
}

if ($wasdef) {
  close(DEF) or die "Cannot close `$lib.def' for write: $!";
}

sub usage {
  warn <<EOU;
usage: $0 library_name incl_file1 incl_file2 ...
ex: $0  readline "<readline/readline.h>" "<readline/history.h>"

If library_name.def is present, it will be renamed to library_name.def.old,
and new, shrinken library_name.def will be written (with ordinals).
If library_name.def is missing, all the symbols found via includes
will be printed to STDOUT.
EOU
}
