/* utime for MS-DOS */

/* by Frank Whaley and Paul Eggert */

	/* $Id: utime.c,v 1.1 1992/01/06 03:18:29 eggert Exp $ */

#include <dos.h>
#include <fcntl.h>
#include <io.h>
#include <sys/types.h>

struct utimbuf { time_t actime, modtime; };

	int
utime(file, times)
	char const *file;
	struct utimbuf const *times;
{
	int fd;
	int ret;
	struct date d;
	struct time t;
	struct ftime ft;

	if (0  <=  (fd = open(file, O_WRONLY))) {
		unixtodos(times->modtime, &d, &t);
		ft.ft_tsec = (t.ti_sec + 1) / 2;
		ft.ft_min = t.ti_min;
		ft.ft_hour = t.ti_hour;
		ft.ft_day = d.da_day;
		ft.ft_month = d.da_mon;
		ft.ft_year = d.da_year - 1980;

		ret = setftime(fd, &ft);

		if (close(fd) == 0)
			return ret;
	}
	return -1;
}
