/* RCS compile-time configuration for DOS and OS/2 */

	/* $Id: conf.h,v 1.10 1992/07/28 16:12:44 eggert Exp $ */

/*
 * This RCS compile-time configuration describes DOS and OS/2 hosts.
 * It differs from ../conf.heg as little as possible.
 * Copy this file to ../conf.h.
 * You may have to edit it for your configuration.
 */

#define exitmain(n) return n /* how to exit from main() */
/* #define _POSIX_SOURCE */ /* Define this if Posix + strict Standard C.  */

#include <errno.h>
#include <stdio.h>
#include <time.h>

/* Comment out #include lines below that do not work.  */
#include <sys/types.h>
#include <sys/stat.h>
/* #include <dirent.h> */
#include <fcntl.h>
#include <limits.h>
/* #include <pwd.h> */
#include <signal.h>
#include <stdlib.h>
#include <string.h>
/* #include <sys/mman.h> */
/* #include <sys/wait.h> */
/* #include <unistd.h> */
/* #include <utime.h> */
/* #include <vfork.h> */

/* Define the following symbols to be 1 or 0.  */
#define has_sys_dir_h 0 /* Does #include <sys/dir.h> work?  */
#define has_sys_param_h 0 /* Does #include <sys/param.h> work?  */
#define has_readlink 0 /* Does readlink() work?  */
#define readlink_isreg_errno EINVAL /* errno after readlink on regular file */

#if !defined(PATH_MAX) && !defined(_POSIX_PATH_MAX)
#	if has_sys_param_h
#		include <sys/param.h>
#		define included_sys_param_h 1
#	endif
#	ifndef PATH_MAX
#		ifndef MAXPATHLEN
#			define MAXPATHLEN 1024
#		endif
#		define PATH_MAX (MAXPATHLEN-1)
#	endif
#endif
#if has_readlink && !defined(MAXSYMLINKS)
#	if has_sys_param_h && !included_sys_param_h
#		include <sys/param.h>
#	endif
#	ifndef MAXSYMLINKS
#		define MAXSYMLINKS 20 /* BSD; not standard yet */
#	endif
#endif

/* Comment out the typedefs below if the types are already declared.  */
/* Fix any uncommented typedefs that are wrong.  */
#ifndef _MODE_T
typedef int mode_t;
#endif
/* typedef int pid_t; */
/* typedef int sig_atomic_t; */
/* typedef unsigned size_t; */
typedef int ssize_t;
/* typedef long time_t; */
/* typedef int uid_t; */

/* Comment out the keyword definitions below if the keywords work.  */
#ifndef __EMX__
#define const
#endif
/* #define volatile */

/* Define the following symbols to be 1 or 0.  */
#define has_prototypes 1 /* Do function prototypes work?  */
#define has_stdarg 1 /* Does <stdarg.h> work?  */
#define has_varargs 0 /* Does <varargs.h> work?  */
#define va_start_args 2 /* How many args does va_start() take?  */
#if has_prototypes
#	define P(params) params
#else
#	define P(params) ()
#endif
#if has_stdarg
#	include <stdarg.h>
#else
#	if has_varargs
#		include <varargs.h>
#	else
		typedef char *va_list;
#		define va_dcl int va_alist;
#		define va_start(ap) ((ap) = (va_list)&va_alist)
#		define va_arg(ap,t) (((t*) ((ap)+=sizeof(t)))  [-1])
#		define va_end(ap)
#	endif
#endif
#if va_start_args == 2
#	define vararg_start va_start
#else
#	define vararg_start(ap,p) va_start(ap)
#endif

#define text_equals_binary_stdio 0 /* Does stdio treat text like binary?  */
#define text_work_stdio 1 /* Text i/o for working file, binary for RCS file?  */
#if text_equals_binary_stdio
	/* Text and binary i/o behave the same, or binary i/o does not work.  */
#	define FOPEN_R "r"
#	define FOPEN_W "w"
#	define FOPEN_WPLUS "w+"
#	define OPEN_O_BINARY 0
#else
	/* Text and binary i/o behave differently.  */
	/* This is incompatible with Posix and Unix.  */
#	define FOPEN_R "rb"
#	define FOPEN_W "wb"
#	define FOPEN_WPLUS "w+b"
#	define OPEN_O_BINARY O_BINARY
#	ifndef O_BINARY
#	define O_BINARY 0
#	endif
#endif
#if text_work_stdio
#	define FOPEN_R_WORK "r"
#	define FOPEN_W_WORK "w"
#	define FOPEN_WPLUS_WORK "w+"
#	define OPEN_O_WORK 0
#else
#	define FOPEN_R_WORK FOPEN_R
#	define FOPEN_W_WORK FOPEN_W
#	define FOPEN_WPLUS_WORK FOPEN_WPLUS
#	define OPEN_O_WORK OPEN_O_BINARY
#endif

/* This may need changing on non-Unix systems (notably DOS).  */
#define OPEN_CREAT_READONLY (S_IREAD) /* lock file mode */
#define OPEN_O_LOCK 0 /* extra open flags for creating lock file */

/* Define or comment out the following symbols as needed.  */
#if defined(__OS2__)
#define OPEN_O_WRONLY O_WRONLY
#define bad_chmod_close 0 /* Can chmod() close file descriptors?  */
#define bad_creat0 0 /* Do writes fail after creat(f,0)?  */
#else /* __MSDOS__ */
#define OPEN_O_WRONLY O_RDWR
#define bad_chmod_close 1 /* Can chmod() close file descriptors?  */
#define bad_creat0 1 /* Do writes fail after creat(f,0)?  */
#endif
#define bad_fopen_wplus 0 /* Does fopen(f,FOPEN_WPLUS) fail to truncate f?  */
#define getlogin_is_secure 1 /* Is getlogin() secure?  Usually it's not.  */
#ifdef __EMX__
#define has_attribute_noreturn 1 /* Does __attribute__((noreturn)) work?  */
#else
#define has_attribute_noreturn 0 /* Does __attribute__((noreturn)) work?  */
#endif
#if has_attribute_noreturn
#	define exiting __attribute__((noreturn))
#else
#	define exiting
#endif
#define has_dirent 0 /* Do opendir(), readdir(), closedir() work?  */
#define void_closedir 0 /* Does closedir() yield void?  */
#define has_fchmod 0 /* Does fchmod() work?  */
#define has_fflush_input 1 /* Does fflush() work on input files?  */
#define has_fputs 1 /* Does fputs() work?  */
#define has_ftruncate 0 /* Does ftruncate() work?  */
#define has_getuid 0 /* Does getuid() work?  */
#define has_getpwuid 0 /* Does getpwuid() work?  */
#define has_memcmp 1 /* Does memcmp() work?  */
#define has_memcpy 1 /* Does memcpy() work?  */
#define has_memmove 1 /* Does memmove() work?  */
#define has_madvise 0 /* Does madvise() work?  */
#define has_mmap 0 /* Does mmap() work on regular files?  */
/* typedef char *caddr_t; */ /* mmap argument type */
#define mmap_signal SIGBUS /* signal received if you reference nonexistent part of mmapped file */
#define has_rename 1 /* Does rename() work?  */
#define bad_a_rename 1 /* Does rename(A,B) fail if A is unwritable?  */
#define bad_b_rename 1 /* Does rename(A,B) fail if B is unwritable?  */
/* typedef int void; */ /* Some ancient compilers need this.  */
#define VOID (void) /* 'VOID e;' discards the value of an expression 'e'.  */
#define has_seteuid 0 /* Does seteuid() work?  See README.  */
#define has_setreuid 0 /* Does setreuid() work?  See INSTALL.  */
#define has_setuid 0 /* Does setuid() exist?  */
#define has_sigaction 0 /* Does struct sigaction work?  */
#define has_signal 1 /* Does signal() work?  */
#define signal_type void /* type returned by signal handlers */
#define sig_zaps_handler 0 /* Must a signal handler reinvoke signal()?  */
#define has_sigblock 0 /* Does sigblock() work?  */
/* #define sigmask(s) (1 << ((s)-1)) */ /* Yield mask for signal number.  */
typedef ssize_t fread_type; /* type returned by fread() and fwrite() */
typedef size_t freadarg_type; /* type of their size arguments */
typedef void *malloc_type; /* type returned by malloc() */
#define has_getcwd 1 /* Does getcwd() work?  */
#define has_getwd 0 /* Does getwd() work?  */
#define needs_getabsname 0 /* Must we define getabsname?  */
#define has_mktemp 1 /* Does mktemp() work?  */
#define has_NFS 1 /* Might NFS be used?  */
#define has_psiginfo 0 /* Does psiginfo() work?  */
#define has_psignal 0 /* Does psignal() work?  */
#define has_sys_siglist 0 /* Does sys_siglist[] work?  */
/* #define strchr index */ /* Use old-fashioned name for strchr()?  */
/* #define strrchr rindex */ /* Use old-fashioned name for strrchr()?  */
#define bad_unlink 1 /* Does unlink() fail on unwritable files?  */
#define has_vfork 0 /* Does vfork() work?  */
#define has_fork 0 /* Does fork() work?  */
#define has_spawn 1 /* Does spawn*() work?  */
#define has_waitpid 0 /* Does waitpid() work?  */
/* #define RCS_SHELL getenv("COMSPEC") */ /* shell to run RCS subprograms */
#define has_printf_dot 1 /* Does "%.2d" print leading 0?  */
#define has_vfprintf 1 /* Does vfprintf() work?  */
#ifdef __EMX__
#define has_attribute_format_printf 1 /* emx uses gcc! */
#else
#define has_attribute_format_printf 0 /* Does __attribute__((format(printf,N,N+1))) work?  */
#endif
#if has_attribute_format_printf
#	define printf_string(m, n) __attribute__((format(printf, m, n)))
#else
#	define printf_string(m, n)
#endif
#if has_attribute_format_printf && has_attribute_noreturn
	/* Work around a bug in GCC 2.5.x.  */
#	define printf_string_exiting(m, n) __attribute__((format(printf, m, n), noreturn))
#else
#	define printf_string_exiting(m, n) printf_string(m, n) exiting
#endif
#define has__doprintf 0 /* Does _doprintf() work?  */
#define has__doprnt 0 /* Does _doprnt() work?  */
/* #undef EXIT_FAILURE */ /* Uncomment this if EXIT_FAILURE is broken.  */
#define large_memory 0 /* Can main memory hold entire RCS files?  */
#ifndef LONG_MAX
#define LONG_MAX 2147483647L /* long maximum */
#endif
/* Do struct stat s and t describe the same file?  Answer d if unknown.  */
#define same_file(s,t,d) (d)
#define has_utimbuf 0 /* Does struct utimbuf work?  */
#define CO "co.exe" /* name of 'co' program */
#define COMPAT2 0 /* Are version 2 files supported?  */
#define DIFF "diff.exe" /* name of 'diff' program */
#define DIFF3 "diff3.exe" /* name of 'diff3' program */
#define DIFF3_A 1 /* Does diff3 -A work?  */
#define DIFF3_BIN 1 /* Is diff3 user-visible (not the /usr/lib auxiliary)?  */
#define DIFF_FLAGS , "-an" /* Make diff output suitable for RCS.  */
#define DIFF_L 1 /* Does diff -L work? */
#define DIFF_SUCCESS 0 /* DIFF status if no differences are found */
#define DIFF_FAILURE 1 /* DIFF status if differences are found */
#define DIFF_TROUBLE 2 /* DIFF status if trouble */
/* #define ED "/bin/ed" */ /* name of 'ed' program (used only if !DIFF3_BIN) */
#define MERGE "merge.exe" /* name of 'merge' program */
#define TMPDIR "c:" /* default directory for temporary files */
#define SLASH '/' /* principal pathname separator */
#define SLASHes SLASH: case '\\' /* `case SLASHes:' labels all pathname separators */
int isSLASH P((int));
#define ROOTPATH(p) (isSLASH((p)[0]) || (p)[0] && (p)[1]==':') /* Is p an absolute pathname?  */
#define X_DEFAULT "" /* default value for -x option */
#define SLASHSLASH_is_SLASH 0 /* Are // and / the same directory?  */
#define ALL_ABSOLUTE 0 /* Do all subprograms satisfy ROOTPATH?  */
#define DIFF_ABSOLUTE 0 /* Is ROOTPATH(DIFF) true?  */
/* #define SENDMAIL "/bin/mail" */ /* how to send mail */
#define TZ_must_be_set 1 /* Must TZ be set for gmtime() to work?  */



/* Adjust the following declarations as needed.  */


/* The rest is for the benefit of non-standard, traditional hosts.  */
/* Don't bother to declare functions that in traditional hosts do not appear, */
/* or are declared in .h files, or return int or void.  */


/* traditional BSD */

#if has_sys_siglist && !defined(sys_siglist)
	extern char const * const sys_siglist[];
#endif


/* Posix (ISO/IEC 9945-1: 1990 / IEEE Std 1003.1-1990) */

/* <fcntl.h> */
#ifdef O_CREAT
#	define open_can_creat 1
#else
#	define open_can_creat 0
#	define O_RDONLY 0
#	define O_WRONLY 1
#	define O_RDWR 2
#	define O_CREAT 01000
#	define O_TRUNC 02000
#endif
#ifndef O_EXCL
#define O_EXCL 0
#endif

/* <sys/stat.h> */
#ifndef S_IRUSR
#	ifdef S_IREAD
#		define S_IRUSR S_IREAD
#	else
#		define S_IRUSR 0400
#	endif
#	ifdef S_IWRITE
#		define S_IWUSR S_IWRITE
#	else
#		define S_IWUSR (S_IRUSR/2)
#	endif
#endif
#ifndef S_IRGRP
#	if has_getuid
#		define S_IRGRP (S_IRUSR / 0010)
#		define S_IWGRP (S_IWUSR / 0010)
#		define S_IROTH (S_IRUSR / 0100)
#		define S_IWOTH (S_IWUSR / 0100)
#	else
		/* single user OS -- not Posix or Unix */
#		define S_IRGRP 0
#		define S_IWGRP 0
#		define S_IROTH 0
#		define S_IWOTH 0
#	endif
#endif
#ifndef S_ISREG
#define S_ISREG(n) (! ((n)&S_IFDIR))
#endif

/* <sys/wait.h> */
#ifndef WEXITSTATUS
#define WEXITSTATUS(stat_val) (stat_val)
#undef WIFEXITED /* Avoid 4.3BSD incompatibility with Posix.  */
#endif
#ifndef WIFEXITED
#define WIFEXITED(stat_val) ((stat_val) != -1)
#endif
#ifndef WTERMSIG
#define WTERMSIG(stat_val) ((stat_val) & 0177)
#undef WIFSIGNALED /* Avoid 4.3BSD incompatibility with Posix.  */
#endif
#ifndef WIFSIGNALED
#define WIFSIGNALED(stat_val) ((unsigned)(stat_val) - 1  <  0377)
#endif

/* <unistd.h> */
char *getlogin P((void));
#ifndef STDIN_FILENO
#	define STDIN_FILENO 0
#	define STDOUT_FILENO 1
#	define STDERR_FILENO 2
#endif
#if has_fork && !has_vfork
#	undef vfork
#	define vfork fork
#endif
#if has_getcwd || !has_getwd
#	define getcwd(p,s) getcwdsl(p,s)
	char *getcwdsl P((char*,size_t));
#else
	char *getwd P((char*));
#endif
#if has_setuid && !has_seteuid
#	undef seteuid
#	define seteuid setuid
#endif
#if has_spawn
#	if ALL_ABSOLUTE
#		define spawn_RCS spawnv
#	else
#           if defined(__EMX__) && defined(__OS2__)
#		define spawn_RCS spawnvp
#           else
#		define spawn_RCS spawnvpq
		int spawnvpq P((int,char const*,char*const*));
#           endif
#	endif
#else
#	if ALL_ABSOLUTE
#		define exec_RCS execv
#	else
#		define exec_RCS execvp
#	endif
#endif

/* utime.h */
#if !has_utimbuf
	struct utimbuf { time_t actime, modtime; };
#endif


/* Standard C library */

/* <stdio.h> */
#ifndef L_tmpnam
#define L_tmpnam 32 /* power of 2 > sizeof("/usr/tmp/xxxxxxxxxxxxxxx") */
#endif
#ifndef SEEK_SET
#define SEEK_SET 0
#endif
#ifndef SEEK_CUR
#define SEEK_CUR 1
#endif
#if has_mktemp
	char *mktemp P((char*)); /* traditional */
#else
	char *tmpnam P((char*));
#endif

/* <stdlib.h> */
/* char *getenv P((char const*)); */
/* exiting void _exit P((int)); */
/* exiting void exit P((int)); */
malloc_type malloc P((size_t));
malloc_type realloc P((malloc_type,size_t));
void free P((malloc_type));
#ifndef EXIT_FAILURE
#define EXIT_FAILURE 1
#endif
#ifndef EXIT_SUCCESS
#define EXIT_SUCCESS 0
#endif
#if !has_fork && !has_spawn
	int system P((char const*));
#endif

/* <string.h> */
/* char *strcpy P((char*,char const*)); */
/* char *strchr P((char const*,int)); */
/* char *strrchr P((char const*,int)); */
/* void *memcpy P((void*,void const*,size_t)); */
#if has_memmove
/*   void *memmove P((void*,void const*,size_t)); */
#endif

/* <time.h> */
time_t time P((time_t*));
