#--------------------------------------------
# Simplified makefile
#--------------------------------------------
#--------------------------------------------
# Include inference rules and definitions
#--------------------------------------------
!include makedefs.inc

.c.obj:
#        $(CCDLL) -I$(HPATH) $*.c 1> $*.err
        $(CCDLL) -I$(HPATH) $*.c 
#        @TYPE $*.err
        @ECHO No Fatal Error for $*.c

.csc.ih:
        sc -v -r $*.csc

#--------------------------------------------
# Define suffixes
#--------------------------------------------
.SUFFIXES:
.SUFFIXES: .c .obj .dll .csc .sc .h .ih .ph .psc .rc .res .dlg

#--------------------------------------------
#  Environment Setup for the component(s).
#--------------------------------------------
SCPATH=m:\TOOLKT21\SC
HPATH=m:\TOOLKT21\c\os2h
LIBPATH=m:\TOOLKT21\os2lib

#--------------------------------------------
# Compiler/tools Macros
#--------------------------------------------
LINK    = LINK386

#--------------------------------------------
# List all objects for app
#--------------------------------------------
DLLOBJS = DM2Test.obj printf.obj

#--------------------------------------------
# Make entry point
#--------------------------------------------
all: DM2Test.ih DM2Test.dll 

DM2Test.ih:  $$(@B).csc

DM2Test.obj: $$(@B).c $$(@B).ih $$(@B).h  $$(@B).sc

DM2Test.dll: $$(@B).def $(DLLOBJS) $$(@B).res  
          $(LINK) $(LFLAGS) $(DLLOBJS),$@,$*.Map,$(DEFLIBS),$*.def; > $*.erl
          rc $*.res $*.dll > $*.erl

DM2Test.res: $$(@B).rc
          rc -r $*.rc $*.res > $*.erc

