DEFINT A-Z
DEFSNG S
'
' QBSLICE - a simple routine to illustrate how a BASIC program can
'           give up time slices under OS/2 Warp.
'
' Usage:  Under the QuickBasic 4.5 "environment":
'             qb.exe qbslice.bas /L qb.qlb
'         Under MS BASIC 7.1 PDS "environment":
'             qbx.exe qbslice.bas /L qbx.qlb
'
' by: D. Scott Katzer - katzer@estd.nrl.navy.mil
'     20 May 1995

' Define the CPU registers

TYPE RegType
    ax AS INTEGER
    bx AS INTEGER
    cx AS INTEGER
    dx AS INTEGER
    bp AS INTEGER
    si AS INTEGER
    di AS INTEGER
    flags AS INTEGER
END TYPE

' The Interrupt subroutine is loaded via the QuickLibrary QB.QLB or QBX.QLB

DECLARE SUB Interrupt (intnum%, inreg AS RegType, outreg AS RegType)

DECLARE FUNCTION DOSVersion! () ' Checks the OS - OS/2 or DOS
DECLARE SUB SliceMe ()          ' Gives up a timeslice to the OS

COLOR 15, 1               ' white text on a blue screen
CLS                       ' clear the screen
LOCATE 3, 5
PRINT "QBSlice - Demonstrates giving up time slices to OS/2 Warp"
LOCATE 4, 25
PRINT "from a QuickBasic program"
LOCATE 6, 5
PRINT "This is DOS Version: "; DOSVersion!
LOCATE 8, 5
PRINT "Hit a key to Quit the following tests...."
LOCATE 11, 58
PRINT "Counts      Time (s)"
LOCATE 12, 5
PRINT "Counting without giving up time slices: ";
i = 1
StartTime = TIMER
DO
   i = i + 1
   LOCATE 12, 57
   PRINT USING "#####.##   "; i; TIMER - StartTime
LOOP WHILE INKEY$ = "" AND i < 10000

LOCATE 14, 5
PRINT "Counting with giving up time slices every 50 steps: ";
i = 1
StartTime = TIMER
DO
   i = i + 1
   LOCATE 14, 57
   PRINT USING "#####.##   "; i; TIMER - StartTime
   IF i MOD 50 = 0 THEN SliceMe ' give up a slice every 50 steps.
LOOP WHILE INKEY$ = "" AND i < 10000

LOCATE 23, 5
PRINT "Done!  Hit any key to exit..."
DO
   SliceMe ' give up time slices while waiting...
LOOP WHILE INKEY$ = ""
END

DEFSNG A-R, T-Z
FUNCTION DOSVersion! STATIC

' This routine determines the OS version that the program is runing under.
' Needed, e.g., in case we are running graphics in a window in OS/2 (many
' graphics modes aren't virtualized in a window if runing WPS in high
' resolution)

DIM reg AS RegType
reg.ax = &H3000
Interrupt &H21, reg, reg
major% = reg.ax MOD 256
minor% = reg.ax \ 256
DOSVersion! = major% + minor% / 100
END FUNCTION

SUB SliceMe

' This subroutine gives up a time slice to Warp.
' It is documented in IBM's OS/2 Virtual Device Driver manual, part
' of the OS/2 Technical Library.

DIM reg AS RegType
reg.ax = &H1680
Interrupt &H2F, reg, reg ' Give up the time slice to OS/2
END SUB

