#ifndef Py_CONFIG_H
#define Py_CONFIG_H

/**********************************************************************
 * config.h.  NOT Generated automatically by configure.
 *
 * This is a manually maintained version used for the IBM VisualAge
 * C/C++ compiler on the OS/2 platform.  It is a standard part of
 * the Python distribution.
 *
 * FILESYSTEM DEFINES:
 * The code specific to a particular way of naming files and
 * directory paths should be wrapped around one of the following
 * #defines:
 *
 *     DOSFILESYS   PCDOS-Style (for PCDOS, Windows and OS/2)
 *     MACFILESYS   Macintosh-Style
 *     UNIXFILESYS  Unix-Style
 * 
 * Because of the different compilers and operating systems in
 * use on the Intel platform, neither the compiler name nor
 * the operating system name is sufficient.
 *
 * OS/2 DEFINES:
 * The code specific to OS/2's Program API should be wrapped around
 *
 * __TOS_OS2__   Target Operating System, OS/2
 *
 * Any code specific to the compiler itself should be wrapped with
 *
 * __IBMC__      IBM C Compiler
 * __IBMCPP__    IBM C++ Compiler
 *
 * Note that since the VisualAge C/C++ compiler is also available
 * for the Windows platform, it may be necessary to use both a
 * __TOS_OS2__ and a __IBMC__ to select a very specific environment.
 *
 **********************************************************************/

/*
 * Some systems require special declarations for data items imported
 * or exported from dynamic link libraries.  Note that the definition
 * of DL_IMPORT covers both cases.  Define USE_DL_IMPORT for the client
 * of a DLL.  Define USE_DL_EXPORT when making a DLL.
 */

#include <io.h>

/* Configuration Options for Finding Modules */
#define PREFIX                 ""
#define EXEC_PREFIX            ""

/* Provide a default library so writers of extension modules
 * won't have to explicitly specify it anymore
 */
#pragma library("Python15.lib")

/***************************************************/
/*    32-Bit IBM VisualAge C/C++ v3.0 for OS/2     */
/*  (Convert Compiler Flags into Useful Switches)  */
/***************************************************/
#define PLATFORM    "os2"
#define COMPILER    "[VisualAge C/C++]"
#define PYOS_OS2    /* Define Indicator of Operating System */
#define PYCC_VACPP  /* Define Indicator of C Compiler */

  /* Platform Filesystem */
#define PYTHONPATH  ".;.\\lib;.\\lib\\plat-win;.\\lib\\lib-tk;.\\lib\\lib-dynload;.\\lib\\site-packages;.\\lib\\dos-8x3"
#define DOSFILESYS  /* OS/2 Uses the DOS File Naming Conventions */
#define IMPORT_8x3_NAMES

  /* Platform CPU-Mode Dependencies */
#define WORD_BIT                32 /* OS/2 is a 32-Bit Operating System */
#define LONG_BIT                32
#define SIZEOF_INT               4 /* Count of Bytes in an (int)            */
#define SIZEOF_LONG              4 /* Count of Bytes in a (long)            */
#define SIZEOF_VOID_P            4 /* Count of Bytes in a (void *)          */
/* #define HAVE_LONG_LONG     1 */ /* VAC++ does not support (long long)    */
/* #define SIZEOF_LONG_LONG   8 */ /* Count of Bytes in a (long long)       */

/* Define if type char is unsigned and you are not using gcc.  */
#ifndef __CHAR_UNSIGNED__
/* #undef __CHAR_UNSIGNED__ */
#endif

typedef int mode_t;
typedef int uid_t;
typedef int gid_t;
typedef int pid_t;

#if defined(__MULTI__)     /* If Compiler /Gt+ Multithread Option Enabled,  */
  #define WITH_THREAD            1 /* Enable Threading Throughout Python    */
  #define OS2_THREADS            1 /* And Use the OS/2 Flavor of Threads    */
/* #define _REENTRANT 1 */ /* Use thread-safe errno, h_errno, and other fns */
#endif

  /* Compiler Runtime Library Capabilities */
#include <ctype.h>
#include <direct.h>
/* #undef BAD_STATIC_FORWARD */ /* if compiler botches static fwd decls */

#define STDC_HEADERS             1 /* VAC++ is an ANSI C Compiler           */
#define HAVE_LIMITS_H            1 /* #include <limits.h>                   */
#define HAVE_STDLIB_H            1 /* #include <stdlib.h>                   */
#define HAVE_HYPOT               1 /* hypot()                               */
#define HAVE_PUTENV              1 /* putenv()                              */
#define HAVE_STDDEF_H            1 /* #include <stddef.h>                   */
/* #define VA_LIST_IS_ARRAY   1 */ /* if va_list is an array of some kind   */

  /* Variable-Arguments/Prototypes */
#define HAVE_PROTOTYPES          1 /* VAC++ supports C Function Prototypes  */
#define HAVE_STDARG_H            1 /* #include <stdarg.h>                   */
#define HAVE_STDARG_PROTOTYPES   1 /* Our <stdarg.h> has prototypes         */

  /* String/Memory/Locale Operations */
#define HAVE_STRDUP              1 /* strdup()                              */
#define HAVE_MEMMOVE             1 /* memmove()                             */
#define HAVE_STRERROR            1 /* strerror()                            */
#define HAVE_SETLOCALE           1 /* setlocale()                           */
#define HAVE_LOCALE_H            1 /* #include <locale.h>                   */
#define MALLOC_ZERO_RETURNS_NULL 1 /* Our malloc(0) returns a NULL ptr      */

  /* Signal Handling */
#define RETSIGTYPE            void /* Return type of handlers (int or void) */
#define HAVE_SIGNAL_H            1 /* #include <signal.h>                   */
/* #undef WANT_SIGFPE_HANDLER   */ /* Handle SIGFPE (see Include/pyfpe.h)   */
/* #define HAVE_ALARM         1 */ /* alarm()                               */
/* #define HAVE_SIGINTERRUPT  1 */ /* siginterrupt()                        */
/* #define HAVE_SIGRELSE      1 */ /* sigrelse()                            */
#define DONT_HAVE_SIG_ALARM      1
#define DONT_HAVE_SIG_PAUSE      1

  /* Clock/Time Support */
#define HAVE_FTIME               1 /* We have ftime() in <sys/timeb.h>      */
#define HAVE_CLOCK               1 /* clock()                               */
#define HAVE_STRFTIME            1 /* strftime()                            */
#define HAVE_STRPTIME            1 /* strptime()                            */
#define HAVE_MKTIME              1 /* mktime()                              */
#define HAVE_TZNAME              1 /* No tm_zone but do have tzname[]       */
#define HAVE_TIMES               1 /* #include <sys/times.h>                */
#define HAVE_SYS_UTIME_H         1 /* #include <sys/utime.h>                */
/* #define HAVE_UTIME_H       1 */ /* #include <utime.h>                    */
#define HAVE_SYS_TIME_H          1 /* #include <sys/time.h>                 */
/* #define TM_IN_SYS_TIME     1 */ /* <sys/time.h> declares struct tm       */
#define HAVE_GETTIMEOFDAY        1 /* gettimeofday()                        */
/* #define GETTIMEOFDAY_NO_TZ 1 */ /* gettimeofday() does not have 2nd arg  */
/* #define HAVE_TIMEGM        1 */ /* timegm()                              */
#define TIME_WITH_SYS_TIME       1 /* Mix <sys/time.h> and <time.h>         */
#define SYS_SELECT_WITH_SYS_TIME 1 /* Mix <sys/select.h> and <sys/time.h>   */
/* #define HAVE_ALTZONE       1 */ /* if <time.h> defines altzone           */

  /* Network/Sockets Support */
#define HAVE_SYS_SELECT_H       1 /* #include <sys/select.h>                */
#define BSD_SELECT              1 /* Use BSD versus OS/2 form of select()   */
#define HAVE_SELECT             1 /* select()                               */
#define HAVE_GETPEERNAME        1 /* getpeername()                          */
/* #undef HAVE_GETHOSTNAME_R 1 */ /* gethostname_r()                        */

  /* File I/O */
#define HAVE_DUP2                1 /* dup2()                                */
#define HAVE_EXECV               1 /* execv()                               */
#define HAVE_SETVBUF             1 /* setvbuf()                             */
#define HAVE_GETCWD              1 /* getcwd()                              */
#define HAVE_PIPE                1 /* pipe()     [OS/2-specific code added] */
#define HAVE_FCNTL_H             1 /* #include <fcntl.h>                    */
/* #define HAVE_FLOCK         1 */ /* flock()                               */
/* #define HAVE_TRUNCATE      1 */ /* truncate()                            */
/* #define HAVE_FTRUNCATE     1 */ /* ftruncate()                           */
/* #define HAVE_LSTAT         1 */ /* lstat()                               */
/* #define HAVE_DIRENT_H      1 */ /* #include <dirent.h>                   */
/* #define HAVE_OPENDIR       1 */ /* opendir()                             */

  /* Process Operations */
#define HAVE_GETPID              1 /* getpid()                              */
#define HAVE_SYSTEM              1 /* system()                              */
#define HAVE_WAIT                1 /* wait()                                */
#define HAVE_KILL                1 /* kill()     [OS/2-specific code added] */
#define HAVE_POPEN               1 /* popen()    [OS/2-specific code added] */
/* #define HAVE_GETPPID       1 */ /* getppid()                             */
/* #define HAVE_WAITPID       1 */ /* waitpid()                             */
/* #define HAVE_FORK          1 */ /* fork()                                */

  /* User/Group ID Queries */
/* #define HAVE_GETEGID       1 */
/* #define HAVE_GETEUID       1 */
/* #define HAVE_GETGID        1 */
/* #define HAVE_GETUID        1 */

  /* Unix-Specific */
#define HAVE_SYS_UN_H         1    /* #include <sys/un.h>                   */
/* #define HAVE_SYS_UTSNAME_H 1 */ /* #include <sys/utsname.h>              */
/* #define HAVE_SYS_WAIT_H    1 */ /* #include <sys/wait.h>                 */
/* #define HAVE_UNISTD_H      1 */ /* #include <unistd.h>                   */
/* #define HAVE_UNAME         1 */ /* uname ()                              */

#ifdef USE_DL_EXPORT
  #define DL_IMPORT(RTYPE) RTYPE _System
#endif

/*
 * Declare the calling convention of all externally accessible entry
 * points to be the standard OS/2 form, so that code other than that
 * compiled with IBM's Visualage C/C++ can use the Python DLL.
 *
 *      (still being debugged -- tricky to get ALL entrypoints)
 */

#pragma linkage(PyArg_Parse, system)
#pragma linkage(PyArg_ParseTuple, system)
#pragma linkage(PyArg_ParseTupleAndKeywords, system)
#pragma linkage(PyArg_VaParse, system)
#pragma linkage(PyBuffer_FromMemory, system)
#pragma linkage(PyBuffer_FromObject, system)
#pragma linkage(PyBuffer_FromReadWriteMemory, system)
#pragma linkage(PyBuffer_FromReadWriteObject, system)
#pragma linkage(PyBuffer_New, system)
#pragma linkage(PyCFunction_Fini, system)
#pragma linkage(PyCFunction_GetFlags, system)
#pragma linkage(PyCFunction_GetFunction, system)
#pragma linkage(PyCFunction_GetSelf, system)
#pragma linkage(PyCFunction_New, system)
#pragma linkage(PyCObject_AsVoidPtr, system)
#pragma linkage(PyCObject_FromVoidPtrAndDesc, system)
#pragma linkage(PyCObject_FromVoidPtr, system)
#pragma linkage(PyCObject_GetDesc, system)
#pragma linkage(PyCObject_Import, system)
#pragma linkage(PyCallable_Check, system)
#pragma linkage(PyClass_IsSubclass, system)
#pragma linkage(PyClass_New, system)
#pragma linkage(PyCode_Addr2Line, system)
#pragma linkage(PyCode_New, system)
#pragma linkage(PyComplex_AsCComplex, system)
#pragma linkage(PyComplex_FromCComplex, system)
#pragma linkage(PyComplex_FromDoubles, system)
#pragma linkage(PyComplex_ImagAsDouble, system)
#pragma linkage(PyComplex_RealAsDouble, system)
#pragma linkage(PyDict_Clear, system)
#pragma linkage(PyDict_DelItem, system)
#pragma linkage(PyDict_DelItemString, system)
#pragma linkage(PyDict_GetItem, system)
#pragma linkage(PyDict_GetItemString, system)
#pragma linkage(PyDict_Items, system)
#pragma linkage(PyDict_Keys, system)
#pragma linkage(PyDict_New, system)
#pragma linkage(PyDict_Next, system)
#pragma linkage(PyDict_SetItem, system)
#pragma linkage(PyDict_SetItemString, system)
#pragma linkage(PyDict_Size, system)
#pragma linkage(PyDict_Values, system)
#pragma linkage(PyErr_BadArgument, system)
#pragma linkage(PyErr_BadInternalCall, system)
#pragma linkage(PyErr_CheckSignals, system)
#pragma linkage(PyErr_Clear, system)
#pragma linkage(PyErr_ExceptionMatches, system)
#pragma linkage(PyErr_Fetch, system)
#pragma linkage(PyErr_Format, system)
#pragma linkage(PyErr_GivenExceptionMatches, system)
#pragma linkage(PyErr_NewException, system)
#pragma linkage(PyErr_NoMemory, system)
#pragma linkage(PyErr_NormalizeException, system)
#pragma linkage(PyErr_Occurred, system)
#pragma linkage(PyErr_Print, system)
#pragma linkage(PyErr_PrintEx, system)
#pragma linkage(PyErr_Restore, system)
#pragma linkage(PyErr_SetFromErrno, system)
#pragma linkage(PyErr_SetFromErrnoWithFilename, system)
#pragma linkage(PyErr_SetInterrupt, system)
#pragma linkage(PyErr_SetNone, system)
#pragma linkage(PyErr_SetObject, system)
#pragma linkage(PyErr_SetString, system)
#pragma linkage(PyEval_AcquireLock, system)
#pragma linkage(PyEval_AcquireThread, system)
#pragma linkage(PyEval_CallFunction, system)
#pragma linkage(PyEval_CallMethod, system)
#pragma linkage(PyEval_CallObject, system)
#pragma linkage(PyEval_CallObjectWithKeywords, system)
#pragma linkage(PyEval_EvalCode, system)
#pragma linkage(PyEval_GetBuiltins, system)
#pragma linkage(PyEval_GetFrame, system)
#pragma linkage(PyEval_GetGlobals, system)
#pragma linkage(PyEval_GetLocals, system)
#pragma linkage(PyEval_GetRestricted, system)
#pragma linkage(PyEval_InitThreads, system)
#pragma linkage(PyEval_ReleaseLock, system)
#pragma linkage(PyEval_ReleaseThread, system)
#pragma linkage(PyEval_RestoreThread, system)
#pragma linkage(PyEval_SaveThread, system)
#pragma linkage(PyFile_AsFile, system)
#pragma linkage(PyFile_FromFile, system)
#pragma linkage(PyFile_FromString, system)
#pragma linkage(PyFile_GetLine, system)
#pragma linkage(PyFile_Name, system)
#pragma linkage(PyFile_SetBufSize, system)
#pragma linkage(PyFile_SoftSpace, system)
#pragma linkage(PyFile_WriteObject, system)
#pragma linkage(PyFile_WriteString, system)
#pragma linkage(PyFloat_AsDouble, system)
#pragma linkage(PyFloat_AsString, system)
#pragma linkage(PyFloat_Fini, system)
#pragma linkage(PyFloat_FromDouble, system)
#pragma linkage(PyFrame_BlockPop, system)
#pragma linkage(PyFrame_BlockSetup, system)
#pragma linkage(PyFrame_FastToLocals, system)
#pragma linkage(PyFrame_Fini, system)
#pragma linkage(PyFrame_LocalsToFast, system)
#pragma linkage(PyFrame_New, system)
#pragma linkage(PyFunction_GetCode, system)
#pragma linkage(PyFunction_GetDefaults, system)
#pragma linkage(PyFunction_GetGlobals, system)
#pragma linkage(PyFunction_New, system)
#pragma linkage(PyFunction_SetDefaults, system)
#pragma linkage(PyGrammar_AddAccelerators, system)
#pragma linkage(PyGrammar_FindDFA, system)
#pragma linkage(PyGrammar_LabelRepr, system)
#pragma linkage(PyGrammar_RemoveAccelerators, system)
#pragma linkage(PyImport_AddModule, system)
#pragma linkage(PyImport_AppendInittab, system)
#pragma linkage(PyImport_Cleanup, system)
#pragma linkage(PyImport_ExecCodeModule, system)
#pragma linkage(PyImport_ExecCodeModuleEx, system)
#pragma linkage(PyImport_ExtendInittab, system)
#pragma linkage(PyImport_GetMagicNumber, system)
#pragma linkage(PyImport_GetModuleDict, system)
#pragma linkage(PyImport_Import, system)
#pragma linkage(PyImport_ImportFrozenModule, system)
#pragma linkage(PyImport_ImportModule, system)
#pragma linkage(PyImport_ImportModuleEx, system)
#pragma linkage(PyImport_ReloadModule, system)
#pragma linkage(PyInstance_DoBinOp, system)
#pragma linkage(PyInstance_New, system)
#pragma linkage(PyInt_AsLong, system)
#pragma linkage(PyInt_Fini, system)
#pragma linkage(PyInt_FromLong, system)
#pragma linkage(PyInt_GetMax, system)
#pragma linkage(PyInterpreterState_Clear, system)
#pragma linkage(PyInterpreterState_Delete, system)
#pragma linkage(PyInterpreterState_New, system)
#pragma linkage(PyList_Append, system)
#pragma linkage(PyList_AsTuple, system)
/* #pragma linkage(PyList_GetItem, system) */
#pragma linkage(PyList_GetSlice, system)
#pragma linkage(PyList_Insert, system)
#pragma linkage(PyList_New, system)
#pragma linkage(PyList_Reverse, system)
#pragma linkage(PyList_SetItem, system)
#pragma linkage(PyList_SetSlice, system)
#pragma linkage(PyList_Size, system)
#pragma linkage(PyList_Sort, system)
#pragma linkage(PyLong_AsDouble, system)
#pragma linkage(PyLong_AsLong, system)
/*              PyLong_AsLongLong */
#pragma linkage(PyLong_AsUnsignedLong, system)
/*              PyLong_AsUnsignedLongLong */
#pragma linkage(PyLong_AsVoidPtr, system)
#pragma linkage(PyLong_FromDouble, system)
#pragma linkage(PyLong_FromLong, system)
/*              PyLong_FromLongLong */
#pragma linkage(PyLong_FromString, system)
#pragma linkage(PyLong_FromUnsignedLong, system)
/*              PyLong_FromUnsignedLongLong */
#pragma linkage(PyLong_FromVoidPtr, system)
#pragma linkage(PyMapping_Check, system)
#pragma linkage(PyMapping_GetItemString, system)
#pragma linkage(PyMapping_HasKey, system)
#pragma linkage(PyMapping_HasKeyString, system)
#pragma linkage(PyMapping_Length, system)
#pragma linkage(PyMapping_SetItemString, system)
/* #pragma linkage(PyMarshal_Init, system) */
#pragma linkage(PyMarshal_ReadLongFromFile, system)
#pragma linkage(PyMarshal_ReadObjectFromFile, system)
#pragma linkage(PyMarshal_ReadObjectFromString, system)
#pragma linkage(PyMarshal_WriteLongToFile, system)
#pragma linkage(PyMarshal_WriteObjectToFile, system)
#pragma linkage(PyMarshal_WriteObjectToString, system)
#pragma linkage(PyMem_Free, system)
#pragma linkage(PyMem_Malloc, system)
#pragma linkage(PyMem_Realloc, system)
#pragma linkage(PyMember_Get, system)
#pragma linkage(PyMember_Set, system)
#pragma linkage(PyMethod_Class, system)
#pragma linkage(PyMethod_Fini, system)
#pragma linkage(PyMethod_Function, system)
#pragma linkage(PyMethod_New, system)
#pragma linkage(PyMethod_Self, system)
#pragma linkage(PyModule_GetDict, system)
#pragma linkage(PyModule_GetName, system)
#pragma linkage(PyModule_New, system)
#pragma linkage(PyNode_AddChild, system)
#pragma linkage(PyNode_Compile, system)
#pragma linkage(PyNode_Free, system)
/*              PyNode_ListTree */
#pragma linkage(PyNode_New, system)
#pragma linkage(PyNumber_Absolute, system)
/* #pragma linkage(PyNumber_Add, system) */
/* #pragma linkage(PyNumber_And, system) */
#pragma linkage(PyNumber_Check, system)
#pragma linkage(PyNumber_Coerce, system)
#pragma linkage(PyNumber_CoerceEx, system)
/* #pragma linkage(PyNumber_Divide, system) */
/* #pragma linkage(PyNumber_Divmod, system) */
#pragma linkage(PyNumber_Float, system)
#pragma linkage(PyNumber_Int, system)
#pragma linkage(PyNumber_Invert, system)
#pragma linkage(PyNumber_Long, system)
/* #pragma linkage(PyNumber_Lshift, system) */
/* #pragma linkage(PyNumber_Multiply, system) */
#pragma linkage(PyNumber_Negative, system)
/* #pragma linkage(PyNumber_Or, system) */
#pragma linkage(PyNumber_Positive, system)
#pragma linkage(PyNumber_Power, system)
/* #pragma linkage(PyNumber_Remainder, system) */
/* #pragma linkage(PyNumber_Rshift, system) */
/* #pragma linkage(PyNumber_Subtract, system) */
/* #pragma linkage(PyNumber_Xor, system) */
#pragma linkage(PyOS_AfterFork, system)
#pragma linkage(PyOS_FiniInterrupts, system)
#pragma linkage(PyOS_GetLastModificationTime, system)
#pragma linkage(PyOS_InitInterrupts, system)
#pragma linkage(PyOS_InterruptOccurred, system)
#pragma linkage(PyOS_Readline, system)
/* #pragma linkage(PyOS_StdioReadline, system) */
#pragma linkage(PyOS_strtol, system)
#pragma linkage(PyOS_strtoul, system)
#pragma linkage(PyObject_CallFunction, system)
#pragma linkage(PyObject_CallMethod, system)
#pragma linkage(PyObject_CallObject, system)
#pragma linkage(PyObject_Cmp, system)
#pragma linkage(PyObject_Compare, system)
#pragma linkage(PyObject_DelItem, system)
#pragma linkage(PyObject_GetAttr, system)
#pragma linkage(PyObject_GetAttrString, system)
#pragma linkage(PyObject_GetItem, system)
#pragma linkage(PyObject_HasAttr, system)
#pragma linkage(PyObject_HasAttrString, system)
#pragma linkage(PyObject_Hash, system)
#pragma linkage(PyObject_IsTrue, system)
#pragma linkage(PyObject_Length, system)
#pragma linkage(PyObject_Not, system)
#pragma linkage(PyObject_Print, system)
#pragma linkage(PyObject_Repr, system)
#pragma linkage(PyObject_SetAttr, system)
#pragma linkage(PyObject_SetAttrString, system)
#pragma linkage(PyObject_SetItem, system)
#pragma linkage(PyObject_Str, system)
#pragma linkage(PyObject_Type, system)
#pragma linkage(PyParser_AddToken, system)
#pragma linkage(PyParser_Delete, system)
#pragma linkage(PyParser_New, system)
#pragma linkage(PyParser_ParseFile, system)
#pragma linkage(PyParser_ParseString, system)
#pragma linkage(PyParser_SimpleParseFile, system)
#pragma linkage(PyParser_SimpleParseString, system)
#pragma linkage(PyRange_New, system)
#pragma linkage(PyRun_AnyFile, system)
#pragma linkage(PyRun_File, system)
#pragma linkage(PyRun_InteractiveLoop, system)
#pragma linkage(PyRun_InteractiveOne, system)
#pragma linkage(PyRun_SimpleFile, system)
#pragma linkage(PyRun_SimpleString, system)
#pragma linkage(PyRun_String, system)
#pragma linkage(PySequence_Check, system)
#pragma linkage(PySequence_Concat, system)
#pragma linkage(PySequence_Contains, system)
#pragma linkage(PySequence_Count, system)
#pragma linkage(PySequence_DelItem, system)
#pragma linkage(PySequence_DelSlice, system)
#pragma linkage(PySequence_GetItem, system)
#pragma linkage(PySequence_GetSlice, system)
#pragma linkage(PySequence_In, system)
#pragma linkage(PySequence_Index, system)
#pragma linkage(PySequence_Length, system)
#pragma linkage(PySequence_List, system)
#pragma linkage(PySequence_Repeat, system)
#pragma linkage(PySequence_SetItem, system)
#pragma linkage(PySequence_SetSlice, system)
#pragma linkage(PySequence_Tuple, system)
#pragma linkage(PySlice_GetIndices, system)
#pragma linkage(PySlice_New, system)
#pragma linkage(PyString_AsString, system)
#pragma linkage(PyString_Concat, system)
#pragma linkage(PyString_ConcatAndDel, system)
#pragma linkage(PyString_Fini, system)
#pragma linkage(PyString_Format, system)
#pragma linkage(PyString_FromString, system)
#pragma linkage(PyString_FromStringAndSize, system)
#pragma linkage(PyString_InternFromString, system)
#pragma linkage(PyString_InternInPlace, system)
#pragma linkage(PyString_Size, system)
#pragma linkage(PySys_GetFile, system)
#pragma linkage(PySys_GetObject, system)
#pragma linkage(PySys_SetArgv, system)
#pragma linkage(PySys_SetObject, system)
#pragma linkage(PySys_SetPath, system)
#pragma linkage(PySys_WriteStderr, system)
#pragma linkage(PySys_WriteStdout, system)
#pragma linkage(PyThreadState_Clear, system)
#pragma linkage(PyThreadState_Delete, system)
#pragma linkage(PyThreadState_Get, system)
#pragma linkage(PyThreadState_GetDict, system)
#pragma linkage(PyThreadState_New, system)
#pragma linkage(PyThreadState_Swap, system)
#pragma linkage(PyThread__exit_thread, system)
#pragma linkage(PyThread_acquire_lock, system)
#pragma linkage(PyThread_allocate_lock, system)
#pragma linkage(PyThread_allocate_sema, system)
#pragma linkage(PyThread_down_sema, system)
#pragma linkage(PyThread_exit_thread, system)
#pragma linkage(PyThread_free_lock, system)
#pragma linkage(PyThread_free_sema, system)
#pragma linkage(PyThread_get_thread_ident, system)
#pragma linkage(PyThread_init_thread, system)
#pragma linkage(PyThread_release_lock, system)
#pragma linkage(PyThread_start_new_thread, system)
#pragma linkage(PyThread_up_sema, system)
#pragma linkage(PyToken_OneChar, system)
#pragma linkage(PyToken_TwoChars, system)
#pragma linkage(PyTokenizer_Free, system)
#pragma linkage(PyTokenizer_FromFile, system)
#pragma linkage(PyTokenizer_FromString, system)
#pragma linkage(PyTokenizer_Get, system)
#pragma linkage(PyTraceBack_Here, system)
#pragma linkage(PyTraceBack_Print, system)
#pragma linkage(PyTuple_Fini, system)
/*              PyTuple_GetItem */
#pragma linkage(PyTuple_GetSlice, system)
#pragma linkage(PyTuple_New, system)
#pragma linkage(PyTuple_SetItem, system)
#pragma linkage(PyTuple_Size, system)
#pragma linkage(Py_AddPendingCall, system)
#pragma linkage(Py_AtExit, system)
#pragma linkage(Py_BuildValue, system)
#pragma linkage(Py_CompileString, system)
#pragma linkage(Py_EndInterpreter, system)
#pragma linkage(Py_Exit, system)
#pragma linkage(Py_FatalError, system)
#pragma linkage(Py_FdIsInteractive, system)
#pragma linkage(Py_Finalize, system)
#pragma linkage(Py_FindMethod, system)
#pragma linkage(Py_FindMethodInChain, system)
#pragma linkage(Py_FlushLine, system)
#pragma linkage(Py_Free, system)
#pragma linkage(Py_GetArgcArgv, system)
#pragma linkage(Py_GetBuildInfo, system)
#pragma linkage(Py_GetCompiler, system)
#pragma linkage(Py_GetCopyright, system)
#pragma linkage(Py_GetExecPrefix, system)
#pragma linkage(Py_GetPath, system)
#pragma linkage(Py_GetPlatform, system)
#pragma linkage(Py_GetPrefix, system)
#pragma linkage(Py_GetProgramFullPath, system)
#pragma linkage(Py_GetProgramName, system)
#pragma linkage(Py_GetPythonHome, system)
#pragma linkage(Py_GetVersion, system)
#pragma linkage(Py_InitModule4, system)
#pragma linkage(Py_Initialize, system)
#pragma linkage(Py_IsInitialized, system)
#pragma linkage(Py_Main, system)
#pragma linkage(Py_MakePendingCalls, system)
#pragma linkage(Py_Malloc, system)
#pragma linkage(Py_NewInterpreter, system)
#pragma linkage(Py_Realloc, system)
#pragma linkage(Py_ReprEnter, system)
#pragma linkage(Py_ReprLeave, system)
#pragma linkage(Py_SetProgramName, system)
#pragma linkage(Py_SetPythonHome, system)
#pragma linkage(Py_VaBuildValue, system)
#pragma linkage(_PyBuiltin_Fini_1, system)
#pragma linkage(_PyBuiltin_Fini_2, system)
#pragma linkage(_PyBuiltin_Init_1, system)
#pragma linkage(_PyBuiltin_Init_2, system)
#pragma linkage(_PyImport_FindExtension, system)
#pragma linkage(_PyImport_Fini, system)
#pragma linkage(_PyImport_FixupExtension, system)
#pragma linkage(_PyImport_Init, system)
#pragma linkage(_PyImport_LoadDynamicModule, system)
#pragma linkage(_PyLong_New, system)
#pragma linkage(_PyModule_Clear, system)
#pragma linkage(_PyObject_New, system)
#pragma linkage(_PyObject_NewVar, system)
#pragma linkage(_PyString_Resize, system)
#pragma linkage(_PySys_Init, system)
#pragma linkage(_PyTuple_Resize, system)
#pragma linkage(_Py_MD5Final, system)
#pragma linkage(_Py_MD5Init, system)
#pragma linkage(_Py_MD5Update, system)
/*obsolete      _Py_addbit */
#pragma linkage(_Py_c_diff, system)
#pragma linkage(_Py_c_neg, system)
#pragma linkage(_Py_c_pow, system)
#pragma linkage(_Py_c_prod, system)
#pragma linkage(_Py_c_quot, system)
#pragma linkage(_Py_c_sum, system)
/*obsolete      _Py_delbitset */
/*obsolete      _Py_mergebitset */
/*obsolete      _Py_meta_grammar */
/*obsolete      _Py_newbitset */
#pragma linkage(_Py_re_compile_fastmap, system)
#pragma linkage(_Py_re_compile_initialize, system)
#pragma linkage(_Py_re_compile_pattern, system)
#pragma linkage(_Py_re_match, system)
#pragma linkage(_Py_re_search, system)
#pragma linkage(_Py_re_set_syntax, system)
/*obsolete      _Py_samebitset */

#include <stdlib.h>

#if FALSE

/* Experimental malloc/free caching system (gains 10% performance) */

void * _IMPORT _LNK_CONV _jcalloc( size_t, size_t );
void   _IMPORT _LNK_CONV _jfree( void * );
void * _IMPORT _LNK_CONV _jmalloc( size_t );
void * _IMPORT _LNK_CONV _jrealloc( void *, size_t );
void * _IMPORT _LNK_CONV _jheapmin(void);

#pragma map( calloc , "_jcalloc"  )
#pragma map( free   , "_jfree"    )
#pragma map( malloc , "_jmalloc"  )
#pragma map( realloc, "_jrealloc" )
#pragma map( heapmin, "_jheapmin" )

#endif

#endif /* !Py_CONFIG_H */

