
/* appdefs.h	    Created:	1995-02-09  Revised:			*/

/* Module Definition Header						*/

/************************************************************************/
/************************************************************************/
/************************************************************************/
/* DISCLAIMER OF WARRANTIES:						*/
/* -------------------------						*/
/* The following [enclosed] code is sample code	created	by IBM		*/
/* Corporation and Prominare Inc.  This	sample code is not part	of any	*/
/* standard IBM	product	and is provided	to you solely for the purpose	*/
/* of assisting	you in the development of your applications.  The code	*/
/* is provided "AS IS",	without	warranty of any	kind.  Neither IBM nor	*/
/* Prominare shall be liable for any damages arising out of your	*/
/* use of the sample code, even	if they	have been advised of the	*/
/* possibility of such damages.						*/
/************************************************************************/
/************************************************************************/
/************************************************************************/
/*		       D I S C L A I M E R				*/
/* This	code is	provided on an as is basis with	no implied support.	*/
/* It should be	considered freeware that cannot	be rebundled as		*/
/* part	of a larger "*ware" offering without our consent.		*/
/************************************************************************/
/************************************************************************/
/************************************************************************/

/* Copyright  International Business Machines Corp., 1995.		*/
/* Copyright  1995  Prominare Inc.  All Rights	Reserved.		*/



/************************************************************************/
/************************************************************************/
/*	Structure Definitions						*/
/************************************************************************/
/************************************************************************/


typedef	struct _QUEINFO
   {
   PSZ	       pszName;		   /* Device Name			*/
   PSZ	       pszDriverName;	   /* Driver Name			*/
   PSZ	       pszPrinters;	   /* Printers				*/
   PVOID       pDriverData;	   /* Device Data			*/
   } QUEINFO ;		   /* quei */

typedef	QUEINFO	*PQUEINFO; /* pquei */

typedef	struct _PRN
   {
   HAB		hAB;		   /* Anchor block for list		*/
   CHAR		szQueue[256];	   /* Default Queue			*/
   INT		iQueue;		   /* Selected Printer Index		*/
   INT		cQueues;	   /* Total Queue Count			*/
   PQUEINFO	pquei;		   /* Queue Information			*/
   } PRN ;		   /* prn */

typedef	PRN *PPRN;	   /* pprn */


/************************************************************************/
/************************************************************************/
/*	Global Variable	Definitions					*/
/************************************************************************/
/************************************************************************/

extern FONTMETRICS fm;		   /* Font Metrics Info			*/
extern HSWITCH	   hSwitch;	   /* Task List	Entry Handle		*/
extern HAB	   hAB;		   /* Program Anchor Block Handle	*/

extern HMQ  hmqPrnSetup;	   /* Program Message Queue Handle	*/
extern HWND hwndPrnSetup;	   /* Client Window Handle		*/
extern HWND hwndPrnSetupFrame;	   /* Frame Window Handle		*/
extern HWND hmenuPrnSetup;	   /* Menu Handle			*/

extern HWND hwndHelp;		   /* Help Window Handle		*/
extern HELPINIT	helpinit;	   /* Help Initialization Table		*/

extern PRN  prn;		   /* Printer Control Holder		*/


/************************************************************************/
/************************************************************************/
/*	Function Prototype Definitions					*/
/************************************************************************/
/************************************************************************/

VOID	InitApp(HWND hwndFrame,	HWND hwndClient, PSZ pszWindowListTitle);
HWND	CreateStdWindow(HWND hwndParent, ULONG flStyle,	ULONG flCreateFlags,
			PSZ pszClientClass, PSZ	pszTitle, ULONG	styleClient,
			HMODULE	hmod, ULONG idResources, PHWND phwndClient,
			LONG x,	LONG y,	LONG cx, LONG cy);
MRESULT	PDSKeyProc(HWND	hWnd, ULONG msg, MPARAM	mp1, MPARAM mp2);
VOID	PDSGetTemplate(HWND hWnd, ULONG	id);

MRESULT	EXPENTRY PrintDriverWndProc(HWND hWnd, ULONG msg, MPARAM mp1, MPARAM mp2);

BOOL	PrnCreatePrinterList(PPRN pprn);
BOOL	PrnDestroyPrinterList(PPRN pprn);
HDC	PrnOpenDC(PPRN pprn, PSZ pszDataType);
BOOL	PrnQueryJobProperties(PPRN pprn, INT iQueue);
PSZ	PrnQueryPrinterName(PPRN pprn);
MRESULT	EXPENTRY PrnSetupDlgProc(HWND hWnd, ULONG msg, MPARAM mp1, MPARAM mp2);
