//===========================================================================\
// ApiExPM.h: General purpose PM macros and definitions
// 24-12-2001 * by Alessandro Cantatore * v...
//===========================================================================/



#ifndef _APIEX_PM_H_
   #define _APIEX_PM_H_

// new type definitions
// image handle : this is used by the control which can display both icons
// and bitmaps
typedef LHANDLE HIMAGE;
typedef HIMAGE * PHIMAGE;

// Message result definitions
#define MRFALSE ((MRESULT)0)
#define MRTRUE  ((MRESULT)1)

// Undocumented messages generated by Warp 4 and superior versions
// These messages are posted to a window when the mouse pointer enters
// or leaves the window rectangle.
// The default window procedure returns FALSE in both cases

// mouse getting inside the window area
// mp1 : handle of the window the mouse is moving to
// mp2 : handle of the window previously under the mouse
#define WM_MOUSEENTER      0x041e

// mouse getting outside the window area
// mp1 : handle of the window the mouse is moving away from
// mp2 : handle of the window the mouse is moving to
#define WM_MOUSEEXIT       0x041f    // mouse leaving the window area


// gets x, y coordinates from a mouse message parameter
#define MOUSEX(mp)          ((SHORT)(ULONG)(mp))
#define MOUSEY(mp)          ((SHORT)((ULONG)mp >> 16))

// New system pointer: display a hand with a finger
#define SPTR_HANDCLICK   (SPTR_CPTR + 1)
// Macro to set a system pointer (used in WM_MOUSEMOVE processing)
#define WinSetSysPointer(iptr) \
   (WinSetPointer(HWND_DESKTOP, WinQuerySysPointer(HWND_DESKTOP, (iptr), 0)))


// general PM query window macros
#define WinHAB(hwnd)         (WinQueryAnchorBlock(hwnd))
#define WinID(hwnd)          (WinQueryWindowUShort((hwnd), QWS_ID))
#define WinNext(hwnd)        (WinQueryWindow((hwnd), QW_NEXT))
#define WinOwner(hwnd)       (WinQueryWindow((hwnd), QW_OWNER))
#define WinParent(hwnd)      (WinQueryWindow((hwnd), QW_PARENT))
#define WinStyle(hwnd)       (WinQueryWindowULong((hwnd), QWL_STYLE))

// general dialog macros
#define DlgItemHwnd(hwnd, id)    (WinWindowFromID((hwnd), (id)))
#define DlgItemEnable(hwnd, id, benable) \
   (WinEnableWindow(DlgItemHwnd((hwnd), (id)), (benable)))
#define DlgItemIsEnabled(hwnd, id) \
   (WinIsWindowEnabled(DlgItemHwnd((hwnd), (id))))
#define DlgItemShow(hwnd, id, bshow) \
   (WinShowWindow(DlgItemHwnd((hwnd), (id)), (bshow)))
#define DlgItemIsVisible(hwnd, id) \
   (WinIsWindowVisible(DlgItemHwnd((hwnd), (id))))

// general purpose point and rectangle manipulation macros
// the ppt and prect parameters must be pointer to POINT and RECTL
// Initializes a point structure
#define PointSet(ppt, _x, _y)   \
  (((PPOINTL)(ppt))->x = (_x),  \
   ((PPOINTL)(ppt))->y = (_y))
// Simmetrically shifts the rectangle coordinates by dx,dy pixels
#define RectInflate(prect, dx, dy)                                \
                           (((PRECTL)(prect))->xLeft -= (dx),     \
                            ((PRECTL)(prect))->yBottom -= (dy),   \
                            ((PRECTL)(prect))->xRight += (dx),    \
                            ((PRECTL)(prect))->yTop += (dy))
// Initializes a rectangle with the coordinates (x0,y0) - (x1,y1)
#define RectSet(prect, x0, y0, x1, y1)                            \
                           (((PRECTL)(prect))->xLeft = (x0),      \
                            ((PRECTL)(prect))->yBottom = (y0),    \
                            ((PRECTL)(prect))->xRight = (x1),     \
                            ((PRECTL)(prect))->yTop = (y1))
// shifts the coordinates of a rectangle by dx, dy pixels
#define RectShift(prect, dx, dy)                                  \
                           (((PRECTL)(prect))->xLeft += (dx),     \
                            ((PRECTL)(prect))->yBottom += (dy),   \
                            ((PRECTL)(prect))->xRight += (dx),    \
                            ((PRECTL)(prect))->yTop += (dy))
                            
                        
#endif // #i            fndef _APIEX_PM_H_
