@echo off
@rem *@file *******************************************************************
@rem *
@rem *   FILE NAME: PWNETDEF.CMD
@rem *
@rem *   DESCRIPTION:
@rem *              This is the command file which will execute the PWCOINS.EXE
@rem *              file.  First the FFENV.CMD file is run followed by the IBM
@rem *              logo screen and the PWCOINS.EXE.
@rem *
@rem *   COMPONENTS:
@rem *              FFENV.CMD - required
@rem *              PWSTATUS.EXE - required (Checks if PW is up)
@rem *              COINLOGO.EXE - required (IBM logo executable)
@rem *
@rem *   INPUTS:
@rem *              %1 = d:\ff_root (drive and root directory for PlantWorks)
@rem *              %2 = environment flag (if set then don't run FFENV.CMD;
@rem *                   otherwise, invoke FFENV.CMD)
@rem *
@rem *************************************************************************/

@setlocal

@if "%1" == "" goto usage
@if NOT "%2" == "" goto nosetenv


@if not exist %1\bin\ffenv.cmd goto noffenv
@call %1\bin\ffenv.cmd %1


:nosetenv
@if not exist %1\bin\pwstatus.exe goto nostatus
@%1\bin\pwstatus.exe
@if errorlevel 1 goto pwup


@if not exist %1\bin\coinlogo.exe goto nologo
@%1\bin\coinlogo
:nologo


@if not exist %1\bin\pwcoins.exe goto nocoins
@start %1\bin\pwcoins.exe
@goto end


:pwup
@set errflag=1
@echo PlantWorks is running.
@echo Shutdown PlantWorks and re-start this command.
@goto end


:nostatus
@set errflag=1
@echo PlantWorks PWSTATUS.EXE not found!
@echo PlantWorks root directory [%1] may be invalid or not installed.
@goto end


:noffenv
@set errflag=1
@echo PlantWorks FFENV.CMD not found!
@echo PlantWorks root directory [%1] may be invalid or not installed.
@goto end


:nocoins
@set errflag=1
@echo PlantWorks PWCOINS.EXE not found!
@echo PlantWorks executable [%1] may not be installed.
@goto end


:usage
@set errflag=1
@echo PlantWorks Install and Configuration:
@echo Usage-
@echo %0 d:\ff_root
@echo      "d:" - drive where PlantWorks is installed
@echo      "\ff_root" - directory where PlantWorks is installed
@goto end


:end
@if "%errflag%" == "1" pause
@endlocal
@exit
