@rem  File: LOADRIC.CMD
@rem
@rem  This sample command file can be used to load a RIC card
@rem
@rem  Invoke this file the following way:
@rem         LOADRIC <cardnumber>
@rem           where <cardnumber> is the number of the card to load
@rem  For example: "LOADRIC 0" loads card number 0.
@rem
@rem  Before using this command file for the first time, go to each
@rem  numbered section and set the following information:
@rem         1.  The environment variables
@rem         2.  The ARTIC shared message pool size
@rem         3.  Which CPP (if any) you want to use
@rem         4.  Whether or not you want to use the Debugger
@rem         5.  Whether or not you want to start CS/2 automatically
@rem
@echo Starting loadric...
@rem -----1. Set the environment variables -------------------------
@rem
@rem  You must set these environment variables to refer to the
@rem  directories which contain the respective files. The
@rem  variables MUST end with a backslash ("\")
@rem
@rem   RIC     -location of the RIC support files
@rem   EXE     -location of the CS/2 executable files
@rem   TOOLKIT -location of the CS/2 toolkit files
@rem
@rem  Set these variables below by typing the correct paths after
@rem  each variable:
@rem
@set RIC=
@set EXE=
@set TOOLKIT=
@rem
@rem For example, if your RIC support is located in 'C:\RIC', you would
@rem type 'C:\RIC\' after the above 'RIC='.
@rem ---------------------------------------------------------------
@rem
@rem Check to see if environment variables are set
@rem if %RIC%. == . goto notset
@rem if %EXE%. == . goto notset
@rem Uncomment the following line if you are using on of the sample CPPs
@rem @if %TOOLKIT%. == . goto notset
@rem
@goto varset
@rem This section tells you if there has been an error.
:notset
@echo Please make sure that the following environment variables are set:
@echo RIC
@echo EXE
@rem Uncomment the following line if you are using on of the sample CPPs
@rem @echo TOOLKIT
@goto end
@rem
:varset
@rem Load the RIC card
@set CARD=%1
@if %1. == . set CARD=0
@set DRIVE=%2
@if %2. == . set DRIVE=C
@set PLC=%3
@if %3. == . set PLC=AB
@set PORT=%4
@if %4. == . set PORT=MP
@set RIC=%DRIVE%:\ICA\
@set EXE=%DRIVE%:\CS2\SYS\
@set TOOLKIT=%DRIVE%:\CS2\TOOLKIT\DDMS\
@rem ----- 2. Reset the RIC card if desired -----------------
@rem Uncomment the following 2 lines to reset the RIC card before loading it.
@echo Resetting the RIC card
%TOOLKIT%resetric %CARD%
@echo Loading the RIC card
@rem
@rem The next two lines are for the IBM Realtime Interface Co-Processor,
@rem IBM Realtime Interface Co-Processor Multiport Adapter, or
@rem IBM Realtime Interface Co-Processor Multiport/2.
@rem If you are using the IBM Realtime Interface Co-Processor Multiport
@rem Adapter, Model 2 or the IBM Realtime Interface Co-Processor Portmaster
@rem Adapter/A, then, comment out the next two lines.
@rem
@if %PORT% == PM @goto portm;
@if %PORT% == MP2 @goto portm;
%RIC%icaldric %CARD% %RIC%icaaim.com          0
%RIC%icaldric %CARD% %RIC%ricps.com           4
@goto step2;
@rem
@rem The following lines are for the IBM Realtime Interface Co-Processor
@rem Multiport Adapter, Model 2 or the IBM Realtime Interface Co-Processor
@rem Portmaster Adapter/A.  Please uncomment the appropriate lines.
@rem If you are using the IBM Realtime Interface Co-Processor,
@rem IBM Realtime Interface Co-Processor Multiport Adapter, or
@rem IBM Realtime Interface Co-Processor Multiport/2, then proceed
@rem to Step 2 Set the ARTIC shared message pool size.
@rem
:portm
@rem For RCM version 2.0, uncomment the next line
@rem %RIC%icaldric %CARD% %RIC%icarcm.com     0
@rem
@rem For RCM version 2.01, uncomment the next line
%RIC%icaldric %CARD% %RIC%icarcm.com     0 (1
@rem
@rem If you want to use the DDMS co-processor overlay server, uncomment the
@rem next line.  0x81 is the interrupt number for the overlay operation.
@rem This number must match the interrupt number used in the link instruction
@rem in DDMSMAKE.MAK
@if %PORT% == MP2 @goto detour;
%RIC%icaldric %CARD% %TOOLKIT%icaovmgr.exe   2 (0x81
:detour
@rem
@rem For either level of RCM 2.0, uncomment the line
%RIC%icaldric %CARD% %RIC%ricpse.com     4
@rem
:step2
@rem -----2. Set the ARTIC shared message pool size-----------------
@rem The MBXiccfg routine may optionally be used to allocate the
@rem ARTIC shared message pool size.  The CPP/A products require at
@rem most 2K to be allocated, but the ARTIC default is much higher.
@rem Some user applications may require more than the 2K needed by the
@rem CPPs.  The user may increase the value by editing this file or
@rem may choose to perform this allocation in an application program.
@rem If the MBXiccfg routine is not used and the application program
@rem does not perform the allocation either, the pool size will
@rem default to the larger ARTIC default value as specified in the
@rem Realtime Coprocessor Extended Services documentation.
@rem The MBXiccfg routine is used as follows:
@rem - Two input parameters can optionally be used on the command line.
@rem - The first parameter is the ARTIC card number; the default is 0.
@rem - The second parameter is the amount of memory required, in K bytes;
@rem   the default is 4K within this routine; 2K is suggested for the
@rem   CPP/A products.
@rem The MBXiccfg routine loads temporary task 11 on the coprocessor;
@rem the task is completed when it returns from this routine.
@rem
@rem Uncomment the following line to configure the ARTIC shared message pool
%TOOLKIT%MBXiccfg %CARD%  15
@rem
@rem ---- 3. Set which CPP (if any) you want to use ----------------
@rem
@rem To use one of the CPPs, uncomment the following line:
%RIC%icaldric %CARD% %RIC%riccs.com      5
@rem
@rem To select any of the following CPPs to automatically load,
@rem uncomment the appropriate line
if %PLC% == AB  %RIC%icaldric %CARD% %EXE%cs2ABcpp.exe   6
if %PLC% == TI  %RIC%icaldric %CARD% %EXE%cs2TIcpp.exe   7
if %PLC% == GE  %RIC%icaldric %CARD% %EXE%cs2GEcpp.exe   8
if %PLC% == MO  %RIC%icaldric %CARD% %EXE%cs2MOcpp.exe   9
@rem
@rem If you have selected 'Other' option, uncomment the following line
@rem making the appropriate modifications
@rem if %CARD% == x  %RIC%icaldric %CARD% %EXE%yyyyyyyy.exe 9
@rem where x is the card number and yyyyyyyy is the CPP name.
@rem Note that you need to add a statement like the one above for each
@rem 'Other' option you have selected on the node.
@rem
@rem ... or uncomment one of the following lines for the sample CPPs
@rem %RIC%icaldric %CARD% %TOOLKIT%CPPASYNC.EXE   10
@rem %RIC%icaldric %CARD% %TOOLKIT%CPPELF.EXE     11
@rem
@rem ---- 4. Set whether or not you want the debugger --------------
@rem To start the debugger automatically, uncomment the next line
@rem start "Debugger" %RIC%icadebug.exe
@rem
@rem ---- 5. Set whether or not you want to start CS/2 -------------
@rem To start CS/2 automatically, uncomment the next line
@rem call %EXE%cs2start.cmd
@rem
@rem ---------------------------------------------------------------
:end
@rem end of file
