/* Setup PlantWorks Environment */

arg PW_Root .

call RxFuncAdd 'SysLoadFuncs', 'RexxUtil', 'SysLoadFuncs'
call SysLoadFuncs


/* Check for command argument */

if PW_Root = '' then call error 1

/* Check for presence of PW configuration file */

if stream(PW_Root'\VISION\FILES\VCONFIG','C','Query Exists') = '' then call error 2

/* Scan for CS/2 directory */

CS2_Root = ''
drivemap = SysDriveMap('C:','LOCAL')
do while drivemap <> ''
    parse var drivemap drive drivemap
    if stream(drive'\CS2\NUL','C','Query Exists') <> '' then do
	CS2_Root = drive'\CS2'
	leave
    end
end
if CS2_Root = '' then call error 3

/* Scan for OS/2 directory */

drivemap = SysDriveMap('C:','LOCAL')
do while drivemap <> ''
    parse var drivemap drive drivemap
    if stream(drive'\OS2\DLL\NUL','C','Query Exists') <> '' then do
	call AppendVar	'DPATH', drive'\OS2\DLL'
	leave
    end
end

/* Define PlantWorks-specific environment variables */

call SetVar	'CS2PATH',	 CS2_Root
call SetVar	'FF_ROOT',       PW_Root
call SetVar	'VOS_ENV_DISK',  PW_Root
call SetVar	'VOS_ENV_FILES', PW_Root'\VISION\FILES'
call SetVar	'TMP',           PW_Root'\TMP'
call SetVar	'IMS_FILPTH',    PW_Root'\IM\FILES'
call SetVar	'IMS_PRIPTH',    PW_Root'\IM\FILES'
call SetVar	'IMS_SECPTH',    PW_Root'\IM\FILES'
call SetVar	'RGS_FILPTH',    PW_Root'\RG\FILES\'
call SetVar	'RGS_PRIPTH',    PW_Root'\IM\FILES\'
call SetVar	'RGS_SECPTH',    PW_Root'\IM\FILES\'

/* Modify current environment variables */

call AppendVar	'PATH',          PW_Root'\BIN;'PW_Root'\VISION\BIN'
call PrependVar	'DPATH',         PW_Root'\MSG;'CS2_Root'\SYS'
call PrependVar	'HELP',	         PW_Root'\IPF'

exit				/* Normal termination */


AppendVar: arg varName, newValue
    oldValue = value(varName,,'OS2ENVIRONMENT')
    if right(oldValue,1) <> ';' then oldValue = oldValue||';'
    call Value varName, oldValue||newValue, 'OS2ENVIRONMENT'
    return

PrependVar: arg varName, newValue
    oldValue = value(varName,,'OS2ENVIRONMENT')
    if left(oldValue,1) <> ';' then oldValue = ';'||oldValue
    call Value varName, newValue||oldValue, 'OS2ENVIRONMENT'
    return

SetVar: arg varName, newValue
    Call Value varName, newValue, 'OS2ENVIRONMENT'
    return

Error: arg msgnum
    msg.1 = 'You must specify the PlantWorks root directory'
    msg.2 = 'PlantWorks configuration file - VCONFIG does not exist'
    msg.3 = 'Unable to locate CS/2 root directory'
    msg.4 = 'Unable to set environment variable'
    msg.9 = 'Unable to load RexxUtil functions'
    say 'FFENV:' msg.msgnum
    exit 999
