/* Export data from a PW 2.1 database */
arg expdir listfile .

Exporter = 'IMREL21.EXE'	/* REl 2.1 IMMVDB */
if expdir = ''   then expdir = directory()
if listfile = '' then listfile = expdir'\Export.Lst'
tempfile = 'Export.TMP'

signal on error

/* initialize RexxUtil library */
call RxFuncAdd 'SysLoadFuncs', 'RexxUtil', 'SysLoadFuncs'
call SysLoadFuncs

if directory(expdir) = '' then do
  say "Creating directory:" expdir
  rc = SysMkDir(expdir)
  if rc <> 0 then do
    say "Unable to create target directory."
    exit 100
  end
  call directory(expdir)
end

Logfile  = expdir'\Export.Log'
call SysFileDelete Logfile
call chkpt "Begin PlantWorks Release 2.1 Export"
call chkpt "-- Export directory:" expdir
call chkpt "-- Export list file:" listfile

/*
** Create a list of all items in the database
*/
Exporter '-q * >' tempfile

SQL_Funcs = 'DBBIND DBGETREC DBSTAMP DBCONN DBDISC DBSQL DBSELECT',
	    'DBUPTATE DBDELETE DBINSERT DBCOMMIT DBROLLBACK'
/*
** Filter out unwanted items
*/
Exporter '-fx *(IOPOINT) *(IOGROUP) *(FFNODE) *(ALMGRP) *(ALMTEMPL)',
    '*(RT_VDISP) SUPPORT' SQL_Funcs 'WRL:ALMDATA.1.0' '<' tempfile '>' listfile
'@COPY' listfile tempfile '2>NUL'
call SysFileDelete listfile

call lineout listfile, "# Migration export list created" date() time()
do while lines(tempfile)
  line = linein(tempfile)
  parse var line itemfile itemname . . itemtype attr .
  if left(itemname,4) = 'WRL:' &,
     (itemtype='RECFMT'  | itemtype='RECORD'  |,
      itemtype='DISPLAY' | itemtype='RT_VDISP') then
      iterate
  call lineout listfile, line
end

/*
** Export item database
*/
call chkpt "Begin database export"
Exporter '-x <' listfile '>>' Logfile
call chkpt "End database export"

/*
** Check the log file for any errors
*/
call SysFileSearch '#error', Logfile, 'ErrList.'
if ErrList.0 <> 0 then do
  call chkpt 'Errors found during export'
  exit 100
end

call chkpt "Export completed"
exit					/* normal termination */

/* ------------------------------------------------------------ */

chkpt:
parse arg msg
say date() time() msg
call lineout Logfile, date() time() msg
call stream Logfile, 'C', 'Close'
return

Error:
call chkpt 'ERROR: Migration export aborted'
call chkpt 'Last command:' condition('D')
exit
