/* Create PlantWorks Reference Diskette */

arg     PW_Root

PW_Cfg = PW_Root || '\CFG'
PW_Bin = PW_Root || '\BIN'
PW_Ipf = PW_Root || '\IPF'
PW_Msg = PW_Root || '\MSG'

/* Re-direct the output to stderr. */
'@ECHO Creating required directories ... >&2'

Call    CreateDirectories '\FF \FF\BIN \FF\CFG \FF\IPF \FF\MSG'
Call    CreateDirectories '\FF\VISION \FF\VISION\FILES \FF\CS2SYS \FF\ICA'

Say     'Copying Network Configuration file ...'

Call    CopyFiles PW_Cfg 'A:\FF\CFG' '?PWNET.CFG ?NET.CFG ?PWIO.CFG'

Say     'Copying Control Block file ...'

Call    CopyFiles PW_Cfg 'A:\FF\CFG' 'FFACB.ACB IM.TBL'

Say     'Copying Configuration utility files ...'

Call    CopyFiles PW_Bin 'A:\FF\BIN' 'PWCOINS.EXE RMKDIR.CMD REMMKDIR.EXE'
Call    CopyFiles PW_Bin 'A:\FF\BIN' 'COINLOGO.EXE PWNETDEF.CMD PWSTATUS.EXE'
Call    CopyFiles PW_Bin 'A:\FF\BIN' 'PWFOLDER.ICO PWSTART.ICO PWFULLSC.ICO PWWIN.ICO'
Call    CopyFiles PW_Bin 'A:\FF\BIN' 'PWNETDEF.ICO RDBSMAIN.ICO FOLDWARN.ICO DAESTART.ICO'
Call    CopyFiles PW_Bin 'A:\' 'CONFIG.CMD ?INSTALL.CMD'
'@COPY' 'A:\CONFIG.CMD A:\INSTALL.CMD 1> nul 2> nul'

Call    CopyFiles PW_Cfg 'A:\FF\CFG' 'EXCPW.INV BLDPW.INV DEFPW.INV BLDEFPW.INV ?DISPW.INV'
Call    CopyFiles PW_Cfg 'A:\FF\CFG' 'VCONFIG.SLV VCONFIG.EXC ?VCONFIG.DIS'
Call    CopyFiles PW_Cfg 'A:\FF\CFG' 'VERSION.TXT BDM.SEQ'

Call    CopyFiles PW_Ipf 'A:\FF\IPF' 'CNS.HLP ?COINS.INF'
Call    CopyFiles PW_Msg 'A:\FF\MSG' '?PWI.MSG ?PWIH.MSG ?PWIDH.MSG'

Call    CopyFiles PW_Cfg 'A:\FF\CFG' 'FFBACK.CMD FFREST.CMD'
Call    CopyFiles PW_Cfg 'A:\FF\CFG' 'PWCS2ST.CMD PWRICST.CMD'
Call    CopyFiles PW_Cfg 'A:\FF\CFG' 'DBINST.LST DELACB.ACB PW_DEF.INI CS2CNFIG.CNF'

Say     'Labeling the reference disk ...'

'@LABEL' 'A:PW-INSTALL 1> nul 2> nul'
        If rc <> 0 Then Call Error rc

Say     '--------------------------------------------------'
Say     'PlantWorks Reference diskette created successfully'
Say     '--------------------------------------------------'

E_X_I_T:
/* Re-direct the input from stderr. */
'@PAUSE<&2'
Exit    0

CreateDirectories:
Parse Arg argv
Do i = 1 to words(argv)
        dir = translate(word(argv,i))
        '@MKDIR' 'A:'dir '2> nul'
End
Return

CopyFiles:
Parse Arg srcDir destDir argv
Do i = 1 to words(argv)
        file = translate(word(argv,i))
        If substr(file,1,1) = '?' Then Do
            file = substr(file,2)
            If stream(srcDir'\'file, 'C', 'Query Exists') = '' Then Iterate i
            If stream(srcDir'\'file, 'C', 'Query Size') = 0 Then Iterate i
        End
        '@COPY' srcDir'\'file destDir '1> nul 2> nul'
        if rc <> 0 then Call Error rc
End i
Return

Error:
Parse Arg rc
esc     = d2c(27)
Say     d2c(7) esc'[1;40;33m'
Say     '-------------------------------------------------------------'
Say     'Error in creating PlantWorks Reference diskette              '
Say     'Please report the error to the PlantWorks site support person'
Say     '-------------------------------------------------------------'
Say     esc'[0;40;37m'
Call    E_X_I_T
