/*
 *	Copyright (C) 1993 IBM Corporation
 *
 *	DISCLAIMER OF WARRANTIES.  The following [enclosed] code is sample
 *	code created by IBM Corporation.  This sample code is not part of
 *	any standard or IBM product and is provided to you solely for the
 *	purpose of assisting you in the development of your applications.
 *	The code is provided "AS IS", without warranty of any kind.
 *	IBM shall not be liable for any damages arising out of your
 *	use of the sample code, even if they have been advised of the
 *	possibility of such damages.
 */

#define INCL_WIN
#include <os2.h>
#include <string.h>
#include <stdlib.h>

#include "client.h"			/* Resource symbolic identifiers*/
#include "resource.h"


#define	MAX_MSG_SZ	300		/* max size of text string	*/

#define	MENU_STARTCONV	0x0001
#define	MENU_STOPCONV	0x0002
#define	MENU_REQUEST	0x0004
#define	MENU_POKE	0x0008
#define	MENU_ADVISE	0x0010
#define	MENU_ENDADVISE	0x0020
#define	MENU_TRIGCHN	0x0040
#define	MENU_ALARM	0x0080

extern	void	DdeMsgLog( USHORT, HWND, void * );


/* Function prototypes */
#pragma linkage( MyWindowProc,	system )
#pragma linkage( InitDlgProc,	system )
#pragma linkage( DialogProc,	system )
#pragma linkage( GetDlgProc,	system )
#pragma linkage( PokeDlgProc,	system )
#pragma linkage( AlarmProc,	system )
#pragma linkage( DdeWndProc,	system )


/* globals */

USHORT	menuState = MENU_STARTCONV;

BOOL	fConnected = FALSE;		/* status of a DDE conversation	*/
USHORT	usAdvise = 0;			/* number of hot link		*/
HWND	hwndFrame,
	hwndMenu,
	hwndDDEserver;

CHAR	szMsg[MAX_MSG_SZ];		/* text string			*/
CHAR	szDDEItemName[CV_MAXDDENAME];	/* DDE item (piece of data) in topic format*/
PFNWP	pWndProc;
DDECONV ddec;				/* DDE Server name and requested topic*/
USHORT	usItem = 0;			/* Menu item			*/
char	itemName[ 64 ];
char	itemData[ 256 ];
USHORT	itemFormat = CF_TEXT;
USHORT	itemState;

struct {
	USHORT	state;
	char	text[ 20 ];
}	almState[] = {
	{ 0,	"ALM_NORMAL"		},
	{ 1,	"ALM_IN_ALARM"		},
	{ 2,	"ALM_HIGH"		},
	{ 3,	"ALM_HIGH_HIGH"		},
	{ 4,	"ALM_INSTR_HIGH"	},
	{ 5,	"ALM_OUT_CLAMP_HIGH"	},
	{ 6,	"ALM_LOW"		},
	{ 7,	"ALM_LOW_LOW"		},
	{ 8,	"ALM_INSTR_LOW"		},
	{ 9,	"ALM_OUT_CLAMP_LOW"	}
};

static	short	topicsCnt = 0,
		applsCnt = 0;

static	char	*ddeTopics[ 256 ],
		*ddeApplications[ 64 ];

static	ATOM	atomIS2,
		atomCsv;


MRESULT EXPENTRY
InitDlgProc( HWND hwnd, USHORT msg, MPARAM mp1, MPARAM mp2 )
{
	static HWND	hwndServer = NULLHANDLE,
			hwndTopic = NULLHANDLE;
	register int	i;

	switch ( msg )
	{
	case WM_INITDLG:
	    if ( hwndServer = WinWindowFromID( hwnd, ID_SERVER_CBX ) )
	    {
		WinSetWindowText( hwndServer, ddec.szDDEServerName );
		WinSendMsg( hwndServer, EM_SETSEL,
			    MPFROM2SHORT( (USHORT) 0, (USHORT) CV_MAXDDENAME ),
			    (MPARAM) 0 );

		for ( i = 0; i < applsCnt; i++ )
			WinInsertLboxItem( hwndServer, LIT_END, ddeApplications[i] );
	    }
	    if ( hwndTopic = WinWindowFromID( hwnd, ID_TOPIC_CBX ) )
	    {
		WinSetWindowText( hwndTopic, ddec.szDDETopicName );
		for ( i = 0; i < topicsCnt; i++ )
			WinInsertLboxItem( hwndTopic, LIT_END, ddeTopics[i] );
	    }
	    return 0;

	case WM_COMMAND:
	    switch ( SHORT1FROMMP( mp1 ) )
	    {
	    case DID_OK:
		WinQueryWindowText( hwndServer, CV_MAXDDENAME,
				    ddec.szDDEServerName );
		WinQueryWindowText( hwndTopic, CV_MAXTOPICNAME,
				    ddec.szDDETopicName );
		return (MRESULT) WinDismissDlg( hwnd, TRUE );

	    case DID_CANCEL:
		return (MRESULT) WinDismissDlg( hwnd, FALSE );
	    }
	    break;

	case WM_SYSCOMMAND:
	    switch ( LOUSHORT( mp1 ) )
	    {
	    case SC_CLOSE:
		return (MRESULT) WinDismissDlg( hwnd, FALSE );

	    default:
		return WinDefDlgProc( hwnd, msg, mp1, mp2 );
	    }
	    break;
	}

	return WinDefDlgProc( hwnd, msg, mp1, mp2 );
}


MRESULT EXPENTRY
DialogProc( HWND hwnd, USHORT msg, MPARAM mp1, MPARAM mp2 )
{
	switch ( msg )
	{
	case WM_INITDLG:
	    WinSetDlgItemText( hwnd, IDC_ITEM, itemName );
	    return 0;

	case WM_COMMAND:
	    switch ( SHORT1FROMMP( mp1 ) )
	    {
	    case DID_OK:
		WinQueryDlgItemText( hwnd, IDC_ITEM, sizeof(itemName), (PSZ) itemName );
		return (MRESULT) WinDismissDlg( hwnd, TRUE );

	    case DID_CANCEL:
		return (MRESULT) WinDismissDlg( hwnd, FALSE );
	    }
	    break;

	case WM_SYSCOMMAND:
	    switch ( LOUSHORT( mp1 ) )
	    {
	    case SC_CLOSE:
		return (MRESULT) WinDismissDlg( hwnd, FALSE );

	    default:
		return WinDefDlgProc( hwnd, msg, mp1, mp2 );
	    }
	    break;
	}

	return WinDefDlgProc( hwnd, msg, mp1, mp2 );
}


MRESULT EXPENTRY
GetDlgProc( HWND hwnd, USHORT msg, MPARAM mp1, MPARAM mp2 )
{
	switch ( msg )
	{
	case WM_INITDLG:
	    WinSetDlgItemText( hwnd, IDC_ITEM, itemName );
	    if ( itemFormat == atomIS2 )
		WinPostMsg( WinWindowFromID( hwnd, IDC_FMT_IS2 ) ,
			    BM_CLICK, MPFROMSHORT( TRUE ), MPVOID );
	    else if ( itemFormat == atomCsv )
		WinPostMsg( WinWindowFromID( hwnd, IDC_FMT_CSV ) ,
			    BM_CLICK, MPFROMSHORT( TRUE ), MPVOID );
	    else
		WinPostMsg( WinWindowFromID( hwnd, IDC_FMT_CFTEXT ) ,
			    BM_CLICK, MPFROMSHORT( TRUE ), MPVOID );
	    return 0;

        case WM_CONTROL:
	    switch ( SHORT1FROMMP( mp1 ) )
	    {
	    case IDC_FMT_CFTEXT:
		itemFormat = CF_TEXT;
		break;

	    case IDC_FMT_IS2:
		itemFormat = atomIS2;
		break;

	    case IDC_FMT_CSV:
		itemFormat = atomCsv;
		break;
	    }
	    break;

	case WM_COMMAND:
	    switch ( SHORT1FROMMP( mp1 ) )
	    {
	    case DID_OK:
		WinQueryDlgItemText( hwnd, IDC_ITEM, sizeof(itemName), (PSZ) itemName );
		return (MRESULT) WinDismissDlg( hwnd, TRUE );

	    case DID_CANCEL:
		return (MRESULT) WinDismissDlg( hwnd, FALSE );
	    }
	    break;

	case WM_SYSCOMMAND:
	    switch ( LOUSHORT( mp1 ) )
	    {
	    case SC_CLOSE:
		return (MRESULT) WinDismissDlg( hwnd, FALSE );

	    default:
		return WinDefDlgProc( hwnd, msg, mp1, mp2 );
	    }
	    break;
	}

	return WinDefDlgProc( hwnd, msg, mp1, mp2 );
}


MRESULT EXPENTRY
PokeDlgProc( HWND hwnd, USHORT msg, MPARAM mp1, MPARAM mp2 )
{
	switch ( msg )
	{
	case WM_INITDLG:
	    WinSetDlgItemText( hwnd, IDC_ITEM, itemName );
	    if ( itemFormat == atomCsv )
		WinPostMsg( WinWindowFromID( hwnd, IDC_FMT_CSV ) ,
			    BM_CLICK, MPFROMSHORT( TRUE ), MPVOID );
	    else
		WinPostMsg( WinWindowFromID( hwnd, IDC_FMT_CFTEXT ) ,
			    BM_CLICK, MPFROMSHORT( TRUE ), MPVOID );
	    return 0;

        case WM_CONTROL:
	    switch ( SHORT1FROMMP( mp1 ) )
	    {
	    case IDC_FMT_CFTEXT:
		itemFormat = CF_TEXT;
		break;

	    case IDC_FMT_CSV:
		itemFormat = atomCsv;
		break;
	    }
	    break;

	case WM_COMMAND:
	    switch ( SHORT1FROMMP( mp1 ) )
	    {
	    case DID_OK:
		WinQueryDlgItemText( hwnd, IDC_ITEM, sizeof(itemName), (PSZ) itemName );
		WinQueryDlgItemText( hwnd, IDC_DATA, sizeof(itemData), (PSZ) itemData );
		return (MRESULT) WinDismissDlg( hwnd, TRUE );

	    case DID_CANCEL:
		return (MRESULT) WinDismissDlg( hwnd, FALSE );
	    }
	    break;

	case WM_SYSCOMMAND:
	    switch ( LOUSHORT( mp1 ) )
	    {
	    case SC_CLOSE:
		return (MRESULT) WinDismissDlg( hwnd, FALSE );

	    default:
		return WinDefDlgProc( hwnd, msg, mp1, mp2 );
	    }
	    break;
	}

	return WinDefDlgProc( hwnd, msg, mp1, mp2 );
}


MRESULT EXPENTRY
AlarmProc( HWND hwnd, USHORT msg, MPARAM mp1, MPARAM mp2 )
{
	static HWND	hwndState = (HWND) NULL;
	register int	i;
	char	state[ 64 ];

	switch ( msg )
	{
	case WM_INITDLG:
	    WinSetDlgItemText( hwnd, IDC_ITEM, itemName );
	    if ( hwndState = WinWindowFromID( hwnd, IDC_STATE ) )
	    {
		WinSetWindowText( hwndState, almState[0].text );
		for ( i = 0; i < (sizeof(almState)/sizeof(almState[0])); i++ )
		{
			WinInsertLboxItem( hwndState, LIT_END,
					   almState[i].text );
		}
	    } 
	    return 0;

	case WM_COMMAND:
	    switch ( SHORT1FROMMP( mp1 ) )
	    {
	    case DID_OK:
		WinQueryDlgItemText( hwnd, IDC_ITEM, sizeof(itemName), (PSZ) itemName );
		WinQueryDlgItemText( hwnd, IDC_DATA, sizeof(itemData), (PSZ) itemData );
		
		WinQueryDlgItemText( hwnd, IDC_STATE, sizeof(state), (PSZ) state );
		for ( i = 0, itemState = 0; i < (sizeof(almState)/sizeof(almState[0])); i++ )
		{
			if ( !strcmp( state, almState[i].text ) )
			{
			    itemState = almState[i].state;
			    break;
			}
		}
		return (MRESULT) WinDismissDlg( hwnd, TRUE );

	    case DID_CANCEL:
		return (MRESULT) WinDismissDlg( hwnd, FALSE );
	    }
	    break;

	case WM_SYSCOMMAND:
	    switch ( LOUSHORT( mp1 ) )
	    {
	    case SC_CLOSE:
		return (MRESULT) WinDismissDlg( hwnd, FALSE );

	    default:
		return WinDefDlgProc( hwnd, msg, mp1, mp2 );
	    }
	    break;
	}

	return WinDefDlgProc( hwnd, msg, mp1, mp2 );
}


PDDESTRUCT
MakeDDEDataSeg( USHORT usFormat, PSZ pszItemName,
		PVOID pvData, USHORT cbData, USHORT fsStatus )
{
	PDDESTRUCT pdde = NULL;		/* ptr to dde data structure	*/
	ULONG	rc = 0;			/* api return code holder	*/
	PULONG	pulSharedObj = NULL;	/* pointer to shared object	*/
	PCHAR	psz = NULL;		/* string ptr for text format	*/
	USHORT	cbObjSize = 0;		/* count of bytes to request	*/

	cbObjSize = (USHORT) strlen( pszItemName ) + cbData + 1;
	rc = DosAllocSharedMem(
			(PPVOID) &pulSharedObj,
			NULL,
			cbObjSize,
			PAG_COMMIT | PAG_READ | PAG_WRITE | OBJ_GIVEABLE
	     );
	if ( rc && pulSharedObj )
	    return NULL;

	pdde = (PDDESTRUCT) pulSharedObj;
	pdde->usFormat = usFormat;
	pdde->offszItemName = (USHORT) sizeof(DDESTRUCT); /* ptr to item name*/
	strcpy( DDES_PSZITEMNAME(pdde), pszItemName );	/* item name*/
	pdde->cbData = cbData;		/* count of bytes of user data*/
	pdde->offabData = (USHORT) pdde->offszItemName + (USHORT) strlen( pszItemName ) + 1;
	pdde->fsStatus = fsStatus;	/* set status flags */

	if ( cbData != 0 && pvData != NULL )
	{
	    switch ( usFormat )
	    {
	    case CF_TEXT:
		strncpy( DDES_PABDATA( pdde ), pvData, (size_t) pdde->cbData++ );
		break;

	    default:
		memcpy( DDES_PABDATA( pdde ), pvData, (size_t) pdde->cbData );
		break;
	    }
	}

	return pdde;
}


/*
 * Pre - hwnd is a valid window handle, szMsg is a null terminated string
 * Post - writes szMsg in hwnd centered vertically and horizontally
 */

VOID EXPENTRY
PaintWindow( HWND hwnd, CHAR *szMsg )
{
	RECTL	rcl;
	HPS	hps = WinBeginPaint( hwnd, (HPS) NULL, &rcl );

	if ( !hps )
	{
	    WinAlarm( HWND_DESKTOP, WA_ERROR );	/* failed to get cached-micro ps */
	    return;
	}

//	fill in the background window color
	WinFillRect( hps, &rcl, SYSCLR_WINDOW );

	WinQueryWindowRect( hwnd, &rcl );
//	write text to window - centered vertical and horizontal
	WinDrawText( hps, -1, szMsg, &rcl, CLR_NEUTRAL,
		     CLR_BACKGROUND, DT_CENTER | DT_VCENTER | DT_ERASERECT );

	WinEndPaint( hps );
}


MRESULT EXPENTRY
DdeWndProc( HWND hwnd, USHORT msg, MPARAM mp1, MPARAM mp2 )
{
	PDDEINIT	pddei = NULL;	/* DDE init struct ptr		*/
	PDDESTRUCT	pdde = NULL,
			pddeOut = NULL; /* DDE Transaction struct ptr	*/

	DdeMsgLog( msg, (HWND) mp1, (void *) mp2 );

	switch ( msg )
	{
	case WM_DDE_DATA:
	    /* ignore responses from other servers */
	    if ( hwndDDEserver != (HWND) mp1 )
		break;

//	    write incomming text message to screen

	    pdde = (PDDESTRUCT) mp2;
	    strncpy( szMsg, (PSZ) DDES_PABDATA(pdde), pdde->cbData ); /* Extract data*/
	    if ( strlen( szMsg ) == 0 )
		strcpy( szMsg, "<no text message from server>" );
	    PaintWindow( hwnd, szMsg );
	    WinInvalidateRect( hwnd, NULL, FALSE );

	    if ( pdde->fsStatus & DDE_FACKREQ )	/* does server requre ack? */
	    {
		pddeOut = MakeDDEDataSeg( CF_TEXT, szDDEItemName, NULL, 0, DDE_FACK );
		if ( pddeOut )
		{
		    WinDdePostMsg( hwndDDEserver, hwnd,
				   WM_DDE_ACK, pddeOut, TRUE );
		}
	    }
	    DosFreeMem( (PVOID) mp2 );
	    break;

	case WM_DDE_ACK:
	    pdde = (PDDESTRUCT) mp2;

	    switch ( usItem )		/* what request was last issued */
	    {
//	    if the ack was in response to our hot link request,
//	    change status of menu items

	    case IDM_ADVISE:
		if ( pdde->fsStatus & DDE_FACK )
		{
		    menuState |= MENU_ENDADVISE;
		    usAdvise++;

//		    Get current value
		    pddeOut = MakeDDEDataSeg( itemFormat, itemName, NULL, 0, 0 );
		    if ( pddeOut )
		    {
			WinDdePostMsg( hwndDDEserver, hwnd,
				       WM_DDE_REQUEST, pddeOut, TRUE );
			usItem = IDM_REQUEST;
		    }
		}
		break;

	    case IDM_ENDADVISE:
		if ( pdde->fsStatus & DDE_FACK )
		{
		    if ( --usAdvise == 0 )
			menuState &= ~MENU_ENDADVISE;
		}
		break;

	    case IDM_POKE:
	    case IDM_REQUEST:
		if ( !( pdde->fsStatus & DDE_FACK ) )
		    WinAlarm( HWND_DESKTOP, WA_ERROR );
		break;
	    }
	    DosFreeMem( (PVOID) mp2 );
	    break;

	case WM_DDE_INITIATEACK:
	    WinAlarm( HWND_DESKTOP, WA_NOTE );
	    pddei = (PDDEINIT) mp2;           /* MS V2 PG 430 */

	    if ( !ddec.szDDEServerName[0] && !ddec.szDDETopicName[0] )
	    {
		register int i;

		for ( i = 0; i < topicsCnt; i++ )
			if ( !stricmp( ddeTopics[i], pddei->pszTopic ) )
			    break;
		if ( i >= topicsCnt )
		    ddeTopics[ topicsCnt++ ] = strdup( pddei->pszTopic );

		for ( i = 0; i < applsCnt; i++ )
			if ( !stricmp( ddeApplications[i], pddei->pszAppName ) )
			    break;
		if ( i >= applsCnt )
		    ddeApplications[ applsCnt++ ] = strdup( pddei->pszAppName );
	    }
	    else if ( fConnected && hwndDDEserver != (HWND) mp1 )
		WinDdePostMsg( (HWND) mp1, hwnd, WM_DDE_TERMINATE, NULL, TRUE );
	    else if ( !stricmp( ddec.szDDETopicName, pddei->pszTopic )
		   || !stricmp( ddec.szDDEServerName, pddei->pszAppName ) )
	    {
		hwndDDEserver = (HWND) mp1;   /* store client window handle*/
		if ( !strcmp( pddei->pszTopic, SZDDESYS_TOPIC ) )
		    menuState = MENU_STOPCONV | MENU_REQUEST;
		else
		    menuState = ~( MENU_STARTCONV | MENU_ENDADVISE );
		WinSetWindowText( hwndFrame, "DDE Client - Connected" );
		fConnected = TRUE;
	    }

	    DosFreeMem( (PVOID) mp2 );
	    break;

	case WM_DDE_TERMINATE:
	    if ( hwndDDEserver != (HWND) mp1 )	/* ignore responses from other servers*/
		break;
	    menuState = MENU_STARTCONV;
	    hwndDDEserver = (HWND) NULL;           /* store client window handle*/
	    WinSetWindowText( hwndFrame, "DDE Client - Not Connected" );
	    fConnected = FALSE;
	    usAdvise = 0;
	    break;

	default:
	    return (*pWndProc)( hwnd, msg, mp1, mp2 );
	}

	return WinDefWindowProc( hwnd, msg, mp1, mp2 );
//	return (MRESULT) NULL;
}


static void
loadFormat( BOOL option )
{
	HATOMTBL hAtomTbl = WinQuerySystemAtomTable();
	static BOOL	rmAtomIS2 = FALSE,
			rmAtomCsv = FALSE;

	if ( option == TRUE )
	{
	    atomIS2 = WinFindAtom( hAtomTbl, "IS2" );

	    if ( atomIS2 == 0 )
	    {
		atomIS2 = WinAddAtom( hAtomTbl, "IS2" );
		rmAtomIS2 = TRUE;
	    }

	    atomCsv = WinFindAtom( hAtomTbl, "Csv" );

	    if ( atomCsv == 0 )
	    {
		atomCsv = WinAddAtom( hAtomTbl, "Csv" );
		rmAtomCsv = TRUE;
	    }
	}
	else
	{
	    if ( rmAtomIS2 == TRUE )
		WinDeleteAtom( hAtomTbl, atomIS2 );
	    if ( rmAtomCsv == TRUE )
		WinDeleteAtom( hAtomTbl, atomCsv );
	}
}


VOID
DisplayMessage( PCH str )
{
	WinMessageBox(
		HWND_DESKTOP,
		HWND_DESKTOP,
		(PCH) str,
		(PCH) "Error Messages For The DDE Sample",
		ID_MESSAGEBOX,
		MB_OK | MB_APPLMODAL | MB_MOVEABLE | MB_ERROR
	);
}


static void
setup()
{
	/* set up our default dde conversation block (struct) */
	ddec.szDDEServerName[0] = 0;
	ddec.szDDETopicName[0] = 0;

	ddeApplications[ applsCnt++ ] = strdup( CV_DDEAPPNAME );
	ddeTopics[ topicsCnt++ ] = strdup( CV_DDETOPIC );
	ddeTopics[ topicsCnt++ ] = strdup( SZDDESYS_TOPIC );

	strcpy( szDDEItemName, CV_DDEITEMSG );

	loadFormat( TRUE );
}


MRESULT EXPENTRY
MyWindowProc( HWND hwnd, USHORT msg, MPARAM mp1, MPARAM mp2 )
{
	PDDESTRUCT	pdde = NULL,
			pddeOut = NULL; /* DDE Transaction struct ptr */
	register int	i;

	switch ( msg )
	{
	/* set up  */
	case WM_CREATE:
	    /* Get the window handles for this instances menu and frame window */
	    hwndFrame = WinQueryWindow( hwnd, QW_PARENT );
	    hwndMenu = WinWindowFromID( hwndFrame, (USHORT) FID_MENU );
	    pWndProc = WinSubclassWindow( hwnd, (PFNWP) DdeWndProc );
	    setup();
	    WinSetWindowText( hwndFrame, "DDE Client - Not Connected" );
	    /* position window on users screen */
	    WinSetWindowPos( hwndFrame, HWND_TOP,
		    50,50,    /* window position (x,y) */
		    WinQuerySysValue(HWND_DESKTOP, SV_CXSCREEN)/3,	/* window width */
		    WinQuerySysValue(HWND_DESKTOP, SV_CYSCREEN)/3,	/* window height */
		    SWP_SIZE | SWP_MOVE | SWP_SHOW );
	    return 0;

	case WM_INITMENU:
	    WinEnableMenuItem( hwndMenu, IDM_TRIGCHN,	menuState & MENU_TRIGCHN );
	    WinEnableMenuItem( hwndMenu, IDM_ALARM,	menuState & MENU_ALARM );
	    WinEnableMenuItem( hwndMenu, IDM_REQUEST,	menuState & MENU_REQUEST );
	    WinEnableMenuItem( hwndMenu, IDM_POKE,	menuState & MENU_POKE );
	    WinEnableMenuItem( hwndMenu, IDM_ADVISE,	menuState & MENU_ADVISE );
	    WinEnableMenuItem( hwndMenu, IDM_ENDADVISE,	menuState & MENU_ENDADVISE );
	    WinEnableMenuItem( hwndMenu, IDM_STOPCONV,	menuState & MENU_STOPCONV );
	    WinEnableMenuItem( hwndMenu, IDM_STARTCONV,	menuState & MENU_STARTCONV );
	    break;

	case WM_COMMAND:
	    switch ( SHORT1FROMMP( mp1 ) )
	    {
	    case IDM_STARTCONV:
		if ( WinDlgBox(HWND_DESKTOP,
			hwndFrame,
			(PFNWP) InitDlgProc,
                        0,
                        IDD_INIT_DLG,
                        NULL) )
		{
		    if ( !WinDdeInitiate( hwnd, ddec.szDDEServerName,
					  ddec.szDDETopicName,
					  (PCONVCONTEXT) 0 ) )
		    {
			WinAlarm( HWND_DESKTOP, WA_ERROR );
			DisplayMessage( "WinDdeInitiate() failed!" );
		    }
		}
		return 0;

	    case IDM_STOPCONV:
		WinDdePostMsg( hwndDDEserver, hwnd, WM_DDE_TERMINATE, NULL, TRUE );
		menuState = MENU_STARTCONV;
		hwndDDEserver = (HWND) NULL;
		WinSetWindowText( hwndFrame, "DDE Client - Not Connected" );
		fConnected = FALSE;
		usAdvise = 0;
		return 0;

	    case IDM_REQUEST:
		if ( WinDlgBox(HWND_DESKTOP,
			hwndFrame,
			(PFNWP) GetDlgProc,
                        0,
                        IDD_GET_ITEM,
                        NULL) )
		{
//		    if a conversation on the System topic is esablished,
//		    issuing a request causes the current status to be retrieved

		    pdde = MakeDDEDataSeg( itemFormat, itemName, NULL, 0, 0 );
		    if ( pdde )
		    {
			WinDdePostMsg( hwndDDEserver, hwnd, WM_DDE_REQUEST, pdde, TRUE );
			usItem = IDM_REQUEST;
		    }
		    else
		    {
			WinAlarm( HWND_DESKTOP, WA_ERROR );
			WinSetWindowText( hwndFrame, "...MakeDDEDataSeg() failed.." );
			break;
		    }
		}
		return 0;

	    case IDM_TRIGCHN:
		if ( WinDlgBox(HWND_DESKTOP,
			hwndFrame,
			(PFNWP) DialogProc,
                        0,
                        IDD_ITEM,
                        NULL) )
		{
//		    if a conversation on the System topic is esablished,
//		    issuing a request causes the current status to be retrieved

		    pdde = MakeDDEDataSeg( CF_TEXT, itemName, NULL, 0, 0 );
		    if (pdde)
		    {
			WinDdePostMsg( hwndDDEserver, hwnd, WM_DDE_EXECUTE, pdde, TRUE );
			usItem = IDM_TRIGCHN;
		    }
		    else
		    {
			WinAlarm( HWND_DESKTOP, WA_ERROR );
			WinSetWindowText( hwndFrame, "...MakeDDEDataSeg() failed.." );
			break;
		    }
		}
		return 0;

	    case IDM_ALARM:
		if ( WinDlgBox(HWND_DESKTOP,
			hwndFrame,
			(PFNWP) AlarmProc,
			0,
			IDD_ALARM,
			NULL) )
		{
		    struct alarm_param_s {
			    USHORT	state;
			    char	data[ 64 ];
		    }	args;
		    args.state = itemState;
		    strcpy( args.data, itemData );
//		    if a conversation on the System topic is esablished,
//		    issuing a request causes the current status to be retrieved

		    pdde = MakeDDEDataSeg( atomIS2, itemName,
					   &args, strlen(args.data)+sizeof(USHORT)+1, 0 );
		    if (pdde)
		    {
			WinDdePostMsg( hwndDDEserver, hwnd,
				       WM_DDE_EXECUTE, pdde, TRUE );
			usItem = IDM_POKE;
		    }
		    else
		    {
			WinAlarm( HWND_DESKTOP, WA_ERROR );
			WinSetWindowText( hwndFrame,
					  "...MakeDDEDataSeg() failed.." );
			break;
		    }
		}
		return 0;

	    case IDM_POKE:
		if ( WinDlgBox(HWND_DESKTOP,
			hwndFrame,
			(PFNWP) PokeDlgProc,
			0,
			IDD_PUT_ITEM,
			NULL) )
		{
//		    if a conversation on the System topic is esablished,
//		    issuing a request causes the current status to be retrieved

		    pdde = MakeDDEDataSeg( itemFormat, itemName,
					   itemData, strlen(itemData), 0 );
		    if ( pdde )
		    {
			WinDdePostMsg( hwndDDEserver, hwnd, WM_DDE_POKE, pdde, TRUE );
			usItem = IDM_POKE;
		    }
		    else
		    {
			WinAlarm( HWND_DESKTOP, WA_ERROR );
			WinSetWindowText( hwndFrame, "...MakeDDEDataSeg() failed.." );
			break;
		    }
		}
		return 0;

	    case IDM_ADVISE:
		if ( WinDlgBox(HWND_DESKTOP,
			hwndFrame,
			(PFNWP) GetDlgProc,
			0,
			IDD_GET_ITEM,
			NULL) )
		{
		    pddeOut = MakeDDEDataSeg( itemFormat, itemName, NULL, 0, DDE_FACKREQ);
		    if (pddeOut)
		    {
			WinDdePostMsg( hwndDDEserver, hwnd,
				       WM_DDE_ADVISE, pddeOut, TRUE );
			WinSetWindowText( hwndFrame,
					  "DDE Client - sent hot link request" );
		    }
		    usItem = IDM_ADVISE;                   /* set state to advise */
		}
		break;

	    case IDM_ENDADVISE:
		if ( WinDlgBox(HWND_DESKTOP,
			hwndFrame,
			(PFNWP) DialogProc,
			0,
			IDD_ITEM,
			NULL) )
		{
		    pddeOut = MakeDDEDataSeg( itemFormat, itemName, NULL, 0, DDE_FACKREQ );
		    if ( pddeOut )
		    {
			WinDdePostMsg( hwndDDEserver, hwnd,
				       WM_DDE_UNADVISE, pddeOut, TRUE );
			WinSetWindowText( hwndFrame, "DDE Client - sent hot link terminate request" );
			usItem = IDM_ENDADVISE;
		    }
		}
		break;
	    }
	    break; /* wm_command */

	case WM_PAINT:
	    PaintWindow( hwnd, szMsg );
	    return 0;

	case WM_CLOSE:
	    loadFormat( FALSE );
	    if ( hwndDDEserver )
		WinDdePostMsg( hwndDDEserver, hwnd, WM_DDE_TERMINATE, NULL, TRUE );
	    WinPostMsg( hwnd, WM_QUIT, 0L, 0L );
	    return 0;

	case WM_ERASEBACKGROUND:
	    return (MRESULT) 1;
	}

	return WinDefWindowProc( hwnd, msg, mp1, mp2 );
}


int
main()
{
	HAB	hab = WinInitialize( 0 );
	HMQ	hmq = WinCreateMsgQueue( hab, 0 );
	HWND	hwndClient;
	QMSG	qmsg;
	ULONG	flCreate = FCF_STANDARD;

	WinRegisterClass(
		hab,
		"MyWindow",
		(PFNWP) MyWindowProc,
		CS_SIZEREDRAW,
		0
	);

	hwndFrame = WinCreateStdWindow(
			HWND_DESKTOP,
			WS_VISIBLE,
			&flCreate,
			"MyWindow",
			"",
			0L,
			(HMODULE) NULL,
			ID_MAINWND,
			&hwndClient
		    );

	if ( hwndFrame != (HWND) NULL )
	{
	    while ( WinGetMsg( hab, &qmsg, (HWND) NULL, 0, 0 ) )
		    WinDispatchMsg( hab, &qmsg );

	    WinDestroyWindow( hwndFrame );
	}

	WinDestroyMsgQueue( hmq );
	WinTerminate( hab );
}
