package Config;
require Exporter;
@ISA = (Exporter);
@EXPORT = qw(%Config);

$] == 5.001 or die sprintf
    "Perl lib version (5.001) doesn't match executable version (%.3f)\n", $];

# This file was created by configpm when Perl was built. Any changes
# made to this file will be lost the next time perl is built.

=head1 NAME

Config - access Perl configuration option

=head1 SYNOPSIS

    use Config;
    if ($Config{'cc'} =~ /gcc/) {
	print "built by gcc\n";
    } 

=head1 DESCRIPTION

The Config module contains everything that was available to the
C<Configure> program at Perl build time.  Shell variables from
F<config.sh> are stored in the readonly-variable C<%Config>, indexed by
their names.

=head1 EXAMPLE

Here's a more sophisticated example of using %Config:

    use Config;

    defined $Config{sig_name} || die "No sigs?";
    foreach $name (split(' ', $Config{sig_name})) {
	$signo{$name} = $i;
	$signame[$i] = $name;
	$i++;
    }   

    print "signal #17 = $signame[17]\n";
    if ($signo{ALRM}) { 
	print "SIGALRM is $signo{ALRM}\n";
    }   

=head1 NOTE

This module contains a good example of how to make a variable
readonly to those outside of it.  

=cut

##
## This file was produced by running the Configure script. It holds all the
## definitions figured out by Configure. Should you modify one of these values,
## do not forget to propagate your changes by running "Configure -der". You may
## instead choose to run each of the .SH files by yourself, or "Configure -S".
##
#
## Configuration time: Sat Dec 10 13:00:00 CET 1994
## Configured by: ak
## Target system: OS/2 2.11 - EMX 0.9
#
#
## AK's extensions
#

$config_sh=<<'!END!OF!CONFIG!';
dynamic_ext='Fcntl GDBM_File SDBM_File POSIX Socket OS2::UPM OS2::REXX OS2::FTP'
extensions='Fcntl GDBM_File SDBM_File POSIX Socket OS2::UPM OS2::REXX OS2::FTP'
static_ext=''
osname='OS/2'
osvers='2.11'
archlib='c:/usr/lib/perl5/os2'
ccflags='-Zomf'
cppflags='-DDOSISH -DOS2=2 -DEMBED -I. -Ios2'
intsize='4'
libpth='c:/usr/lib/emx h:/emx/lib'
sig_name='ZERO HUP INT QUIT ILL TRAP ABRT EMT FPE KILL BUS SEGV SYS PIPE ALRM TERM USR1 USR2 CHLD 19 20 BREAK'
so='dll'
sharpbang='extproc '
shsharp='false'
startsh='extproc ksh\\n#! sh'
Author=''
CONFIG='true'
Date='$Date'
Header=''
Id='$Id'
Locker=''
Log='$Log'
Mcc='Mcc'
PATCHLEVEL='0'
RCSfile='$RCSfile'
Revision='$Revision'
Source=''
State=''
afs='false'
alignbytes='8'
aphostname=''
archlibexp='c:/usr/lib/perl5/os2'
archname='os2'
awk='awk'
bash=''
bin='c:/usr/binp'
binexp='c:/usr/binp'
bison='bison'
byacc=''
byteorder='1234'
c='\c'
castflags='0'
cat='cat'
cc='gcc'
cccdlflags='-Zdll'
ccdlflags=''
cf_by='src'
cf_time='Sat Dec 10 13:00:00 CET 1994'
chgrp=''
chmod=''
chown=''
clocktype='clock_t'
compress='compress'
contains='grep'
cp='cp'
cpio='cpio'
cpp='cpp'
cpp_stuff='42'
cpplast=''
cppminus=''
cpprun='cpp'
cppstdin='cpp'
cryptlib=''
csh=''
d_Gconvert='sprintf((b),"%.*g",(n),(x))'
d_access='define'
d_alarm='define'
d_archlib='define'
d_attrib='define'
d_attribut='define'
d_bcmp='define'
d_bcopy='define'
d_bsdpgrp='undef'
d_bzero='define'
d_casti32='define'
d_castneg='define'
d_charsprf='undef'
d_charvspr='undef'
d_chown='undef'
d_chroot='undef'
d_chsize='define'
d_closedir='define'
d_const='define'
d_crypt='undef'
d_csh='undef'
d_cuserid='define'
d_dbl_dig='define'
d_difftime='define'
d_dirnamlen='undef'
d_dlerror='undef'
d_dlopen='undef'
d_dlsymun='undef'
d_dosuid='undef'
d_drem='undef'
d_dup2='define'
d_eunice='undef'
d_fchmod='undef'
d_fchown='undef'
d_fcntl='define'
d_fd_macros='define'
d_fd_set='define'
d_fds_bits='define'
d_fgetpos='define'
d_flexfnam='define'
d_flock='define'
d_fmod='define'
d_fork='undef'
d_fpathconf='define'
d_fsetpos='define'
d_getgrps='undef'
d_gethent='define'
d_gethname='undef'
d_getlogin='define'
d_getpgrp2='undef'
d_getpgrp='undef'
d_getppid='define'
d_getprior='define'
d_group='undef'
d_htonl='define'
d_index='undef'
d_isascii='define'
d_killpg='undef'
d_link='undef'
d_linuxstd='undef'
d_locconv='define'
d_lockf='undef'
d_lstat='undef'
d_mblen='define'
d_mbstowcs='define'
d_mbtowc='define'
d_memcmp='define'
d_memcpy='define'
d_memmove='define'
d_memset='define'
d_mkdir='define'
d_mkfifo='undef'
d_mktime='define'
d_msg='undef'
d_msgctl='undef'
d_msgget='undef'
d_msgrcv='undef'
d_msgsnd='undef'
d_mymalloc='define'
d_nice='undef'
d_oldsock='undef'
d_open3='define'
d_passwd='undef'
d_pathconf='define'
d_pause='define'
d_phostname='undef'
d_pipe='define'
d_portable='define'
d_pwage='undef'
d_pwchange='undef'
d_pwclass='undef'
d_pwcomment='undef'
d_pwexpire='undef'
d_pwquota='undef'
d_readdir='define'
d_readlink='undef'
d_rename='define'
d_rewinddir='define'
d_rmdir='define'
d_safebcpy='undef'
d_safemcpy='undef'
d_seekdir='define'
d_select='define'
d_sem='undef'
d_semctl='undef'
d_semget='undef'
d_semop='undef'
d_setegid='undef'
d_seteuid='undef'
d_setlinebuf='undef'
d_setlocale='define'
d_setpgid='undef'
d_setpgrp2='undef'
d_setpgrp='undef'
d_setprior='define'
d_setregid='undef'
d_setresgid='undef'
d_setresuid='undef'
d_setreuid='undef'
d_setrgid='undef'
d_setruid='undef'
d_setsid='undef'
d_shm='undef'
d_shmat='undef'
d_shmatprototype='undef'
d_shmctl='undef'
d_shmdt='undef'
d_shmget='undef'
d_sitelib='undef'
d_socket='define'
d_sockpair='undef'
d_statblks='undef'
d_stdiobase='undef'
d_stdstdio='undef'
d_strchr='define'
d_strcoll='define'
d_strctcpy='define'
d_strerrm='strerror(e)'
d_strerror='define'
d_strxfrm='define'
d_suidsafe='undef'
d_symlink='undef'
d_syscall='undef'
d_sysconf='define'
d_sysernlst=''
d_syserrlst='define'
d_system='define'
d_tcgetpgrp='define'
d_tcsetpgrp='define'
d_telldir='define'
d_time='define'
d_times='define'
d_truncate='define'
d_tzname='define'
d_umask='define'
d_uname='define'
d_vfork='undef'
d_void_closedir='define'
d_voidsig='define'
d_voidtty=''
d_volatile='define'
d_vprintf='define'
d_wait4='undef'
d_waitpid='define'
d_wcstombs='define'
d_wctomb='define'
d_xenix='undef'
date=''
defvoidused='15'
direntrytype='struct dirent'
dirsep='\'
dlext='dll'
dlsrc='dl_os2.xs'
echo=''
egrep='egrep'
emacs=''
eunicefix=':'
exeext='.exe'
expr='expr'
find='find'
flex='flex'
fpostype='fpos_t'
freetype='void'
gcc='gcc'
gccversion='2.6.3'
gidtype='gid_t'
glibpth='c:/usr/lib/emx h:/emx/lib'
grep='grep'
groupcat=''
groupstype='gid_t'
h_fcntl='true'
h_sysfile='true'
hint='recommended'
hostcat=''
huge=''
i_bsdioctl=''
i_db='undef'
i_dbm='undef'
i_dirent='define'
i_dld='undef'
i_dlfcn='undef'
i_fcntl='define'
i_float='define'
i_gdbm='define'
i_grp='undef'
i_limits='define'
i_malloc='define'
i_math='define'
i_memory='undef'
i_ndbm='undef'
i_neterrno='undef'
i_niin='define'
i_pwd='undef'
i_sgtty='undef'
i_stdarg='define'
i_stddef='define'
i_stdlib='define'
i_string='define'
i_sysdir='define'
i_sysfile='define'
i_sysfilio='undef'
i_sysin='undef'
i_sysioctl='define'
i_sysndir='undef'
i_sysparam='define'
i_sysselct='define'
i_syssockio=''
i_sysstat='define'
i_systime='define'
i_systimek='undef'
i_systimes='define'
i_systypes='define'
i_sysutime='undef'
i_termio='undef'
i_termios='define'
i_time='define'
i_unistd='define'
i_utime='undef'
i_varargs='undef'
i_varhdr='stdarg.h'
i_vfork='undef'
incpath=''
inews=''
installarchlib='c:/usr/lib/perl5/os2'
installbin='c:/usr/binp'
installmansrc='/usr/local/man/man1'
installprivlib=''
installscript=''
known_extensions='DB_File Fcntl GDBM_File NDBM_File ODBM_File POSIX SDBM_File Socket UPM REXXCALL'
ksh=''
large=''
lddlflags='-Zdll'
ldflags='-Zomf'
less=''
libc=''
libs='-lm -lbsd'
libswanted='net socket inet nsl nm ndbm gdbm dbm db malloc dl dld ld sun m c cposix posix ndir dir crypt ucb bsd BSD PW x'
line=''
lint=''
lkflags=''
ln=''
lns=''
lp=''
lpr=''
ls='ls'
lseektype='off_t'
mail='mail'
mailx=''
make='dmake'
mallocobj=''
mallocsrc=''
malloctype='void *'
manext='1'
mansrc='/usr/local/man/man1'
mansrcexp='/usr/local/man/man1'
medium=''
mips=''
mips_type=''
mkdir='mkdir'
models='none'
modetype='mode_t'
more='more'
mv='mv'
mydomain='s.bawue.de'
myhostname='ananke'
myuname='OS/2 2.11 - EMX 0.9'
n=''
nm_opt='-p'
nroff=''
optimize='-O'
orderlib='false'
package='perl5'
passcat=''
pathsep='\;'
perl='perl5'
pg='pg'
phostname='hostname'
plibpth=''
pmake=''
pr='pr'
prefix='c:/usr'
privlib='c:/local/lib/perl5'
privlibexp='c:/local/lib/perl5'
prototype='define'
randbits='15'
ranlib='ar s'
rm='rm'
rmail=''
runnm='true'
scriptdir='c:/usr/binp'
scriptdirexp='c:/usr/binp'
sed='sed'
selecttype='fd_set *'
sendmail=''
sh=''
shar=''
shmattype=''
signal_t='void'
sizetype='size_t'
sleep='sleep'
smail=''
small=''
sockethdr=''
socketlib='-lsocket'
sort='sort'
spackage=''
spitshell='cat'
split=''
ssizetype='ssize_t'
stdchar='char'
strings='/usr/include/string.h'
submit=''
sysman='/usr/man/man1'
tail=''
tar='tar'
tbl=''
test=''
timeincl=''
timetype='time_t'
touch='touch'
tr=''
troff=''
uidtype='uid_t'
uname=''
uniq=''
usedl='define'
usemymalloc='y'
usenm='true'
useposix='true'
usevfork='false'
usrinc='c:/usr/inc'
uuname=''
vi=''
voidflags='15'
xlibpth=''
yacc='yacc'
yaccflags=''
zcat='zcat'
!END!OF!CONFIG!


tie %Config, Config;
sub TIEHASH { bless {} }
sub FETCH { 
    # check for cached value (which maybe undef so we use exists not defined)
    return $_[0]->{$_[1]} if (exists $_[0]->{$_[1]});
 
    my($value); # search for the item in the big $config_sh string
    return undef unless (($value) = $config_sh =~ m/^$_[1]='(.*)'\s*$/m);
 
    $value = undef if $value eq 'undef'; # So we can say "if $Config{'foo'}".
    $_[0]->{$_[1]} = $value; # cache it
    return $value;
}
 
sub FIRSTKEY {
    $prevpos = 0;
    my $key;
    ($key) = $config_sh =~ m/^(.*)=/;
    $key;
}

sub NEXTKEY {
    my ($pos, $len);
    $pos = $prevpos;
    $pos = index( $config_sh, "\n", $pos) + 1;
    $prevpos = $pos;
    $len = index( $config_sh, "=", $pos) - $pos;
    $len > 0 ? substr( $config_sh, $pos, $len) : undef;
}

sub EXISTS{ 
     exists($_[0]->{$_[1]})  or  $config_sh =~ m/^$_[1]=/m; 
}

sub readonly { die "\%Config::Config is read-only\n" }

sub myconfig {
	my($output);
	
	$output = <<'END';
Summary of my $package (patchlevel $PATCHLEVEL) configuration:
  Platform:
    osname=$osname, osver=$osvers, archname=$archname
    uname='$myuname'
    hint=$hint
  Compiler:
    cc='$cc', optimize='$optimize'
    cppflags='$cppflags'
    ccflags ='$ccflags'
    ldflags ='$ldflags'
    stdchar='$stdchar', d_stdstdio=$d_stdstdio, usevfork=$usevfork
    voidflags=$voidflags, castflags=$castflags, d_casti32=$d_casti32, d_castneg=$d_castneg
    intsize=$intsize, alignbytes=$alignbytes, usemymalloc=$usemymalloc, randbits=$randbits
  Libraries:
    so=$so
    libpth=$libpth
    libs=$libs
    libc=$libc
  Dynamic Linking:
    dlsrc=$dlsrc, dlext=$dlext, d_dlsymun=$d_dlsymun
    cccdlflags='$cccdlflags', ccdlflags='$ccdlflags', lddlflags='$lddlflags'

END
	$output =~ s/\$(\w+)/$Config{$1}/ge;
	$output;
}

sub STORE { &readonly }
sub DELETE{ &readonly }
sub CLEAR { &readonly }


1;
