#include <signal.h>

/* HAS_IOCTL:
 *	This symbol, if defined, indicates that the ioctl() routine is
 *	available to set I/O characteristics
 */
#ifdef __EMX__
#define	HAS_IOCTL		/**/
#endif
 
/* HAS_UTIME:
 *	This symbol, if defined, indicates that the routine utime() is
 *	available to update the access and modification times of files.
 */
#define HAS_UTIME		/**/

#ifndef __IBMC__
#define HAS_KILL
#endif
#define HAS_WAIT

#ifndef SIGABRT
#    define SIGABRT SIGILL
#endif
#ifndef SIGILL
#    define SIGILL 6         /* blech */
#endif

#ifdef __IBMC__
#define ABORT() abort();
#else
#define ABORT() kill(getpid(),SIGABRT);
#endif

/*
 * fwrite1() should be a routine with the same calling sequence as fwrite(),
 * but which outputs all of the bytes requested as a single stream (unlike
 * fwrite() itself, which on some systems outputs several distinct records
 * if the number_of_items parameter is >1).
 */
#define fwrite1 fwrite

#define my_getenv(var) getenv(var)

/*****************************************************************************/

#ifdef __EMX__

#include <stdlib.h>	/* before the following definitions */
#include <unistd.h>	/* before the following definitions */

#define chdir	_chdir2
#define getcwd	_getcwd2

#define OS2_STAT_HACK 1

#else /* __IBMC__ */

#define __EXTENDED__

#include <fcntl.h>
#include <io.h>
#include <direct.h>
#include <process.h>

#define mkdir(x,y) _mkdir(x)

#define OS2_STAT_HACK 0

#endif /* __IBMC__ */

#define OP_BINARY O_BINARY


#if OS2_STAT_HACK

#define Stat(fname,bufptr) os2_stat((fname),(bufptr))
#define Fstat(fd,bufptr)   fstat((fd),(bufptr))

#undef S_IFBLK
#undef S_ISBLK
#define S_IFBLK		0120000
#define S_ISBLK(mode)	(((mode) & S_IFMT) == S_IFBLK)

#else

#define Stat(fname,bufptr) stat((fname),(bufptr))
#define Fstat(fd,bufptr)   fstat((fd),(bufptr))

#endif

