# MODE=exe: plain EMX exe for fork().

CC	= gcc
OPTIM	= -O2 -m486 -fomit-frame-pointer
# DEBUG	= -g
D	=

CFLAGS	= $(OPTIM) $(DEBUG) -DEMBED -DDOSISH -DOS2=2 -I. -Ios2 $D
LDFLAGS	= $(OPTIM) $(DEBUG)
LDLIBS	= -lx -lsocket -lm -lbsd

.IF $O == .obj
  CFLAGS  += -Zomf
  LDFLAGS += -Zomf -Zcrtdll -Zstack 384
  TARGETS = perl5.exe perl5.dll perl5.lib
  REXX    = os2rexx.obj
.ELSE
  CFLAGS  += -DHAS_FORK
  TARGETS = perl5x.exe
  REXX    =
.END

modules	   = Fcntl GDBM_File SDBM_File POSIX Socket
os2modules = UPM REXX FTP

mallocobj = malloc$O
obj1 = $(mallocobj) gv$O toke$O perly$O op$O regcomp$O dump$O util$O mg$O
obj2 = hv$O av$O run$O pp_hot$O sv$O pp$O scope$O pp_ctl$O pp_sys$O
obj3 = doop$O doio$O regexec$O taint$O deb$O perl$O os2$O globals$O
objs = $(obj1) $(obj2) $(obj3)

exts = DynaLoader$O
extsx = Socket$O POSIX$O
extsd = DynaLoader$O REXX$O

.IF $(OPTIM) == $(NULL)
  SUFFIX = d
  CFLAGS += -DDEBUGGING
.ELSE
  SUFFIX =
.END

.SOURCE.c : os2 ext/DynaLoader ext/OS2/REXX ext/Socket ext/POSIX
.SOURCE$O : obj$(SUFFIX)

all  : config.h preplibrary $(TARGETS) lib/Config.pm modules os2modules
mini : miniperl.exe
exe  : perl5x.exe
dbg  : perl5d.exe

.IF $O == .obj
miniperl.exe miniperl.map .UPDATEALL : miniperlmain$O $(objs)
	$(CC) $(LDFLAGS) $< $(LDLIBS) -Zmap -Zlinker /map -Zlinker /exepack:2 -o $@
.END

perl5.exe : os2main$O perl5.lib
	$(CC) $(LDFLAGS) $< -o $@

perl5x.exe : os2main$O $(objs) $(extsx)
	$(CC) $(LDFLAGS) $< $(LDLIBS) -o perl5x
	emxbind -b -s perl5x

perl5d.exe : os2main2$O $(objs) $(extsd)
	$(CC) $(LDFLAGS) $< $(LDLIBS) -Zmap -Zlinker /map -o $@

perl5.dll : $(objs) $(exts) $(REXX) perl5.def
	$(CC) $(LDFLAGS) -Zdll $< $(LDLIBS) -o $@

perl5.lib : perl5.def
	implib /noign $@ perl5.def

perl5.def : os2/perl5hdr.def miniperl.map os2/mkdef.pl
	echo LIBRARY 'Perl5' INITINSTANCE TERMINSTANCE >$@
	cat os2/perl5hdr.def >>$@
	.\miniperl -n os2/mkdef.pl miniperl.map | sort -u - >>$@

preplibrary : miniperl.exe lib/Config.pm config.sh
	-mkdir lib/auto
	@echo "	AutoSplitting perl library"
	find lib -name "*.pm" ! -name "REXX.pm" -print >tmp
	.\miniperl -Ilib -e "use AutoSplit; autosplit_lib_modules(@ARGV)" @tmp
	-$(RM) $(RMFLAGS) tmp

config.h : config.sh
	ksh config_h.sh

lib/Config.pm : config.sh miniperl.exe
	.\miniperl.exe configpm

os2main2$O : os2main.c
	$(CC) $(CFLAGS) -DSTATIC $? -c -o $@

DynaLoader.c .SETDIR=ext/DynaLoader : dl_os2.xs
	..\..\miniperl ../../lib/ExtUtils/xsubpp dl_os2.xs > DynaLoader.c

modules :
	cmd /c "for %x in ($(modules)) do call os2\ext %x"
os2modules :
	cmd /c "for %x in ($(os2modules)) do call os2\ext2 OS2 %x"

#############################################################################

install :
	-cp -t perl5.exe perl5.dll perl5x.exe os2/h2xs.cmd $(ROOTDIR)/usr/binp
	-cp -t perl5.exe $(ROOTDIR)/usr/binp/perl.exe
