#
# Expects:
#	TOP		Perl5 top level directory
#	PREFIX		Optional module name prefix
#	EXT		Module name, set in command line
#	EXTLIBS=...	optional libraries for EXT
#

TOP	= ../..
PREFIX	=
PERL	= $(TOP)/miniperl

CC	= gcc
OPTIM	= -O2
DEBUG	=

CFLAGS	= $(OPTIM) $(DEBUG) -Zomf -I$(TOP) -DEMBED
LDFLAGS	= $(OPTIM) $(DEBUG) -Zomf -Zdll -Zcrtdll
LDLIBS	= $(EXTLIBS) $(TOP)/perl5.lib

.IF $(PREFIX)
  AUTO  = $(TOP)/lib/auto/$(PREFIX)/$(EXT)
  PM	= lib/$(PREFIX)/$(EXT).pm
.ELSE
  AUTO  = $(TOP)/lib/auto/$(EXT)
  PM	= lib/$(EXT).pm
.ENDIF

DLL	= $(AUTO)/$(EXT)_.dll
BOOT	= $(AUTO)/$(EXT).bs

.INCLUDE .IGNORE : $(TOP)/os2/$(EXT).mk

all : $(DLL) $(TOP)/$(PM) $(BOOT)

$(DLL) : $(EXT).obj $(EXT).def
[
	# truncate DLL name to 8 chars (for Warp)
	ext=`$(PERL) -e "'$(DLL)' =~ m'^.*/\w{{1,8}}' and print qq'$$&.dll';"`
	$(CC) $(LDFLAGS) $(EXT).obj $(EXT).def $(LDLIBS) -o $$ext
	if [ $$ext != $@ -a -f $$ext ]
	then
		# create empty fullname DLL for make rules, won't load
		rm -f $@
		touch $@
	fi
	exit 0
]

$(BOOT) :
[
	$(PERL) -I$(TOP)/lib $(TOP)/ext/util/mkbootstrap
	touch $(EXT).bs
	cp -t $(EXT).bs $@
]

$(EXT).def : $(TOP)/os2/ext.mk
[
	# truncate library name to 8 chars (for Warp)
	$(PERL) <<END > $@
	printf "LIBRARY '%.7s_' INITINSTANCE TERMINSTANCE\n", $(EXT);
	printf "CODE LOADONCALL\nDATA LOADONCALL NONSHARED MULTIPLE\n";
	printf "EXPORTS\n boot_%s%s", ("$(PREFIX)" ? "$(PREFIX)__" : ""), $(EXT);
	exit 0;
END
]

$(EXT).c : $(EXT).xs
[
	if [ -f typemap ]
	then
		$(PERL) $(TOP)/lib/ExtUtils/xsubpp -typemap typemap $(EXT).xs > $@
	else
		$(PERL) $(TOP)/lib/ExtUtils/xsubpp $(EXT).xs > $@
	fi
]

cleanup :
	-$(RM) $(RMFLAGS) $(DLL) $(EXT).def $(EXT).c $(EXT).obj
