/******************************************************************************
*                                                                             *
*  File Name   : WRTSMDLG.C                                                   *
*                                                                             *
*  Description : Dialog functions for the WRTSAMPL.exe                        *
*                                                                             *
*  Function:  This file has all the dialog procedures for the wrtsampl.exe    *
*                                                                             *
*  Copyright (C) 1993 IBM Corporation                                         *
*                                                                             *
*      DISCLAIMER OF WARRANTIES.  The following [enclosed] code is            *
*      sample code created by IBM Corporation. This sample code is not        *
*      part of any standard or IBM product and is provided to you solely      *
*      for  the purpose of assisting you in the development of your           *
*      applications.  The code is provided "AS IS", without                   *
*      warranty of any kind.  IBM shall not be liable for any damages         *
*      arising out of your use of the sample code, even if they have been     *
*      advised of the possibility of such damages.                            *
*                                                                             *
*******************************************************************************/

#define INCL_DOS
#define INCL_PM
#define INCL_GPI
#define INCL_DOSMEMMGR
#define  INCL_WINLOAD
#define  INCL_DOSPROCESS
#define  INCL_DOSSEMAPHORES
#include <os2.h>
#include <stdlib.h>
#include <string.h>
#include <stdio.h>

#include <penpm.h>

#include "wrtsampl.h"

ULONG ulNumDevices;
CHAR aDeviceName[10][32];
SHORT index1, index2, index3;
HWND hwndCombo1, hwndCombo2, hwndCombo3;
LONG startvalue;
SHORT index;
/******************************************************************************/
/*     Display Dialogs                                                        */
/******************************************************************************/
/*******************************************************************************
*                                                                              *
* Function Name: QInpDevDlgProc                                                *
*                                                                              *
* Description :                                                                *
*                                                                              *
*   Displays the Query Input Device variable Pen for OS/2                      *
*                                                                              *
* Input:                                                                       *
*                                                                              *
* Output: Display the Query Input variable.                                    *
*                                                                              *
*******************************************************************************/
MRESULT EXPENTRY QInpDevDlgProc(HWND hwnd, ULONG msg, MPARAM mp1, MPARAM mp2)
{
  HWND hwnd_temp;

switch(msg)
{
  case WM_INITDLG:
    init_invar ( hwnd, 1 );
  return(FALSE);

 case WM_COMMAND:
    switch ( SHORT1FROMMP ( mp1 ) )
    {
       case EXIT:
           WinDismissDlg ( hwnd, EXIT );
           break;
    } /* endswitch */
 return ( FALSE );

 case WM_CONTROL:
    switch ( SHORT2FROMMP ( mp1 ) )
    {
       case CBN_ENTER:
         hwnd_temp = HWNDFROMMP ( mp2 );
         updatecntrl ( hwnd, 1, hwnd_temp );
       break;
    }  /* endswitch */
 return ( FALSE );
} /* endswitch */
return(WinDefDlgProc(hwnd, msg, mp1, mp2));
}
/*******************************************************************************
*                                                                              *
* Function Name: QInDevNDlgProc                                                *
*                                                                              *
* Description :                                                                *
*                                                                              *
*   Displays the Device names supported by each driver                         *
*                                                                              *
* Input:                                                                       *
*                                                                              *
* Output: Display the Device names supported by each driver.                   *
*                                                                              *
*******************************************************************************/
MRESULT EXPENTRY QInDevNDlgProc(HWND hwnd, ULONG msg, MPARAM mp1, MPARAM mp2)
{
  APIRET irc;
  CHAR cbuffer[MAXCBUFFER];
  ULONG aDeviceType[10];
  ULONG aDeviceID[10];
  HWND hwnd_temp;
  WNDPARAMS comboprams;
  INT i;

switch(msg)
{
 case WM_INITDLG:
  /****************************************************************************/
  /* Find out how many input driver there are                                 */
  /****************************************************************************/
  ulNumDrivers = 0L;
  irc = WrtEnumInputDrivers ( &ulNumDrivers, NULL );
  if ( irc != WRT_NO_ERROR )
  {
    DisplayError ( hwnd, irc );
  } else
  {
    if ( ulNumDrivers > 10L )
    {
      sprintf(cbuffer,"Too many drivers[%ld] for my ARRAY", ulNumDrivers );
      WinMessageBox( HWND_DESKTOP,
                     hwnd,
                     cbuffer,
                     NULL, 1, MB_OK );
    } else
    {
      if ( ulNumDrivers == 0L )
      {
        sprintf(cbuffer,"No drivers found" );
        WinMessageBox( HWND_DESKTOP,
                       hwnd,
                       cbuffer,
                       NULL, 1, MB_OK );
      } else
      {
        /**********************************************************************/
        /* get array of driver names                                          */
        /**********************************************************************/
        irc = WrtEnumInputDrivers ( &ulNumDrivers, szDriverName );
        if ( irc != WRT_NO_ERROR )
        {
          DisplayError ( hwnd, irc );
        } else
        {
          /********************************************************************/
          /* initialize the entries in the Drivers list box                   */
          /********************************************************************/
          hwndCombo1 = WinWindowFromID ( hwnd , wrtelc01 );

          for ( i= 0; i < ulNumDrivers ; i++ )
          {
            index1 = (SHORT) WinSendMsg ( hwndCombo1, LM_INSERTITEM,
                                 MPFROMSHORT ( LIT_END ),
                                 MPFROMP ( szDriverName[i] ) );
          } /* endfor */
          /********************************************************************/
          /* Set the first item on the list at the top.                       */
          /********************************************************************/
          index1 = 0;                         /* intialize the index to zeror */
          WinSendMsg ( hwndCombo1, LM_SETTOPINDEX, MPFROMSHORT ( index1 ), 0 );

          comboprams.fsStatus = WPM_TEXT;      /* change window text          */
          comboprams.cchText = sizeof ( szDriverName[index1] );  /* text size */
          comboprams.pszText = szDriverName[index1];         /*text to display*/
          WinSendMsg ( hwndCombo1, WM_SETWINDOWPARAMS,
                       &comboprams, 0 );

          /********************************************************************/
          /* Find out how many input device there are                         */
          /********************************************************************/
          ulNumDevices = 0L;
          irc = WrtQueryInputDeviceNames ( szDriverName[index1], &ulNumDevices,
                                           NULL, NULL, NULL );
          if ( irc != WRT_NO_ERROR )
          {
            DisplayError ( hwnd, irc );
          } else
          {
            if ( ulNumDevices > 10L )
            {
              sprintf(cbuffer,"Too many devices[%ld] Driver[%s] for my ARRAY",
                      ulNumDevices, szDriverName[index1] );
              WinMessageBox( HWND_DESKTOP,
                             hwnd,
                             cbuffer,
                             NULL, 1, MB_OK );
            } else
            {
              /****************************************************************/
              /* Get array of device names                                    */
              /****************************************************************/
              irc = WrtQueryInputDeviceNames ( szDriverName[index1],
                                               &ulNumDevices, aDeviceName,
                                               aDeviceType, aDeviceID );
              if ( irc != WRT_NO_ERROR )
              {
                DisplayError ( hwnd, irc );
              } else
              {
                /**************************************************************/
                /* initialize the entries in the list box                     */
                /**************************************************************/
                hwndCombo2 = WinWindowFromID ( hwnd , wrtelc02 );

                for ( i= 0; i < ulNumDevices ; i++ )
                {
                  index2 = (SHORT) WinSendMsg ( hwndCombo2, LM_INSERTITEM,
                                       MPFROMSHORT ( LIT_END ),
                                       MPFROMP ( aDeviceName[i] ) );
                } /* endfor */
                /**************************************************************/
                /* Set the first item on the list at the top.                 */
                /**************************************************************/
                index2 = 0;                     /* intialize the index to zeror */
                WinSendMsg ( hwndCombo2, LM_SETTOPINDEX,
                             MPFROMSHORT ( index2 ), 0 );

                comboprams.fsStatus = WPM_TEXT;      /* change window text    */
                comboprams.cchText = sizeof( aDeviceName[index2] );/*text size*/
                comboprams.pszText = aDeviceName[index2];    /*text to display*/
                WinSendMsg ( hwndCombo2, WM_SETWINDOWPARAMS,
                             &comboprams, 0 );
              } /* endif */
            } /* endif */
          } /* endif */
        } /* endif */
      } /* endif */
    } /* endif */
  } /* endif */
  return(FALSE);

 case WM_COMMAND:
         switch ( SHORT1FROMMP ( mp1 ) )
         {
            case EXIT:
                WinDismissDlg ( hwnd, EXIT );
                break;
         } /* endswitch */
 return ( FALSE );

 case WM_CONTROL:
    switch ( SHORT2FROMMP ( mp1 ) )
    {
       case CBN_ENTER:
         hwnd_temp = HWNDFROMMP ( mp2 );
         if ( hwnd_temp == hwndCombo1 )
         {
           /*******************************************************************/
           /* Get the Driver selected and find:                               */
           /* 1: devices supported by the driver                              */
           /*******************************************************************/
           /*******************************************************************/
           /* find the index of the selected item                             */
           /*******************************************************************/
           index1 = (SHORT)WinSendMsg ( hwndCombo1, LM_QUERYSELECTION, 0L, 0L );
           if ( index1 != LIT_NONE )
           {
             /*****************************************************************/
             /* get the name of the driver choosen.                           */
             /*****************************************************************/
             WinSendMsg ( hwndCombo1, LM_QUERYITEMTEXT,
                                  MPFROM2SHORT ( index1, 32 ),
                                  MPFROMP ( szDriverName[index1] ) );
             /*****************************************************************/
             /* Clear out the Devices list box and get the devices for the    */
             /* driver.                                                       */
             /*****************************************************************/
             WinSendMsg ( hwndCombo2, LM_DELETEALL,
                                  0L,
                                  0L );
             /*****************************************************************/
             /* Find out how many input device there are                      */
             /*****************************************************************/
             ulNumDevices = 0L;
             irc = WrtQueryInputDeviceNames ( szDriverName[index1],
                                              &ulNumDevices,
                                              NULL, NULL, NULL );
             if ( irc != WRT_NO_ERROR )
             {
               sprintf(cbuffer,"FAIL getting # Device Name Driver[%s] RET= %#x",
                    szDriverName[index1], irc );
               WinMessageBox( HWND_DESKTOP,
                              hwnd,
                              cbuffer,
                              NULL, 1, MB_OK );
             } else
             {
               if ( ulNumDevices > 10L )
               {
                 sprintf(cbuffer,"Too many devices[%ld] Driver[%s] for my ARRAY",
                         ulNumDevices, szDriverName[index1] );
                 WinMessageBox( HWND_DESKTOP,
                                hwnd,
                                cbuffer,
                                NULL, 1, MB_OK );
               } else
               {
                 /*************************************************************/
                 /* Get array of device names                                 */
                 /*************************************************************/
                 irc = WrtQueryInputDeviceNames ( szDriverName[index1],
                                                  &ulNumDevices, aDeviceName,
                                                  aDeviceType, aDeviceID );
                 if ( irc != WRT_NO_ERROR )
                 {
                   sprintf(cbuffer,"FAIL Device Name Driver[%s] RET= %#x",
                           szDriverName[i], irc );
                   WinMessageBox( HWND_DESKTOP,
                                  hwnd,
                                  cbuffer,
                                  NULL, 1, MB_OK );
                 } else
                 {
                   /***********************************************************/
                   /* initialize the entries in the list box                  */
                   /***********************************************************/
                   hwndCombo2 = WinWindowFromID ( hwnd , wrtelc02 );

                   for ( i= 0; i < ulNumDevices ; i++ )
                   {
                     index2 = (SHORT) WinSendMsg ( hwndCombo2, LM_INSERTITEM,
                                          MPFROMSHORT ( LIT_END ),
                                          MPFROMP ( aDeviceName[i] ) );
                   } /* endfor */
                   /***********************************************************/
                   /* Set the first item on the list at the top.              */
                   /***********************************************************/
                   index2 = 0;                /* intialize the index to zeror */
                   WinSendMsg ( hwndCombo2, LM_SETTOPINDEX,
                                MPFROMSHORT ( index2 ), 0 );

                   comboprams.fsStatus = WPM_TEXT;      /* change window text */
                   comboprams.cchText = sizeof ( aDeviceName[index2] );
                   /*text size*/
                   comboprams.pszText = aDeviceName[index2]; /*text to display*/
                   WinSendMsg ( hwndCombo2, WM_SETWINDOWPARAMS,
                                &comboprams, 0 );

                 } /* endif */
               } /* endif */
             } /* endif */
           } /* endif */
         } /* endif */
       break;
    }  /* endswitch */
 return ( FALSE );
} /* endswitch */
return(WinDefDlgProc(hwnd, msg, mp1, mp2));
}
/*******************************************************************************
*                                                                              *
* Function Name: SInpDevDlgProc                                                *
*                                                                              *
* Description :                                                                *
*                                                                              *
*   Set the Input Device variable Pen for OS/2                                 *
*                                                                              *
* Input:                                                                       *
*                                                                              *
* Output: Set the Input variable.                                              *
*                                                                              *
******************************************************************************/
MRESULT EXPENTRY SInpDevDlgProc(HWND hwnd, ULONG msg, MPARAM mp1, MPARAM mp2)
{
  APIRET irc;
  CHAR cbuffer[MAXCBUFFER];
  HWND hwnd_temp;
  INT i;
  INT cbox;

switch(msg)
{
 case WM_INITDLG:
         init_invar ( hwnd, 0 );
 return(FALSE);

 case WM_COMMAND:
         switch ( SHORT1FROMMP ( mp1 ) )
         {
           case EXIT:
             WinDismissDlg ( hwnd, EXIT );
             break;
           case SET:
             if ( index1 == LIT_NONE )
             {
               sprintf(cbuffer,"INDEX1 == LIT_NONE can not set value");
               WinMessageBox( HWND_DESKTOP,
                              hwnd,
                              cbuffer,
                              NULL, 1, MB_OK );
             } else
             {
               if ( index2 == LIT_NONE )
               {
                 sprintf(cbuffer,"INDEX2 == LIT_NONE can not set value");
                 WinMessageBox( HWND_DESKTOP,
                               hwnd,
                               cbuffer,
                               NULL, 1, MB_OK );
               } else
               {
                 if ( index3 == LIT_NONE )
                 {
                   sprintf(cbuffer,"INDEX3 == LIT_NONE can not set value");
                   WinMessageBox( HWND_DESKTOP,
                                  hwnd,
                                  cbuffer,
                                  NULL, 1, MB_OK );
                 } else
                 {
                   /*********************************************************/
                   /*Find the ID coresponding to the index                  */
                   /*********************************************************/
                   cbox = -1;
                   for ( i= 0; i < (PPMIDSIZE - 1); i++)
                   {
                     if ( ppmid[i].active )
                     {
                       if ( ++cbox == index3  )
                       {
                          break;
                       } /* endif */
                     } /* endif */
                   } /* endfor */
                   /*********************************************************/
                   /* Query the value of the spin button and put it in      */
                   /* ppmid[].value                                         */
                   /*********************************************************/
                   WinSendMsg ( WinWindowFromID ( hwnd, wrtelc04 )
                               ,SPBM_QUERYVALUE
                               ,MPFROMLONG ( &ppmid[i].value )
                               ,MPFROM2SHORT ( NULL, SPBQ_DONOTUPDATE )
                               );

                   /*********************************************************/
                   /* Write the Device ID value in to memory                */
                   /*********************************************************/
                   irc = WrtSetInputDeviceVariable ( szDriverName[index1],
                                                     aDeviceName[index2],
                                                     ppmid[i].ValueID,
                                                     ppmid[i].value,
                                                     0L,
                                                     NULL
                                                   );
                   if ( irc == WRT_NO_ERROR )
                   {
                     /*******************************************************/
                     /* Broadcast a post message to all descendants of      */
                     /* HWND_DESKTOP notifying which device variable got    */
                     /* changed so they can update if need be               */
                     /*******************************************************/
                     WinBroadcastMsg (
                                  HWND_DESKTOP,
                                  WM_WRT_SYSVALUECHANGED,
                                  (MPARAM)VT_PPMID,
                                  (MPARAM)ppmid[i].ValueID,
                                  BMSG_DESCENDANTS | BMSG_POST
                                  );
                   } /* endif */
                 } /* endif */
               } /* endif */
             } /* endif */
           break;
         } /* endswitch */
 return ( FALSE );

 case WM_CONTROL:
    switch ( SHORT2FROMMP ( mp1 ) )
    {
       case SPBN_UPARROW:
       case SPBN_DOWNARROW:
          /*********************************************************/
          /*Find the ID coresponding to the index                  */
          /*********************************************************/
          cbox = -1;
          for ( i= 0; i < (PPMIDSIZE - 1); i++)
          {
            if ( ppmid[i].active )
            {
              if ( ++cbox == index3  )
              {
                 break;
              } /* endif */
            } /* endif */
          } /* endfor */
          if ( ppmid[i].disable == 1 )
          {
             /*********************************************************/
             /* Query the value of the spin button and put it in      */
             /* ppmid[].value                                         */
             /*********************************************************/
             WinSendMsg ( WinWindowFromID ( hwnd, wrtelc04 )
                         ,SPBM_QUERYVALUE
                         ,MPFROMLONG ( &ppmid[i].value )
                         ,MPFROM2SHORT ( NULL, SPBQ_DONOTUPDATE )
                         );
             if ( ppmid[i].value == ppmid[i].minval ||
                  ppmid[i].value == ppmid[i].maxval  )
             {
               WinSendMsg ( WinWindowFromID ( hwnd, wrtelc04 ),
                           SPBM_OVERRIDESETLIMITS,
                           MPFROMLONG ( ppmid[i].maxval ),/* MAX*/
                           MPFROMLONG ( 0L ) /* MIN*/
                           );
             } else
             {
               if ( ppmid[i].value < ppmid[i].minval )
               {
                 WinSendMsg ( WinWindowFromID ( hwnd, wrtelc04 ),
                             SPBM_SETCURRENTVALUE,
                             MPFROMLONG ( 0L ),
                             0L
                             );
                 WinSendMsg ( WinWindowFromID ( hwnd, wrtelc04 ),
                             SPBM_OVERRIDESETLIMITS,
                             MPFROMLONG ( ppmid[i].maxval ),/* MAX*/
                             MPFROMLONG ( ppmid[i].minval ) /* MIN*/
                             );
               } /* endif */
             } /* endif */
          } /* endif */
          break;
       case CBN_ENTER:
         hwnd_temp = HWNDFROMMP ( mp2 );
         updatecntrl ( hwnd, 0, hwnd_temp );
       break;
    }  /* endswitch */
 return ( FALSE );
} /* endswitch */
return(WinDefDlgProc(hwnd, msg, mp1, mp2));
}
/*******************************************************************************
*                                                                              *
* Function Name: EnumDrvDlgProc                                                *
*                                                                              *
* Description :                                                                *
*                                                                              *
*   Displays the Enumiration of the Pen for OS/2 input drivers.                *
*                                                                              *
* Input:                                                                       *
*                                                                              *
* Output: Display the Enumiration of the Pen for OS/2 drivers.                 *
*                                                                              *
*******************************************************************************/
MRESULT EXPENTRY EnumDrvDlgProc(HWND hwnd, ULONG msg, MPARAM mp1, MPARAM mp2)
{
   INT i;

   switch(msg)
   {
      case WM_INITDLG:
        WinSendDlgItemMsg(hwnd,          /* Delete all items in the list box */
                          wrtelc01,
                          LM_DELETEALL,
                          0UL,
                          0UL);

        for ( i = 0; i < ulNumDrivers; i++ )
        {
              WinSendDlgItemMsg(hwnd,   /* put the Driver name to listbox */
                                wrtelc01,
                                LM_INSERTITEM,
                                MPFROM2SHORT( LIT_END, 0 ),
                                MPFROMP( szDriverName[i] )
                                );
        } /* endfor */
        return(FALSE);

      case WM_COMMAND:
         switch ( SHORT1FROMMP ( mp1 ) )
         {
            case EXIT:
                WinDismissDlg ( hwnd, EXIT );
         } /* endswitch */
         return ( FALSE );
   } /* endswitch */
   return(WinDefDlgProc(hwnd, msg, mp1, mp2));
}
/*******************************************************************************
*                                                                              *
* Function Name: RSysVlDlgProc                                                 *
*                                                                              *
* Description :                                                                *
*                                                                              *
*   Read a System values.                                                      *
*                                                                              *
* Input:                                                                       *
*                                                                              *
* Output: Read system values                                                   *
*                                                                              *
*******************************************************************************/
MRESULT EXPENTRY RSysVlDlgProc ( HWND hwnd, ULONG msg, MPARAM mp1, MPARAM mp2 )
{
  CHAR cbuffer[MAXCBUFFER];
  APIRET irc;
   switch(msg)
   {
     case WM_INITDLG:
        init_sysval( hwnd, 1 );
        return(FALSE);

     case WM_CONTROL:
        switch ( SHORT2FROMMP ( mp1 ) )
        {
           case CBN_ENTER:
            enter_sysval( hwnd, 1 );
            return ( FALSE );
        } /* endswitch */
     case WM_COMMAND:
        switch ( SHORT1FROMMP ( mp1 ) )
        {
            case EXIT:
               /***************************************************************/
               /* exit the dialog with out writing any system values.         */
               /***************************************************************/
               WinDismissDlg ( hwnd, EXIT );
               break;

            case READ:
               /***************************************************************/
               /* Read  the system value from Pen for OS/2 profile set memory */
               /***************************************************************/
               irc = WrtReadSysValue ( HWND_DESKTOP,
                                        qsvalue[index+1].valueid );
               if ( irc == WRT_NO_ERROR )
               {
                 /**********************************************************/
                 /* Broadcast a post message to all descendants of         */
                 /* HWND_DESKTOP notifying which system value got changed  */
                 /* so they can update if need be                          */
                 /**********************************************************/
                 WinBroadcastMsg (
                              HWND_DESKTOP,
                              WM_WRT_SYSVALUECHANGED,
                              (MPARAM)VT_PPMSV,
                              (MPARAM)qsvalue[index+1].valueid,
                              BMSG_DESCENDANTS | BMSG_POST
                              );
               } else
               {
                 DisplayError ( hwnd, irc );
               } /* endif */
               /***************************************************************/
               /* get the sytem value to change                               */
               /***************************************************************/
               startvalue = WrtQuerySysValue ( HWND_DESKTOP,
                                          qsvalue[index+1].valueid );

               /***************************************************************/
               /* initialize all the entry field to the system value that was */
               /* query. If the query reutrn an error (WRTERR_INVALID_PARM)   */
               /* set the entry field to zerro.                               */
               /***************************************************************/
               if ( startvalue == WRTERR_INVALID_PARM )
               {
                 startvalue = 0L;
               } /* endif */

               /***************************************************************/
               /* Set the entry field value to the value that was query from  */
               /* the system.                                                 */
               /***************************************************************/
               sprintf ( cbuffer, "%li", startvalue);
               WinSetDlgItemText ( hwnd, wrtelc02, cbuffer );
               break;
        } /* endswitch */
        return ( FALSE );
   } /* endswitch */
   return ( WinDefDlgProc(hwnd, msg, mp1, mp2) );
}
/*******************************************************************************
*                                                                              *
* Function Name: WSysVlDlgProc                                                 *
*                                                                              *
* Description :                                                                *
*                                                                              *
*   Displays and Write   System values.                                        *
*                                                                              *
* Input:                                                                       *
*                                                                              *
* Output: Write a     system values                                            *
*                                                                              *
*******************************************************************************/
MRESULT EXPENTRY WSysVlDlgProc ( HWND hwnd, ULONG msg, MPARAM mp1, MPARAM mp2 )
{
  APIRET irc;
   switch(msg)
   {
     case WM_INITDLG:
        init_sysval( hwnd, 0 );
        return(FALSE);

     case WM_CONTROL:
        switch ( SHORT2FROMMP ( mp1 ) )
        {
           case SPBN_UPARROW:
           case SPBN_DOWNARROW:
              updwn_sysval ( hwnd );
           break;
           case CBN_ENTER:
            enter_sysval( hwnd, 0 );
            return ( FALSE );
        } /* endswitch */
     case WM_COMMAND:
        switch ( SHORT1FROMMP ( mp1 ) )
        {
            case EXIT:
               /***************************************************************/
               /* exit the dialog with out writing any system values.         */
               /***************************************************************/
               WinDismissDlg ( hwnd, EXIT );
               break;
            case SET:
               set_sysval ( hwnd );

               /***************************************************************/
               /* Write the system value from memory to Pen for OS/2 profile  */
               /***************************************************************/
               irc = WrtWriteSysValue ( HWND_DESKTOP,
                                        qsvalue[index+1].valueid );
               DisplayError ( hwnd, irc );

               break;
        } /* endswitch */
        return ( FALSE );
   } /* endswitch */
   return ( WinDefDlgProc(hwnd, msg, mp1, mp2) );
}
/*******************************************************************************
*                                                                              *
* Function Name: SSysVlDlgProc                                                 *
*                                                                              *
* Description :                                                                *
*                                                                              *
*   Displays and set the System values.                                        *
*                                                                              *
* Input:                                                                       *
*                                                                              *
* Output: Set     the system values                                            *
*                                                                              *
*******************************************************************************/
MRESULT EXPENTRY SSysVlDlgProc ( HWND hwnd, ULONG msg, MPARAM mp1, MPARAM mp2 )
{
   switch(msg)
   {
      case WM_INITDLG:
        init_sysval( hwnd, 0 );
        return(FALSE);

     case WM_CONTROL:
        switch ( SHORT2FROMMP ( mp1 ) )
        {
           case SPBN_UPARROW:
           case SPBN_DOWNARROW:
              updwn_sysval ( hwnd );
           break;
           case CBN_ENTER:
            enter_sysval( hwnd, 0 );
            return ( FALSE );
        } /* endswitch */
     case WM_COMMAND:
        switch ( SHORT1FROMMP ( mp1 ) )
        {
            case EXIT:
               /***************************************************************/
               /* exit the dialog with out writing any system values.         */
               /***************************************************************/
               WinDismissDlg ( hwnd, EXIT );
               break;
            case SET:
               set_sysval ( hwnd );
               break;
        } /* endswitch */
        return ( FALSE );
   } /* endswitch */
   return ( WinDefDlgProc(hwnd, msg, mp1, mp2) );
}

/******************************************************************************
*                                                                             *
* Function Name: SysValDlgProc                                                *
*                                                                             *
* Description :                                                               *
*                                                                             *
*   Displays the System Values                                                *
*                                                                             *
* Input:                                                                      *
*                                                                             *
* Output: Display the system values                                           *
*                                                                             *
******************************************************************************/
MRESULT EXPENTRY SysValDlgProc ( HWND hwnd, ULONG msg, MPARAM mp1, MPARAM mp2 )
{
  CHAR cbuffer[MAXCBUFFER];
  CHAR cname[30], cvalue[15];
  INT i;
   switch(msg)
   {
        case WM_INITDLG:
            for (i=0; i< QSVALUESIZE ; i++)
            {
              qsvalue[i].value = WrtQuerySysValue ( HWND_DESKTOP,
                                         qsvalue[i].valueid );

              if ( qsvalue[i].value == WRTERR_INVALID_PARM )
              {
                sprintf ( cvalue, "%15s","Invalid Parm" );
              } else
              {
                sprintf ( cvalue, "%05li", qsvalue[i].value );
              } /* endif */

              sprintf ( cname, "%-30s", qsvalue[i].valname );
              sprintf ( cbuffer, "%-30.30s%-15.15s", cname, cvalue );
              WinSendDlgItemMsg(hwnd,
                                wrtelc01,
                                LM_INSERTITEM,
                                MPFROM2SHORT(LIT_END, 0),
                                MPFROMP( cbuffer ) );
            } /* endfor */
        return(FALSE);
     case WM_COMMAND:
        switch ( SHORT1FROMMP ( mp1 ) )
        {
           case EXIT:
               WinDismissDlg ( hwnd, EXIT );
        } /* endswitch */
        return ( FALSE );
   }
   return(WinDefDlgProc(hwnd, msg, mp1, mp2));
}

/*******************************************************************************
*                                                                              *
* Function Name: ButCapDlgProc                                                 *
*                                                                              *
* Description :                                                                *
*                                                                              *
*   Displays the capabilities of the Buttons                                   *
*                                                                              *
* Input:                                                                       *
*                                                                              *
* Output: Display the capabilities of the system                               *
*                                                                              *
*******************************************************************************/
MRESULT EXPENTRY ButCapDlgProc ( HWND hwnd, ULONG msg, MPARAM mp1, MPARAM mp2 )
{
  CHAR cbuffer[MAXCBUFFER];
  WRTBUTTONDEVINFO bcInfo;
  ULONG ulButtonID;
  ULONG ulButTmp;
  WNDPARAMS comboprams;
  APIRET irc;
   switch(msg)
   {
        case WM_INITDLG:
          /********************************************************************/
          /*  Find out how many buttons the system has by querying the        */
          /*  button capabilities API with ulButtonID = 0L.                   */
          /*  The API will write the number of button IDs in the system in    */
          /*  the variable ulButtonID.                                        */
          /********************************************************************/
          ulButtonID = 0L;
          irc = WrtQueryButtonCaps ( &ulButtonID, NULL );
          if ( irc != WRT_NO_ERROR )
          {
            /******************************************************************/
            /* ERROR from API                                                 */
            /******************************************************************/
            DisplayError ( hwnd, irc );
          } else
          {
            /******************************************************************/
            /* Find out if return greater than zero buttons                   */
            /******************************************************************/
            if ( ulButtonID == 0L )
            {
              WinMessageBox( HWND_DESKTOP,
                              hwnd,
                              "WrtQueryButtonCaps return 0 buttons",
                              NULL, 1, MB_OK );
            } else
            {
              /****************************************************************/
              /* Got some locator to display                                  */
              /****************************************************************/
              hwndCombo1 = WinWindowFromID ( hwnd, wrtelc05 );
              for ( ulButTmp = 1L; ulButTmp <= ulButtonID; ulButTmp++ )
              {
                /**************************************************************/
                /* The cbStructureSize variable in the WRTBUTTONDEVINFO       */
                /* structure must be initialize to the size of the            */
                /* WRTBUTTONDEVINFO structure before querying the button      */
                /* capabilities.                                              */
                /**************************************************************/
                bcInfo.cbStructSize = sizeof ( bcInfo );

                /**************************************************************/
                /* ulButTmp   variable has the ID of the button that you      */
                /* want to query                                              */
                /**************************************************************/
                irc = WrtQueryButtonCaps ( &ulButTmp, &bcInfo );

                if ( irc == WRT_NO_ERROR )
                {
                  /************************************************************/
                  /*  good return from API                                    */
                  /************************************************************/
                  sprintf ( cbuffer, "%s %s",
                            bcInfo.pszDriverName, bcInfo.pszDeviceName );
                  index1 = (SHORT) WinSendMsg ( hwndCombo1, LM_INSERTITEM,
                                    MPFROMSHORT ( LIT_END ),
                                    MPFROMP ( cbuffer ) );
                } else
                {
                  /************************************************************/
                  /* ERROR from API                                           */
                  /************************************************************/
                  DisplayError ( hwnd, irc );
                } /* endif */
              } /* endfor */
              /****************************************************************/
              /* Set the last  item on the list at the top.                   */
              /****************************************************************/
              WinSendMsg ( hwndCombo1, LM_SETTOPINDEX,
                           MPFROMSHORT ( index1 ), 0 );

              comboprams.fsStatus = WPM_TEXT;           /* change window text */
              comboprams.cchText = sizeof ( cbuffer );  /* text size          */
              comboprams.pszText = cbuffer ;            /* text to display    */
              WinSendMsg ( hwndCombo1, WM_SETWINDOWPARAMS, &comboprams, 0 );

              disp_butcaps ( hwnd, &bcInfo );

            } /* endif */
          } /* endif */

        return(FALSE);
     case WM_CONTROL:
        switch ( SHORT2FROMMP (mp1) )
        {
           case CBN_ENTER:
             /*****************************************************************/
             /* find the index of the selected item                           */
             /*****************************************************************/
             index1 = (SHORT)WinSendMsg ( hwndCombo1, LM_QUERYSELECTION, 0L, 0L );
             if ( index1 != LIT_NONE )
             {
               ulButTmp = (ULONG)(index1 + 1L);
               bcInfo.cbStructSize = sizeof ( bcInfo );
               irc = WrtQueryButtonCaps ( &ulButTmp, &bcInfo );
               if ( irc == WRT_NO_ERROR )
               {
                 disp_butcaps (hwnd, &bcInfo );
               } /* endif */
             } /* endif */
        } /* endswitch */
        return ( FALSE );
     case WM_COMMAND:
        switch ( SHORT1FROMMP ( mp1 ) )
        {
           case EXIT:
               WinDismissDlg ( hwnd, EXIT );
        } /* endswitch */
        return ( FALSE );
   }
   return(WinDefDlgProc(hwnd, msg, mp1, mp2));
}

/*******************************************************************************
*                                                                              *
* Function Name: LocCapDlgProc                                                 *
*                                                                              *
* Description :                                                                *
*                                                                              *
*   Displays the capabilities of the Locaotors                                 *
*                                                                              *
* Input:                                                                       *
*                                                                              *
* Output: Display the capabilities of the system                               *
*                                                                              *
*******************************************************************************/
MRESULT EXPENTRY LocCapDlgProc(HWND hwnd, ULONG msg, MPARAM mp1, MPARAM mp2)
{
  WRTLOCATORDEVINFO lcInfo;
  CHAR cbuffer[MAXCBUFFER];
  ULONG ulLocatorID;
  ULONG ulLocTmp;
  WNDPARAMS comboprams;
  APIRET irc;
   switch(msg)
   {
      case WM_INITDLG:

            /******************************************************************/
            /*  Find out how many locators the system has by querying the     */
            /*  locator capabilities API with ulLocatorID = 0L.               */
            /*  The API will write the number of locator IDs in the system in */
            /*  the variable ulLocatorID.                                     */
            /******************************************************************/
            ulLocatorID = 0L;
            irc = WrtQueryLocatorCaps ( &ulLocatorID, NULL );
            if ( irc != WRT_NO_ERROR )
            {
              /****************************************************************/
              /* ERROR from API                                               */
              /****************************************************************/
              DisplayError ( hwnd, irc );
            } else
            {
              /****************************************************************/
              /* Find out if locator are greater than zero                    */
              /****************************************************************/
              if ( ulLocatorID == 0L )
              {
                WinMessageBox( HWND_DESKTOP,
                                hwnd,
                                "WrtQueryLocatorCaps return 0 locators",
                                NULL, 1, MB_OK );
              } else
              {
                /* Got some locator to display */
                hwndCombo1 = WinWindowFromID ( hwnd, wrtelc23 );
                /**************************************************************/
                /* Display the Capabilities for all the locator in the system */
                /**************************************************************/

                for ( ulLocTmp = 1L ; ulLocTmp <= ulLocatorID ; ulLocTmp++ )
                {
                  /************************************************************/
                  /* The cbStructureSize variable in the WRTLOCATORDEVINFO    */
                  /* structure must be initialize to the size of the          */
                  /* WRTLOCATORDEVINFO structure before querying the locator  */
                  /* capabilities.                                            */
                  /************************************************************/
                  lcInfo.cbStructSize = sizeof ( lcInfo );

                  /************************************************************/
                  /* ulLocTmp    variable has the ID of the locator that you  */
                  /* want to query                                            */
                  /************************************************************/
                  irc = WrtQueryLocatorCaps ( &ulLocTmp, &lcInfo );

                  if ( irc == WRT_NO_ERROR )
                  {
                    /**********************************************************/
                    /*  good return from API                                  */
                    /**********************************************************/
                    sprintf ( cbuffer, "%s %s",
                              lcInfo.pszDriverName, lcInfo.pszDeviceName );
                    index1 = (SHORT) WinSendMsg ( hwndCombo1, LM_INSERTITEM,
                                      MPFROMSHORT ( LIT_END ),
                                      MPFROMP ( cbuffer ) );
                  } else
                  {
                    /**********************************************************/
                    /* ERROR from API                                         */
                    /**********************************************************/
                    DisplayError ( hwnd, irc );
                  } /* endif */
                } /* endfor */
                /**************************************************************/
                /* Set the last  item on the list at the top.                 */
                /**************************************************************/
                WinSendMsg ( hwndCombo1, LM_SETTOPINDEX,
                             MPFROMSHORT ( index1 ), 0 );

                comboprams.fsStatus = WPM_TEXT;               /* change window text */
                comboprams.cchText = sizeof ( cbuffer );      /* text size          */
                comboprams.pszText = cbuffer ;                /* text to display    */
                WinSendMsg ( hwndCombo1, WM_SETWINDOWPARAMS, &comboprams, 0 );

                disp_loccaps ( hwnd, &lcInfo );

              } /* endif */ /* end of display locator information */
            } /* endif */
          /******************************************************************/

        return(FALSE);
     case WM_CONTROL:
        switch ( SHORT2FROMMP (mp1) )
        {
           case CBN_ENTER:
             /*****************************************************************/
             /* find the index of the selected item                           */
             /*****************************************************************/
             index1 = (SHORT)WinSendMsg ( hwndCombo1, LM_QUERYSELECTION, 0L, 0L );
             if ( index1 != LIT_NONE )
             {
               ulLocTmp = (ULONG)(index1 + 1L);
               lcInfo.cbStructSize = sizeof ( lcInfo );
               irc = WrtQueryLocatorCaps ( &ulLocTmp, &lcInfo );
               if ( irc == WRT_NO_ERROR )
               {
                 disp_loccaps ( hwnd, &lcInfo );
               } /* endif */
             } /* endif */
        } /* endswitch */
        return ( FALSE );
     case WM_COMMAND:
        switch ( SHORT1FROMMP ( mp1 ) )
        {
           case EXIT:
               WinDismissDlg ( hwnd, EXIT );
        } /* endswitch */
        return ( FALSE );
   }
   return(WinDefDlgProc(hwnd, msg, mp1, mp2));
}
/*******************************************************************************
*                                                                              *
* Function Name: DisCapDlgProc                                                 *
*                                                                              *
* Description :                                                                *
*                                                                              *
*   Displays the capabilities of the Displays                                  *
*                                                                              *
* Input:                                                                       *
*                                                                              *
* Output: Display the capabilities of the system                               *
*                                                                              *
*******************************************************************************/
MRESULT EXPENTRY DisCapDlgProc(HWND hwnd, ULONG msg, MPARAM mp1, MPARAM mp2)
{
  WRTDISPLAYDEVINFO dcInfo;
  CHAR cbuffer[MAXCBUFFER];
  ULONG ulDisplayID;
  ULONG ulDisTmp;
  WNDPARAMS comboprams;
  APIRET irc;
   switch(msg)
   {
        case WM_INITDLG:
          /******************************************************************/
          /*  Find out how many Displays the system has by querying the     */
          /*  Display capabilities API with ulDisplayID = 0L.               */
          /*  The API will write the number of Display IDs in the system in */
          /*  the variable ulDisplayID.                                     */
          /******************************************************************/
          ulDisplayID = 0L;
          irc = WrtQueryDisplayCaps ( &ulDisplayID, NULL );
          if ( irc != WRT_NO_ERROR )
          {
            /****************************************************************/
            /* ERROR from API                                               */
            /****************************************************************/
            DisplayError ( hwnd, irc );
          } else
          {
            /****************************************************************/
            /* Find out if there are greater than zero display.             */
            /****************************************************************/
            if ( ulDisplayID == 0L)
            {
              WinMessageBox( HWND_DESKTOP,
                              hwnd,
                              "WrtQueryDisplayCaps return 0 displays",
                              NULL, 1, MB_OK );
            } else
            {
              /**************************************************************/
              /* Got some locator to display                                */
              /**************************************************************/
              hwndCombo1 = WinWindowFromID ( hwnd, wrtelc10 );
              for ( ulDisTmp= 1L; ulDisTmp <= ulDisplayID; ulDisTmp++ )
              {
                /************************************************************/
                /* The cbStructureSize variable in the WRTDISPLAYDEVINFO    */
                /* structure must be initialize to the size of the          */
                /* WRTDISPLAYDEVINFO structure before querying the Display  */
                /* capabilities.                                            */
                /************************************************************/
                dcInfo.cbStructSize = sizeof ( dcInfo );

                /************************************************************/
                /* ulDisTmp    variable has the ID of the Display that you  */
                /* want to query                                            */
                /************************************************************/
                irc = WrtQueryDisplayCaps ( &ulDisTmp, &dcInfo );

                if ( irc == WRT_NO_ERROR )
                {
                  /**********************************************************/
                  /*  good return from API                                  */
                  /**********************************************************/
                  sprintf ( cbuffer, "%s %s",
                            dcInfo.pszDriverName, dcInfo.pszDeviceName );
                  index1 = (SHORT) WinSendMsg ( hwndCombo1, LM_INSERTITEM,
                                    MPFROMSHORT ( LIT_END ),
                                    MPFROMP ( cbuffer ) );
                } else
                {
                  /**********************************************************/
                  /* ERROR from API                                         */
                  /**********************************************************/
                  DisplayError ( hwnd, irc );
                } /* endif */
              } /* endfor */
              /**************************************************************/
              /* Set the last  item on the list at the top.                 */
              /**************************************************************/
              WinSendMsg ( hwndCombo1, LM_SETTOPINDEX,
                           MPFROMSHORT ( index1 ), 0 );

              comboprams.fsStatus = WPM_TEXT;               /* change window text */
              comboprams.cchText = sizeof ( cbuffer );      /* text size          */
              comboprams.pszText = cbuffer ;                /* text to display    */
              WinSendMsg ( hwndCombo1, WM_SETWINDOWPARAMS, &comboprams, 0 );

              disp_discaps ( hwnd, &dcInfo  );
            } /* endif */
          } /* endif */

        return(FALSE);
     case WM_CONTROL:
        switch ( SHORT2FROMMP (mp1) )
        {
           case CBN_ENTER:
             /*****************************************************************/
             /* find the index of the selected item                           */
             /*****************************************************************/
             index1 = (SHORT)WinSendMsg ( hwndCombo1, LM_QUERYSELECTION, 0L, 0L );
             if ( index1 != LIT_NONE )
             {
               ulDisTmp = (ULONG)(index1 + 1L);
               dcInfo.cbStructSize = sizeof ( dcInfo );
               irc = WrtQueryDisplayCaps ( &ulDisTmp, &dcInfo );
               if ( irc == WRT_NO_ERROR )
               {
                 disp_discaps ( hwnd, &dcInfo );
               } /* endif */
             } /* endif */
        } /* endswitch */
        return ( FALSE );
     case WM_COMMAND:
        switch ( SHORT1FROMMP ( mp1 ) )
        {
           case EXIT:
               WinDismissDlg ( hwnd, EXIT );
        } /* endswitch */
        return ( FALSE );
   }
   return(WinDefDlgProc(hwnd, msg, mp1, mp2));
}
/*******************************************************************************
*                                                                              *
* Function Name: SysCapDlgProc                                                 *
*                                                                              *
* Description :                                                                *
*                                                                              *
*   Displays the capabilities of the system.                                   *
*                                                                              *
* Input:                                                                       *
*                                                                              *
* Output: Display the capabilities of the system                               *
*                                                                              *
*******************************************************************************/
MRESULT EXPENTRY SysCapDlgProc(HWND hwnd, ULONG msg, MPARAM mp1, MPARAM mp2)
{
  PWRTSYSTEMINFO pscInfo;
  CHAR cbuffer[MAXCBUFFER];

   switch(msg)
   {
        case WM_INITDLG:
          pscInfo = PVOIDFROMMP ( mp2 );

          sprintf ( cbuffer, "%ld", pscInfo->cbStructSize );
          WinSetDlgItemText ( hwnd, wrtelc01, cbuffer );

          sprintf ( cbuffer, "%ld", pscInfo->ulDisplayXPels );
          WinSetDlgItemText ( hwnd, wrtelc02, cbuffer );

          sprintf ( cbuffer, "%ld", pscInfo->ulDisplayYPels );
          WinSetDlgItemText ( hwnd, wrtelc03, cbuffer );

          sprintf ( cbuffer, "%ld", pscInfo->ulDisplayXRes );
          WinSetDlgItemText ( hwnd, wrtelc04, cbuffer );

          sprintf ( cbuffer, "%ld", pscInfo->ulDisplayYRes );
          WinSetDlgItemText ( hwnd, wrtelc05, cbuffer );

          sprintf ( cbuffer, "%ld", pscInfo->ulNumDrivers );
          WinSetDlgItemText ( hwnd, wrtelc06, cbuffer );

          sprintf ( cbuffer, "%ld", pscInfo->ulNumLocators );
          WinSetDlgItemText ( hwnd, wrtelc07, cbuffer );

          sprintf ( cbuffer, "%ld", pscInfo->ulNumButtons );
          WinSetDlgItemText ( hwnd, wrtelc08, cbuffer );

          sprintf ( cbuffer, "%ld", pscInfo->ulNumDisplays );
          WinSetDlgItemText ( hwnd, wrtelc09, cbuffer );

        return(FALSE);
     case WM_COMMAND:
        switch ( SHORT1FROMMP ( mp1 ) )
        {
           case EXIT:
               WinDismissDlg ( hwnd, EXIT );
        } /* endswitch */
        return ( FALSE );
   }
   return(WinDefDlgProc(hwnd, msg, mp1, mp2));
}

/*******************************************************************************
*                                                                              *
* Function Name: AUXPNTDlgProc                                                 *
*                                                                              *
* Description :                                                                *
*                                                                              *
*   Displays the AUX. Point Data.                                              *
*                                                                              *
* Input:                                                                       *
*                                                                              *
* Output: Display the AUX. Point Data                                          *
*                                                                              *
*******************************************************************************/
MRESULT EXPENTRY AUXPNTDlgProc(HWND hwnd, ULONG msg, MPARAM mp1, MPARAM mp2)
{
  CHAR cbuffer[MAXCBUFFER];
  INT i;

   switch(msg)
   {
          case WM_INITDLG:
             sprintf ( cbuffer, "%d", apdExtra.cbStructSize );
             WinSetDlgItemText ( hwnd, wrtelc01, cbuffer );

              /****************************************************************/
              /* The display information is being done first to test what the */
              /* dirver is returning. On a real application you would not     */
              /* care to look at the variable if the ValidityFlags bit was    */
              /* off. The driver should be returning 0 on unsed variables.    */
              /****************************************************************/
              sprintf ( cbuffer, "%ld", apdExtra.ulTimestamp );
              WinSetDlgItemText ( hwnd, wrtelc02, cbuffer );
            if ( !(ldiarr[ulocindx].ulValidityFlags & ADF_TIMESTAMP) )
            {
               WinEnableWindow ( (WinWindowFromID ( hwnd , wrtlc02 )), FALSE );
               WinEnableWindow ( (WinWindowFromID ( hwnd , wrtelc02 )), FALSE );
            } /* endif */

             sprintf ( cbuffer, "%#x", apdExtra.usFlags );
             WinSetDlgItemText ( hwnd, wrtelc03, cbuffer );
            if ( !(ldiarr[ulocindx].ulValidityFlags & ADF_FLAGS) )
            {
               WinEnableWindow ( (WinWindowFromID ( hwnd , wrtlc03 )), FALSE );
               WinEnableWindow ( (WinWindowFromID ( hwnd , wrtelc03 )), FALSE );
            } /* endif */

             sprintf ( cbuffer, "%d", apdExtra.usUser );
             WinSetDlgItemText ( hwnd, wrtelc04, cbuffer );
            if ( !(ldiarr[ulocindx].ulValidityFlags & ADF_USER) )
            {
               WinEnableWindow ( (WinWindowFromID ( hwnd , wrtlc04 )), FALSE );
               WinEnableWindow ( (WinWindowFromID ( hwnd , wrtelc04 )), FALSE );
            } /* endif */

             sprintf ( cbuffer, "%d", apdExtra.sScrZ );
             WinSetDlgItemText ( hwnd, wrtelc05, cbuffer );
            if ( !(ldiarr[ulocindx].ulValidityFlags & ADF_SCREENZ) )
            {
               WinEnableWindow ( (WinWindowFromID ( hwnd , wrtlc05 )), FALSE );
               WinEnableWindow ( (WinWindowFromID ( hwnd , wrtelc05 )), FALSE );
            } /* endif */

             sprintf ( cbuffer, "%d", apdExtra.sDevZ );
             WinSetDlgItemText ( hwnd, wrtelc06, cbuffer );
            if ( !(ldiarr[ulocindx].ulValidityFlags & ADF_DEVZ) )
            {
               WinEnableWindow ( (WinWindowFromID ( hwnd , wrtlc06 )), FALSE );
               WinEnableWindow ( (WinWindowFromID ( hwnd , wrtelc06 )), FALSE );
            } /* endif */

             sprintf ( cbuffer, "%d", apdExtra.sAngle );
             WinSetDlgItemText ( hwnd, wrtelc07, cbuffer );
            if ( !(ldiarr[ulocindx].ulValidityFlags & ADF_ANGLE) )
            {
               WinEnableWindow ( (WinWindowFromID ( hwnd , wrtlc07 )), FALSE );
               WinEnableWindow ( (WinWindowFromID ( hwnd , wrtelc07 )), FALSE );
            } /* endif */

             sprintf ( cbuffer, "%d", apdExtra.sRotation );
             WinSetDlgItemText ( hwnd, wrtelc08, cbuffer );
            if ( !(ldiarr[ulocindx].ulValidityFlags & ADF_ROTATION) )
            {
               WinEnableWindow ( (WinWindowFromID ( hwnd , wrtlc08 )), FALSE );
               WinEnableWindow ( (WinWindowFromID ( hwnd , wrtelc08 )), FALSE );
            } /* endif */

             sprintf ( cbuffer, "%#x", apdExtra.usButton );
             WinSetDlgItemText ( hwnd, wrtelc09, cbuffer );
            if ( !(ldiarr[ulocindx].ulValidityFlags & ADF_BUTTON) )
            {
               WinEnableWindow ( (WinWindowFromID ( hwnd , wrtlc09 )), FALSE );
               WinEnableWindow ( (WinWindowFromID ( hwnd , wrtelc09 )), FALSE );
            } /* endif */

            if ( ldiarr[ulocindx].ulValidityFlags & ADF_OEM )
            {
             /* adf_oem_count_mask is not supported in release 1 */
             for ( i= 0; i < ldiarr[ulocindx].ulOEMValidityCnt; i++ )
             {
                sprintf ( cbuffer, "OEM[%i]= %li", i, apdExtra.OEM[i] );
                WinSendDlgItemMsg(hwnd,
                                   wrtelc10,
                                   LM_INSERTITEM,
                                   MPFROM2SHORT(LIT_END, 0),
                                   MPFROMP( cbuffer ) );

             } /* endfor */
            } else
            {
               WinEnableWindow ( (WinWindowFromID ( hwnd , wrtlc10 )), FALSE );
            } /* endif */
        return(FALSE);
     case WM_COMMAND:
        switch ( SHORT1FROMMP ( mp1 ) )
        {
           case EXIT:
               btoggle_aux = FALSE;
               WinSendDlgItemMsg (
                                 hwndFrame
                                ,(ULONG) FID_MENU
                                ,(ULONG) MM_SETITEMATTR
                                ,MPFROM2SHORT ( ID_AUX, TRUE )
                                ,MPFROM2SHORT ( MIA_CHECKED, 0 )
                                );
               AUXTEST = 0;
               WinDismissDlg ( hwnd, EXIT );
        } /* endswitch */
        return ( FALSE );
   }
   return(WinDefDlgProc(hwnd, msg, mp1, mp2));
}

/*******************************************************************************
*                                                                              *
* Function Name: EVNTDTDlgProc                                                 *
*                                                                              *
* Description :                                                                *
*                                                                              *
*   Displays the Event Data.                                                   *
*                                                                              *
* Input:                                                                       *
*                                                                              *
* Output: Display the Event Data                                               *
*                                                                              *
*******************************************************************************/
MRESULT EXPENTRY EVNTDTDlgProc(HWND hwnd, ULONG msg, MPARAM mp1, MPARAM mp2)
{
  CHAR cbuffer[MAXCBUFFER];

   switch(msg)
   {
        case WM_INITDLG:
             sprintf ( cbuffer, "%d", edInfo.cbStructSize );
             WinSetDlgItemText ( hwnd, wrtelc01, cbuffer );

             sprintf ( cbuffer, "%#x", edInfo.usKCFlags );
             WinSetDlgItemText ( hwnd, wrtelc02, cbuffer );

             sprintf ( cbuffer, "%#x", edInfo.usHitTest );
             WinSetDlgItemText ( hwnd, wrtelc03, cbuffer );

             sprintf ( cbuffer, "%#x", edInfo.flEventStatus );
             WinSetDlgItemText ( hwnd, wrtelc04, cbuffer );

             sprintf ( cbuffer, "%ld", edInfo.ptlDisplay.x );
             WinSetDlgItemText ( hwnd, wrtelc05, cbuffer );
             sprintf ( cbuffer, "%ld", edInfo.ptlDisplay.y );
             WinSetDlgItemText ( hwnd, wrtelc06, cbuffer );

             sprintf ( cbuffer, "%ld", edInfo.ptlSensor.x );
             WinSetDlgItemText ( hwnd, wrtelc07, cbuffer );
             sprintf ( cbuffer, "%ld", edInfo.ptlSensor.y  );
             WinSetDlgItemText ( hwnd, wrtelc08, cbuffer );

             sprintf ( cbuffer, "%ld", edInfo.ptlStandard.x );
             WinSetDlgItemText ( hwnd, wrtelc09, cbuffer );
             sprintf ( cbuffer, "%ld", edInfo.ptlStandard.y  );
             WinSetDlgItemText ( hwnd, wrtelc10, cbuffer );

             sprintf ( cbuffer, "%ld", edInfo.ulStrokeSeq  );
             WinSetDlgItemText ( hwnd, wrtelc11, cbuffer );

             sprintf ( cbuffer, "%ld", edInfo.ulStrokeSize );
             WinSetDlgItemText ( hwnd, wrtelc12, cbuffer );

             sprintf ( cbuffer, "%ld", edInfo.ulLocatorID  );
             WinSetDlgItemText ( hwnd, wrtelc13, cbuffer );

             sprintf ( cbuffer, "%ld", edInfo.ulLocatorType  );
             WinSetDlgItemText ( hwnd, wrtelc14, cbuffer );

             sprintf ( cbuffer, "%#lx", edInfo.ulLocatorFlags  );
             WinSetDlgItemText ( hwnd, wrtelc15, cbuffer );

             sprintf ( cbuffer, "%#lx", edInfo.ulValidityFlags );
             WinSetDlgItemText ( hwnd, wrtelc16, cbuffer );

             sprintf ( cbuffer, "%#lx", edInfo.ulButtonStatus  );
             WinSetDlgItemText ( hwnd, wrtelc17, cbuffer );

             sprintf ( cbuffer, "%ld", edInfo.hwndUnderPtr );
             WinSetDlgItemText ( hwnd, wrtelc18, cbuffer );
        return(FALSE);
     case WM_COMMAND:
        switch ( SHORT1FROMMP ( mp1 ) )
        {
           case EXIT:
               btoggle_event = FALSE;
               WinSendDlgItemMsg (
                                 hwndFrame
                                ,(ULONG) FID_MENU
                                ,(ULONG) MM_SETITEMATTR
                                ,MPFROM2SHORT ( ID_EVENT, TRUE )
                                ,MPFROM2SHORT ( MIA_CHECKED, 0 )
                                );
               EVENTTEST = 0;
               WinDismissDlg ( hwnd, EXIT );
        } /* endswitch */
        return ( FALSE );
   }
   return(WinDefDlgProc(hwnd, msg, mp1, mp2));
}

/*******************************************************************************
*                                                                              *
* Function Name: BACKLTDlgProc                                                 *
*                                                                              *
* Description :                                                                *
*                                                                              *
*   Let the user turn ON or OFF the backlight of a specific display.           *
*                                                                              *
* Input:                                                                       *
*                                                                              *
* Output: Let the user turn ON or OFF the backlight of a specific display.     *
*                                                                              *
*******************************************************************************/
MRESULT EXPENTRY BACKLTDlgProc(HWND hwnd, ULONG msg, MPARAM mp1, MPARAM mp2)
{
  CHAR cbuffer[MAXCBUFFER];
  WRTDISPLAYDEVINFO dcInfo;            /* Display capabilities structure      */
  WNDPARAMS comboprams;
  INT i;
  APIRET irc;

   switch(msg)
   {
     case WM_INITDLG:
          /********************************************************************/
          /* There should be a valid display with a backlight support since   */
          /* the backlight menu option would be disable at program srart up   */
          /* you would not be here.                                           */
          /********************************************************************/
          i = 0;
          hwndCombo1 = WinWindowFromID ( hwnd , wrtelc03 );
          for ( ; ulbacklight_displayID[i] != 0L; i++ )
          {
            dcInfo.cbStructSize = sizeof ( dcInfo );

            /******************************************************************/
            /* ulbacklight_displayID[i] variable has the ID of the            */
            /* Display that you want to query                                 */
            /******************************************************************/
            irc = WrtQueryDisplayCaps ( &ulbacklight_displayID[i], &dcInfo );

            if ( irc == WRT_NO_ERROR )
            {
              sprintf ( cbuffer, "%s %s",
                        dcInfo.pszDriverName, dcInfo.pszDeviceName );
              /****************************************************************/
              /* initialize the entries in the list box                       */
              /****************************************************************/
              index1 = (SHORT) WinSendMsg ( hwndCombo1, LM_INSERTITEM,
                                     MPFROMSHORT ( LIT_END ),
                                     MPFROMP ( cbuffer ) );
            } /* endif */
          } /* endfor */
          /********************************************************************/
          /* Set the last  item on the list at the top.                       */
          /********************************************************************/
          WinSendMsg ( hwndCombo1, LM_SETTOPINDEX, MPFROMSHORT ( index1 ), 0 );

          comboprams.fsStatus = WPM_TEXT;               /* change window text */
          comboprams.cchText = sizeof ( cbuffer );      /* text size          */
          comboprams.pszText = cbuffer ;                /* text to display    */
          WinSendMsg ( hwndCombo1, WM_SETWINDOWPARAMS, &comboprams, 0 );

          /********************************************************************/
          /* Turn the backlight on and mark the ON radio button               */
          /********************************************************************/
          WinSendMsg ( WinWindowFromID( hwnd, wrtelc01), BM_CLICK, 0L, 0L );
        return ( FALSE );
     case WM_CONTROL:
       switch ( SHORT2FROMMP ( mp1 ) )
       {
         case CBN_ENTER:
           /*******************************************************************/
           /* find the index of the selected item                             */
           /*******************************************************************/
           index1 = (SHORT)WinSendMsg ( hwndCombo1, LM_QUERYSELECTION, 0L, 0L );
           if ( index1 != LIT_NONE )
           {
             dcInfo.cbStructSize = sizeof ( dcInfo );
             irc = WrtQueryDisplayCaps ( &ulbacklight_displayID[index1],
                                         &dcInfo );
             if ( irc == WRT_NO_ERROR )
             {
               WinSendMsg ( WinWindowFromID( hwnd, wrtelc01),
                            BM_CLICK, 0L, 0L );
             } /* endif */
           } /* endif */
         break;
         case BN_CLICKED:
              switch ( SHORT1FROMMP(mp1) )
              {
           case wrtelc01:
                    irc = WrtControlDisplayBacklight ( CDB_LIGHT_ON,
                                               ulbacklight_displayID[index1] );
                    if ( irc != WRT_NO_ERROR )
                    {
                      DisplayError ( hwnd, irc );
                    } /* endif */
                break;
                case wrtelc02:
                    irc = WrtControlDisplayBacklight ( CDB_LIGHT_OFF,
                                               ulbacklight_displayID[index1] );
                    if ( irc != WRT_NO_ERROR )
                    {
                      DisplayError ( hwnd, irc );
                    } /* endif */
                break;
              } /* endswitch */
         break;
       } /* endswitch */
       return ( FALSE );
     case WM_COMMAND:
        switch ( SHORT1FROMMP ( mp1 ) )
        {
           case EXIT:
               WinDismissDlg ( hwnd, EXIT );
        } /* endswitch */
        return ( FALSE );
   } /* endswitch */
   return(WinDefDlgProc(hwnd, msg, mp1, mp2));
}
/******************************************************************************/
/*  Error reporting functions                                                 */
/******************************************************************************/
VOID DisplayError ( HWND hwnd, APIRET errcode )
{
   CHAR errbuff[MAXCBUFFER];
   CHAR loadbuff[MAXCBUFFER];

   if ( errcode != WRT_NO_ERROR )
   {
     switch ( errcode ) {
     case WRTERR_INVALID_BUTTON_ID:
     case WRTERR_INVALID_POINTER:
     case WRTERR_INVALID_BUFFER:
     case WRTERR_STRUCT_NOT_INIT:
     case WRTERR_NOT_ACTIVE:
     case WRTERR_INVALID_LOCATOR_ID:
     case WRTERR_INVALID_DISPLAY_ID:
     case WRTERR_INVALID_HWND:
     case WRTERR_WRITE_FAILED:
     case WRTERR_INVALID_PARM:
     case WRTERR_INVALID_ID:
     case WRTERR_PARM_OUT_OF_RANGE:
     case WRTERR_MORE_NAMES_AVAIL:
     case WRTERR_STROKE_INVALID:
        WinLoadString (
                        habMain,
                        NULLHANDLE,
                        errcode,
                        MAXCBUFFER,
                        errbuff
                        );
        break;
     default:
        WinLoadString (
                        habMain,
                        NULLHANDLE,
                        IDMSG_UNKOWN,
                        MAXCBUFFER,
                        loadbuff
                        );
        sprintf ( errbuff, loadbuff, errcode );
       break;
     } /* endswitch */

     WinMessageBox( HWND_DESKTOP,
                    hwnd,
                    errbuff,
                    NULL, 1, MB_OK );
   } /* endif */
}

VOID init_sysval( HWND hwnd, INT r_sw )
{
  CHAR cbuffer[MAXCBUFFER];
  WNDPARAMS comboprams;
  INT       i;

  /**********************************************************************/
  /* initialize the entries in the list box                             */
  /**********************************************************************/
  hwndCombo1 = WinWindowFromID ( hwnd , wrtelc01 );

  for ( i= 1; i < (QSVALUESIZE - 2); i++ )
  {
        index = (SHORT) WinSendMsg ( hwndCombo1, LM_INSERTITEM,
                       MPFROMSHORT ( LIT_END ),
                       MPFROMP ( qsvalue[i].valname ) );
  }
  /**********************************************************************/
  /* Set the first item on the list at the top.                         */
  /**********************************************************************/
  index = 0;                            /* intialize the index to zeror */
  WinSendMsg ( hwndCombo1, LM_SETTOPINDEX, MPFROMSHORT ( index ), 0 );

  comboprams.fsStatus = WPM_TEXT;      /* change window text            */
  comboprams.cchText = sizeof ( qsvalue[index+1].valname );/* text size*/
  comboprams.pszText = qsvalue[index+1].valname;  /* text to display   */
  WinSendMsg ( hwndCombo1, WM_SETWINDOWPARAMS,
               &comboprams, 0 );
  /**********************************************************************/
  /* query the system value to set the spin box.                        */
  /**********************************************************************/
  startvalue = WrtQuerySysValue ( HWND_DESKTOP,
                             qsvalue[index+1].valueid );

  /**********************************************************************/
  /* initialize all the spin button to the system value that where      */
  /* query. If the query reutrn an error (WRTERR_INVALID_PARM) SET      */
  /* the spin button to zerro.                                          */
  /**********************************************************************/
  if ( startvalue == WRTERR_INVALID_PARM )
  {
    startvalue = 0L;
  } /* endif */
  if ( r_sw )
  {            /* r-sw == 1 is a read */
    /**********************************************************************/
    /* Set the entry field value to the value that was query from         */
    /* the system.                                                        */
    /**********************************************************************/
    sprintf ( cbuffer, "%li", startvalue);
    WinSetDlgItemText ( hwnd, wrtelc02, cbuffer );
  } else       /* r_sw == 0is a set or write */
  {
    /************************************************************/
    /* check to see if the value can be set to 0 (disabled)     */
    /************************************************************/
    if ( qsvalue[index+1].disable == 1 )
    {
      WinSendMsg ( WinWindowFromID ( hwnd, wrtelc02 ),
                  SPBM_SETLIMITS,
                  MPFROMLONG ( qsvalue[index+1].valuemax ),/* MAX*/
                  MPFROMLONG ( 0L ) /* MIN*/
                  );
    } else
    {
      WinSendMsg ( WinWindowFromID ( hwnd, wrtelc02 ),
                  SPBM_SETLIMITS,
                  MPFROMLONG ( qsvalue[index+1].valuemax ),      /* MAX    */
                  MPFROMLONG ( qsvalue[index+1].valuemin )       /* MIN    */
                  );
    } /* endif */
    /**********************************************************************/
    /* Set the spin button value to the value that was query from         */
    /* the system.                                                        */
    /**********************************************************************/
    WinSendMsg ( WinWindowFromID ( hwnd, wrtelc02 ),
                SPBM_SETCURRENTVALUE,
                MPFROMLONG ( startvalue ),
                0L
                );
  } /* endif */
}

VOID enter_sysval( HWND hwnd, INT r_sw )
{
  CHAR cbuffer[MAXCBUFFER];

  /******************************************************************/
  /* find the index of the selected item                            */
  /******************************************************************/
  index = (SHORT) WinSendMsg ( hwndCombo1, LM_QUERYSELECTION, 0L, 0L );
  if ( index != LIT_NONE )
  {
    /****************************************************************/
    /* get the sytem value to change                                */
    /****************************************************************/
    startvalue = WrtQuerySysValue ( HWND_DESKTOP,
                               qsvalue[index+1].valueid );

    /****************************************************************/
    /* initialize all the spin button to the system value that where*/
    /* query. If the query reutrn an error (WRTERR_INVALID_PARM) SET*/
    /* the spin button to zerro.                                    */
    /****************************************************************/
    if ( startvalue == WRTERR_INVALID_PARM )
    {
      startvalue = 0L;
    } /* endif */

    if ( r_sw )
    {             /* if r_sw == 1 is read */
      /****************************************************************/
      /* Set the entry field value to the value that was query from   */
      /* the system.                                                  */
      /****************************************************************/
      sprintf ( cbuffer, "%li", startvalue);
      WinSetDlgItemText ( hwnd, wrtelc02, cbuffer );
    } else
    {             /* if r_sw == 0 is set or write */
      /************************************************************/
      /* check to see if the value can be set to 0 (disabled)     */
      /************************************************************/
      if ( qsvalue[index+1].disable == 1 )
      {
        WinSendMsg ( WinWindowFromID ( hwnd, wrtelc02 ),
                    SPBM_SETLIMITS,
                    MPFROMLONG ( qsvalue[index+1].valuemax ),/* MAX    */
                    MPFROMLONG ( 0L ) /* MIN*/
                    );
      } else
      {
        WinSendMsg ( WinWindowFromID ( hwnd, wrtelc02 ),
                    SPBM_SETLIMITS,
                    MPFROMLONG ( qsvalue[index+1].valuemax ),/* MAX    */
                    MPFROMLONG ( qsvalue[index+1].valuemin ) /* MIN    */
                    );
      } /* endif */
      /****************************************************************/
      /* Set the spin button value to the value that was query from   */
      /* the system.                                                  */
      /****************************************************************/
      WinSendMsg ( WinWindowFromID ( hwnd, wrtelc02 ),
                  SPBM_SETCURRENTVALUE,
                  MPFROMLONG ( startvalue ),
                  0L
                  );
      /****************************************************************/
      /* set the spin button's maximum and minimum values for the     */
      /* users to choose from.                                        */
      /****************************************************************/
      WinSendMsg ( WinWindowFromID ( hwnd, wrtelc02 ),
                  SPBM_OVERRIDESETLIMITS,
                  MPFROMLONG ( qsvalue[index+1].valuemax ),/* MAX    */
                  MPFROMLONG ( qsvalue[index+1].valuemin ) /* MIN    */
                  );

    } /* endif */
  } /* endif */
}

VOID updwn_sysval ( HWND hwnd )
{
  if ( qsvalue[index+1].disable == 1 )
  {
     /*********************************************************/
     /* Query the value of the spin button and put it in      */
     /* ppmid[].value                                         */
     /*********************************************************/
     WinSendMsg ( WinWindowFromID ( hwnd, wrtelc02 )
                 ,SPBM_QUERYVALUE
                 ,MPFROMLONG ( &startvalue )
                 ,MPFROM2SHORT ( NULL, SPBQ_DONOTUPDATE )
                 );
     if ( startvalue == qsvalue[index+1].valuemin ||
          startvalue == qsvalue[index+1].valuemax  )
     {
       WinSendMsg ( WinWindowFromID ( hwnd, wrtelc02 ),
                   SPBM_OVERRIDESETLIMITS,
                   MPFROMLONG ( qsvalue[index+1].valuemax ),/* MAX*/
                   MPFROMLONG ( 0L ) /* MIN*/
                   );
     } else
     {
       if ( startvalue < qsvalue[index+1].valuemin )
       {
         WinSendMsg ( WinWindowFromID ( hwnd, wrtelc02 ),
                     SPBM_SETCURRENTVALUE,
                     MPFROMLONG ( 0L ),
                     0L
                     );
         WinSendMsg ( WinWindowFromID ( hwnd, wrtelc02 ),
                     SPBM_OVERRIDESETLIMITS,
                     MPFROMLONG ( qsvalue[index+1].valuemax ),/* MAX*/
                     MPFROMLONG ( qsvalue[index+1].valuemin ) /* MIN*/
                     );
       } /* endif */
     } /* endif */
  } /* endif */
}

VOID set_sysval ( HWND hwnd )
{
  LONG value;
  APIRET irc;

  /***************************************************************/
  /* Query the value of the spin button and if the value got     */
  /* change set the new system value.                            */
  /***************************************************************/
  WinSendMsg ( WinWindowFromID ( hwnd, wrtelc02 )
              ,SPBM_QUERYVALUE
              ,MPFROMLONG ( &value )
              ,MPFROM2SHORT ( NULL, SPBQ_DONOTUPDATE )
              );
  if ( startvalue != value )
  {
     /************************************************************/
     /* value got change must set the value                      */
     /************************************************************/
     irc = WrtSetSysValue ( HWND_DESKTOP,
                            qsvalue[index+1].valueid, value );
     if ( irc == WRT_NO_ERROR )
     {
       /**********************************************************/
       /* Broadcast a post message to all descendants of         */
       /* HWND_DESKTOP notifying which system value got changed  */
       /* so they can update if need be                          */
       /**********************************************************/
       WinBroadcastMsg (
                    HWND_DESKTOP,
                    WM_WRT_SYSVALUECHANGED,
                    (MPARAM)VT_PPMSV,
                    (MPARAM)qsvalue[index+1].valueid,
                    BMSG_DESCENDANTS | BMSG_POST
                    );
     } else
     {
        DisplayError ( hwnd, irc );
     } /* endif */
  } /* endif */
}

VOID disp_loccaps ( HWND hwnd, PWRTLOCATORDEVINFO lcInfo )
{
  CHAR cbuffer[MAXCBUFFER];

   sprintf ( cbuffer, "%ld", lcInfo->cbStructSize );
   WinSetDlgItemText ( hwnd, wrtelc01, cbuffer );

   sprintf ( cbuffer, "%ld", lcInfo->ulLocatorID );
   WinSetDlgItemText ( hwnd, wrtelc02, cbuffer );

   sprintf ( cbuffer, "%ld", lcInfo->ulLocatorType );
   WinSetDlgItemText ( hwnd, wrtelc03, cbuffer );

   sprintf ( cbuffer, "%#lx", lcInfo->ulLocatorFlags );
   WinSetDlgItemText ( hwnd, wrtelc04, cbuffer );

   sprintf ( cbuffer, "%#lx", lcInfo->ulValidityFlags );
   WinSetDlgItemText ( hwnd, wrtelc05, cbuffer );

   sprintf ( cbuffer, "%#lx", lcInfo->ulOEMValidityCnt );
   WinSetDlgItemText ( hwnd, wrtelc06, cbuffer );

   sprintf ( cbuffer, "%ld", lcInfo->ulSensorHeight );
   WinSetDlgItemText ( hwnd, wrtelc07, cbuffer );

   sprintf ( cbuffer, "%ld", lcInfo->ulSensorWidth );
   WinSetDlgItemText ( hwnd, wrtelc08, cbuffer );

   sprintf ( cbuffer, "%ld", lcInfo->ulNumMouButtons );
   WinSetDlgItemText ( hwnd, wrtelc09, cbuffer );

   sprintf ( cbuffer, "%ld", lcInfo->ulNumButtons );
   WinSetDlgItemText ( hwnd, wrtelc10, cbuffer );

   sprintf ( cbuffer, "%ld", lcInfo->ulButtonMask );
   WinSetDlgItemText ( hwnd, wrtelc22, cbuffer );

   sprintf ( cbuffer, "%ld", lcInfo->ulSensorXpts );
   WinSetDlgItemText ( hwnd, wrtelc11, cbuffer );

   sprintf ( cbuffer, "%ld", lcInfo->ulSensorYpts );
   WinSetDlgItemText ( hwnd, wrtelc12, cbuffer );

   sprintf ( cbuffer, "%ld", lcInfo->lSensorZptsP );
   WinSetDlgItemText ( hwnd, wrtelc13, cbuffer );

   sprintf ( cbuffer, "%ld", lcInfo->ulSensorZptsH );
   WinSetDlgItemText ( hwnd, wrtelc14, cbuffer );

   sprintf ( cbuffer, "%ld", lcInfo->ulSensorXres );
   WinSetDlgItemText ( hwnd, wrtelc15, cbuffer );

   sprintf ( cbuffer, "%ld", lcInfo->ulSensorYres );
   WinSetDlgItemText ( hwnd, wrtelc16, cbuffer );

   sprintf ( cbuffer, "%ld", lcInfo->ulStandardXpts );
   WinSetDlgItemText ( hwnd, wrtelc17, cbuffer );

   sprintf ( cbuffer, "%ld", lcInfo->ulStandardYpts );
   WinSetDlgItemText ( hwnd, wrtelc18, cbuffer );

   sprintf ( cbuffer, "%ld", lcInfo->ulSampleRate );
   WinSetDlgItemText ( hwnd, wrtelc19, cbuffer );

   sprintf ( cbuffer, "%ld", lcInfo->ulMaxSampleRate );
   WinSetDlgItemText ( hwnd, wrtelc20, cbuffer );

   sprintf ( cbuffer, "%ld", lcInfo->ulTimestampRes );
   WinSetDlgItemText ( hwnd, wrtelc21, cbuffer );
}

VOID disp_butcaps ( HWND hwnd, PWRTBUTTONDEVINFO bcInfo )
{
  CHAR cbuffer[MAXCBUFFER];

   sprintf ( cbuffer, "%ld", bcInfo->cbStructSize );
   WinSetDlgItemText ( hwnd, wrtelc01, cbuffer );

   sprintf ( cbuffer, "%ld", bcInfo->ulButtonID );
   WinSetDlgItemText ( hwnd, wrtelc02, cbuffer );

   sprintf ( cbuffer, "%ld", bcInfo->ulNumButtons );
   WinSetDlgItemText ( hwnd, wrtelc03, cbuffer );

   sprintf ( cbuffer, "%#lx", bcInfo->ulButtonMask );
   WinSetDlgItemText ( hwnd, wrtelc04, cbuffer );
}

VOID disp_discaps ( HWND hwnd, PWRTDISPLAYDEVINFO dcInfo )
{
  CHAR cbuffer[MAXCBUFFER];

   sprintf ( cbuffer, "%ld", dcInfo->cbStructSize );
   WinSetDlgItemText ( hwnd, wrtelc01, cbuffer );

   sprintf ( cbuffer, "%ld", dcInfo->ulDisplayID );
   WinSetDlgItemText ( hwnd, wrtelc02, cbuffer );

   sprintf ( cbuffer, "%ld", dcInfo->ulDisplayType );
   WinSetDlgItemText ( hwnd, wrtelc03, cbuffer );

   sprintf ( cbuffer, "%ld", dcInfo->ulDisplayXPels );
   WinSetDlgItemText ( hwnd, wrtelc04, cbuffer );

   sprintf ( cbuffer, "%ld", dcInfo->ulDisplayYPels );
   WinSetDlgItemText ( hwnd, wrtelc05, cbuffer );

   sprintf ( cbuffer, "%ld", dcInfo->ulDisplayXRes );
   WinSetDlgItemText ( hwnd, wrtelc06, cbuffer );

   sprintf ( cbuffer, "%ld", dcInfo->ulDisplayYRes );
   WinSetDlgItemText ( hwnd, wrtelc07, cbuffer );

   sprintf ( cbuffer, "%ld", dcInfo->ulDisplayHeight );
   WinSetDlgItemText ( hwnd, wrtelc08, cbuffer );

   sprintf ( cbuffer, "%ld", dcInfo->ulDisplayWidth );
   WinSetDlgItemText ( hwnd, wrtelc09, cbuffer );
}

VOID init_invar ( HWND hwnd, INT q_s )
{
  APIRET irc;
  ULONG aDeviceType[10];
  ULONG aDeviceID[10];
  ULONG ulDatalen;
  CHAR Data[512];
  WNDPARAMS comboprams;
  INT i;
  INT cbox;
  CHAR cbuffer[MAXCBUFFER];
  /****************************************************************************/
  /* Find out how many input driver there are       *                         */
  /****************************************************************************/
  ulNumDrivers = 0L;
  irc = WrtEnumInputDrivers ( &ulNumDrivers, NULL );
  if ( irc != WRT_NO_ERROR )
  {
    DisplayError ( hwnd, irc );
  } else
  {
    if ( ulNumDrivers > 10L )
    {
      sprintf(cbuffer,"Too many drivers[%ld] for my ARRAY", ulNumDrivers );
      WinMessageBox( HWND_DESKTOP,
                     hwnd,
                     cbuffer,
                     NULL, 1, MB_OK );
    } else
    {
      if ( ulNumDrivers == 0L )
      {
        sprintf(cbuffer,"No drivers found" );
        WinMessageBox( HWND_DESKTOP,
                       hwnd,
                       cbuffer,
                       NULL, 1, MB_OK );
      } else
      {
        /**********************************************************************/
        /* get array of driver names                                          */
        /**********************************************************************/
        irc = WrtEnumInputDrivers ( &ulNumDrivers, szDriverName );
        if ( irc != WRT_NO_ERROR )
        {
          DisplayError ( hwnd, irc );
        } else
        {
          /********************************************************************/
          /* initialize the entries in the Drivers list box                   */
          /********************************************************************/
          hwndCombo1 = WinWindowFromID ( hwnd , wrtelc01 );

          for ( i= 0; i < ulNumDrivers ; i++ )
          {
            index1 = (SHORT) WinSendMsg ( hwndCombo1, LM_INSERTITEM,
                                 MPFROMSHORT ( LIT_END ),
                                 MPFROMP ( szDriverName[i] ) );
          } /* endfor */
          /********************************************************************/
          /* Set the first item on the list at the top.                       */
          /********************************************************************/
          index1 = 0;                         /* intialize the index to zeror */
          WinSendMsg ( hwndCombo1, LM_SETTOPINDEX, MPFROMSHORT ( index1 ), 0 );

          comboprams.fsStatus = WPM_TEXT;      /* change window text          */
          comboprams.cchText = sizeof ( szDriverName[index1] );  /* text size */
          comboprams.pszText = szDriverName[index1];         /*text to display*/
          WinSendMsg ( hwndCombo1, WM_SETWINDOWPARAMS,
                       &comboprams, 0 );

          /********************************************************************/
          /* Find out how many input device there are                         */
          /********************************************************************/
          ulNumDevices = 0L;
          irc = WrtQueryInputDeviceNames ( szDriverName[index1], &ulNumDevices,
                                           NULL, NULL, NULL );
          if ( irc != WRT_NO_ERROR )
          {
            DisplayError ( hwnd, irc );
          } else
          {
            if ( ulNumDevices > 10L )
            {
              sprintf(cbuffer,"Too many devices[%ld] Driver[%s] for my ARRAY",
                      ulNumDevices, szDriverName[index1] );
              WinMessageBox( HWND_DESKTOP,
                             hwnd,
                             cbuffer,
                             NULL, 1, MB_OK );
            } else
            {
              /****************************************************************/
              /* Get array of device names                                    */
              /****************************************************************/
              irc = WrtQueryInputDeviceNames ( szDriverName[index1],
                                               &ulNumDevices, aDeviceName,
                                               aDeviceType, aDeviceID );
              if ( irc != WRT_NO_ERROR )
              {
                DisplayError ( hwnd, irc );
              } else
              {
                /**************************************************************/
                /* initialize the entries in the list box                     */
                /**************************************************************/
                hwndCombo2 = WinWindowFromID ( hwnd , wrtelc02 );

                for ( i= 0; i < ulNumDevices ; i++ )
                {
                  index2 = (SHORT) WinSendMsg ( hwndCombo2, LM_INSERTITEM,
                                       MPFROMSHORT ( LIT_END ),
                                       MPFROMP ( aDeviceName[i] ) );
                } /* endfor */
                /**************************************************************/
                /* Set the first item on the list at the top.                 */
                /**************************************************************/
                index2 = 0;                     /* intialize the index to zeror */
                WinSendMsg ( hwndCombo2, LM_SETTOPINDEX,
                             MPFROMSHORT ( index2 ), 0 );

                comboprams.fsStatus = WPM_TEXT;      /* change window text    */
                comboprams.cchText = sizeof ( aDeviceName[index2] );/*text size*/
                comboprams.pszText = aDeviceName[index2];    /*text to display*/
                WinSendMsg ( hwndCombo2, WM_SETWINDOWPARAMS,
                             &comboprams, 0 );

                /**************************************************************/
                /* initialize the entries in the Value ID list box            */
                /**************************************************************/
                hwndCombo3 = WinWindowFromID ( hwnd , wrtelc03 );

                /**************************************************************/
                /* initialize the value ID valid for this driver and device   */
                /**************************************************************/
                cbox = 0;
                for ( i=0; i < (PPMIDSIZE - 1); i++ )
                {
                  irc = WrtQueryInputDeviceVariable ( szDriverName[index1],
                                                      aDeviceName[index2],
                                                      ppmid[i].ValueID,
                                                      &ppmid[i].value,
                                                      NULL,
                                                      NULL
                                                     );
                  if ( irc == WRT_NO_ERROR )
                  {
                    /**********************************************************/
                    /* Mark the input device variable as suported.            */
                    /**********************************************************/
                    ppmid[i].active = 1;
                    cbox++;

                    /**********************************************************/
                    /*Set the input device variable in the list to choose from*/
                    /**********************************************************/
                    index3 = (SHORT) WinSendMsg ( hwndCombo3, LM_INSERTITEM,
                                           MPFROMSHORT ( LIT_END ),
                                           MPFROMP ( ppmid[i].name ) );

                  } else
                  {
                    /**********************************************************/
                    /* Mark the input device variable as not active.          */
                    /**********************************************************/
                    ppmid[i].active = 0;
                  } /* endif */
                } /* endfor */
                if ( cbox == 0 )
                {
                  WinEnableWindow ( (WinWindowFromID ( hwnd , wrtlc03 )), FALSE );
                  WinEnableWindow ( (WinWindowFromID ( hwnd , wrtelc03 )), FALSE );
                  WinEnableWindow ( (WinWindowFromID ( hwnd , wrtlc04 )), FALSE );
                  WinEnableWindow ( (WinWindowFromID ( hwnd , wrtelc04 )), FALSE );
                  sprintf(cbuffer,"No active variables Drv[%s] Name[%s]",
                  szDriverName[index1], aDeviceName[index2] );
                  WinMessageBox( HWND_DESKTOP,
                                 hwnd,
                                 cbuffer,
                                 NULL, 1, MB_OK );
                } else
                {
                  /************************************************************/
                  /*Find the first active input device variable to gets       */
                  /* its name                                                 */
                  /************************************************************/
                  for ( i= 0; i < (PPMIDSIZE - 1); i++)
                  {
                    if ( ppmid[i].active )
                    {
                       break;
                    } /* endif */
                  } /* endfor */
                  /************************************************************/
                  /* Set the first item on the list at the top.               */
                  /************************************************************/
                  index3 = 0;                 /* intialize the index to zeror */
                  WinSendMsg ( hwndCombo3, LM_SETTOPINDEX,
                               MPFROMSHORT ( index3 ), 0 );

                  comboprams.fsStatus = WPM_TEXT;       /* change window text */
                  comboprams.cchText = sizeof ( ppmid[i].name ); /* text size */
                  comboprams.pszText = ppmid[i].name;      /* text to display */
                  WinSendMsg ( hwndCombo3, WM_SETWINDOWPARAMS,
                               &comboprams, 0 );

                  if ( q_s )
                  {                 /* q_s == 1 then query */
                    sprintf ( cbuffer, "%li", ppmid[i].value );
                    WinSendDlgItemMsg(hwnd,
                                      wrtelc04,
                                      LM_INSERTITEM,
                                      MPFROM2SHORT(LIT_END, 0),
                                      MPFROMP( cbuffer ) );

                  } else
                  {                 /* q_s == 0 then set   */
                    /************************************************************/
                    /* check to see if the value can be set to 0 (disabled)     */
                    /************************************************************/
                    if (ppmid[i].disable == 1 )
                    {
                      WinSendMsg ( WinWindowFromID ( hwnd, wrtelc04 ),
                                  SPBM_SETLIMITS,
                                  MPFROMLONG ( ppmid[i].maxval ),/* MAX*/
                                  MPFROMLONG ( 0L ) /* MIN*/
                                  );
                    } else
                    {
                      WinSendMsg ( WinWindowFromID ( hwnd, wrtelc04 ),
                                  SPBM_SETLIMITS,
                                  MPFROMLONG ( ppmid[i].maxval ),/* MAX*/
                                  MPFROMLONG ( ppmid[i].minval ) /* MIN*/
                                  );
                    } /* endif */
                    /************************************************************/
                    /* Set the spin button value to the value that was query    */
                    /* from the system.                                         */
                    /************************************************************/
                    WinSendMsg ( WinWindowFromID ( hwnd, wrtelc04 ),
                                SPBM_SETCURRENTVALUE,
                                MPFROMLONG ( ppmid[i].value ),
                                0L
                                );
                    /************************************************************/
                    /* set the spin button's maximum and minimum values for the */
                    /* users to choose from.                                    */
                    /************************************************************/
                    WinSendMsg ( WinWindowFromID ( hwnd, wrtelc04 ),
                                SPBM_OVERRIDESETLIMITS,
                                MPFROMLONG ( ppmid[i].maxval ),/* MAX*/
                                MPFROMLONG ( ppmid[i].minval ) /* MIN*/
                                );
                  } /* endif */
                } /* endif */
                if ( q_s )
                {                /* q_s == 1 then query */
                  /**************************************************************/
                  /* Find out if the "Driver" is supported.                     */
                  /* If it is set "Driver as a choice in combo 2                */
                  /**************************************************************/
                  ulDatalen = 512;
                  irc = WrtQueryInputDeviceVariable ( szDriverName[index1],
                                                      "Driver",
                                                      ppmid[ PPMIDSIZE - 1 ].ValueID,
                                                      &ppmid[ PPMIDSIZE - 1 ].value,
                                                      &ulDatalen,
                                                      Data
                                                     );
                  if ( irc == WRT_NO_ERROR )
                  {
                    ppmid[ PPMIDSIZE - 1 ].active = 1;
                    WinSendMsg ( hwndCombo2, LM_INSERTITEM,
                                 MPFROMSHORT ( LIT_END ),
                                 MPFROMP ( "Driver" ) );
                  } else
                  {
                    ppmid[ PPMIDSIZE - 1 ].active = 0;
                  }  /* endif */
                } /* endif */
              } /* endif */
            } /* endif */
          } /* endif */
        } /* endif */
      } /* endif */
    } /* endif */
  } /* endif */
}

VOID updatecntrl ( HWND hwnd, INT q_s, HWND hwnd_temp )
{
  APIRET irc;
  CHAR szDrvName[32];
  ULONG aDeviceType[10];
  ULONG aDeviceID[10];
  ULONG ulDatalen;
  CHAR Data[512];
  WNDPARAMS comboprams;
  INT i;
  INT cbox;
  CHAR cbuffer[MAXCBUFFER];

  WinEnableWindow ( (WinWindowFromID ( hwnd , wrtlc04 )), TRUE );
  WinEnableWindow ( (WinWindowFromID ( hwnd , wrtelc04 )), TRUE );
  WinEnableWindow ( (WinWindowFromID ( hwnd , wrtlc03 )), TRUE );
  WinEnableWindow ( (WinWindowFromID ( hwnd , wrtelc03 )), TRUE );
  if ( hwnd_temp == hwndCombo1 )
  {
    /*******************************************************************/
    /* Get the Driver selected and find:                               */
    /* 1: devices supported by the driver                              */
    /* 2: ValueID supported by the 1st device                          */
    /* 3: Value of the 1st ValueID                                     */
    /*******************************************************************/
    /*******************************************************************/
    /* find the index of the selected item                             */
    /*******************************************************************/
    index1 = (SHORT)WinSendMsg ( hwndCombo1, LM_QUERYSELECTION, 0L, 0L );
    if ( index1 != LIT_NONE )
    {
      /*****************************************************************/
      /* get the name of the driver choosen.                           */
      /*****************************************************************/
      WinSendMsg ( hwndCombo1, LM_QUERYITEMTEXT,
                           MPFROM2SHORT ( index1, 32 ),
                           MPFROMP ( szDriverName[index1] ) );
      /*****************************************************************/
      /* Clear out the Devices list box and get the devices for the    */
      /* driver.                                                       */
      /*****************************************************************/
      WinSendMsg ( hwndCombo2, EM_CLEAR,
                             0L,
                             0L );
      WinSendMsg ( hwndCombo2, LM_DELETEALL,
                           0L,
                           0L );
      WinSendMsg ( hwndCombo3, EM_CLEAR,
                             0L,
                             0L );
      WinSendMsg ( hwndCombo3, LM_DELETEALL,
                           0L,
                           0L );
      index3 = 0;                /* intialize the index to zero */
      WinSendMsg ( hwndCombo3, LM_SETTOPINDEX,
                  MPFROMSHORT ( index3 ), 0 );

      comboprams.fsStatus = WPM_TEXT;    /* change window text */
      comboprams.cchText = sizeof ( "     " );/*text size*/
      comboprams.pszText = "     ";   /* text to display */
      WinSendMsg ( hwndCombo3, WM_SETWINDOWPARAMS,
                   &comboprams, 0 );
      WinSendDlgItemMsg(hwnd,
                            wrtelc04,
                            LM_DELETEALL,
                            0L,
                            0L );
      /*****************************************************************/
      /* Find out how many input device there are                      */
      /*****************************************************************/
      ulNumDevices = 0L;
      irc = WrtQueryInputDeviceNames ( szDriverName[index1],
                                       &ulNumDevices,
                                       NULL, NULL, NULL );
      if ( irc != WRT_NO_ERROR )
      {
         DisplayError ( hwnd, irc );
      } else
      {
        if ( ulNumDevices > 10L )
        {
          sprintf(cbuffer,"Too many devices[%ld] Driver[%s] for my ARRAY",
                  ulNumDevices, szDriverName[index1] );
          WinMessageBox( HWND_DESKTOP,
                         hwnd,
                         cbuffer,
                         NULL, 1, MB_OK );
        } else
        {
          /*************************************************************/
          /* Get array of device names                                 */
          /*************************************************************/
          irc = WrtQueryInputDeviceNames ( szDriverName[index1],
                                           &ulNumDevices, aDeviceName,
                                           aDeviceType, aDeviceID );
          if ( irc != WRT_NO_ERROR )
          {
            DisplayError ( hwnd, irc );
          } else
          {
            /***********************************************************/
            /* initialize the entries in the list box                  */
            /***********************************************************/
            hwndCombo2 = WinWindowFromID ( hwnd , wrtelc02 );

            for ( i= 0; i < ulNumDevices ; i++ )
            {
              index2 = (SHORT) WinSendMsg ( hwndCombo2, LM_INSERTITEM,
                                   MPFROMSHORT ( LIT_END ),
                                   MPFROMP ( aDeviceName[i] ) );
            } /* endfor */
            /***********************************************************/
            /* Set the first item on the list at the top.              */
            /***********************************************************/
            index2 = 0;                /* intialize the index to zeror */
            WinSendMsg ( hwndCombo2, LM_SETTOPINDEX,
                         MPFROMSHORT ( index2 ), 0 );

            comboprams.fsStatus = WPM_TEXT;      /* change window text */
            comboprams.cchText = sizeof ( aDeviceName[index2] );
            /*text size*/
            comboprams.pszText = aDeviceName[index2]; /*text to display*/
            WinSendMsg ( hwndCombo2, WM_SETWINDOWPARAMS,
                         &comboprams, 0 );

            /*************************************************************/
            /* initialize the entries in the Value ID list box           */
            /*************************************************************/
            hwndCombo3 = WinWindowFromID ( hwnd , wrtelc03 );

            update3 ( hwnd, q_s );
            if ( q_s )
            {            /* q_s == 1 is a query */
              /***********************************************************/
              /* Find out if the "Driver" is supported.                  */
              /* If it is set "Driver as a choice in combo 2             */
              /***********************************************************/
              ulDatalen = 512;
              irc = WrtQueryInputDeviceVariable ( szDriverName[index1],
                                                  "Driver",
                                                  ppmid[ PPMIDSIZE - 1 ].ValueID,
                                                  &ppmid[ PPMIDSIZE - 1 ].value,
                                                  &ulDatalen,
                                                  Data
                                                 );
              if ( irc == WRT_NO_ERROR )
              {
                ppmid[ PPMIDSIZE - 1 ].active = 1;
                WinSendMsg ( hwndCombo2, LM_INSERTITEM,
                             MPFROMSHORT ( LIT_END ),
                             MPFROMP ( "Driver" ) );
              } else
              {
                ppmid[ PPMIDSIZE - 1 ].active = 0;
              }  /* endif */
            } /* endif */
          } /* endif */
        } /* endif */
      } /* endif */
    } /* endif */
  } else
  {
    if ( hwnd_temp == hwndCombo2 )
    {
      /*****************************************************************/
      /* Get the Device selected and find:                             */
      /* 1: ValueID supported by the 1st device                        */
      /* 2: Value of the 1st ValueID                                   */
      /*******************************************************************/
      /*****************************************************************/
      /* get the name of the driver choosen.                           */
      /*****************************************************************/

      comboprams.fsStatus = WPM_TEXT;            /* get window text    */
      comboprams.cchText = sizeof ( szDrvName ); /* text size          */
      comboprams.pszText = szDrvName;            /* buffer to put text */
      WinSendMsg ( hwndCombo1, WM_QUERYWINDOWPARAMS, &comboprams, 0 );
      /*****************************************************************/
      /* find the index of the selected item                           */
      /*****************************************************************/
      index2 = (SHORT)WinSendMsg( hwndCombo2, LM_QUERYSELECTION, 0L, 0L);
      if ( index2 != LIT_NONE )
      {
        /***************************************************************/
        /* get the name of the device choosen.                         */
        /***************************************************************/
        WinSendMsg ( hwndCombo2, LM_QUERYITEMTEXT,
                             MPFROM2SHORT ( index2, 32 ),
                             MPFROMP ( aDeviceName[index2] ) );

        /***************************************************************/
        /* Clear out the ValueID list box and get the devices for the  */
        /* driver.                                                     */
        /***************************************************************/
        WinSendMsg ( hwndCombo3, EM_CLEAR,
                             0L,
                             0L );
        WinSendMsg ( hwndCombo3, LM_DELETEALL,
                             0L,
                             0L );
        index3 = 0;                     /* intialize the index to zero */
        WinSendMsg ( hwndCombo3, LM_SETTOPINDEX,
                     MPFROMSHORT ( index3 ), 0 );

        comboprams.fsStatus = WPM_TEXT;          /* change window text */
        comboprams.cchText = sizeof ( "       " );/*text size          */
        comboprams.pszText = "       ";           /* text to display   */
        WinSendMsg ( hwndCombo3, WM_SETWINDOWPARAMS,
                     &comboprams, 0 );
        if ( q_s )
        {
          WinSendDlgItemMsg(hwnd,
                               wrtelc04,
                               LM_DELETEALL,
                               0L,
                               0L );
        } else
        {
          WinSendMsg ( WinWindowFromID ( hwnd, wrtelc04 ),
                      SPBM_SETLIMITS,
                      MPFROMLONG ( 0L ),/* MAX*/
                      MPFROMLONG ( 0L ) /* MIN*/
                      );
          WinSendMsg ( WinWindowFromID ( hwnd, wrtelc04 ),
                      SPBM_SETCURRENTVALUE,
                      MPFROMLONG ( 0L ),
                      0L
                      );
        } /* endif */
        /***************************************************************/
        /* if the device name is "Driver" then only do driver          */
        /* else do all variables                                       */
        /***************************************************************/
        if ( strcmp ( "Driver", aDeviceName[index2] )  == 0 )
        {
          ulDatalen = 512;
          for ( i=0; i < ulDatalen ; i++)
          {
            Data[i] = 0;                         /* clear out old data */
          } /* endfor */
          irc = WrtQueryInputDeviceVariable ( szDrvName,
                                               "Driver",
                                               ppmid[ PPMIDSIZE - 1 ].ValueID,
                                               &ppmid[ PPMIDSIZE - 1 ].value,
                                               &ulDatalen,
                                               Data
                                              );
          if ( irc == WRT_NO_ERROR )
          {
            sprintf ( cbuffer, "Data length is %i", ulDatalen );
            WinSendDlgItemMsg(hwnd,
                               wrtelc04,
                               LM_INSERTITEM,
                               MPFROM2SHORT(LIT_END, 0),
                               MPFROMP( cbuffer ) );
            for ( i= 0; i < ulDatalen ; i++ )
            {
               sprintf ( cbuffer, "Data[%i] =%i", i, Data[i] );
               WinSendDlgItemMsg(hwnd,
                                  wrtelc04,
                                  LM_INSERTITEM,
                                  MPFROM2SHORT(LIT_END, 0),
                                  MPFROMP( cbuffer ) );
            } /* endfor */
            if ( ulDatalen == 0L)
            {
              WinEnableWindow ( (WinWindowFromID ( hwnd , wrtlc03 )),
                                    FALSE );
              WinEnableWindow ( (WinWindowFromID ( hwnd , wrtelc03 )),
                                    FALSE );
              WinEnableWindow ( (WinWindowFromID ( hwnd , wrtlc04 )),
                                    FALSE );
              WinEnableWindow ( (WinWindowFromID ( hwnd , wrtelc04 )),
                                    FALSE );
            } /* endif */
          } else
          {
            sprintf(cbuffer,"WrtQueryInputDeviceVariable with Driver Failed");
            WinMessageBox( HWND_DESKTOP,
                           hwnd,
                           cbuffer,
                           NULL, 1, MB_OK );
          } /* endif */
        } else
        {
          update3 ( hwnd, q_s );
        } /* endif */
      } /* endif */
    } else
    {
      if ( hwnd_temp == hwndCombo3 )
      {
        /***************************************************************/
        /* Get the valueID selected and find:                          */
        /* 2: Value of the ValueID                                     */
        /***************************************************************/
        /***************************************************************/
        /* find the index of the selected item                         */
        /***************************************************************/
        index3 = (SHORT)WinSendMsg( hwndCombo3,
                                    LM_QUERYSELECTION, 0L, 0L);
        if ( index3 != LIT_NONE )
        {
          if ( q_s )
          {
            /*************************************************************/
            /* Clear out the Value list box                              */
            /*************************************************************/
            WinSendDlgItemMsg(hwnd,
                                 wrtelc04,
                                 LM_DELETEALL,
                                 0L,
                                 0L );
          } else
          {
            /*************************************************************/
            /* Clear out the Value list box                              */
            /*************************************************************/
            WinSendMsg ( WinWindowFromID ( hwnd, wrtelc04 ),
                        SPBM_SETLIMITS,
                        MPFROMLONG ( 0L ),/* MAX*/
                        MPFROMLONG ( 0L ) /* MIN*/
                        );
            WinSendMsg ( WinWindowFromID ( hwnd, wrtelc04 ),
                        SPBM_SETCURRENTVALUE,
                        MPFROMLONG ( 0L ),
                        0L
                        );
          } /* endif */
          /*************************************************************/
          /*Find the ID coresponding to the index                      */
          /*************************************************************/
          cbox = -1;
          for ( i= 0; i< (PPMIDSIZE - 1); i++)
          {
            if ( ppmid[i].active )
            {
              if ( ++cbox == index3  )
              {
                 break;
              } /* endif */
            } /* endif */
          } /* endfor */
          if ( q_s )
          {
            sprintf ( cbuffer, "%li", ppmid[i].value );
            WinSendDlgItemMsg(hwnd,
                               wrtelc04,
                               LM_INSERTITEM,
                               MPFROM2SHORT(LIT_END, 0),
                               MPFROMP( cbuffer ) );
          } else
          {
            /************************************************************/
            /* check to see if the value can be set to 0 (disabled)     */
            /************************************************************/
            if (ppmid[i].disable == 1 )
            {
              WinSendMsg ( WinWindowFromID ( hwnd, wrtelc04 ),
                          SPBM_SETLIMITS,
                          MPFROMLONG ( ppmid[i].maxval ),/* MAX*/
                          MPFROMLONG ( 0L ) /* MIN*/
                          );
            } else
            {
              WinSendMsg ( WinWindowFromID ( hwnd, wrtelc04 ),
                          SPBM_SETLIMITS,
                          MPFROMLONG ( ppmid[i].maxval ),/* MAX*/
                          MPFROMLONG ( ppmid[i].minval ) /* MIN*/
                          );
            } /* endif */
            /*************************************************************/
            /* Set the spin button value to the value that was query     */
            /* from the system.                                          */
            /*************************************************************/
            WinSendMsg ( WinWindowFromID ( hwnd, wrtelc04 ),
                        SPBM_SETCURRENTVALUE,
                        MPFROMLONG ( ppmid[i].value ),
                        0L
                        );
            /*************************************************************/
            /* set the spin button's maximum and minimum values for      */
            /* the users to choose from.                                 */
            /*************************************************************/
            WinSendMsg ( WinWindowFromID ( hwnd, wrtelc04 ),
                        SPBM_OVERRIDESETLIMITS,
                        MPFROMLONG ( ppmid[i].maxval ),/* MAX            */
                        MPFROMLONG ( ppmid[i].minval ) /* MIN            */
                        );
          } /* endif */
        } /* endif */
      } else
      {
       sprintf(cbuffer,"No MATCH mp2[%ld] 1[%ld]2[%ld]3[%ld]",
               hwnd_temp, hwndCombo1, hwndCombo2, hwndCombo3 );
       WinMessageBox( HWND_DESKTOP,
                      hwnd,
                      cbuffer,
                      NULL, 1, MB_OK );
      } /* endif */
    } /* endif */
  } /* endif */
}

VOID update3 (HWND hwnd, INT q_s )
{
  APIRET irc;
  WNDPARAMS comboprams;
  INT i;
  INT cbox;
  CHAR cbuffer[MAXCBUFFER];
  /*************************************************************/
  /* initialize the value ID valid for this driver and device  */
  /*************************************************************/
  cbox = 0;
    for ( i=0; i < (PPMIDSIZE - 1) ; i++ )
    {
      irc = WrtQueryInputDeviceVariable ( szDriverName[index1],
                                          aDeviceName[index2],
                                          ppmid[i].ValueID,
                                          &ppmid[i].value,
                                          NULL,
                                          NULL
                                         );
      if ( irc == WRT_NO_ERROR )
      {
        /*******************************************************/
        /* Mark the input device variable as suported.         */
        /*******************************************************/
        ppmid[i].active = 1;
        cbox++;

        /*******************************************************/
        /* Set the input device variable in the list to choose */
        /* from                                                */
        /*******************************************************/
        index3 = (SHORT) WinSendMsg ( hwndCombo3, LM_INSERTITEM,
                               MPFROMSHORT ( LIT_END ),
                               MPFROMP ( ppmid[i].name ) );

      } else
      {
        /*******************************************************/
        /* Mark the input device variable as not active.       */
        /*******************************************************/
        ppmid[i].active = 0;
      } /* endif */
    } /* endfor */
    if ( cbox == 0)
    {
      WinEnableWindow ( (WinWindowFromID ( hwnd , wrtlc03 )), FALSE );
      WinEnableWindow ( (WinWindowFromID ( hwnd , wrtelc03 )), FALSE );
      WinEnableWindow ( (WinWindowFromID ( hwnd , wrtlc04 )), FALSE );
      WinEnableWindow ( (WinWindowFromID ( hwnd , wrtelc04 )), FALSE );
      sprintf(cbuffer,"No active variables Drv[%s] Name[%s]",
      szDriverName[index1], aDeviceName[index2] );
      WinMessageBox( HWND_DESKTOP,
                     hwnd,
                     cbuffer,
                     NULL, 1, MB_OK );
    } else
    {
      /*********************************************************/
      /* Find the first active input device variable to gets   */
      /* its name                                              */
      /*********************************************************/
      for ( i= 0; i < (PPMIDSIZE - 1); i++)
      {
        if ( ppmid[i].active )
        {
           break;
        } /* endif */
      } /* endfor */
      /*********************************************************/
      /* Set the first item on the list at the top.            */
      /*********************************************************/
      index3 = 0;                /* intialize the index to zero */
      WinSendMsg ( hwndCombo3, LM_SETTOPINDEX,
                   MPFROMSHORT ( index3 ), 0 );

      comboprams.fsStatus = WPM_TEXT;    /* change window text */
      comboprams.cchText = sizeof ( ppmid[i].name );/*text size*/
      comboprams.pszText = ppmid[i].name;   /* text to display */
      WinSendMsg ( hwndCombo3, WM_SETWINDOWPARAMS,
                   &comboprams, 0 );

      if ( q_s )
      {
        sprintf ( cbuffer, "%li", ppmid[i].value );
        WinSendDlgItemMsg(hwnd,
                          wrtelc04,
                          LM_INSERTITEM,
                          MPFROM2SHORT(LIT_END, 0),
                          MPFROMP( cbuffer ) );
      } else
      {
        /************************************************************/
        /* check to see if the value can be set to 0 (disabled)     */
        /************************************************************/
        if (ppmid[i].disable == 1 )
        {
          WinSendMsg ( WinWindowFromID ( hwnd, wrtelc04 ),
                      SPBM_SETLIMITS,
                      MPFROMLONG ( ppmid[i].maxval ),/* MAX*/
                      MPFROMLONG ( 0L ) /* MIN*/
                      );
        } else
        {
          WinSendMsg ( WinWindowFromID ( hwnd, wrtelc04 ),
                      SPBM_SETLIMITS,
                      MPFROMLONG ( ppmid[i].maxval ),/* MAX*/
                      MPFROMLONG ( ppmid[i].minval ) /* MIN*/
                      );
        } /* endif */
        /*********************************************************/
        /* Set the spin button value to the value that was query */
        /* from the system.                                      */
        /*********************************************************/
        WinSendMsg ( WinWindowFromID ( hwnd, wrtelc04 ),
                    SPBM_SETCURRENTVALUE,
                    MPFROMLONG ( ppmid[i].value ),
                    0L
                    );
        /*********************************************************/
        /* set the spin button's maximum and minimum values for  */
        /* the users to choose from.                             */
        /*********************************************************/
        WinSendMsg ( WinWindowFromID ( hwnd, wrtelc04 ),
                    SPBM_OVERRIDESETLIMITS,
                    MPFROMLONG ( ppmid[i].maxval ),/* MAX*/
                    MPFROMLONG ( ppmid[i].minval ) /* MIN*/
                    );
      } /* endif */
    } /* endif */
}
