/******************************************************************************/
/*                                                                            */
/* File Name   : WRTSAMPLE.H                                                  */
/*                                                                            */
/* Description : Example Pen for OS/2 Aware Application                       */
/*                                                                            */
/*                                                                            */
/* Copyright (C) 1993 IBM Corporation                                         */
/*                                                                            */
/*     DISCLAIMER OF WARRANTIES.  The following [enclosed] code is            */
/*     sample code created by IBM Corporation. This sample code is not        */
/*     part of any standard or IBM product and is provided to you solely      */
/*     for  the purpose of assisting you in the development of your           */
/*     applications.  The code is provided "AS IS", without                   */
/*     warranty of any kind.  IBM shall not be liable for any damages         */
/*     arising out of your use of the sample code, even if they have bee      */
/*     advised of the possibility of such damages.                            */
/*                                                                            */
/******************************************************************************/


#define IDD_BCDLG     2500
#define IDD_LCDLG     2501
#define IDD_SCDLG     2502
#define IDD_DCDLG     2503
#define IDD_SVDLG     2504
#define IDD_SSDLG     2505
#define IDD_WSDLG     2506
#define IDD_RSDLG     2507
#define IDD_EIDLG     2508
#define IDD_QVDLG     2509
#define IDD_DNDLG     2510
#define IDD_SNDLG     2511
#define ID_PTL_ARRAY  2512
#define PTR_BLOB      2513                 /* ID of BLOB pointer     */
#define wrtelc01      2514
#define wrtelc02      2515
#define wrtelc03      2516
#define wrtelc04      2517
#define wrtelc05      2518
#define wrtelc06      2519
#define wrtelc07      2520
#define wrtelc08      2521
#define wrtelc09      2522
#define wrtelc10      2523
#define wrtelc11      2524
#define wrtelc12      2525
#define wrtelc13      2526
#define wrtelc14      2527
#define wrtelc15      2528
#define wrtelc16      2529
#define wrtelc17      2530
#define wrtelc18      2531
#define wrtelc19      2532
#define wrtelc20      2533
#define wrtelc21      2534
#define wrtelc22      2535
#define wrtelc23      2536
#define wrtelc24      2537
#define wrtelc25      2606
#define wrtlc01       2538
#define wrtlc02       2539
#define wrtlc03       2540
#define wrtlc04       2541
#define wrtlc05       2542
#define wrtlc06       2543
#define wrtlc07       2544
#define wrtlc08       2545
#define wrtlc09       2546
#define wrtlc10       2547
#define wrtlc11       2548
#define wrtlc12       2549
#define wrtlc13       2550
#define wrtlc14       2551
#define wrtlc15       2552
#define wrtlc16       2553
#define wrtlc17       2554
#define wrtlc18       2555
#define wrtlc19       2556
#define wrtlc20       2557
#define wrtlc21       2558
#define wrtlc22       2559
#define wrtlc23       2560
#define wrtlc24       2561
#define EXIT          2562
#define SET           2563
#define READ          2564
#define IDMSG_UNKOWN  2565
#define ID_MAIN       2566
#define ID_CLEAR      2567
#define ID_EXIT       2568
#define ID_DLSTR      2569
#define ID_DLEND      2570
#define ID_FULL       2571
#define ID_SCAPS      2572
#define ID_LCAPS      2573
#define ID_BCAPS      2574
#define ID_DCAPS      2575
#define ID_QSVAL      2576
#define ID_SSVAL      2577
#define ID_WSVAL      2578
#define ID_RSVAL      2579
#define ID_ENUDR      2580
#define ID_QDNAM      2581
#define ID_QDVAR      2582
#define ID_SDVAR      2583
#define ID_SEMUL      2584
#define ID_BACKL      2585
#define ID_AUX        2586
#define ID_EVENT      2587
#define IDD_PADLG     2588
#define IDD_EVDLG     2589
#define IDD_BLDLG     2590
#define OBJECTID1     2591
#define OBJECTID2     2592

#define ID_DISP       WM_USER
#define ID_TAUX       WM_USER + 1
#define ID_TEVENT     WM_USER + 2
#define ID_TLIFTOFF   WM_USER + 3

#define MAXCBUFFER      80
#define QSVALUESIZE     19
#define PPMIDSIZE       11

typedef struct _PPMID
  {
 CHAR  name[30];
 ULONG ValueID;
 LONG  value;
 BOOL  active;
 LONG  maxval;
 LONG  minval;
 INT   disable;
  } PPMID;
typedef struct _QSVSTRUCT1             /* sturcture for the system values     */
 {
 CHAR  valname[40];
 ULONG valueid;          
 LONG  value;           
 LONG  valuemin;
 LONG  valuemax;
 INT   disable;
 } QSVSTRUCT1;


#ifdef WRTSAMPL_MAIN
HAB               habMain;
ULONG             ulocindx;
BOOL              blocarr[10];         /* array to identify good locator */
WRTLOCATORDEVINFO ldiarr[10];          /* Array of Locator capabilities structure */
ULONG             ulNumDrivers;
CHAR              szDriverName[10][32];
AUXPOINTDATA      apdExtra;
WRTEVENTDATA     edInfo;
PWRTEVENTDATA     pedInfo;
ULONG            ulbacklight_displayID[10];
PPMID ppmid[PPMIDSIZE] =
  {"PPMID_MOTION_STOP",PPMID_MOTION_STOP, 0L, 0, PPMID_MOTION_STOP_MAX, PPMID_MOTION_STOP_MIN,0 ,
   "PPMID_MOTION_START",PPMID_MOTION_START, 0L, 0, PPMID_MOTION_START_MAX, PPMID_MOTION_START_MIN,0 ,
   "PPMID_MINGESTURELENGTH",PPMID_MINGESTURELENGTH, 0L, 0, PPMID_MINGESTURELENGTH_MAX, PPMID_MINGESTURELENGTH_MIN,0 ,
   "PPMID_DISABLE_PROXIMITY",PPMID_DISABLE_PROXIMITY, 0L, 0, PPMID_DISABLE_PROXIMITY_MAX, PPMID_DISABLE_PROXIMITY_MIN,0 ,
   "PPMID_TOUCHOFFSET_X",PPMID_TOUCHOFFSET_X, 0L, 0, PPMID_TOUCHOFFSET_X_MAX, PPMID_TOUCHOFFSET_X_MIN,0 ,
   "PPMID_TOUCHOFFSET_Y",PPMID_TOUCHOFFSET_Y, 0L, 0, PPMID_TOUCHOFFSET_Y_MAX, PPMID_TOUCHOFFSET_Y_MIN,0 ,
   "PPMID_BACKLIGHTBLANK",PPMID_BACKLIGHTBLANK, 0L, 0, PPMID_BACKLIGHTBLANK_MAX, PPMID_BACKLIGHTBLANK_MIN,0 ,
   "PPMID_BACKLIGHTBLANK_INT",PPMID_BACKLIGHTBLANK_INT, 0L, 0, PPMID_BACKLIGHTBLANK_INT_MAX, PPMID_BACKLIGHTBLANK_INT_MIN,0 ,
   "PPMID_POINT_RATE",PPMID_POINT_RATE, 0L, 0, PPMID_POINT_RATE_MAX, PPMID_POINT_RATE_MIN,1 ,
   "PPMID_DIVIDE_RATE",PPMID_DIVIDE_RATE, 0L, 0, PPMID_DIVIDE_RATE_MAX, PPMID_DIVIDE_RATE_MIN,0 ,
   "PPMID_DEVICE_PARMS",PPMID_DEVICE_PARMS, 0L, 0, PPMID_DEVICE_PARMS_MAX, PPMID_DEVICE_PARMS_MIN,0};
QSVSTRUCT1 qsvalue[QSVALUESIZE] =
{"Version",PPMSV_VERSION,0,0,0,0 ,
 "Suspend",PPMSV_SUSPEND,0,0,1,0 ,
 "Pen Pause",PPMSV_PEN_PAUSE,0,PPMSV_PEN_PAUSE_MIN,PPMSV_PEN_PAUSE_MAX,0 ,
 "Pen Pause Enable",PPMSV_PEN_PAUSE_ENABLE,0,PPMSV_PEN_PAUSE_ENABLE_MIN,PPMSV_PEN_PAUSE_ENABLE_MAX,0 ,
 "Touch Pause",PPMSV_TOUCH_PAUSE,0,PPMSV_TOUCH_PAUSE_MIN,PPMSV_TOUCH_PAUSE_MAX,0 ,
 "Touch Pause Enable",PPMSV_TOUCH_PAUSE_ENABLE,0,PPMSV_TOUCH_PAUSE_ENABLE_MIN,PPMSV_TOUCH_PAUSE_ENABLE_MAX,0 ,
 "Mouse Pause",PPMSV_MOUSE_PAUSE,0,PPMSV_MOUSE_PAUSE_MIN,PPMSV_MOUSE_PAUSE_MAX,0 ,
 "Mouse Pause Enable",PPMSV_MOUSE_PAUSE_ENABLE,0,PPMSV_MOUSE_PAUSE_ENABLE_MIN,PPMSV_MOUSE_PAUSE_ENABLE_MAX,0 ,
 "Other Pause",PPMSV_OTHER_PAUSE,0,PPMSV_OTHER_PAUSE_MIN,PPMSV_OTHER_PAUSE_MAX,0 ,
 "Other Pause Enable",PPMSV_OTHER_PAUSE_ENABLE,0,PPMSV_OTHER_PAUSE_ENABLE_MIN,PPMSV_OTHER_PAUSE_ENABLE_MAX,0 ,
 "Pause Beep Freq.",PPMSV_PAUSEBEEPFREQ,0,PPMSV_PAUSEBEEPFREQ_MIN,PPMSV_PAUSEBEEPFREQ_MAX,1 ,
 "Reco Beep Enable",PPMSV_RECO_BEEP_ENABLE,0,PPMSV_RECO_BEEP_ENABLE_MIN,PPMSV_RECO_BEEP_ENABLE_MAX,1 ,
 "Min. Gesture Points",PPMSV_MINGESTUREPOINTS,0,PPMSV_MINGESTUREPOINTS_MIN,PPMSV_MINGESTUREPOINTS_MAX,0 ,
 "Reco. Ptr. Timer",PPMSV_RECOPTRTIMER,0,PPMSV_RECOPTRTIMER_MIN,PPMSV_RECOPTRTIMER_MAX,1 ,
 "Gesture Cancel Timeout",PPMSV_GESTURE_CANCEL_TIMEOUT,0,PPMSV_GESTURE_CANCEL_TIMEOUT_MIN,PPMSV_GESTURE_CANCEL_TIMEOUT_MAX,0 ,
 "Gesture Timeout",PPMSV_GESTURE_TIMEOUT,0,PPMSV_GESTURE_TIMEOUT_MIN,PPMSV_GESTURE_TIMEOUT_MAX,0 ,
 "Standardized Resolution",PPMSV_STANDARDIZED_RESOLUTION,0,PPMSV_STANDARDIZED_RESOLUTION_MIN,PPMSV_STANDARDIZED_RESOLUTION_MAX,0 ,
 "Character Box DX",PPMSV_CHARACTER_BOX_DX,0,0,0,0 ,
 "Character Box DY",PPMSV_CHARACTER_BOX_DY,0,0,0,0 };
INT AUXTEST = 0;
INT EVENTTEST = 0;
HWND     hwndFrame;
HWND     hwndAuxDLG;
HWND     hwndEventDLG;
BOOL       btoggle_aux = 0;
BOOL       btoggle_event = FALSE;
#else
extern HAB               habMain;
extern ULONG             ulocindx;
extern BOOL              blocarr[10];
extern WRTLOCATORDEVINFO ldiarr[10];
extern ULONG             ulNumDrivers;
extern CHAR              szDriverName[10][32];
extern AUXPOINTDATA      apdExtra;
extern WRTEVENTDATA      edInfo;
extern PWRTEVENTDATA     pedInfo;
extern ULONG             ulbacklight_displayID[10];
extern PPMID             ppmid[PPMIDSIZE];
extern QSVSTRUCT1        qsvalue[QSVALUESIZE];
extern INT      AUXTEST;
extern INT      EVENTTEST;
extern HWND     hwndFrame;
extern HWND     hwndDLG;
extern BOOL     btoggle_aux;
extern BOOL     btoggle_event;
#endif

INT main ( VOID );
MRESULT EXPENTRY ClientWndProc ( HWND hwnd, ULONG msg, MPARAM mp1, MPARAM mp2 );
MRESULT EXPENTRY MGDlgProc ( HWND hwnd, ULONG msg, MPARAM mp1, MPARAM mp2 );
MRESULT EXPENTRY ButCapDlgProc ( HWND hwnd, ULONG msg, MPARAM mp1, MPARAM mp2 );
MRESULT EXPENTRY LocCapDlgProc ( HWND hwnd, ULONG msg, MPARAM mp1, MPARAM mp2 );
MRESULT EXPENTRY SysCapDlgProc ( HWND hwnd, ULONG msg, MPARAM mp1, MPARAM mp2 );
MRESULT EXPENTRY DisCapDlgProc ( HWND hwnd, ULONG msg, MPARAM mp1, MPARAM mp2 );
MRESULT EXPENTRY SysValDlgProc ( HWND hwnd, ULONG msg, MPARAM mp1, MPARAM mp2 );
MRESULT EXPENTRY SSysVlDlgProc ( HWND hwnd, ULONG msg, MPARAM mp1, MPARAM mp2 );
MRESULT EXPENTRY WSysVlDlgProc ( HWND hwnd, ULONG msg, MPARAM mp1, MPARAM mp2 );
MRESULT EXPENTRY RSysVlDlgProc ( HWND hwnd, ULONG msg, MPARAM mp1, MPARAM mp2 );
MRESULT EXPENTRY EnumDrvDlgProc ( HWND hwnd, ULONG msg, MPARAM mp1, MPARAM mp2 );
MRESULT EXPENTRY QInpDevDlgProc ( HWND hwnd, ULONG msg, MPARAM mp1, MPARAM mp2 );
MRESULT EXPENTRY SInpDevDlgProc ( HWND hwnd, ULONG msg, MPARAM mp1, MPARAM mp2 );
MRESULT EXPENTRY QInDevNDlgProc ( HWND hwnd, ULONG msg, MPARAM mp1, MPARAM mp2 );
MRESULT EXPENTRY AUXPNTDlgProc ( HWND hwnd, ULONG msg, MPARAM mp1, MPARAM mp2 );
MRESULT EXPENTRY EVNTDTDlgProc ( HWND hwnd, ULONG msg, MPARAM mp1, MPARAM mp2 );
MRESULT EXPENTRY BACKLTDlgProc ( HWND hwnd, ULONG msg, MPARAM mp1, MPARAM mp2 );
MRESULT EXPENTRY ThreadWndProc (HWND hwnd, ULONG msg, MPARAM mp1, MPARAM mp2);
MRESULT EXPENTRY ThreadLiftOffProc (HWND hwnd, ULONG msg, MPARAM mp1, MPARAM mp2);
VOID DisplayError ( HWND hwnd, APIRET errcode );
VOID init_sysval( HWND hwnd, INT r_sw );
VOID enter_sysval( HWND hwnd, INT r_sw );
VOID updwn_sysval ( HWND hwnd );
VOID set_sysval ( HWND hwnd );
VOID disp_loccaps ( HWND hwnd, PWRTLOCATORDEVINFO lcInfo );
VOID disp_butcaps ( HWND hwnd, PWRTBUTTONDEVINFO bcInfo );
VOID disp_discaps ( HWND hwnd, PWRTDISPLAYDEVINFO dcInfo );
VOID init_invar ( HWND hwnd, INT q_s );
VOID updatecntrl ( HWND hwnd, INT q_s, HWND hwnd_temp );
VOID update3 (HWND hwnd, INT q_s );
VOID BackThread ( VOID * arg );
VOID LiftOffThread ( VOID * arg );
