#ifndef OS2ME_INCLUDED
#include <os2me.h>
#endif

#ifndef PENPMH_INCLUDED
#include <penpm.h>
#endif

#define  WC_INK_WINDOW        "MYINKINGWINDOW"

#define  ID_INK_WINDOW        999

#define  IME_NO_ERROR                  0
#define  IME_COULD_NOT_REGISTER_CLASS  1
#define  IME_COULD_NOT_CREATE_WINDOW   2
#define  IME_INVALID_POINTER           3

#define  IDD_AUDIO                    15

/*****************************************************************************
* This is the definition of the inking window data structure.                *
*****************************************************************************/
typedef struct                  /********************************************/
{                               /* Declaration of an application data type  */
   HWND          hwnd;          /* My window handle                         */
   HWND          hwndParent;    /* My parent window handle                  */
   HPS           hps;           /* Handle to presentation space             */
   HAB           hab;           /* Handle to anchor block                   */
   HDC           hdc;           /* Handle to device context                 */
   POINTL        points;        /* Point structure for saving last point    */
   SIZEL         OrgWindowSize; /* Size of window at time of stroke input   */
   LONG          CurrentColor;  /* Current ink color                        */
   PSTROKEDATA   pStrokeHead;   /* Pointer to first stroke in linked list   */
                                /*    of high resolution data               */
   PSTROKEDATA   pScaledHead;   /* Pointer to first stroke in linked list   */
                                /*    of scaled data                        */
   PSTROKEDATA   pCurrStroke;   /* Pointer to current stroke data           */
   LONG          NumSegments;   /* Number of graphic segments in PS         */
   PPOINTL       pCurrPoint;    /* Pointer to current point                 */
   USHORT        NumPointsLeft; /* Number of points left to be inked        */
   BOOL          fPlay;         /* Boolean flag to indicate play status     */
   BOOL          fRecord;       /* Boolean flag to indicate recording status*/
   BOOL          td;            /* Boolean flag to indicate touchdown status*/
}                               /*    TRUE = TOUCHDOWN, FALSE = LIFTOFF     */
MYWINDOWDATA;                   /* Structure data type                      */
                                /********************************************/

typedef MYWINDOWDATA *PMYWINDOWDATA; /* Pointer to structure data type      */

