#===================================================================
#
# SKETSAMP Make file
#
#===================================================================
#
#===================================================================
#
.SUFFIXES:
.SUFFIXES: .rc .res .obj .lst .c .hlp .itl .ipf

#===================================================================
#
#  Symbol definitions
#
#===================================================================

#===================================================================
#
# Default compilation macros for sample programs
#
#===================================================================
#
# Compile switchs
#
# /c      compile don't link
# /Fa+    Write ASM  file to DASD ( + = YES, - = NO
# /Fd+    Write temp file to DASD ( /Fd- = Write temp files to virtual memory )
# /Fl+    Write basic listing file  ( + = YES, - = NO )
# /Gd     use runtime library that: ( + = Dynamic Link, - = Static Link )
# /Ge     use runtime library that: ( + = EXE Built,    - = DLL Built )
# /Gm     use the multi-threaded libraries ( + = YES, - = NO )
# /Kb     Control basic diagnostic message (/Kb+ = ON, /Kb- = OFF )
# /Kp     Unused Parameter Messages        (/Kp+ = ON, /Kp- = OFF )
# /Fp2    Pack on two byte boundaries
# /Lf+    Write full  listing file  ( + = YES, - = NO )
# /Ms     use the system calling convention and not optilink as the default
# /O      Optimization: ( + = ON, - = OFF )
# /Rx     Subsystem Development (where x = e | n, e=runtime environ, n=none)
# /Se     allow cset  extensions
# /Ss     allow  "//" for comment lines
# /SpX    Pack on "X" boundary, where "X" is 1, 2, 4
# /Ti+    Compile for Debug
#

CCE = icc  /c /Kb+ /Kp+ /Sp2

LFLAGSD    = /ALIGN:4 /NOI
LIBS       = OS2386+PENPM
LINK       = LINK386 $(LFLAGSD)
RC         = rc

#-------------------------------------------------------------------
#   A list of all of the object files
#-------------------------------------------------------------------

all: sketsamp.exe sketsamp.hlp

sketsamp.obj:  sketsamp.c sketsamp.h
  $(CCE) sketsamp.c

sketsamp.hlp: sketsamp.ipf sketsamp.rc
  ipfc sketsamp.ipf


sketsamp.res: sketsamp.rc sketsamp.h sketsamp.ico sketsamp.dlg
    $(RC) -r sketsamp.rc

sketsamp.lnk: sketsamp.mak sketsamp.def
    echo sketsamp.obj        > sketsamp.lnk
    echo sketsamp.exe       >> sketsamp.lnk
    echo sketsamp.map       >> sketsamp.lnk
    echo $(LIBS)            >> sketsamp.lnk
    echo sketsamp.def       >> sketsamp.lnk

sketsamp.exe : sketsamp.obj sketsamp.def sketsamp.lnk sketsamp.mak sketsamp.res
    $(LINK) @sketsamp.lnk
    $(RC) sketsamp.res sketsamp.exe


