.*****************************************************************************/
.*                                                                           */
.*  File Name   : SKETSAMP.IPF                                               */
.*                                                                           */
.*  Description : Sketch Controls Sample Program Information File            */
.*                                                                           */
.*                                                                           */
.*  Copyright (C) 1993 IBM Corporation                                       */
.*                                                                           */
.*      DISCLAIMER OF WARRANTIES.  The following [enclosed] code is          */
.*      sample code created by IBM Corporation. This sample code is not      */
.*      part of any standard or IBM product and is provided to you solely    */
.*      for  the purpose of assisting you in the development of your         */
.*      applications.  The code is provided "AS IS", without                 */
.*      warranty of any kind.  IBM shall not be liable for any damages       */
.*      arising out of your use of the sample code, even if they have been   */
.*      advised of the possibility of such damages.                          */
.*                                                                           */
.*****************************************************************************/
:userdoc
.****************************************************************/
.*  Help from Sketch Window                                     */
.*  PANEL_SKETCH                                                */
.****************************************************************/
:h1 res=804.Sketch Input Window
You can draw or sketch to this window.
Press "SELECT CONTROL" to display a list box containing a list of
SKETCH control messages to choose from.  To execute a particular control
message, highlight an item from the list box and press "OK".  To get help
for a particular control message, highlight an item from the list box and press
"HELP".
.****************************************************************/
.*  Help for Control Message Selection                          */
.*  PANEL_MESSAGE      F1                                       */
.****************************************************************/
:h1 res=805.Control Message Selection
Highlight an item from the list box and press "HELP" to display help for
a particular Control Message.
:p.
Highlight an item from the list box and press "OK" to execute the Message.
.****************************************************************/
.*  Help for Auxiliary Data choice dialog                       */
.*  PANEL_AUX                                                   */
.****************************************************************/
:h1 res=806.Auxiliary Data
Choose "No Auxiliary Data" to send a zero value with SKM_SET_CTL_AUXDATA_MODE
and retrieve no auxiliary data for subsequent strokes.
Choose "All Auxiliary Data" to send a value of ADF_ALL with
SKM_SET_CTL_AUXDATA_MODE and retrieve all auxiliary data for subsequent
strokes.
.****************************************************************/
.*  Help for SKM_DELETE_ALL_STROKES                             */
.*  PANEL_SKM_DELETE_ALL_STROKES                                */
.****************************************************************/
:h1 res=815.SKM_DELETE_ALL_STROKES
This Control Message is sent to the control to request deletion of all
strokes in the stroke database.
:lines.
Returns:
TRUE  - Success (All strokes deleted)
FALSE - No strokes in the stroke database to delete.
:elines.
:p.
:hp4.Example:
:xmp.
:font facename=Helv size=10x10.
BOOL      rc;
:p.
rc = (BOOL) WinSendMsg(hSKETCHControl,
                       SKM_DELETE_ALL_STROKES,
                       NULL,
                       NULL);
:ehp4.
:font facename=default.
:exmp.
:p.
Press "OK" to execute control message SKM_DELETE_ALL_STROKES.
.****************************************************************/
.*  Help for SKM_UNDO_LAST_STROKE                               */
.*  PANEL_SKM_UNDO_LAST_STROKE                                  */
.****************************************************************/
:h1 res=816.SKM_UNDO_LAST_STROKE
This message tells the control to clear the ink of the last stroke
and to delete it from the stroke database.
:lines.
Returns:
TRUE  - Success (Last stroke deleted)
FALSE - No strokes in the stroke database to undo.
:elines.
:p.
:hp4.Example:
:xmp.
:font facename=Helv size=10x10.
BOOL      rc;
:p.
rc = (BOOL) WinSendMsg(hSKETCHControl,
                       SKM_UNDO_LAST_STROKE,
                       NULL,
                       NULL);
:ehp4.
:font facename=default.
:exmp.
:p.
Press "OK" to execute control message SKM_UNDO_LAST_STROKE.
.****************************************************************/
.*  Help for SKM_QUERY_CTL_DRAW_POINTER                         */
.*  PANEL_SKM_QUERY_CTL_DRAW_POINTER                            */
.****************************************************************/
:h1 res=817.SKM_QUERY_CTL_DRAW_POINTER
This message returns the drawing pointer handle.
:p.
:hp4.Example:
:xmp.
:font facename=Helv size=10x10.
HPOINTER  DrawPtr;
:p.
DrawPtr = (HPOINTER) WinSendMsg(hSKETCHControl,
                                SKM_QUERY_CTL_DRAW_POINTER,
                                NULL,
                                NULL);
:ehp4.
:font facename=default.
:exmp.
:p.
Press "OK" to execute control message SKM_QUERY_CTL_DRAW_POINTER.
.****************************************************************/
.*  Help for SKM_QUERY_CTL_INK_WIDTH                            */
.*  PANEL_SKM_QUERY_INK_CTL_WIDTH                               */
.****************************************************************/
:h1 res=818.SKM_QUERY_CTL_INK_WIDTH
This message returns the control's current ink width.
:lines.
Returns:
ULONG ulWidth - Control Ink Width
FALSE         - Failure
:elines.
:p.
:hp4.Example:
:xmp.
:font facename=Helv size=10x10.
ULONG ulWidth;
:p.
ulWidth = (ULONG) WinSendMsg(hSKETCHControl,
                             SKM_QUERY_CTL_INK_WIDTH,
                             NULL,
                             NULL);
:ehp4.
:font facename=default.
:exmp.
:p.
Press "OK" to execute control message SKM_QUERY_CTL_INK_WIDTH.
.****************************************************************/
.*  Help for SKM_QUERY_CTL_INK_COLOR                            */
.*  PANEL_SKM_QUERY_CTL_INK_COLOR                               */
.****************************************************************/
:h1 res=819.SKM_QUERY_CTL_INK_COLOR
This message returns the control's current ink color.
:lines.
Returns:
LONG lColor - Control Ink Color
CLR_ERROR -   Failure
:elines.
:p.
:hp4.Example:
:xmp.
:font facename=Helv size=10x10.
LONG  lColor;
:p.
lColor = (LONG) WinSendMsg(hSKETCHControl,
                           SKM_QUERY_CTL_INK_COLOR,
                           NULL,
                           NULL);
:ehp4.
:font facename=default.
:exmp.
:p.
Press "OK" to execute control message SKM_QUERY_CTL_INK_COLOR.
.****************************************************************/
.*  Help for SKM_QUERY_CTL_INVISIBLE_MODE                       */
.*  PANEL_SKM_QUERY_CTL_INVISIBLE_MODE                          */
.****************************************************************/
:h1 res=820.SKM_QUERY_CTL_INVISIBLE_MODE
This message queries the display mode of the ink, whether it is visible or
invisible.
:lines.
Returns:
TRUE  - Ink is invisible.
FALSE - Ink is visible.
:elines.
:p.
:hp4.Example:
:xmp.
:font facename=Helv size=10x10.
USHORT    usInvisible;
:p.
usInvisible = (USHORT) WinSendMsg(hSKETCHControl,
                                  SKM_QUERY_CTL_INVISIBLE_MODE,
                                  NULL,
                                  NULL);
:ehp4.
:font facename=default.
:exmp.
:p.
Press "OK" to execute control message SKM_QUERY_CTL_INVISIBLE_MODE.
.****************************************************************/
.*  Help for SKM_SET_CTL_DRAW_POINTER                           */
.*  PANEL_SKM_SET_CTL_DRAW_POINTER                              */
.****************************************************************/
:h1 res=821.SKM_SET_CTL_DRAW_POINTER
This message sets the drawing pointer handle and returns the previous pointer.
:p.
:hp4.Example:
:xmp.
:font facename=Helv size=10x10.
HPOINTER OldDrawPtr;
HPOINTER NewDrawPtr;
POINTER   PTR_PEN   blackpen.ptr
:p.
NewDrawPtr = WinLoadPointer(HWND_DESKTOP, 0L, PTR_PEN);
OldDrawPtr = (HPOINTER)WinSendMsg(hSKETCHControl,
                                  SKM_SET_CTL_DRAW_POINTER,
                                  MPFROMLONG(NewDrawPtr),
                                  NULL);
:ehp4.
:font facename=default.
:exmp.
:p.
Press "OK" to execute control message SKM_SET_CTL_DRAW_POINTER.
.****************************************************************/
.*  Help for SKM_SET_CTL_INK_WIDTH                              */
.*  PANEL_SKM_SET_CTL_INK_WIDTH                                 */
.****************************************************************/
:h1 res=822.SKM_SET_CTL_INK_WIDTH
This message sets the drawing stroke ink width for the control.
Strokes created after this message will have the newly set width.
The choices for the width are one or two pels.  The default ink
width is one pel.
:lines.
Returns:
TRUE  - Success
FALSE - Ink width cannot be set.
:elines.
:p.
:hp4.Example:
:xmp.
:font facename=Helv size=10x10.
BOOL  rc;
ULONG ulWidth = 2;
:p.
rc = (BOOL) WinSendMsg(hSKETCHControl,
                       SKM_SET_CTL_INK_WIDTH,
                       MPFROMLONG(ulWidth2),
                       NULL);
:ehp4.
:font facename=default.
:exmp.
:p.
Press "OK" to execute control message SKM_SET_CTL_INK_WIDTH.
.****************************************************************/
.*  Help for SKM_SET_CTL_INK_COLOR                              */
.*  PANEL_SKM_SET_CTL_INK_COLOR                                 */
.****************************************************************/
:h1 res=823.SKM_SET_CTL_INK_COLOR
This message sets the drawing stroke color for the control.
Strokes created after this message will have the newly set color.
:lines.
Returns:
TRUE  - Success
FALSE - Ink color cannot be set.
:elines.
:p.
:hp4.Example:
:xmp.
:font facename=Helv size=10x10.
BOOL      rc;
:p.
rc = (BOOL) WinSendMsg(hSKETCHControl,
                       SKM_SET_CTL_INK_COLOR,
                       MPFROMLONG(CLR_RED),
                       NULL);
:ehp4.
:font facename=default.
:exmp.
:p.
Press "OK" to execute control message SKM_SET_CTL_INK_COLOR.
.****************************************************************/
.*  Help for SKM_SET_CTL_INVISIBLE_MODE                         */
.*  PANEL_SKM_SET_CTL_INVISIBLE_MODE                            */
.****************************************************************/
:h1 res=824.SKM_SET_CTL_INVISIBLE_MODE
This message sets the ink color to be invisible or visible.
Set param1 to TRUE if you wish to select invisible ink.
Set param1 to FALSE if you wish to select visible ink.
:lines.
Returns:
TRUE  - Success
FALSE - Failure
:elines.
:p.
:hp4.Example:
:xmp.
:font facename=Helv size=10x10.
BOOL   rc;
USHORT usInvisible = TRUE;
:p.
rc =  (BOOL) WinSendMsg(hSKETCHControl,
                        SKM_SET_CTL_INVISIBLE_MODE
                        MPFROMSHORT(usInvisible),
                        NULL);
:ehp4.
:font facename=default.
:exmp.
:p.
Press "OK" to select invisible or visible mode and execute.
.****************************************************************/
.*  Help for SKM_RENDER_TO_CLIPBOARD                            */
.*  PANEL_SKM_RENDER_TO_CLIPBOARD                               */
.****************************************************************/
:h1 res=825.SKM_RENDER_TO_CLIPBOARD
This message copies the screen resolution bitmap image from the sketch
control to the Clipboard.
:lines.
Returns:
TRUE  - Success
FALSE - Failure
:elines.
:p.
:hp4.Example:
:xmp.
:font facename=Helv size=10x10.
BOOL      rc;
:p.
rc = (BOOL) WinSendMsg(hSKETCHControl,
                       SKM_RENDER_TO_CLIPBOARD,
                       NULL,
                       NULL);
:ehp4.
:font facename=default.
:exmp.
:p.
Press "OK" to execute control message SKM_RENDER_TO_CLIPBOARD.
.****************************************************************/
.*  Help for SKM_QUERY_CTL_STROKE_COUNT                         */
.*  PANEL_SKM_QUERY_CTL_STROKE_COUNT                            */
.****************************************************************/
:h1 res=826.SKM_QUERY_CTL_STROKE_COUNT
This message is used to get the count of strokes in the stroke database.
:p.
:hp4.Example:
:xmp.
:font facename=Helv size=10x10.
ULONG  ulStrokeCount;
:p.
ulStrokeCount =  (ULONG) WinSendMsg(hSKETCHControl,
                                    SKM_QUERY_CTL_STROKE_COUNT,
                                    NULL,
                                    NULL);
:ehp4.
:font facename=default.
:exmp.
:p.
Press "OK" to execute control message SKM_QUERY_CTL_STROKE_COUNT.
.****************************************************************/
.*  Help for SKM_SET_STROKE_INK_COLOR                           */
.*  PANEL_SKM_SET_STROKE_INK_COLOR                              */
.****************************************************************/
:h1 res=827.SKM_SET_STROKE_INK_COLOR
This message is used to reset the color attribute of stroke(i) in the
stroke database.  Parameter mp1 specifies the stroke number(1..n), and mp2
is the value for stroke(i) ink color.
:lines.
Returns:
TRUE  - Success
FALSE - Failure
:elines.
:p.
:hp4.Example:
:xmp.
:font facename=Helv size=10x10.
BOOL   rc;
LONG   lStrokeColor = CLR_RED;
ULONG  ulStrokeNumber = 1;
:p.
rc = (BOOL) WinSendMsg(hSKETCHControl,
                       SKM_SET_STROKE_INK_COLOR,
                       MPFROMLONG(ulStrokeNumber),
                       MPFROMP(lStrokeColor) );
:ehp4.
:font facename=default.
:exmp.
:p.
Press "OK" to execute control message SKM_SET_STROKE_INK_COLOR.
.****************************************************************/
.*  Help for SKM_SET_STROKE_INK_WIDTH                           */
.*  PANEL_SKM_SET_STROKE_INK_WIDTH                              */
.****************************************************************/
:h1 res=828.SKM_SET_STROKE_INK_WIDTH
.****************************************************************/
This message is used to reset the width attribute of stroke(i) in the
stroke database.  Parameter mp1 specifies the stroke number(1..n), and mp2
is the value for stroke(i) ink width.
:lines.
Returns:
TRUE  - Success
FALSE - Failure
:elines.
:p.
:hp4.Example:
:xmp.
:font facename=Helv size=10x10.
BOOL   rc;
ULONG  ulStrokeWidth = 2;
ULONG  ulStrokeNumber = 1;
:p.
rc = (BOOL) WinSendMsg(hSKETCHControl,
                       SKM_SET_STROKE_INK_WIDTH,
                       MPFROMLONG(ulStrokeNumber),
                       MPFROMLONG(ulStrokeWidth) );
:ehp4.
:font facename=default.
:exmp.
:p.
Press "OK" to execute control message SKM_SET_STROKE_INK_WIDTH.
.****************************************************************/
.*  Help for SKN_INK_COLOR_CHANGE                               */
.*  PANEL_SKN_INK_COLOR_CHANGE                                  */
.****************************************************************/
:h1 res=829.SKN_INK_COLOR_CHANGE
This Notification Message is sent to the parent by the control whenever
the ink color for the drawing stroke has been changed.  Parameter
mp2 will contain the value of the color changed to.
:p.
:hp4.Example:
:xmp.
:font facename=Helv size=10x10.
LONG  lColor;
:p.
case WM_CONTROL:
       switch(SHORT2FROMMP(mp1))
         {
           case SKN_INK_COLOR_CHANGE:
             lColor = LONGFROMMP(mp2);
             break;
         }
:ehp4.
:font facename=default.
:exmp.
:p.
Press "OK" to change the ink color and receive Notification Message
SKN_INK_COLOR_CHANGE.
.****************************************************************/
.*  Help for SKN_STROKE_ADD                                     */
.*  PANEL_SKN_STROKE_ADD                                        */
.****************************************************************/
:h1 res=830.SKN_STROKE_ADD
This Notification Message is sent to the parent by the control when a stroke
is about to be added to the stroke database.  Parameter mp2 will contain the
stroke number of the stroke about to be added.  If the parent returns TRUE to
the message, the stroke will not be added.  If the parent returns FALSE, the
stroke will be added.
:p.
:hp4.Example:
:xmp.
:font facename=Helv size=10x10.
ULONG  ulStrokeNumber;
BOOL   AddTheStroke = TRUE;
:p.
case WM_CONTROL:
       switch(SHORT2FROMMP(mp1))
         {
           case SKN_STROKE_ADD:
             lStrokeNumber = LONGFROMMP(mp2);
             if (AddTheStroke)
               return((MRESULT) FALSE);
             else
               return((MRESULT) TRUE);
         }
:ehp4.
:font facename=default.
:exmp.
:p.
Press "OK".  When the next stroke is made in the sketch window, the
Sketch Control will send Notification message SKN_STROKE_ADD.
.****************************************************************/
.*  Help for SKN_STROKE_UNDO                                    */
.*  PANEL_SKN_STROKE_UNDO                                       */
.****************************************************************/
:h1 res=831.SKN_STROKE_UNDO
This Notification Message is sent to the parent by the control when a stroke
is about to be deleted from the stroke database.  Parameter mp2 will contain
the stroke number of the stroke about to be deleted.  If the parent returns
TRUE to the message, the stroke will not be deleted.  If the parent returns
FALSE, the stroke will be deleted.
:p.
:hp4.Example:
:xmp.
:font facename=Helv size=10x10.
ULONG  ulStrokeNumber;
BOOL   UndoTheStroke = TRUE;
:p.
case WM_CONTROL:
       switch(SHORT2FROMMP(mp1))
         {
           case SKN_STROKE_UNDO:
             ulStrokeNumber = LONGFROMMP(mp2);
             if (UndoTheStroke)
               return((MRESULT) FALSE);
             else
               return((MRESULT) TRUE);
         }
:ehp4.
:font facename=default.
:exmp.
:p.
Press "OK" to undo the last stroke and receive Notification Message
SKN_STROKE_UNDO.
.****************************************************************/
.*  Help for SKN_CONTROL_CLEARED                                */
.*  PANEL_SKN_CONTROL_CLEARED                                   */
.****************************************************************/
:h1 res=832.SKN_CONTROL_CLEARED
This Notification Message is sent to the parent by the control whenever the
stroke database is about to be cleared of all strokes.  Parameter mp2 will
contain the number of strokes about to be deleted.  If the parent returns
TRUE to the message, the strokes will not be deleted, if the parent returns
FALSE, all strokes will be deleted from the stroke database.
:p.
:hp4.Example:
:xmp.
:font facename=Helv size=10x10.
ULONG  ulStrokes;
BOOL   ClearAllStrokes = TRUE;
:p.
case WM_CONTROL:
      switch(SHORT2FROMMP(mp1))
        {
          case SKN_CONTROL_CLEARED:
            ulStrokes = LONGFROMMP(mp2);
            if (ClearAllStrokes)
              return((MRESULT) FALSE);
            else
              return((MRESULT) TRUE);
        }
:ehp4.
:font facename=default.
:exmp.
:p.
Press "OK" to clear all strokes and receive Notification Message
SKN_CONTROL_CLEARED.
.****************************************************************/
.*  Help for SKM_SET_CTL_AUXDATA_MODE                           */
.*  PANEL_SKM_SET_CTL_AUXDATA_MODE                              */
.****************************************************************/
:h1 res=833.SKM_SET_CTL_AUXDATA_MODE
This message informs the control that subsequent strokes will retrieve the
specified pen stroke auxiliary data if the data can be returned by the device
(pen, touch, mouse).
:p.
Following is a list of the ADF_* flags defined in the header file penpm.h:
:sl compact.
:li.ADF_TIMESTAMP- Point timestamp
:li.ADF_FLAGS    - Point flags
:li.ADF_SCREENZ  - Z axis value
:li.ADF_ANGLE    - Device angle
:li.ADF_ROTATION - Device rotation
:li.ADF_BUTTON   - Button status
:li.ADF_OEM      - OEM spec. data byte cnt
:li.ADF_USER     - always set
:li.ADF_ALL      - All fields
:li.ADF_OEM_COUNT_MASK - OEM valid count
:esl.
:p.
These values can be ORed together to retrieve multiple fields of auxiliary
data or a zero can be sent to reset so that no auxiliary data is retrieved
for subsequent strokes.
:p.
:hp4.Example:
:xmp.
:font facename=Helv size=10x10.
BOOL   rc;
ULONG ulAuxData = ADF_TIMESTAMP;
:p.
rc =  (BOOL) WinSendMsg(hSKETCHControl,
                        SKM_SET_CTL_AUXDATA_MODE,
                        MPFROMLONG(ulAuxData),
                        NULL);
:ehp4.
:font facename=default.
:exmp.
:p.
Press "OK" to choose to have subsequent strokes retrieve all or none
of the auxiliary data and execute the message.
.****************************************************************/
.*  Help for SKN_INK_WIDTH_CHANGE                               */
.*  PANEL_SKN_INK_WIDTH_CHANGE                                  */
.****************************************************************/
:h1 res=834.SKN_INK_WIDTH_CHANGE
This Notification Message is sent to the parent by the control whenever
the ink width for the drawing stroke has been changed.  Parameter
mp2 will contain the value of the width changed to.
:p.
:hp4.Example:
:xmp.
:font facename=Helv size=10x10.
LONG  ulWidth;
case WM_CONTROL:
       switch(SHORT2FROMMP(mp1))
         {
           case SKN_INK_WIDTH_CHANGE:
           ulWidth = LONGFROMMP(mp2);
           break;
         }
:ehp4.
:font facename=default.
:exmp.
:p.
Press "OK" to change the ink width and receive a SKN_INK_WIDTH_CHANGE
notification message.
.****************************************************************/
.*  Help for SKM_GET_BITMAP                                     */
.*  PANEL_SKM_GET_BITMAP                                        */
.****************************************************************/
:h1 res=835.SKM_GET_BITMAP
This message creates a screen resolution bitmap image from the sketch
control and returns its handle.
:p.
:hp4.Example:
:xmp.
:font facename=Helv size=10x10.
HBITMAP   hBitmap;

hBitmap = (HBITMAP) WinSendMsg(hSKETCHControl,
                    SKM_GET_BITMAP,
                    NULL,
                    NULL);
:ehp4.
:font facename=default.
:exmp.
:p.
The handle returned can be used to save the bitmap to a file on disk.
Press "OK" to execute control message SKM_GET_BITMAP.  The bitmap handle
will be displayed and you may choose to save the bitmap to a file.
.****************************************************************/
.*  Help for SKM_QUERY_BITMAP_SIZE                              */
.*  PANEL_SKM_QUERY_BITMAP_SIZE                                 */
.****************************************************************/
:h1 res=836.SKM_QUERY_BITMAP_SIZE
This message returns the size of the bitmap that could be returned with
the SKM_GET_BITMAP or the SKM_RENDER_TO_CLIPBOARD messages.  The returned
values are dependent on whether the control has a border.  If the control
does not contain a border, the bitmap's size is the same size as the
control's window.  If the control does contain a border, the bitmap's size
will be reduced by 2 pixels in the X and Y directions.
:lines.
Returns:  size(ULONG)
LOUSHORT = Size in pixels in the X direction.
HIUSHORT = Size in pixels in the Y direction.
FALSE    = An error occured.
:elines.
:p.
:hp4.Example:
:xmp.
:font facename=Helv size=10x10.
ULONG     ulSize;
SHORT     sSizeX;
SHORT     sSizeY;

ulSize = (ULONG) WinSendMsg(hSKETCHControl,
                 SKM_QUERY_BITMAP_SIZE,
                 NULL,
                 NULL);

sSizeX = LOUSHORT(lSize);
sSizeY = HIUSHORT(lSize);
:ehp4.
:font facename=default.
:exmp.
:p.
Press "OK" to execute control message SKM_QUERY_BITMAP_SIZE.
.****************************************************************/
.*  Help for SKM_QUERY_STROKE_LENGTH                            */
.*  PANEL_SKM_QUERY_STROKE_LENGTH                               */
.****************************************************************/
:h1 res=837.SKM_QUERY_STROKE_LENGTH
This message is used to retrieve the size, in bytes, of stroke(i).
A zero return code signals an error, such as stroke not available.
:p.
:hp4.Example:
:xmp.
:font facename=Helv size=10x10.
ULONG   ulLength;
ULONG   ulStrokeNumber = 1;
:p.
ulLength = (ULONG) WinSendMsg(hSKETCHControl,
                              SKM_QUERY_STROKE_LENGTH,
                              MPFROMLONG(ulStrokeNumber),
                              NULL);
:ehp4.
:font facename=default.
:exmp.
:p.
Press "OK" to execute control message SKM_QUERY_STROKE_INK_WIDTH.
.****************************************************************/
.*  Help for SKM_QUERY_STROKE_DATA                              */
.*  PANEL_SKM_QUERY_STROKE_DATA                                 */
.****************************************************************/
:h1 res=838.SKM_QUERY_STROKE_DATA
This message is used to retrieve stroke(i) from the stroke database.  MP1
specifies the stroke(1..n), MP2 is a pointer to a buffer to hold the contents
of the stroke, including any aux data.  The buffer size is determined by
a SKM_QUERY_STROKE_LENGTH.
:lines.
Returns:
TRUE  - Success
FALSE - Failure
:elines.
:p.
:hp4.Example:
:xmp.
:font facename=Helv size=10x10.
ULONG  ulLength;
ULONG  ulStrokeNumber = 1;
BOOL   rc;
PSKETCHSTROKEDEF pStrokeData;

ulLength = (LONG) WinSendMsg(hSKETCHControl,
                             SKM_QUERY_STROKE_LENGTH,
                             MPFROMLONG(ulStrokeNumber),
                             NULL);

pStrokeData = malloc(ulLength);
rc = (BOOL) WinSendMsg(hSKETCHControl,
                       SKM_QUERY_STROKE_DATA,
                       MPFROMLONG(ulStrokeNumber),
                       MPFROMP(pStrokeData) );


free(pStrokeData);
:ehp4.
:font facename=default.
:exmp.
:p.
Press "OK" to execute control message SKM_QUERY_STROKE_DATA.
.****************************************************************/
.*  Help for SKM_QUERY_STROKE_INK_COLOR                         */
.*  PANEL_SKM_QUERY_STROKE_INK_COLOR                            */
.****************************************************************/
:h1 res=839.SKM_QUERY_STROKE_INK_COLOR
This message returns the color attribute of stroke(i) in the stroke database.
Parameter mp1 specifies the stroke number(1..n) to query.
:lines.
Returns:
LONG lColor - color of stroke number(1..n)
CLR_ERROR -    Failure
:elines.
:p.
:hp4.Example:
:xmp.
:font facename=Helv size=10x10.
LONG  lColor;
ULONG  ulStrokeNumber = 1;
:p.
lColor = (LONG) WinSendMsg(hSKETCHControl,
                           SKM_QUERY_STROKE_INK_COLOR,
                           MPFROMLONG(ulStrokeNumber),
                           NULL );
:ehp4.
:font facename=default.
:exmp.
:p.
Press "OK" to execute control message SKM_QUERY_STROKE_INK_COLOR.
.****************************************************************/
.*  Help for SKM_QUERY_STROKE_INK_WIDTH                         */
.*  PANEL_SKM_QUERY_STROKE_INK_WIDTH                            */
.****************************************************************/
:h1 res=840.SKM_QUERY_STROKE_INK_WIDTH
This message returns the width attribute of stroke(i) in the stroke database.
Parameter mp1 specifies the stroke number(1..n) to query.
:lines.
Returns:
ULONG ulWidth - width of stroke number(1..n)
FALSE         - Failure
:elines.
:p.
:hp4.Example:
:xmp.
:font facename=Helv size=10x10.
ULONG   ulWidth;
ULONG   ulStrokeNumber = 1;
:p.
ulWidth = (LONG) WinSendMsg(hSKETCHControl,
                            SKM_QUERY_STROKE_INK_WIDTH,
                            MPFROMLONG(ulStrokeNumber),
                            NULL );
:ehp4.
:font facename=default.
:exmp.
:p.
Press "OK" to execute control message SKM_QUERY_STROKE_INK_WIDTH.
:euserdoc.
