
/*****************************************************************************/
/*                                                                           */
/*  File Name   : SKETSAMP.H                                                 */
/*                                                                           */
/*  Description : Sample Program for SKETCH Controls                         */
/*  Copyright (C) 1993 IBM Corporation                                       */
/*                                                                           */
/*      DISCLAIMER OF WARRANTIES.  The following [enclosed] code is          */
/*      sample code created by IBM Corporation. This sample code is not      */
/*      part of any standard or IBM product and is provided to you solely    */
/*      for  the purpose of assisting you in the development of your         */
/*      applications.  The code is provided "AS IS", without                 */
/*      warranty of any kind.  IBM shall not be liable for any damages       */
/*      arising out of your use of the sample code, even if they have been   */
/*      advised of the possibility of such damages.                          */
/*                                                                           */
/*****************************************************************************/

#define ID_MAIN       1000       /* main window */

/***************/
/* Dialog ID's */
/***************/
#define IDC_SELECT                  501       /* Pushbutton to Select Control*/
#define IDC_SKETCH                  502
#define IDC_SKETCH_HELP             503
#define IDC_CANCEL                  504

#define MESSAGE_MAX   40         /* Maximum length of a Control Message      */
#define MAXTEXTLEN    75         /* Maximum length for text.                 */

/****************************/
/* Draw Pointer ID's        */
/****************************/
#define PTR_PEN       202

/************************************************/
/* List Box  ID's   - Control Message Selection */
/************************************************/
#define IDD_SELECTCONTROL           525
#define IDC_SELECTBOX               526
#define IDC_MESSAGE_HELP            527

/************************************************/
/* Dlg Box ID's     - Color Selection           */
/************************************************/
#define IDD_COLORSELECTION          535
#define IDC_WHITE                   536
#define IDC_BLACK                   537
#define IDC_BLUE                    538
#define IDC_RED                     539
#define IDC_PINK                    540
#define IDC_GREEN                   541
#define IDC_CYAN                    542
#define IDC_YELLOW                  543
#define IDC_DARKGRAY                544
#define IDC_DARKBLUE                545
#define IDC_DARKRED                 546
#define IDC_DARKPINK                547
#define IDC_DARKGREEN               548
#define IDC_DARKCYAN                549
#define IDC_BROWN                   550
#define IDC_PALEGRAY                551

/**************************************************/
/* Dlg Box ID's     - Visible/Invisible Selection */
/**************************************************/
#define IDD_VISIBLE                 560
#define IDC_VISIBLE                 561
#define IDC_INVISIBLE               562

/*************************************************/
/* Dlg Box ID's     - Stroke Number Selection    */
/*************************************************/
#define IDD_GETSTROKENUMBER         563
#define IDC_STROKETEXT              564
#define IDC_STROKEINPUT             565

/************************************************/
/* Dlg Box ID's     - Stroke Width Selection    */
/************************************************/
#define IDD_GETWIDTH                566
#define IDC_WIDTHTEXT               567
#define IDC_WIDTHINPUT              568

/**************************************************/
/* Dlg Box ID's     - Auxiliary Data Selection    */
/**************************************************/
#define IDD_AUX                     570
#define IDC_ALLAUX                  571
#define IDC_NONEAUX                 572
#define IDC_AUX_HELP                573

/************************************************/
/* Dlg Box ID's     - Display Stroke Info       */
/************************************************/
#define IDD_STROKE_INFO             575
#define IDC_STROKE_NUMBER           576
#define IDC_STROKE_NUMBER_DATA      577
#define IDC_STROKE_COLOR            578
#define IDC_STROKE_COLOR_DATA       579
#define IDC_STROKE_WIDTH            580
#define IDC_STROKE_WIDTH_DATA       581
#define IDC_TIMESTAMP               582
#define IDC_TIMESTAMP_DATA          583
#define IDC_STRUCT_SIZE             584
#define IDC_STRUCT_SIZE_DATA        585
#define IDC_SOURCE                  586
#define IDC_SOURCE_DATA             587
#define IDC_RESOLUTION              588
#define IDC_RESOLUTION_DATA         589
#define IDC_SAMPLE_RATE             590
#define IDC_SAMPLE_RATE_DATA        591
#define IDC_NUMPOINTS               592
#define IDC_NUMPOINTS_DATA          593

/****************************/
/* Message Box ID           */
/****************************/
#define IDD_MSGBOX                600


/*********************************************/
/* Test Messagetable Ids                     */
/*********************************************/
#define IDMSG_SHOWINFO                700    /* Information Message                                  */
#define IDMSG_INK_COLOR_QUERY         701    /* The INK color is %s.                                 */
#define IDMSG_INK_COLOR_SET           702    /* The INK color has been set to %s.                    */
#define IDMSG_INK_WIDTH_QUERY         703    /* The INK width is %s.                                 */
#define IDMSG_INK_WIDTH_SET           704    /* The INK width has been set to %s.                    */
#define IDMSG_DISPLAY_MODE            705    /* The display mode is %s.                              */
#define IDMSG_DRAWPOINTER_QUERY       706    /* The drawing pointer is %s."                          */
#define IDMSG_DRAWPOINTER_SET         707    /* Set Drawing Pointer:%s"                              */
#define IDMSG_INK_COLOR_CHANGE        708    /* COLOR CHANGE NOTIFICATION:  Ink color changed to %s! */
#define IDMSG_INK_WIDTH_CHANGE        709    /* WIDTH CHANGE NOTIFICATION:  Ink width changed to %s! */
#define IDMSG_NOTHING_CLEAR           710    /* No Strokes in Database to clear!                     */
#define IDMSG_NOTHING_UNDO            711    /* No Strokes in Database to undo!                      */
#define IDMSG_STROKE_COUNT            712    /* Database Stroke Count = %s.                          */
#define IDMSG_AUX_ALL_SET             714    /* Subsequent strokes will retrieve auxiliary data.     */
#define IDMSG_AUX_NONE_SET            715    /* Subsequent strokes will NOT retrieve auxiliary data. */
#define IDMSG_BMP_SAVED_OK            716    /* Bitmap Saved to file %s!"                            */
#define IDMSG_BITMAP_SIZE_QUERY       717    /* Bitmap Size:%s"                                    */
#define IDMSG_STROKE_COLOR_QUERY      718    /* Query Stroke Color:%s"                             */
#define IDMSG_STROKE_COLOR_SET        719    /* Set Stroke Color:%s                                */
#define IDMSG_STROKE_WIDTH_QUERY      720    /* Query Stroke Width:%s"                             */
#define IDMSG_STROKE_WIDTH_SET        721    /* Set Stroke Width:%s                                */
#define IDMSG_STROKE_LENGTH_QUERY     722    /* Query Stroke Length:%s"                                  */
#define IDMSG_ALL_STROKES_CLEARED     723    /* All Strokes Cleared!                         */
#define IDMSG_LAST_STROKE_CLEARED     724    /* Last Stroke Cleared!                         */


#define IDMSG_SHOWWARNING             740     /* Warning Message                                         */
#define IDMSG_STROKE_ADD              741     /* STROKE ADD NOTIFICATION:  Press OK to add stroke #%s to the database.     */
#define IDMSG_STROKE_UNDO             742     /* STROKE UNDO NOTIFICATION: Press OK to delete stroke #%s from the database.*/
#define IDMSG_STROKE_CLEAR            743     /* STROKE CLEAR NOTIFICATION: Press OK to clear all(%s) strokes.             */
#define IDMSG_BITMAP_HANDLE_SAVE      744     /* Bitmap Handle = %sPress OK to save the bitmap to a file.*/
#define IDMSG_BITMAP_REALLY_SAVE      745     /* File %s already exists and WILL BE ERASED! */


#define IDMSG_SHOWERROR               750    /* Error Message                */
#define IDMSG_MESSAGE_FAIL            751    /* %s FAILED.                   */
#define IDMSG_NO_PEN_RUNNING          752    /* Pen for OS/2 is not running. */
#define IDMSG_NO_HELP                 753    /* Missing HELP.                */
#define IDMSG_MEMORY_ERROR            754    /* Memory Failure - Bitmap cannot be saved. */
#define IDMSG_FILE_ERROR              755    /* File Error - Bitmap cannot be saved. */
#define IDMSG_MEMORY_FAIL_GETSTROKE   756    /* Memory Fail during Stroke #%s retrieve!  */
#define IDMSG_INK_WIDTH_SET_FAIL      757    /* FAIL!  Width can only be set to 1 or 2 pels. */
#define IDMSG_STROKE_INVALID          758    /* Stroke #%s is invalid!                               */

/*********************************************/
/* Help IDs                                  */
/*********************************************/
#define SKETCH_HELPTABLE              800
#define DLG_CHOOSE_HELPSUBTABLE       801
#define SKETCH_HELPSUBTABLE           802
#define DLG_CHOOSE_AUXSUBTABLE        803

#define PANEL_SKETCH                  804     /* F1 or Help button pressed at Sketch Window */

#define PANEL_MESSAGE                 805     /* F1 pressed at Select Window */

#define PANEL_AUX                     806     /* F1 pressed at Choose Aux    */

#define PANEL_SKM_DELETE_ALL_STROKES       815 /* Help button pressed at SKM_DELETE_ALL_STROKES     */
#define PANEL_SKM_UNDO_LAST_STROKE         816 /* Help button pressed at SKM_UNDO__LAST_STROKE      */
#define PANEL_SKM_QUERY_CTL_DRAW_POINTER   817 /* Help button pressed at SKM_QUERY_CTL_DRAW_POINTER */
#define PANEL_SKM_QUERY_CTL_INK_WIDTH      818 /* Help button pressed at SKM_QUERY_CTL_INK_WIDTH    */
#define PANEL_SKM_QUERY_CTL_INK_COLOR      819 /* Help button pressed at SKM_QUERY_CTL_INK_COLOR    */
#define PANEL_SKM_QUERY_CTL_INVISIBLE_MODE 820
#define PANEL_SKM_SET_CTL_DRAW_POINTER     821
#define PANEL_SKM_SET_CTL_INK_WIDTH        822
#define PANEL_SKM_SET_CTL_INK_COLOR        823
#define PANEL_SKM_SET_CTL_INVISIBLE_MODE   824
#define PANEL_SKM_RENDER_TO_CLIPBOARD      825
#define PANEL_SKM_QUERY_CTL_STROKE_COUNT   826
#define PANEL_SKM_SET_STROKE_INK_COLOR     827
#define PANEL_SKM_SET_STROKE_INK_WIDTH     828
#define PANEL_SKN_INK_COLOR_CHANGE         829
#define PANEL_SKN_STROKE_ADD               830
#define PANEL_SKN_STROKE_UNDO              831
#define PANEL_SKN_CONTROL_CLEARED          832
#define PANEL_SKM_SET_CTL_AUXDATA_MODE     833
#define PANEL_SKN_INK_WIDTH_CHANGE         834
#define PANEL_SKM_GET_BITMAP               835
#define PANEL_SKM_QUERY_BITMAP_SIZE        836
#define PANEL_SKM_QUERY_STROKE_LENGTH      837
#define PANEL_SKM_QUERY_STROKE_DATA        838
#define PANEL_SKM_QUERY_STROKE_INK_COLOR   839
#define PANEL_SKM_QUERY_STROKE_INK_WIDTH   840



MRESULT EXPENTRY ClientWndProc(HWND hwnd, ULONG msg, MPARAM mp1, MPARAM mp2 );
MRESULT EXPENTRY ChooseControlProc( HWND hwndDlg, ULONG msg, MPARAM mp1, MPARAM mp2 );
MRESULT EXPENTRY ColorDlgProc( HWND hwndDlg, ULONG msg, MPARAM mp1, MPARAM mp2 );
MRESULT EXPENTRY VisibleDlgProc( HWND hwndDlg, ULONG msg, MPARAM mp1, MPARAM mp2 );
MRESULT EXPENTRY AllNoneAuxDlgProc( HWND hwndDlg, ULONG msg, MPARAM mp1, MPARAM mp2 );
MRESULT EXPENTRY GetStrokeNumberProc( HWND hwndDlg, ULONG msg, MPARAM mp1, MPARAM mp2 );
MRESULT EXPENTRY WidthDlgProc( HWND hwndDlg, ULONG msg, MPARAM mp1, MPARAM mp2 );
MRESULT EXPENTRY DisplayStrokeInfoDlgProc( HWND hwndDlg, ULONG msg, MPARAM mp1, MPARAM mp2 );

int     main( VOID );

VOID    ExecuteControlMessage(LONG lMessageValue, PSZ pszChosenItem, HWND hwnd);
VOID    GetColorString(LONG ColNum, PSZ szColor);
USHORT  ShowMessageBox(HWND hwnd, USHORT idMsg, PSZ szExtendedMessage);
VOID    InitHelp(VOID);
VOID    SaveBmpInFile(HWND hwndDlg, HBITMAP hBitmap);
VOID    CreateControls(HWND hwnd);


/*************************/
/* Global Variables      */
/*************************/
  HWND      hwndFrame;             /* window handle                          */
  HAB       hab;                   /* anchor block handle                    */

  HWND      hSKETCHControl;        /* Sketch Window                          */
  HWND      hSELECTButton;
  HWND      hCANCELButton;
  HWND      hHELPButton;
  HWND      hwndSelectDlg;         /* Select Dialog handle */

  HPOINTER  hptrt1;                /* Black Pen Drawing Pointer              */
  HPOINTER  hpDefault;             /* Default Sketch Control Drawing Pointer */

  CHAR      szMessageBoxString[240];      /* Complete message to user        */

  BOOL      bLookAtNotification;  /* flag to verify that a notification message was received */
                                  /* TRUE if want to display message showing that notification was received */
  BOOL      bWindowsCreated;      /* TRUE if successfully create sketch control, and action buttons         */

  HWND      hwndHelp;

  USHORT    usAux = FALSE;       /* TRUE if want all Aux data                */

  PSKETCHSTROKEDEF pStrokeData = NULL; /* Stroke Data Structure              */


/**********************************************************/
/* Select Control Listbox, Execution and Help Information */
/**********************************************************/
struct MessageData
  {
    PSZ    pszMessageName;      /* Control Message Name String               */
    LONG   lMessageValue;       /* Control Message Value                     */
    ULONG  ulMessageHelpValue;  /* Control Message Help                      */
  };

struct MessageData MessageList[27] =  {
{"SKM_DELETE_ALL_STROKES",      SKM_DELETE_ALL_STROKES,       PANEL_SKM_DELETE_ALL_STROKES      },
{"SKM_UNDO_LAST_STROKE",        SKM_UNDO_LAST_STROKE,         PANEL_SKM_UNDO_LAST_STROKE        },
{"SKM_QUERY_CTL_DRAW_POINTER",  SKM_QUERY_CTL_DRAW_POINTER,   PANEL_SKM_QUERY_CTL_DRAW_POINTER  },
{"SKM_SET_CTL_DRAW_POINTER",    SKM_SET_CTL_DRAW_POINTER,     PANEL_SKM_SET_CTL_DRAW_POINTER    },
{"SKM_QUERY_CTL_INK_WIDTH",     SKM_QUERY_CTL_INK_WIDTH,      PANEL_SKM_QUERY_CTL_INK_WIDTH     },
{"SKM_SET_CTL_INK_WIDTH",       SKM_SET_CTL_INK_WIDTH,        PANEL_SKM_SET_CTL_INK_WIDTH       },
{"SKM_QUERY_CTL_INK_COLOR",     SKM_QUERY_CTL_INK_COLOR,      PANEL_SKM_QUERY_CTL_INK_COLOR     },
{"SKM_SET_CTL_INK_COLOR",       SKM_SET_CTL_INK_COLOR,        PANEL_SKM_SET_CTL_INK_COLOR       },
{"SKM_QUERY_CTL_INVISIBLE_MODE",SKM_QUERY_CTL_INVISIBLE_MODE, PANEL_SKM_QUERY_CTL_INVISIBLE_MODE},
{"SKM_SET_CTL_INVISIBLE_MODE",  SKM_SET_CTL_INVISIBLE_MODE,   PANEL_SKM_SET_CTL_INVISIBLE_MODE  },
{"SKM_QUERY_STROKE_INK_COLOR",  SKM_QUERY_STROKE_INK_COLOR,   PANEL_SKM_QUERY_STROKE_INK_COLOR },
{"SKM_SET_STROKE_INK_COLOR",    SKM_SET_STROKE_INK_COLOR,     PANEL_SKM_SET_STROKE_INK_COLOR    },
{"SKM_QUERY_STROKE_INK_WIDTH",  SKM_QUERY_STROKE_INK_WIDTH,   PANEL_SKM_QUERY_STROKE_INK_WIDTH  },
{"SKM_SET_STROKE_INK_WIDTH",    SKM_SET_STROKE_INK_WIDTH,     PANEL_SKM_SET_STROKE_INK_WIDTH    },
{"SKM_QUERY_STROKE_LENGTH",     SKM_QUERY_STROKE_LENGTH,      PANEL_SKM_QUERY_STROKE_LENGTH     },
{"SKM_QUERY_STROKE_DATA",       SKM_QUERY_STROKE_DATA,        PANEL_SKM_QUERY_STROKE_DATA       },
{"SKM_QUERY_CTL_STROKE_COUNT",  SKM_QUERY_CTL_STROKE_COUNT,   PANEL_SKM_QUERY_CTL_STROKE_COUNT  },
{"SKM_GET_BITMAP",              SKM_GET_BITMAP,               PANEL_SKM_GET_BITMAP              },
{"SKM_QUERY_BITMAP_SIZE",       SKM_QUERY_BITMAP_SIZE,        PANEL_SKM_QUERY_BITMAP_SIZE       },
{"SKM_SET_CTL_AUXDATA_MODE",    SKM_SET_CTL_AUXDATA_MODE,     PANEL_SKM_SET_CTL_AUXDATA_MODE    },
{"SKM_RENDER_TO_CLIPBOARD",     SKM_RENDER_TO_CLIPBOARD,      PANEL_SKM_RENDER_TO_CLIPBOARD     },
{"SKN_INK_COLOR_CHANGE",        SKN_INK_COLOR_CHANGE,         PANEL_SKN_INK_COLOR_CHANGE        },
{"SKN_INK_WIDTH_CHANGE",        SKN_INK_WIDTH_CHANGE,         PANEL_SKN_INK_WIDTH_CHANGE        },
{"SKN_STROKE_ADD",              SKN_STROKE_ADD,               PANEL_SKN_STROKE_ADD              },
{"SKN_STROKE_UNDO",             SKN_STROKE_UNDO,              PANEL_SKN_STROKE_UNDO             },
{"SKN_CONTROL_CLEARED",         SKN_CONTROL_CLEARED,          PANEL_SKN_CONTROL_CLEARED         },
{NULL,                           0L,                              0UL                           }
};

