/****************************** Module Header ******************************\
*                                                                          *
* Pen for OS/2 header file                                                 *
*                                                                          *
* Copyright (c) 1992, 1993 IBM Corporation                                 *
*                                                                          *
* Module Name: penpm.h                                                     *
*                                                                          *
\***************************************************************************/

#ifndef PENPMH_INCLUDED
#define PENPMH_INCLUDED


LONG    APIENTRY WrtQuerySysValue(HWND DeskTop, ULONG  id);
APIRET  APIENTRY WrtSetSysValue(HWND DeskTop, ULONG  id, LONG Val);
APIRET  APIENTRY WrtReadSysValue(HWND DeskTop, ULONG id);
APIRET  APIENTRY WrtWriteSysValue(HWND DeskTop, ULONG  id);

#define RECO_MAX_COORD   4

typedef ULONG    RECOID, HRECO;
typedef RECOID   *PRECOID;
typedef HRECO    *PHRECO;

typedef struct _RECODATA
  {
  ULONG  cbSize;              /* size of struc                       */
  RECOID id;                  /* ID if reco event                    */
  HRECO  hReco;               /* Reco subsystem handle               */
  ULONG  virtual_id;          /* virtual id of event                 */
  ULONG  char_code;           /* character code of event             */
  RECTL  bound_box;           /* box that bounds gesture             */
  POINTL ptlHotSpot;          /* Hot Spot X/Y screen coordinate      */
  HWND   hwnd;                /* Hwnd under hot spot                 */
  HWND   hwndActive;          /* Active window                       */
  HWND   hwndFocus;           /* Window that has the focus           */
  CHAR   *pszCommand;         /* Cmd and args gesture mapped to      */
  CHAR   *pszCmdArgs;
  CHAR   *pszPrefixCmd;
  } RECODATA;
typedef RECODATA *PRECODATA;

#define MAX_RECO_NAME_LENGTH   11  /* Maximum characters length for  */
                                   /* Reco subsystem and event names */



#define MAX_STROKE_POINTS 1000

/*************************************************************/
/* AUXPOINTDATA structure returned by WrtQueryAuxPointData() */
/*                                                           */
/*  AUXPOINTDATA is a static data structure available on     */
/*  each WM_MOUSEMOVE.                                       */
/*************************************************************/

typedef struct  _AUXPOINTDATA  /* apd */
  {
  USHORT         cbStructSize;   /* Structure size                */
  ULONG          ulTimestamp;    /* Point timestamp               */
  USHORT         usFlags;        /* Point flags                   */
  USHORT         usUser;         /* For program use               */
  SHORT          sScrZ;          /* Normalize Z axis value (4K to -4K)*/
                                 /* Height - 0 t0 4096            */
                                 /* Pressure 0 to -4096           */
  SHORT          sDevZ;          /* Device Z axis value is device */
                                 /*   dependant. See locator      */
                                 /*   caps structure.             */
  SHORT          sAngle;         /* Stylus angle to XY            */
  SHORT          sRotation;      /* Stylus barrel rotation        */
  USHORT         usButton;       /* Button status                 */
  UCHAR          OEM[8];         /* OEM specific data             */
  } AUXPOINTDATA;
typedef AUXPOINTDATA *PAUXPOINTDATA; /* papd */

/* AUXPOINTDATA.usFlags Equates */
#define APD_MODEMASK         0x0003   /* Mode mask (see below)          */
#define APD_IDLEMODE              0   /* Stylus is idle                 */
#define APD_PROXMODE              1   /* Stylus is in proximity         */
#define APD_CONTACTMODE           2   /* Stylus is in contact           */
#define APD_FILTERED         0x0004   /* Mouse event not passed to PM   */


APIRET APIENTRY WrtQueryPointAuxData(PAUXPOINTDATA  papdInfo);


/*****************************************************************/
/* AUXDATADESC structure used to build the AUXDATAINFO structure */
/*****************************************************************/

typedef struct  _AUXDATADESC  /* add */
  {
  ULONG          id;             /* Aux data type identity (See ADT_*) */
  ULONG          offset;         /* Field offset                 */
  ULONG          cb;             /* Aux data type byte count     */
  } AUXDATADESC;
typedef AUXDATADESC *PAUXDATADESC; /* padd */

/* AUXDATADESC.id Equates  */
#define ADT_TIMESTAMP   0        /* Point timestamp.             */
#define ADT_FLAGS       1        /* Point flags                  */
#define ADT_SCREENZ     2        /* Normalized Z axis value      */
#define ADT_DEVZ        3        /* Device Z axis value          */
#define ADT_ANGLE       4        /* Stylus angle to XY           */
#define ADT_ROTATION    5        /* Stylus rotation              */
#define ADT_BUTTON      6        /* Button status                */
#define ADT_USER        7        /* For program use              */
#define ADT_OEM         16       /* OEM specific data            */


/*****************************************************************/
/* AUXDATAINFO structure pointed to by STROKEDATA.pAuxInfo       */
/*****************************************************************/

typedef struct  _AUXDATAINFO  /* adi */
  {
  ULONG          cbAuxDesc;      /* Size of Aux desc structure   */
  ULONG          ulNumElements;  /* Number of data elements in   */
                                 /* aux data packet              */
  ULONG          ulAuxSize;      /* Length of aux data packet    */
                                 /* Sum of all AUXDATADESC.cb fields */
  AUXDATADESC    addAuxDesc[1];  /* Array of descriptors         */
  } AUXDATAINFO;
typedef AUXDATAINFO *PAUXDATAINFO; /* padi */

/*****************************************************************/
/* AUXSTROKEDATA structure pointed to by STROKEDATA.pAuxData     */
/*****************************************************************/

typedef struct  _AUXSTROKEDATA  /* asd */
  {
  UCHAR          bAuxData[1][1]; /* Auxiliary stroke data        */
  } AUXSTROKEDATA;
typedef AUXSTROKEDATA *PAUXSTROKEDATA; /* pasd */


/*********************************************************/
/* STROKEDATA structure returned by WrtQueryStrokeData() */
/*********************************************************/

typedef struct _STROKEDATA  /* sd */
  {
  ULONG          cbStructSize;      /* Size of stroke data header    */
  ULONG          ulSource;          /* See Wrt Event Sources         */
  ULONG          ulSeq;             /* Sequence number wraps at 4G   */
  ULONG          ulResolution;      /* Points per Inch               */
  ULONG          ulSampleRate;      /* Points per Second             */
  RECTL          rclCell;           /* Rectangle Around Stroke       */
  ULONG          ulNumPoints;       /* Number of points in stroke    */
  ULONG          flStrokeFlags;     /* Stroke flags. (See SBF_*)     */
  ULONG          ulXExtent;         /* X extent used to scale coords */
  ULONG          ulYExtent;         /* Y extent used to scale coords */
  ULONG          ulSensorResolution;/* Sensor resolution in dots/inch*/
  ULONG          ulSensorXExtent;   /* Extent of sensor X axis       */
  ULONG          ulSensorYExtent;   /* Extent of sensor Y axis       */
  ULONG          ulTimestamp;       /* Timestamp of Button down      */
  ULONG          ulDevTimestampRes; /* Resolution of device TS in usecs */
  PPOINTL        pXY;               /* pointer to X/Y POINTL array   */
  PAUXDATAINFO   pAuxInfo;          /* See AUXDATAINFO               */
  PAUXSTROKEDATA pAuxData;          /* See AUXPOINTDATA              */
  ULONG          ulUser1;
  ULONG          ulUser2;
  struct _STROKEDATA *psdFwd;   /* Recommended use-Forward chain ptr  */
  struct _STROKEDATA *psdBack;  /* Recommended use-Backward chain ptr */
  } STROKEDATA;
typedef STROKEDATA *PSTROKEDATA; /* psd */

/* Stroke Buffer Flags */
#define SBF_SCREEN          0x00000001  /* 1=Screen coords 0=hi res coord*/
#define SBF_SCALE           0x00000001  /* 1=Scaled coords 0=hi res coord*/
#define SBF_INKED           0x00000002  /* Stroke was inked              */
#define SBF_INK_NOT_REMOVED 0x00000004  /* Stroke left inked             */
#define SBF_TD_LO_SAME_HWND 0x00000008  /* Touchdown/liftoff in same hwnd*/
#define SBF_STROKE_OUTSIDE_HWND 0x00000010 /* Stroke left the boundaries */
#define SBF_POINTS_LOST     0x00000040  /* Points were lost (HW overrun) */
#define SBF_BUFFER_OVERRUN  0x00000080  /* Points were lost (SB overrun) */
#define SBF_MBUTTON_MASK    0x00001C00  /* Mask for isolating mouse butto*/
#define SBF_TAP             0x00002000  /* Stroke was a tap              */
#define SBF_DBLTAP          0x00004000  /* Stroke was a double tap       */
#define SBF_NEGATIVE_COORDS 0x80000000  /* Contains negative window coord*/

APIRET APIENTRY WrtQueryStrokeData(PBYTE    pStrokeBuf,
                                   PULONG   pBufLen,
                                   HWND     hwnd,
                                   ULONG    flConvopt,   /* See QSD_* */
                                   ULONG    ulXOutput,
                                   ULONG    ulYOutput,
                                   ULONG    flAuxData);  /* See ADF_* */

#define QSD_NO_CNV           0x00000000  /* No Conversion (sensor resolution)   */
#define QSD_SCALE            0x00000001  /* Scale to specified resolution       */
#define QSD_STANDARDIZED_RES 0x00000002  /* Scale to standardize resolution     */
#define QSD_RESOLUTION       0x00000004  /* Scale factor specified in dots/inch */


APIRET  APIENTRY WrtMapPointLong(HWND     hwnd,
                                 PPOINTL  pXY,
                                 ULONG    flParms,     /* See MP_*  */
                                 ULONG    ulXInput,
                                 ULONG    ulYInput,
                                 ULONG    ulXOutput,
                                 ULONG    ulYOutput,
                                 ULONG    ulCount
                                 );

#define MP_SCALE        0x00000000    /* Scale coordinates (Default)              */
#define MP_NO_SCALE     0x00000001    /* Do not scale coordinates                 */
#define MP_RESOLUTION   0x00000002    /* Input and output expressed in resolution */


APIRET  APIENTRY WrtSetStrictEmulation(HWND    hwnd,
                                       ULONG   option);
#define SSE_RESET     0x00000000    /* Reset strict emulation for app*/
#define SSE_SET       0x00000001    /* Set strict emulation for appl */


APIRET  APIENTRY WrtControlDisplayBacklight(ULONG  option, ULONG displayID);
#define CDB_LIGHT_ON    0x00000001  /* Turn backlight on.            */
#define CDB_LIGHT_OFF   0x00000002  /* Turn backlight off.           */

/************************************************/
/*      PenPM Messages Definition Section       */
/*                                              */
/************************************************/

#ifndef WM_PENFIRST
#define WM_PENFIRST             0x04C0        /* These equates taken    */
#endif

#ifndef WM_PENLAST
#define WM_PENLAST              0x04FF        /* from private pmwin.h   */
#endif

#define WM_PEN_MSG   WM_PENFIRST

#define WM_TOUCHDOWN           WM_PEN_MSG + 0
#define WM_LIFTOFF             WM_PEN_MSG + 1
#define WM_RECO                WM_PEN_MSG + 2
#define WM_RECO_COMMAND        WM_PEN_MSG + 3
#define WM_SENSOR_MOVE         WM_PEN_MSG + 4

#define WM_EXIT_PROXIMITY      WM_PEN_MSG + 6
#define WM_WRT_DEV_CAPS_CHANGE WM_PEN_MSG + 7
#define WM_WRT_SYSVALUECHANGED WM_PEN_MSG + 8
#define WM_PROXIMITY_TIMEOUT   WM_PEN_MSG + 9
#define WM_PAUSE_TIMEOUT       WM_PEN_MSG + 12
#define WM_STROKE              WM_PEN_MSG + 13
#define WM_TAP                 WM_PEN_MSG + 14
#define WM_DBL_TAP             WM_PEN_MSG + 15

/**************************************/
/*   WM_TOUCHDOWN MRESULT Values      */
/*   -------------------------------  */
#define TDN_DEFAULT_DELAY    0x00000000  /* Delay Button 1 down (default) */
#define TDN_IMMEDIATE        0x00000001  /* Immediate BUTxDOWN            */
#define TDN_INFINITE         0x00000002  /* Never Issue BUTxDOWN          */
#define TDN_DELAY_BITMASK TDN_DEFAULT_DELAY+TDN_IMMEDIATE+TDN_INFINITE
                                         /*                               */
#define TDN_INK_STROKE       0x00000000  /* Ink Stroke (Default)          */
#define TDN_NO_INK_STROKE    0x00000010  /* Don't Ink Stroke              */
#define TDN_LEAVE_INK        0x00000020  /* Leave Stroke Inked at liftoff */
#define TDN_INK_BITMASK  TDN_INK_STROKE+TDN_NO_INK_STROKE+TDN_LEAVE_INK
                                         /*                               */
#define TDN_HIFREQ_MOUSEMOVE 0x00000040  /* Regenerate coalesced mouse moves */
#define TDN_SENSOR_MOVE      0x00000080  /* Generate WM_SENSOR_MOVE msgs  */



/*************************************/
/*  WM_LIFTOFF MRESULT Values        */
/*  -----------------------------    */
#define LO_DEFAULT           0x00000000  /* App didn't process stroke,*/
                                         /*   do gesture processing   */
#define LO_STROKE_PROCESSED  0x00000001  /* App processed stroke,     */
                                         /*   take no other action    */
#define LO_EMULATE_MOUSE     0x00000002  /* App processed stroke,     */
                                         /*   perform mouse emulation */


/*************************************/
/*  WM_STROKE MRESULT Values         */
/*  -----------------------------    */
#define STK_DEFAULT          0x00000000  /* App didn't process stroke,*/
                                         /*   do gesture processing   */
#define STK_STROKE_PROCESSED 0x00000001  /* App processed stroke,     */
                                         /*   take no other action    */


/**************************************/
/*  WM_PAUSE_TIMEOUT MRESULT Values   */
/*  --------------------------------  */

#define PTO_DEFAULT          0x00000000  /* Allow mouse emulation     */
#define PTO_CONTINUE         0x00000001  /* Remain in gesture mode    */
                                         /*   take no other action    */


/********************************************/
/*   WM_TAP and WM_DBL_TAP MRESULT Values   */
/*  --------------------------------------  */

#define TP_TAP_PROCESSED    0x00000001  /* App processed tap message,   */
                                        /*   take no other action       */
#define TP_DEFAULT          0x00000000  /* Mouse emulation is performed */
                                        /* except if TDN_INFINITE was   */
                                        /* returned at touchdown        */

/*************************************/
/*  WM_RECO MRESULT Values           */
/*  --------------------------       */
#define RECO_MAP             0         /* App didn't process event, */
                                       /*   PPM will map event      */
#define RECO_NOMAP          -1         /* App doesn't want mapping  */
                                       /*   done, only mou emulation*/
#define RECO_PROCESSED       1         /* App processed reco event, */
                                       /*   no mouse emul performed */


typedef struct _WRTEVENTDATA   /* ed */
  {
  ULONG     cbStructSize;       /* Structure size                        */
  USHORT    usKCFlags;          /* KC_* flags from mouse message         */
  USHORT    usHitTest;          /* Hit test results from mouse message   */
  POINTL    ptlDisplay;         /* Display X/Y coordinate                */
  POINTL    ptlSensor;          /* Sensor X/Y coordinate                 */
  POINTL    ptlStandard;        /* Standard X/Y coordinate               */
  ULONG     flEventStatus;      /* Event status                          */
  ULONG     ulStrokeSeq;        /* Stroke sequence number                */
  ULONG     ulStrokeSize;       /* Number of stroke points (Liftoff only)*/
  ULONG     ulLocatorID;        /* ID of pointing device                 */
  ULONG     ulLocatorType;      /* Type of pointing device (See LT_*)    */
  ULONG     ulLocatorFlags;     /* Pointing device flags   (See LTYPE_*) */
  ULONG     ulValidityFlags;    /* Aux data validity flags (See ADF_*)   */
  ULONG     ulButtonStatus;     /* Button device status                  */
  HWND      hwndUnderPtr;       /* Hwnd under pointer                    */
  } WRTEVENTDATA;
typedef WRTEVENTDATA *PWRTEVENTDATA; /* ped */


/*******************************************/
/*   WRT_*  Event and State Indicators     */
/*                                         */
/*******************************************/

/* WRTEVENTDATA.flEventStatus Equates */
#define WRT_STROKE_AVAIL     0x00000001   /* Stroke is avail for retrieval */
#define WRT_INKING           0x00000002   /* Stroke was inked              */
                                          /* Note: The next three flags are*/
                                          /*       only valid if the Stroke*/
                                          /*       Avail bit is set.       */
#define WRT_INK_NOT_REMOVED  0x00000004   /* Stroke left inked as requested*/
#define WRT_TD_LO_SAME_HWND  0x00000008   /* Touchdown/liftoff in same hwnd*/
#define WRT_STROKE_OUTSIDE_HWND 0x00000010 /* Stroke left the boundaries */
                                           /* of the TD window's hwnd.      */
#define WRT_POINTS_LOST      0x00000040   /* Points were lost (HW overrun) */
#define WRT_BUFFER_OVERRUN   0x00000080   /* Points lost (Stroke buffer overrun)*/
#define WRT_NON_DEVICE_EVENT 0x00000100   /* Mouse event not generated by device*/
#define WRT_MBUTTON_MASK     0x00001C00   /* Mask for isolating mouse butto*/
#define WRT_MBUTTON1         0x00000400   /* Mouse button 1                */
#define WRT_MBUTTON2         0x00000800   /* Mouse button 2                */
#define WRT_MBUTTON3         0x00001000   /* Mouse button 3                */
#define WRT_TAP              0x00002000   /* Stroke is a tap               */
#define WRT_DBLTAP           0x00004000   /* Stroke is a double tap        */


/*******************************************/
/*   Virtual Event IDs                     */
/*     Intent-based are individual values; */
/*     User/letter events covered by one.  */
/*******************************************/

#define VE_TOGGLESELECTION      (1)
#define VE_HELP                 (2)
#define VE_SPACE                (3)
#define VE_EDIT                 (4)
#define VE_DELETE               (5)
#define VE_PASTE                (6)
#define VE_SCRATCHOUT           (7)
#define VE_DELETECHAR           (8)
#define VE_INSERT               (9)
#define VE_CUT                  (10)
#define VE_COPY                 (11)
#define VE_ASSIGNMENTS          (12)
#define VE_UNDO                 (13)
#define VE_ENTER                (14)
#define VE_TAB                  (15)
#define VE_SCROLLUP             (16)
#define VE_SCROLLDOWN           (17)
#define VE_SCROLLLEFT           (18)
#define VE_SCROLLRIGHT          (19)
#define VE_SCROLLUPMORE         (20)
#define VE_SCROLLDOWNMORE       (21)
#define VE_SCROLLLEFTMORE       (22)
#define VE_SCROLLRIGHTMORE      (23)
#define VE_SCROLLUPMAX          (24)
#define VE_SCROLLDOWNMAX        (25)
#define VE_SCROLLLEFTMAX        (26)
#define VE_SCROLLRIGHTMAX       (27)
#define VE_BACKSPACE            (28)
#define VE_EXTENDSELECTION      (29)
#define VE_CONTEXTMENU          (30)
#define VE_BOUNDSELECTIONLEFT   (31)
#define VE_BOUNDSELECTIONRIGHT  (32)

#define VE_LETTERGESTURE          (100)   /* Single value covers multiple. */


/* string types for WrtQueryDeviceNames */
typedef CHAR STR_32[32];     /* str32 */
typedef STR_32 *PSTR_32;

/* defines for all device types */
#define DT_LOCATOR  0x03          /* locator device  */
#define DT_BUTTON   0x04          /* button device   */
#define DT_DISPLAY  0x05          /* display device  */

APIRET APIENTRY WrtQueryEventData(PWRTEVENTDATA  pedInfo);

APIRET APIENTRY WrtQueryInputDeviceNames(PSZ     pszDriverName,
                                         PULONG  ulNumDevices,
                                         PSTR_32  aDeviceName,
                                         PULONG  aDeviceType,
                                         PULONG  aDeviceID);

APIRET APIENTRY WrtEnumInputDrivers(PULONG pulNumDrivers, PSTR_32 aDriverNames);

typedef struct _WRTSYSTEMINFO       /* si */
  {
  ULONG     cbStructSize;      /* Structure size                      */
  ULONG     ulDisplayXPels;    /* Number of display X pixels          */
  ULONG     ulDisplayYPels;    /* Number of display Y pixels          */
  ULONG     ulDisplayXRes;     /* Display resolution                  */
  ULONG     ulDisplayYRes;     /* Display resolution                  */
  ULONG     ulStandardXRes;    /* Standardized dots per inch X axis   */
  ULONG     ulStandardYRes;    /* Standardized dots per inch Y axis   */
  ULONG     ulNumDrivers;      /* Number of registered pen drivers    */
  ULONG     ulNumLocators;     /* Number of registered pointing devs  */
  ULONG     ulNumButtons;      /* Number of registered button device  */
  ULONG     ulNumDisplays;     /* Number of registered display devs   */
  } WRTSYSTEMINFO;
typedef WRTSYSTEMINFO *PWRTSYSTEMINFO; /* psi */

APIRET APIENTRY WrtQuerySystemCaps(PWRTSYSTEMINFO  psiInfo);

typedef struct _WRTLOCATORDEVINFO   /* ldi */
  {
  ULONG     cbStructSize;       /* Structure size                        */
  ULONG     ulLocatorID;        /* ID of pointing device                 */
  ULONG     ulLocatorType;      /* Type of pointing device               */
  ULONG     ulLocatorFlags;     /* Pointing device flags                 */
  ULONG     ulValidityFlags;    /* Aux data validity flags               */
  ULONG     ulOEMValidityCnt;   /* Count of valid OEM bytes              */
  ULONG     ulSensorHeight;     /* Sensor height in thousands of inches  */
  ULONG     ulSensorWidth;      /* Sensor width in thousands of inches   */
  ULONG     ulNumMouButtons;    /* Number of mouse buttons emulated      */
  ULONG     ulNumButtons;       /* Number of buttons on pointing device  */
  ULONG     ulButtonMask;       /* Mask giving IDs of barrel buttons     */
  ULONG     ulSensorXpts;       /* Number of sensor X axis units         */
  ULONG     ulSensorYpts;       /* Number of sensor Y axis units         */
  LONG      lSensorZptsP;       /* Number of sensor Z axis pressure units*/
  ULONG     ulSensorZptsH;      /* Number of sensor Z axis height units  */
  ULONG     ulSensorXres;       /* Sensor X resolution (points/inch)     */
  ULONG     ulSensorYres;       /* Sensor Y resolution (points/inch)     */
  ULONG     ulStandardXpts;     /* Number of Standardized X axis units   */
  ULONG     ulStandardYpts;     /* Number of Standardized Y axis units   */
  ULONG     ulSampleRate;       /* Sample rate of stylus                 */
  ULONG     ulMaxSampleRate;    /* Maximum possible point rate supported */
  ULONG     ulTimestampRes;     /* Dev timestamp resolution in microsecs */
  UCHAR     pszDriverName[32];  /* Name of controlling device driver     */
  UCHAR     pszDeviceName[32];  /* Name of pointing device               */
  } WRTLOCATORDEVINFO;
typedef WRTLOCATORDEVINFO *PWRTLOCATORDEVINFO; /* pldi */

/* WRTLOCATORDEVINFO.ulLocatorType Values */
#define LT_MOUSE              0x00000001 /* Mouse                     */
#define LT_PEN                0x00000002 /* Stylus                    */
#define LT_TOUCH              0x00000003 /* Finger touch              */
#define LT_OTHER              0x00000004 /* Other misc pointing device*/

/* WRTLOCATORDEVINFO.ulLocatorFlags Values */
#define LTYPE_TETHERED        0x00000001 /* Stylus is tethered          */
#define LTYPE_PROXIMITY_EVENT 0x00000002 /* Proximity events reported   */
#define LTYPE_TILT            0x00000004 /* Device reports angle to XY  */
#define LTYPE_ROTATION        0x00000008 /* Device reports rotation     */
#define LTYPE_OEMDATA         0x00000010 /* Device reports extra OEMata */
#define LTYPE_TIMESTAMP       0x00000020 /* Device reports hi res timestamp*/
#define LTYPE_PRESSURE        0x00000040 /* Device reports pressure     */
#define LTYPE_HEIGHT          0x00000080 /* Device reports height       */
#define LTYPE_PIN             0x00000100 /* Pen contains PIN            */
#define LTYPE_BATTERY         0x00000800 /* Pen contains battery        */
#define LTYPE_ERASURE         0x00000200 /* Erasure end of stylus reported */
#define LTYPE_INTEG_SENSOR    0x00000400 /* Sensor integrated in display*/
#define LTYPE_RELATIVE        0x00001000 /* Relative pointing device    */
                                         /* Sensor coords from relative */
                                         /* devices are offsets from    */
                                         /* last reported point         */
#define LTYPE_ABSOLUTE        0x00002000 /* Absolute pointing device    */


/* WRTLOCATORDEVINFO.ulValidityFlags Values */
#define ADF_TIMESTAMP         0x00000001 /* Point timestamp             */
#define ADF_FLAGS             0x00000002 /* Point flags                 */
#define ADF_SCREENZ           0x00000004 /* Normalized Z axis           */
#define ADF_DEVZ              0x00000008 /* Device Z                    */
#define ADF_ANGLE             0x00000010 /* Stylus angle to XY          */
#define ADF_ROTATION          0x00000020 /* Stylus barrel rotation      */
#define ADF_BUTTON            0x00000040 /* Button status               */
#define ADF_OEM               0x00000080 /* OEM specific data byte cnt  */
#define ADF_OEM_COUNT_MASK    0x000F0000 /* OEM valid count             */
#define ADF_USER              0x00000100 /* This bit is not HW relat and*/
                                         /* is always set. For appl use.*/
#define ADF_ALL               0X000001FF /* All fields                  */

APIRET APIENTRY WrtQueryLocatorCaps(PULONG              ulNumLocators,
                                    PWRTLOCATORDEVINFO  pldiInfo);

typedef struct _WRTBUTTONDEVINFO    /* bdi */
  {
  ULONG     cbStructSize;       /* Structure size                    */
  ULONG     ulButtonID;         /* ID of button device               */
  ULONG     ulNumButtons;       /* Number of configured buttons      */
  ULONG     ulButtonMask;       /* 1=barrel,  0=non-barrel button    */
  UCHAR     pszDriverName[32];  /* Name of controlling device driver */
  UCHAR     pszDeviceName[32];  /* Name of button device             */
  } WRTBUTTONDEVINFO;
typedef WRTBUTTONDEVINFO *PWRTBUTTONDEVINFO;   /* pbdi */

APIRET APIENTRY WrtQueryButtonCaps(PULONG             ulNumButtons,
                                   PWRTBUTTONDEVINFO  pbdiInfo);

typedef struct _WRTDISPLAYDEVINFO     /* ddi */
  {
  ULONG     cbStructSize;      /* Structure size                    */
  ULONG     ulDisplayID;       /* ID of display device              */
  ULONG     ulDisplayType;     /* Type of display                   */
  ULONG     ulDisplayXPels;    /* Number of display X pixels        */
  ULONG     ulDisplayYPels;    /* Number of display Y pixels        */
  ULONG     ulDisplayXRes;     /* Display pels per inch X axis      */
  ULONG     ulDisplayYRes;     /* Display pels per inch Y axis      */
  ULONG     ulDisplayHeight;   /* Height of display in thousandsths */
  ULONG     ulDisplayWidth;    /* Width of display in thousandsths  */
  UCHAR     pszDriverName[32]; /* Name of controlling device driver */
  UCHAR     pszDeviceName[32]; /* Name of display device            */
  } WRTDISPLAYDEVINFO;
typedef WRTDISPLAYDEVINFO *PWRTDISPLAYDEVINFO;   /* pddi */

/* WRTDISPLAYDEVINFO.ulDisplayType Values */
#define DISPTYPE_LCD        0x0001   /* 1 - LCD,      0 - not LC   */
#define DISPTYPE_CRT        0x0002   /* 1 - CRT,      0 - not CR   */
#define DISPTYPE_BLANKING   0x0004   /* Display performs blankin   */
#define DISPTYPE_COLOR      0x0008   /* 1 - Color,    0 - Monochme */
#define DISPTYPE_ATTACHED   0x0010   /* 1 - Attached, 0 - Portab   */
#define DISPTYPE_NO_KBD     0x0020   /* No Keyboard Attached       */
#define DISPTYPE_BATTERY    0x0040   /* 1 - Battery,  0 - AC pow   */
#define DISPTYPE_SPEAKER    0x0080   /* 1 - Speaker integrated     */
#define DISPTYPE_MICROPHONE 0x0100   /* 1 - Microphone integrate   */

APIRET APIENTRY WrtQueryDisplayCaps(PULONG              ulDisplayID,
                                    PWRTDISPLAYDEVINFO  pddiInfo);


APIRET APIENTRY WrtWaitActive( ULONG ulTimeout );

/* WrtWaitActive Timeout equates */
#define WRT_INDEFINITE_WAIT     -1L
#define WRT_IMMEDIATE_RETURN     0L

APIRET APIENTRY VkpCloseKb( HWND hwnd );
APIRET APIENTRY VkpHideKeyboard( HWND hwnd );
APIRET APIENTRY VkpLoadKeyboard( PSZ pszKbd, HWND hwnd );
APIRET APIENTRY VkpDeleteKeyboard( PSZ pszKbd, HWND hwnd );
APIRET APIENTRY VkpIsKbRunning( PBOOL fRunning );
APIRET APIENTRY VkpIsKbHidden( PBOOL fHidden );
APIRET APIENTRY VkpQueryKbPos( PSWP pswp );
APIRET APIENTRY VkpSetKbPos( LONG x, LONG y, LONG cx, LONG cy,
                             ULONG fs, HWND hwnd );


/****************************/
/* PPMSV_* System Value IDs */
/****************************/

/* Not stored in Profile */
#define  PPMSV_VERSION                  0    /*  PenPM version number        */
#define  PPMSV_RELEASE                  1
#define  PPMSV_LEVEL                    2
#define  PPMSV_SUSPEND                  3    /*  Suspend PenPM processing    */

/* Stored in Profile */
#define  PPMSV_PEN_PAUSE               13    /*  Pen pause T.O value         */
#define  PPMSV_TOUCH_PAUSE             14    /*  Touch pause T.O value       */
#define  PPMSV_MOUSE_PAUSE             15    /*  Mouse pause T.O value       */
#define  PPMSV_OTHER_PAUSE             16    /*  Other pause T.O value       */

#define  PPMSV_PAUSEBEEPFREQ           17    /*  Pause T.O. beep freq        */
#define  PPMSV_RECO_BEEP_ENABLE        18    /*  Enable beep for no reco map */
#define  PPMSV_MINGESTUREPOINTS        19    /*  Minimum gesture points      */
#define  PPMSV_RECOPTRTIMER            20    /*  Timer display time          */
#define  PPMSV_GESTURE_CANCEL_TIMEOUT  21    /*  Cancel gesture timeout      */
#define  PPMSV_GESTURE_TIMEOUT         22    /*  Inter-stroke gesture timeout*/
#define  PPMSV_STANDARDIZED_RESOLUTION 23    /*                              */

#define  PPMSV_CHARACTER_BOX_DX        24    /*  Character box dx and dy are */
#define  PPMSV_CHARACTER_BOX_DY        25    /*   read-only variables        */

#define  PPMSV_TOUCH_PAUSE_ENABLE      26    /*  Touch pause T.O enable      */
#define  PPMSV_PEN_PAUSE_ENABLE        27    /*  Pen pause T.O enable        */
#define  PPMSV_MOUSE_PAUSE_ENABLE      28    /*  Mouse pause T.O enable      */
#define  PPMSV_OTHER_PAUSE_ENABLE      29    /*  Other pause T.O enable      */

#define  PPMSV_RESERVED_FIRST          30    /*  Reserved                    */
#define  PPMSV_RESERVED_LAST           39    /*  Reserved                    */

#define  PPMSV_PROFILE_FIRST           13
#define  PPMSV_PROFILE_LAST            39

#define  PPMSV_NUM_PPMSV               40
#define  PPMSV_PROTECTED               PPMSV_LEVEL


/***********************************/
/* PPMSV_* Variables Range Values  */
/***********************************/

#define  PPMSV_TOUCH_PAUSE_MIN             150
#define  PPMSV_TOUCH_PAUSE_MAX            2000
#define  PPMSV_TOUCH_PAUSE_DEF             300
#define  PPMSV_PEN_PAUSE_MIN               150
#define  PPMSV_PEN_PAUSE_MAX              2000
#define  PPMSV_PEN_PAUSE_DEF               400
#define  PPMSV_MOUSE_PAUSE_MIN             150
#define  PPMSV_MOUSE_PAUSE_MAX            2000
#define  PPMSV_MOUSE_PAUSE_DEF             400
#define  PPMSV_OTHER_PAUSE_MIN             150
#define  PPMSV_OTHER_PAUSE_MAX            3500
#define  PPMSV_OTHER_PAUSE_DEF             200

#define  PPMSV_GESTURE_CANCEL_TIMEOUT_MIN  500
#define  PPMSV_GESTURE_CANCEL_TIMEOUT_MAX 3000
#define  PPMSV_GESTURE_CANCEL_TIMEOUT_DEF 1200
#define  PPMSV_GESTURE_TIMEOUT_MIN         100
#define  PPMSV_GESTURE_TIMEOUT_MAX        2000
#define  PPMSV_GESTURE_TIMEOUT_DEF         900

#define  PPMSV_PAUSEBEEPFREQ_MIN           100
#define  PPMSV_PAUSEBEEPFREQ_MAX          4000
#define  PPMSV_PAUSEBEEPFREQ_DEF           100
#define  PPMSV_RECO_BEEP_ENABLE_MIN          0
#define  PPMSV_RECO_BEEP_ENABLE_MAX          1
#define  PPMSV_RECO_BEEP_ENABLE_DEF          1

#define  PPMSV_MINGESTUREPOINTS_MIN          1
#define  PPMSV_MINGESTUREPOINTS_MAX         20
#define  PPMSV_MINGESTUREPOINTS_DEF          5
#define  PPMSV_RECOPTRTIMER_MIN            200
#define  PPMSV_RECOPTRTIMER_MAX           1250
#define  PPMSV_RECOPTRTIMER_DEF            350

#define  PPMSV_STANDARDIZED_RESOLUTION_MIN 1000
#define  PPMSV_STANDARDIZED_RESOLUTION_MAX 1000
#define  PPMSV_STANDARDIZED_RESOLUTION_DEF 1000

#define  PPMSV_TOUCH_PAUSE_ENABLE_MIN        0
#define  PPMSV_TOUCH_PAUSE_ENABLE_MAX        1
#define  PPMSV_TOUCH_PAUSE_ENABLE_DEF        1
#define  PPMSV_PEN_PAUSE_ENABLE_MIN          0
#define  PPMSV_PEN_PAUSE_ENABLE_MAX          1
#define  PPMSV_PEN_PAUSE_ENABLE_DEF          1
#define  PPMSV_MOUSE_PAUSE_ENABLE_MIN        0
#define  PPMSV_MOUSE_PAUSE_ENABLE_MAX        1
#define  PPMSV_MOUSE_PAUSE_ENABLE_DEF        0
#define  PPMSV_OTHER_PAUSE_ENABLE_MIN        0
#define  PPMSV_OTHER_PAUSE_ENABLE_MAX        1
#define  PPMSV_OTHER_PAUSE_ENABLE_DEF        1

APIRET APIENTRY WrtQueryInputDeviceVariable(PSZ     pszDriverName,
                                            PSZ     pszDeviceName,
                                            ULONG   ulValueID, /* See PPMID_* */
                                            PLONG   lValue,
                                            PULONG  ulDatalen,
                                            PVOID   pData);
APIRET APIENTRY WrtSetInputDeviceVariable(PSZ     pszDriverName,
                                          PSZ     pszDeviceName,
                                          ULONG   ulValueID, /* See PPMID_* */
                                          LONG    lValue,
                                          ULONG   ulDatalen,
                                          PVOID   pData);
/*************************************/
/* PPMID_* Input Device Variable IDs */
/*************************************/

/* Stored in Profile */
#define  PPMID_MOTION_STOP           0
#define  PPMID_MOTION_START          1
#define  PPMID_MINGESTURELENGTH      2
#define  PPMID_DISABLE_PROXIMITY     3
#define  PPMID_TOUCHOFFSET_X         4
#define  PPMID_TOUCHOFFSET_Y         5
#define  PPMID_BACKLIGHTBLANK        6
#define  PPMID_BACKLIGHTBLANK_INT    7
#define  PPMID_POINT_RATE            8
#define  PPMID_DIVIDE_RATE           9
#define  PPMID_DEVICE_PARMS         10
#define  PPMID_RSVD_1               11
#define  PPMID_RSVD_2               12
#define  PPMID_RSVD_3               13

#define  PPMID_PROFILE_FIRST         0
#define  PPMID_PROFILE_LAST         13

#define  PPMID_NUM_PPMID            14


/***********************************/
/* PPMID_* Variables Range Values  */
/***********************************/
#define  PPMID_MOTION_STOP_MIN             28
#define  PPMID_MOTION_STOP_MAX            300
#define  PPMID_MOTION_STOP_DEF_PEN         28
#define  PPMID_MOTION_STOP_DEF_TOUCH       56
#define  PPMID_MOTION_STOP_DEF_MOUSE       28
#define  PPMID_MOTION_STOP_DEF_OTHER       28
#define  PPMID_MOTION_START_MIN             1
#define  PPMID_MOTION_START_MAX          1000
#define  PPMID_MOTION_START_DEF_PEN        64
#define  PPMID_MOTION_START_DEF_TOUCH     104
#define  PPMID_MOTION_START_DEF_MOUSE      52
#define  PPMID_MOTION_START_DEF_OTHER      25

#define  PPMID_MINGESTURELENGTH_MIN         0
#define  PPMID_MINGESTURELENGTH_MAX      8000
#define  PPMID_MINGESTURELENGTH_DEF_PEN   156
#define  PPMID_MINGESTURELENGTH_DEF_TOUCH 233
#define  PPMID_MINGESTURELENGTH_DEF_MOUSE 233
#define  PPMID_MINGESTURELENGTH_DEF_OTHER 233

#define  PPMID_DISABLE_PROXIMITY_MIN        0
#define  PPMID_DISABLE_PROXIMITY_MAX        1
#define  PPMID_DISABLE_PROXIMITY_DEF        1

#define  PPMID_BACKLIGHTBLANK_MIN           0
#define  PPMID_BACKLIGHTBLANK_MAX           1
#define  PPMID_BACKLIGHTBLANK_DEF           1
#define  PPMID_BACKLIGHTBLANK_INT_MIN      30
#define  PPMID_BACKLIGHTBLANK_INT_MAX  500000
#define  PPMID_BACKLIGHTBLANK_INT_DEF    1200

#define  PPMID_POINT_RATE_MIN              40
#define  PPMID_POINT_RATE_MAX             200
#define  PPMID_POINT_RATE_DEF             100

#define  PPMID_DIVIDE_RATE_MIN              1
#define  PPMID_DIVIDE_RATE_MAX              8
#define  PPMID_DIVIDE_RATE_DEF              2
#define  PPMID_DEVICE_PARMS_MIN             0
#define  PPMID_DEVICE_PARMS_MAX             1
#define  PPMID_DEVICE_PARMS_DEF             1

#define  PPMID_TOUCHOFFSET_X_MIN        -1000
#define  PPMID_TOUCHOFFSET_X_MAX         1000
#define  PPMID_TOUCHOFFSET_X_DEF           60
#define  PPMID_TOUCHOFFSET_Y_MIN        -1000
#define  PPMID_TOUCHOFFSET_Y_MAX         1000
#define  PPMID_TOUCHOFFSET_Y_DEF           10

/*                                                 */
/*  WM_WRT_SYSVALUECHANGED message mp1 values      */
/*                                                 */
#define   VT_PPMSV     1
#define   VT_PPMID     2


/************************/
/* WRTERR_* Error Codes */
/************************/
#define WRT_NO_ERROR                        0
#define WRTERR_START                   0x7000
#define WRTERR_ALREADY_ACTIVE          0x7001
#define WRTERR_NOT_ENOUGH_MEMORY       0x7002
#define WRTERR_CREATETHREAD_FAILED     0x7003
#define WRTERR_SETHOOK_FAILED          0x7004
#define WRTERR_RELEASEHOOK_FAILED      0x7005
#define WRTERR_NOT_ACTIVE              0x7006
#define WRTERR_NOT_OWNER               0x7007
#define WRTERR_INVALID_HWND            0x7008
#define WRTERR_INVALID_ID              0x7009
#define WRTERR_INVALID_PID             0x700A
#define WRTERR_TOO_MANY_MAPPERS        0x700B
#define WRTERR_WRITE_FAILED            0x700C
#define WRTERR_NOT_PEN_ENV             0x700D
#define WRTERR_BUFFER_TOO_SMALL        0x700E
#define WRTERR_STROKE_INVALID          0x700F
#define WRTERR_BxDOWN_IN_STATEB        0x7010
#define WRTERR_BxUP_IN_STATE0          0x7011
#define WRTERR_APPL_NOT_ACTIVE         0x7012

#define REDERR_RECO_SUBSYS_NOT_REG     0x7015
#define REDERR_RECO_NAME_TOO_LONG      0x7016
#define REDERR_INVALID_RECO_NAME       0x7017
#define REDERR_EVENT_NAME_TOO_LONG     0x7018
#define REDERR_INVALID_EVENT_NAME      0x7019
#define REDERR_EVENT_NAME_NOT_REG      0x701A
#define REDERR_INVALID_EVENT_ID        0x701C
#define REDERR_INVALID_EVENT_PTR       0x701D
#define REDERR_RECO_DATA_INVALID       0x701E


#define WRTERR_SENSORRESOLUTION_UNAVAIL 0x701F
#define WRTERR_BxDOWN_IN_STATEA        0x7020
#define WRTERR_HITTEST_FAILED          0x7021
#define WRTERR_BACKLITE_CMD_FAILED     0x7022
#define WRTERR_INVALID_PARM            0x7023
#define WRTERR_INVALID_EXTENTS         0x7024
#define WRTERR_INVALID_OPTION          0x7025
#define WRTERR_PARM_OUT_OF_RANGE       0x7026
#define WRTERR_INVALID_BUFFER          0x7027
#define WRTERR_INVALID_DRIVER_NAME     0x7028
#define WRTERR_INVALID_DEVICE_NAME     0x7029
#define WRTERR_MORE_NAMES_AVAIL        0x702A
#define WRTERR_INVALID_POINTER         0x702B
#define WRTERR_INVALID_LOCATOR_ID      0x702C
#define WRTERR_INVALID_BUTTON_ID       0x702D
#define WRTERR_INVALID_DISPLAY_ID      0x702E
#define WRTERR_STRUCT_NOT_INIT         0x702F
#define WRTERR_VALUEID_DEVICE_MISMATCH 0x7030
#define WRTERR_NO_DEVICE_CAPABILITY    0x7031
#define WRTERR_INVALID_BUTTON_EVENT    0x7032
#define WRTERR_WAIT_TIMEOUT            0x7033
#define WRTERR_INVALID_MOUSE_EVENT     0x7034
#define WRTERR_INVALID_INPUT           0x7035
#define WRTERR_INVALID_COUNT           0x7036
#define WRTERR_ID_READ_ONLY            0x7037
#define WRTERR_PEN_NOT_INSTALLED       0x7038

/************************/
/* VKPERR_* Error Codes */
/************************/

#define VKP_NO_ERROR                   NO_ERROR
#define VKPERR_OUT_OF_MEMORY           0x7100
#define VKPERR_VKP_NOT_READY           0x7101
#define VKPERR_INVALID_KBD_NAME        0x7102
#define VKPERR_KBD_LOAD_FAILED         0x7103
#define VKPERR_KBD_LOAD_TIMEOUT        0x7104
#define VKPERR_INVALID_PARM            0x7105
#define VKPERR_WSWP_FAILED             0x7106
#define VKPERR_WQWP_FAILED             0x7107
#define VKPERR_INVALID_OWNER           0x7108

/* Start of handwriting control area */

#ifndef __HWXENTRY_INCLUDED__
#define __HWXENTRY_INCLUDED__

/*****************************************************************************/
/*                                                                           */
/* Class Name                                                                */
/*                                                                           */
/*****************************************************************************/

#ifndef WC_PENFIRST
#define WC_PENFIRST     (0xffff0029L)
#endif

#define WC_HWXENTRY     ((PSZ)0xffff0029L)

/*****************************************************************************/
/*                                                                           */
/* Handwriting Control Style Bits                                            */
/*                                                                           */
/*****************************************************************************/

#define HX_BORDER       0x0001   /* Control displays a    border        */
#define HX_3DBORDER     0x0002   /* Control displays a 3D border        */

/*****************************************************************************/
/*                                                                           */
/*  Parent Notification Messages                                             */
/*                                                                           */
/*****************************************************************************/

#define HXN_STROKE_ADDED          WM_USER + 1   /* Stroke Add pending         */
#define HXN_GESTURE_PENDING       WM_USER + 2   /* Gesture pending            */
#define HXN_DELETE_PENDING        WM_USER + 3   /* Delete char pending        */
#define HXN_INSERT_PENDING        WM_USER + 4   /* Insert char pending        */
#define HXN_OVERFLOW              WM_USER + 5   /* Control text overflow      */
#define HXN_SETFOCUS              WM_USER + 6   /* Input focus activated      */
#define HXN_KILLFOCUS             WM_USER + 7   /* Input focus deactivated    */
#define HXN_CONTENTS_CHANGED      WM_USER + 8   /* Control Recognition change */

#endif                              /* ifndef __HWXENTRY_INCLUDED__ */

/* Start of Sketch area */

#ifndef __SKETCH_INCLUDED__
#define __SKETCH_INCLUDED__

/******************************************************************************/
/*                                                                            */
/* Class Name                                                                 */
/*                                                                            */
/******************************************************************************/

#ifndef WC_PENFIRST
#define WC_PENFIRST     (0xffff0029L)
#endif


#define WC_SKETCH       ((PSZ)0xffff002AL)



/******************************************************************************/
/*                                                                            */
/* Control Style Bits                                                         */
/*                                                                            */
/******************************************************************************/

#define SKS_BORDER       0x0001   /* Control appearance is Bordered     */
#define SKS_3DBORDER     0x0002   /* Control appearance is 3D Bordered  */

/******************************************************************************/
/*                                                                            */
/* Control Messages                                                           */
/*                                                                            */
/*  Messages sent to Sketch Control from Owner                                */
/*                                                                            */
/* These constants below are used as messages to query and change             */
/* the state of a WC_SKETCH window.                                           */
/* They are sent to WC_SKETCH windows using WinSendMsg like so:               */
/*                                                                            */
/*    rc = WinSendMsg (hwndSketch, SKM_xxx, mp1, mp2);                        */
/*                                                                            */
/******************************************************************************/


                                                    /* Non modal messages     */
#define SKM_DELETE_ALL_STROKES        WM_USER +  1  /*                        */
#define SKM_GET_BITMAP                WM_USER +  2  /*                        */
#define SKM_UNDO_LAST_STROKE          WM_USER +  3  /*                        */
#define SKM_QUERY_BITMAP_SIZE         WM_USER +  4  /*                        */
#define SKM_RENDER_TO_CLIPBOARD       WM_USER +  5  /*                        */
                                                    /*                        */
                                                    /* Query control values   */
#define SKM_QUERY_CTL_DRAW_POINTER    WM_USER +  6  /*                        */
#define SKM_QUERY_CTL_INK_COLOR       WM_USER +  7  /*                        */
#define SKM_QUERY_CTL_INK_WIDTH       WM_USER +  8  /*                        */
#define SKM_QUERY_CTL_INVISIBLE_MODE  WM_USER +  9  /*                        */
#define SKM_QUERY_CTL_STROKE_COUNT    WM_USER + 10  /*                        */
                                                    /*                        */
                                                    /* Query stroke values    */
#define SKM_QUERY_STROKE_DATA         WM_USER + 11  /*                        */
#define SKM_QUERY_STROKE_INK_COLOR    WM_USER + 12  /*                        */
#define SKM_QUERY_STROKE_INK_WIDTH    WM_USER + 13  /*                        */
#define SKM_QUERY_STROKE_LENGTH       WM_USER + 14  /*                        */
                                                    /*                        */
                                                    /* Set control values     */
#define SKM_SET_CTL_AUXDATA_MODE      WM_USER + 15  /* level of aux data      */
#define SKM_SET_CTL_DRAW_POINTER      WM_USER + 16  /* draw pointer           */
#define SKM_SET_CTL_INK_COLOR         WM_USER + 17  /* ink color              */
#define SKM_SET_CTL_INK_WIDTH         WM_USER + 18  /* ink width              */
#define SKM_SET_CTL_INVISIBLE_MODE    WM_USER + 19  /* invisible mode         */
                                                    /*                        */
                                                    /* Set stroke values      */
#define SKM_SET_STROKE_INK_COLOR      WM_USER + 20  /*                        */
#define SKM_SET_STROKE_INK_WIDTH      WM_USER + 21  /*                        */

#define SKM_ADD_STROKE                WM_USER + 22  /* Add a stroke           */

/******************************************************************************/
/*                                                                            */
/* Parent Notification Messages                                               */
/*                                                                            */
/* The WC_SKETCH window will send a message to its parent                     */
/*                                                                            */
/*     WinSendMsg (hwndOwner, WM_CONTROL,                                     */
/*             MPFROM2SHORT (idSktWindow, usNotifyCode), mp2);                */
/*                                                                            */
/* These constants below are used as notification codes                       */
/* for WM_CONTROL messages. (These are usNotifyCode's.)                       */
/*                                                                            */
/******************************************************************************/

#define SKN_FOCUS_ACTIVATE        WM_USER + 100   /* Control has gained focus        */
#define SKN_FOCUS_DEACTIVATE      WM_USER + 102   /* Control has lost focus          */
#define SKN_STROKE_ADD            WM_USER + 103   /* Control is adding stroke        */
#define SKN_STROKE_UNDO           WM_USER + 104   /* Control is deleteting stroke    */
#define SKN_CONTROL_CLEARED       WM_USER + 105   /* Control is deleting all strokes */
#define SKN_INK_COLOR_CHANGE      WM_USER + 106   /* Control has changed ink color   */
#define SKN_INK_WIDTH_CHANGE      WM_USER + 107   /* Control has changed ink width   */

/******************************************************************************/
/*                                                                            */
/*     Structure used to retrieve stroke(i) from the stroke database.         */
/*                                                                            */
/*                                                                            */
/*             . ------------------------------- .                            */
/*           1 .                                 .                            */
/*             . SKTCTRLSTROKEDEF                .                            */
/*             .                                 .                            */
/*             .         PSTROKEDATA             . -> 2                       */
/*             . ------------------------------- .                            */
/*           2 .                                 .                            */
/*             . STROKEDATA                      .                            */
/*             .                                 .                            */
/*             .         PPOINTL                 . -> 3                       */
/*             .                                 .                            */
/*             .         PAUXDATAINFO            . -> 4                       */
/*             .         PAUXSTROKEDATA          . -> 5                       */
/*             .                                 .                            */
/*             .         struct _STROKEDATA *    . -> NULL                    */
/*             .         struct _STROKEDATA *    . -> NULL                    */
/*             . ------------------------------- .                            */
/*           3 .                                 .                            */
/*             . X/Y POINTL array                .                            */
/*             .                                 .                            */
/*             . ------------------------------- .                            */
/*           4 .                                 .                            */
/*             . AUXDATAINFO                     .                            */
/*             .                                 .                            */
/*             . ------------------------------- .                            */
/*           5 .                                 .                            */
/*             . AUXPOINTDATA                    .                            */
/*             .                                 .                            */
/*             . ------------------------------- .                            */
/*                                                                            */
/******************************************************************************/

typedef struct _SKETCHSTROKEDEF
{
   ULONG  ulStrokeColor;
   ULONG  ulStrokeWidth;
   POINTL reserved1;
   ULONG  reserved2;
   ULONG  reserved3;
   PSTROKEDATA pStroke;
} SKETCHSTROKEDEF;

typedef SKETCHSTROKEDEF *PSKETCHSTROKEDEF;    /* Ptr->SKETCHSTROKEDEF         */
typedef PSKETCHSTROKEDEF *PPSKETCHSTROKEDEF;  /* Ptr->Ptr->SKETCHSTROKEDEF    */

#endif                                  /* ifndef __SKETCH_INCLUDED__ */

/* Start of RED area */

#ifndef PPMRED_INCLUDED
#define PPMRED_INCLUDED


#define REDHOBJ_OS2 (HOBJECT)(0xfffffffe)
#define REDHOBJ_WIN (HOBJECT)(0xfffffffd)
#define REDHOBJ_DOS (HOBJECT)(0xfffffffc)
#define REDHOBJ_PM  (HOBJECT)(0xfffffffb)


/*
 * Error defines for Red layer
 */
#define RED_NO_ERROR (0)
#define REDERR_INVALID_BUTTON        0x0000a000
#define REDERR_INVALID_BI            0x0000a001
#define REDERR_BUF_TOO_SMALL         0x0000a002
#define REDERR_INVALID_PARM          0x0000a003
#define REDERR_NO_MEMORY             0x0000a004
#define REDERR_NOT_FOUND             0x0000a005
#define REDERR_WRITE_ERR             0x0000a006
#define REDERR_PROFILE_ERROR         0x0000a007
#define REDERR_CMD_IS_BUILTIN        0x0000a008


/*
 * declarations for RED functions
 */

APIRET APIENTRY RedRegisterRecoCommand(PSZ pszCommand, ULONG id, HWND hwnd);

HWND APIENTRY RedQueryRecoCommand(PSZ cmdp);

APIRET APIENTRY RedDeregisterRecoCommand(HWND hwnd);


APIRET APIENTRY RedRecoDataFromEnv(PRECODATA prdEnv, ULONG *lenp);


APIRET APIENTRY RedQueryRecoHandle(PSZ     pszRecoSubsystem,
                                    PHRECO  phReco,
                                    PULONG pEventCount);


APIRET APIENTRY RedQueryRecoSubsystem(HRECO   hReco,
                                      PSZ     pszRecoSubsystem,
                                      PULONG pEventCount);


APIRET APIENTRY RedRecoIDFromName(HRECO   hReco,
                                  PSZ     pszEventName,
                                  PRECOID eventID);

APIRET APIENTRY RedRecoNameFromID(HRECO   hReco,
                                  RECOID  eventID,
                                  PSZ     pszEventName);

APIRET APIENTRY RedWriteObjectEventMap(HOBJECT hobj, PSZ fnamep);

APIRET APIENTRY RedReadObjectEventMap(HOBJECT hobj, PSZ fnamep);

#endif      /* ifndef RED_INCLUDED */

#endif
