
# This file was generated by the SOM Compiler.
# FileName: penbtndv.sc.
# Generated using:
#     SOM Precompiler spc: 1.22
#     SOM Emitter emitcsc: 1.10

/*
 *  SCC: @(#) 71 4/12/93 12:02:47 1.3 @(#)
 *  Module Header
 * 
 *  Module Name: PENBTNDV
 * 
 *  OS/2 Presentation Manager Workplace class definitions
 * 
 *  Copyright (c) International Business Machines Corporation 1992
 * 
 */

#include "wpabs.sc"

class: PenButtonDevice, 
    external stem = Penbtn, local, external prefix = btn_, 
    classprefix = btnM_, major version = 1, minor version = 1, 
    file stem = penbtndv;

    -- 
    --  CLASS: PenButtonDevice
    -- 
    --  CLASS HIERARCHY:
    --     SOMObject
    --        WPObject
    --              WPAbstract
    --                    PenButtonDevice
    -- 
    --  DESCRIPTION:
    --     This is the Pen Button Device support class
    -- 


parent class: WPAbstract;


release order:
    penAddButtonsMappingsPage, penQueryButtonData, penSetButtonData, 
    penQueryDriverName, penQueryDeviceName, penQueryButtonDeviceName, 
    penQueryBarrelCount, penSetDriverName, penSetDeviceName, 
    penSetButtonDeviceName, penSetBarrelCount, penclsQueryButtonData;


passthru: C.h, after;

   #define MAXBUTTONNAME        20

   typedef struct _PENEVENTDATA
   {
        PVOID   pReserved1;
        HMODULE hModule;
        ULONG   ulResourceId;
        CHAR    pszName[MAXBUTTONNAME];
   } PENEVENTDATA, *PPENEVENTDATA;

endpassthru;
methods:


    ULONG    penAddButtonsMappingsPage(HWND hwndNotebook);

    -- 
    --  METHOD: penAddButtonsMappingsPage                       ( ) PRIVATE
    --                                                          (X) PUBLIC
    --  PURPOSE:
    --    Add the Buttons Mapping configuration page to the buttons settings
    --    notebook
    -- 

    ULONG    penQueryButtonData(PPENEVENTDATA pPenEventData);

    -- 
    --  METHOD: penQueryButtonData                              ( ) PRIVATE
    --                                                          (X) PUBLIC
    --  PURPOSE:
    --    The penQueryButtonData method is called to allow the instance
    --    to query its default button bitmaps to be used on the buttons page.
    -- 

    BOOL    penSetButtonData(PPENEVENTDATA pPenEventData);

    -- 
    --  METHOD: penSetButtonData                                ( ) PRIVATE
    --                                                          (X) PUBLIC
    --  PURPOSE:
    --    The penSetButtonData method is called to allow the instance
    --    to set its default button bitmaps to be used on the buttons page.
    -- 

    ULONG    penclsQueryButtonData(PPENEVENTDATA pPenEventData), class;

    -- 
    --  METHOD: penclsQueryButtonData                           ( ) PRIVATE
    --                                                          (X) PUBLIC
    --  PURPOSE:
    --    The penclsQueryButtonData method is called to allow the class object
    --    to specify the default button bitmaps to be used on the buttons page
    --    for its instances.
    -- 

    override wpAddSettingsPages;

    -- 
    --  METHOD: wpAddSettingsPages                             ( ) PRIVATE
    --                                                         (X) PUBLIC
    --  PURPOSE:
    --    Add our own settings page to let the user change the backlight
    --    timeout.
    -- 

    override wpSetup;

    -- 
    --  REMARKS:
    -- 

    override wpSaveState;

    -- 
    --  REMARKS:
    --     Save the instance variable values.
    -- 
    -- 

    override wpRestoreState;

    -- 
    --  REMARKS:
    --     Retreive the device driver name and the device name for this
    --     object instance and set the instance variables for these parameters.
    -- 
    -- 

    override wpInitData;

    -- 
    --  REMARKS:
    --     Initialize the button link list and the button command link list
    -- 
    -- 

    override wpUnInitData;

    -- 
    --  REMARKS:
    --     Releases the button link list and the button command link list
    --     memory
    -- 
    -- 

    override wpclsInitData, class;

    -- 
    --  REMARKS:
    --     Initialize the command list
    -- 
    -- 

    override wpclsNew, class;

    -- 
    --  REMARKS:
    --     Lock any instances that are created
    -- 
    -- 

