/******************************************************************************
*                                                                             *
*  File Name   : OEM.C                                                        *
*                                                                             *
*  Description : Sample sublcass                                              *
*                                                                             *
*  Function:  This is a sample of a subclass of PenLocatorPen                 *
*                                                                             *
*  Copyright (C) 1993 IBM Corporation                                         *
*                                                                             *
*      DISCLAIMER OF WARRANTIES.  The following [enclosed] code is            *
*      sample code created by IBM Corporation. This sample code is not        *
*      part of any standard or IBM product and is provided to you solely      *
*      for  the purpose of assisting you in the development of your           *
*      applications.  The code is provided "AS IS", without                   *
*      warranty of any kind.  IBM shall not be liable for any damages         *
*      arising out of your use of the sample code, even if they have been     *
*      advised of the possibility of such damages.                            *
*                                                                             *
*******************************************************************************/

/*
 * This file was generated by the SOM Compiler
 * and them updated. Please note the SOMInitModule and _DLL_InitTerm.
 * FileName: oem.c.
 * Generated using:
 *     SOM Precompiler spc: 1.22
 *     SOM Emitter emitc: 1.24
 */

#define oem_Class_Source
#include "oem.ih"

/* Define a global variable for the dll hmodule */
HMODULE  MyModHandle = NULLHANDLE;

unsigned long  _System _DLL_InitTerm(unsigned long modhandle,
                                     unsigned long flag)
{
   if ( flag == 0 ) /* init */
   {
       MyModHandle = modhandle;
   }
   return 1;
}

VOID EXPENTRY OemSetup( HWND hwndOwner,          /* These parameters need     */
                        PSZ  pszSourcePath,      /* to be specified, because  */
                        PSZ  pszDestination,     /* INSTALL expects to call   */
                        PSZ  pszSSDllInput,      /* the entry point as such   */
                        HWND hwndObject,         /* In this example, only     */
                        PSZ  achResponse)        /* pszDestination is used    */
{
  CHAR     szResourceDll[255];
  CHAR     ErrorBuffer[100];
  HMODULE  hMod;
  APIRET   apiret;
  ULONG    ulDrive;
  ULONG    ulRet;

  /************************************************************************
  * Set the default drive to where OEM is installed                       *
  ************************************************************************/
  szResourceDll[0] = '\0';
  strcpy(szResourceDll, pszDestination);
  ulDrive = (ULONG)( (szResourceDll[0] - 'A')+ 1);
  apiret = DosSetDefaultDisk (ulDrive);

  /************************************************************************
  * Change the directory to where OEM is installed                        *
  ************************************************************************/
  apiret = DosSetCurrentDir ((PSZ)strchr(szResourceDll, '\\'));

  /************************************************************************
  * Noe, we need to do a DosLoadModule on this module, because            *
  * WinRegisterObjectClass will not be able to find the module as         *
  * loaded by INSTALL (by path). By changing directory to the directory   *
  * where OEM.DLL resides, and doing a DosLoadModule, WinRegisterClass    *
  * will be able to find the DLL.  The result is that during install,     *
  * there are 2 copies of OEM.DLL loaded.  This will be cleaned up when   *
  * the user reboots the machine after installation is complete           *
  *                                                                       *
  ************************************************************************/
  ulRet = DosLoadModule( (PSZ) ErrorBuffer,
                         sizeof(ErrorBuffer),
                         "OEM",
                         &hMod
                      );
  if ( ulRet == NO_ERROR )
  {
     /************************************************************************
     * Create the Devices Folder, only if it does not already exist          *
     ************************************************************************/
     WinCreateObject("WPFolder",
                     "Devices",
                     "OBJECTID=<DEVICES_FOLDER>;HELPPANEL=40067;HELPLIBRARY=PSETUP.HLP",
                     "<PPM_FOLDER>",
                     CO_FAILIFEXISTS);

     /************************************************************************
     * Register the class                                                    *
     ************************************************************************/
     WinRegisterObjectClass("oem", "OEM");

     /************************************************************************
     *  Create the object in the Devices Folder                              *
     ************************************************************************/
     WinCreateObject("oem",
                     "OEM Pen",
                     "OBJECTID=<OEM_PEN>;CALPROG=CAL.EXE;CALPARMS=TRUE;PEN_DRIVER=Digitizer Mod 3;PEN_DEVICE=Pen",
                     "<DEVICES_FOLDER>",
                     CO_REPLACEIFEXISTS);
  }
}

VOID SOMLINK SOMInitModule()
{
   oemNewClass ( oem_MajorVersion,
                 oem_MinorVersion);
}

/*
 *
 *   overrides
 */

#undef SOM_CurrentClass
#define SOM_CurrentClass SOMInstance
SOM_Scope ULONG   SOMLINK AddUserTypePage(oem *somSelf,
    HWND hwndOem)
{
    PAGEINFO pageinfo;
    APIRET   rc;

    /* oemData  *somThis = oemGetData(somSelf); */
    oemMethodDebug("oem","AddUserTypePage");

   /*************************************************************************/
   /* Setup the page information structure and then insert the page into    */
   /*  the settings notebook for this object.                               */
   /*************************************************************************/
   memset((PCH) &pageinfo, 0, sizeof(PAGEINFO));

   if ( MyModHandle )
   {
      pageinfo.cb                 = sizeof(PAGEINFO);
      pageinfo.hwndPage           = NULLHANDLE;
      pageinfo.usPageStyleFlags   = BKA_MAJOR;
      pageinfo.usPageInsertFlags  = BKA_FIRST;
      pageinfo.pfnwp              = (PFNWP) OemDialogProc;
      pageinfo.resid              = MyModHandle;
      pageinfo.dlgid              = OEM_DIALOG;
      pageinfo.pszName            = "OEM";
      pageinfo.pCreateParams      = (PVOID) NULL;
      pageinfo.idDefaultHelpPanel = 0;
      pageinfo.pHelpSubtable      = 0L;
      pageinfo.pszHelpLibraryName = NULL;
      return _wpInsertSettingsPage( somSelf, hwndOem, &pageinfo );
   }
}

SOM_Scope BOOL   SOMLINK wpAddSettingsPages(oem *somSelf,
                                            HWND hwndNotebook)
{
    /* oemData *somThis = oemGetData(somSelf); */
    oemMethodDebug("oem","wpAddSettingsPages");

    if (parent_wpAddSettingsPages(somSelf, hwndNotebook) &&
        _AddUserTypePage(somSelf, hwndNotebook))
       return(TRUE);
    else
       return(FALSE);
}

#undef SOM_CurrentClass
#define SOM_CurrentClass SOMMeta
SOM_Scope ULONG SOMLINK oemM_wpclsQueryIconData(M_oem *somSelf,
                                                PICONINFO pIconInfo)
{

    /* M_oemData *somThis = M_oemGetData(somSelf); */
    M_oemMethodDebug("M_oem","oemM_wpclsQueryIcon");

    if (pIconInfo)
    {
       pIconInfo->fFormat = ICON_RESOURCE;
       pIconInfo->hmod    = MyModHandle;
       pIconInfo->resid   = ID_OBJECTICON;
    }

    return (sizeof(ICONINFO));
}

SOM_Scope PSZ   SOMLINK oemM_wpclsQueryTitle(M_oem *somSelf)
{
    /* M_oemData *somThis = M_oemGetData(somSelf); */
    M_oemMethodDebug("M_oem","oemM_wpclsQueryTitle");

    return ((PSZ) "OEM Pen");
}

MRESULT EXPENTRY OemDialogProc(HWND hwndDlg, ULONG msg, MPARAM mp1, MPARAM mp2)

{
    static BOOL bDuringInit;
    ULONG       ulSliderSetting;
    APIRET      rc;

  switch (msg)
  {
     case WM_INITDLG:
        /*****************************************************************
        *   Perform initialization here                                  *
        *****************************************************************/
        return (MRESULT) FALSE;

     case WM_DESTROY:
        /*****************************************************************
        *   Perform clean up here                                        *
        *****************************************************************/
        break;

     case WM_COMMAND:
     case WM_CONTROL:
        return (MRESULT) FALSE;
  }  /* of switch(msg)                         */

  return (WinDefDlgProc(hwndDlg, msg, mp1, mp2) );
}
