.*****************************************************************************/
.*                                                                           */
.*  File Name   : MOVEKBD.IPF                                                */
.*                                                                           */
.*  Description : Move Popup Keyboard Sample Program Information File        */
.*                                                                           */
.*                                                                           */
.*  Copyright (C) 1993 IBM Corporation                                       */
.*                                                                           */
.*      DISCLAIMER OF WARRANTIES.  The following [enclosed] code is          */
.*      sample code created by IBM Corporation. This sample code is not      */
.*      part of any standard or IBM product and is provided to you solely    */
.*      for  the purpose of assisting you in the development of your         */
.*      applications.  The code is provided "AS IS", without                 */
.*      warranty of any kind.  IBM shall not be liable for any damages       */
.*      arising out of your use of the sample code, even if they have been   */
.*      advised of the possibility of such damages.                          */
.*                                                                           */
.*****************************************************************************/
:userdoc
.****************************************************************/
.*  Help from Move Keyboard Window                              */
.*  PANEL_MOVEKBD                                               */
.****************************************************************/
:h1 res=910.Move Pop-Up Keyboard Window
Select "Demo", then "Start Demo" to start the Demonstration Program.

The dialog displays a row of pushbuttons which controls the position
and size of a Pop-Up Keyboard.
:lines.
Button Actions:
:link
reftype=hd res=911.LOAD:elink. - Loads the default Pop-Up Keyboard.
:link
reftype=hd res=912.MOVE:elink. - Moves the Pop-Up Keyboard.
:link
reftype=hd res=913.ENLARGE:elink. - Enlarges the Pop-Up Keyboard.
:link
reftype=hd res=914.SHRINK:elink. - Shrinks the Pop-Up Keyboard.
:link
reftype=hd res=915.CLOSE:elink. - Closes the Pop-Up Keyboard.
:elines.
.****************************************************************/
.*  Help for LOAD Pushbutton                                    */
.*  PANEL_BTNLOAD                                               */
.****************************************************************/
:h1 res=911.LOAD
:lines.
LOAD - Loads the default Pop-Up Keyboard.
:elines.
:p.
:hp4.Example:
:xmp.
:font facename=Helv size=10x10.
APIRET    rc;
:p.
rc = (APIRET) VkpLoadKeyboard( NULL,
                               hwnd )

   hwnd - The window handle of the frame
          that owns the Pop-Up Keyboard.
:ehp4.
:font facename=default.
:exmp.
.****************************************************************/
.*  Help for MOVE Pushbutton                                    */
.*  PANEL_BTNMOVE                                               */
.****************************************************************/
:h1 res=912.MOVE
:lines.
MOVE - Repositions the Pop-Up Keyboard.  The keyboard will be positioned at
the lower border of the Demo window.  If the window is too low for the
Pop_Up Keyboard to be completely displayed underneath, then the
keyboard will be positioned at the upper border.  Move the Demo window around,
press the Move button and see what happens.
:elines.
:p.
:hp4.Example:
:xmp.
:font facename=Helv size=10x10.
APIRET    rc;
LONG      lX, lY;
:p.
rc = (APIRET) VkpSetKbPos( lX,       /* new keyboard position, x-coordinate */
                           lY,       /* new keyboard position, y-coordinate */
                           0L, 0L,   /* no change in Pop-Up Keyboard size   */
                           SWP_MOVE, /* flag to move the Pop-Up Keyboard    */
                           hwnd )    /* owner of the Pop-Up keyboard        */
:ehp4.
:font facename=default.
:exmp.
.****************************************************************/
.*  Help for ENLARGE Pushbutton                                 */
.*  PANEL_BTNLARG                                               */
.****************************************************************/
:h1 res=913.ENLARGE
:lines.
ENLARGE - Enlarges a Pop-Up Keyboard.  The keyboard size is increased in
fixed increments.  If the new size will put part of the Pop-Up Keyboard
beyond the screen border, then it will not be resized.
:elines.
:p.
:hp4.Example:
:xmp.
:font facename=Helv size=10x10.
APIRET    rc;
LONG      lCx, lCy;
:p.
rc = (APIRET) VkpSetKbPos( 0L, 0L,   /* no change in Pop-Up Keyboard position */
                           lCx,      /* new keyboard width                    */
                           lCy,      /* new keyboard height                   */
                           SWP_SIZE, /* flag to resize the Pop-Up Keyboard    */
                           hwnd )    /* owner of the Pop-Up keyboard          */
:ehp4.
:font facename=default.
:exmp.
.****************************************************************/
.*  Help for SHRINK Pushbutton                                  */
.*  PANEL_BTNSHNK                                               */
.****************************************************************/
:h1 res=914.SHRINK
:lines.
SHRINK - Shrinks the Pop-Up Keyboard.  The keyboard cannot be reduced
below a fixed size.
:elines.
:p.
:hp4.Example:
:xmp.
:font facename=Helv size=10x10.
APIRET    rc;
LONG      lCx, lCy;
:p.
rc = (APIRET) VkpSetKbPos( 0L, 0L,   /* no change in Pop-Up Keyboard position */
                           lCx,      /* new keyboard width                    */
                           lCy,      /* new keyboard height                   */
                           SWP_SIZE, /* flag to resize the Pop-Up Keyboard    */
                           hwnd )    /* owner of the Pop-Up keyboard          */
:ehp4.
:font facename=default.
:exmp.
.****************************************************************/
.*  Help for CLOSE Pushbutton                                   */
.*  PANEL_BTNCLOSE                                              */
.****************************************************************/
:h1 res=915.CLOSE
:lines.
CLOSE - Closes the Pop-Up Keyboard.
:elines.
:p.
:hp4.Example:
:xmp.
:font facename=Helv size=10x10.
BOOL      rc;
:p.
rc = (APIRET) VkpCloseKb( hwnd )

   hwnd - The window handle of the frame
          that owns the Pop-Up Keyboard.
:ehp4.
:font facename=default.
:exmp.
:euserdoc.
