/*****************************************************************************/
/*                                                                           */
/* File Name:    MOVEKBD.H                                                   */
/*                                                                           */
/* Description:  Defines, static variable definitons and function            */
/*               prototypes for MOVEKBD Sample program.                      */
/*                                                                           */
/*                                                                           */
/*  Copyright (C) 1993 IBM Corporation                                       */
/*                                                                           */
/*      DISCLAIMER OF WARRANTIES.  The following [enclosed] code is          */
/*      sample code created by IBM Corporation. This sample code is not      */
/*      part of any standard or IBM product and is provided to you solely    */
/*      for  the purpose of assisting you in the development of your         */
/*      applications.  The code is provided "AS IS", without                 */
/*      warranty of any kind.  IBM shall not be liable for any damages       */
/*      arising out of your use of the sample code, even if they have been   */
/*      advised of the possibility of such damages.                          */
/*                                                                           */
/*****************************************************************************/

/*-------------------------------------------------------------------*/
/* Resource identifiers.                                             */
/*-------------------------------------------------------------------*/
#define ID_NULL                           9999
#define ID_WINDOW                          256
#define ID_ICON                           1000

/*-------------------------------------------------------------------*/
/* Menu item identifiers.                                            */
/*-------------------------------------------------------------------*/
#define IDM_START_DLG                     1300
#define IDM_DEMO                          1310
#define IDM_OPTIONS                       1311
#define IDM_EXIT_DEMO                     1312
#define IDM_HELP                          1313

/*-------------------------------------------------------------------*/
/* Dialog item identifiers.                                          */
/*-------------------------------------------------------------------*/
#define IDD_DLG_MOVE                      1330
#define IDD_LOAD                          1331
#define IDD_MOVE                          1332
#define IDD_ENLARGE                       1333
#define IDD_SHRINK                        1334
#define IDD_CLOSE                         1335

/*-------------------------------------------------------------------*/
/* Help IDs                                                          */
/*-------------------------------------------------------------------*/
#define MOVEKBD_HELPTABLE                  800
#define MOVEKBD_HELPSUBTABLE               801
#define BTNLOAD_HELPSUBTABLE               802
#define BTNMOVE_HELPSUBTABLE               803
#define BTNLARG_HELPSUBTABLE               804
#define BTNSHNK_HELPSUBTABLE               805
#define BTNCLOSE_HELPSUBTABLE              806

#define PANEL_MOVEKBD                      910
#define PANEL_BTNLOAD                      911
#define PANEL_BTNMOVE                      912
#define PANEL_BTNLARG                      913
#define PANEL_BTNSHNK                      914
#define PANEL_BTNCLOSE                     915

/*-------------------------------------------------------------------*/
/* String identifiers.                                               */
/*-------------------------------------------------------------------*/
#define MY_MSG                            2800

#define IDS_APPNAME                   MY_MSG+1
#define IDS_NOSTANDARDWIN             MY_MSG+2
#define IDS_NOREGISTER                MY_MSG+3
#define IDS_NOERASE                   MY_MSG+4
#define IDS_NO_KBD_LOAD               MY_MSG+5
#define IDS_NO_KBD_RUNNING            MY_MSG+6
#define IDS_NO_SET_KBD_POS            MY_MSG+7
#define IDS_NO_QUERY_KBD_POS          MY_MSG+8
#define IDS_NO_RESIZE_KBD             MY_MSG+9
#define IDS_NO_CLOSE_KBD              MY_MSG+10
#define IDS_NO_HELP                   MY_MSG+11
#define IDS_PEN_NOT_INSTALLED         MY_MSG+12
#define IDS_PEN_NOT_RUNNING           MY_MSG+13

/*-------------------------------------------------------------------*/
/* Constants.                                                        */
/*-------------------------------------------------------------------*/

#define MAXSTRINGLEN                 80
#define KEYBOARD_MOVE_INCREMENT      50L
#define KEYBOARD_SIZE_INCREMENT      25L
#define PARMLEN                      16

/*-------------------------------------------------------------------*/
/* Public Variables                                                  */
/*-------------------------------------------------------------------*/

static  BOOL    fRunning=FALSE;                /* keyboard running flag */
static  HAB     hab;                           /* anchor block handle   */
static  HWND    hwndFrame;                     /* frame window handle   */
static  HWND    hwndClient;                    /* client window handle  */
static  HWND    hwndDemoWin;                   /* demo window handle    */
static  HWND    hwndHelp;                      /* help window handle    */
static  HMQ     hmq;                           /* message queue handle  */
static  QMSG    qmsg;                          /* message from msg Q    */
static  LONG    lScreenWd;                     /* screen width          */
static  LONG    lScreenHt;                     /* screen height         */
static  SWP     sDWin;                         /* window coordinates    */
static  SWP     sWinPos;                       /* DeskTop size          */
static  SWP     sKbdPos;                       /* popup keyboard pos    */
static  CHAR    szMsgString[MAXSTRINGLEN];     /* message buffer        */
static  CHAR    szString[MAXSTRINGLEN];        /* message buffer        */

/*-------------------------------------------------------------------*/
/* Internal function prototypes                                      */
/*-------------------------------------------------------------------*/

static MRESULT EXPENTRY MainWndProc( HWND, USHORT, MPARAM, MPARAM );
static MRESULT EXPENTRY DemoDlgProc( HWND, USHORT, MPARAM, MPARAM );
static VOID DisplayMessage( HAB, ULONG );
static VOID InitHelp( VOID );
