.*****************************************************************************/
.*                                                                           */
.*  File Name:    LOADKBD.IPF                                                */
.*                                                                           */
.*  Description:  Load Popup Keyboard Sample Program Information File        */
.*                                                                           */
.*                                                                           */
.*  Copyright (C) 1993 IBM Corporation                                       */
.*                                                                           */
.*      DISCLAIMER OF WARRANTIES.  The following [enclosed] code is          */
.*      sample code created by IBM Corporation. This sample code is not      */
.*      part of any standard or IBM product and is provided to you solely    */
.*      for  the purpose of assisting you in the development of your         */
.*      applications.  The code is provided "AS IS", without                 */
.*      warranty of any kind.  IBM shall not be liable for any damages       */
.*      arising out of your use of the sample code, even if they have been   */
.*      advised of the possibility of such damages.                          */
.*                                                                           */
.*****************************************************************************/
:userdoc
.****************************************************************/
.*  Help from LOAD Keyboard Window                              */
.*  PANEL_LOADKBD                                               */
.****************************************************************/
:h1 res=910.LOAD Pop-Up Keyboard Window
Select "Demo", then "Start Demo" to start the Demonstration Program.

The dialog displays two windows.  One has two entry fields for a name
and a phone number.  These entry fields should be filled in by using
the Pop-Up Keyboard.  A different keyboard is displayed for each field.
:lines.
Button Actions:
:link
reftype=hd res=911.OK:elink. - Copies the Name and Phone Number fields to the display window.
:link
reftype=hd res=912.NAME:elink. - Enter a name in this field.
:link
reftype=hd res=913.PHONE_NO:elink. - Enter a phone number in this field.
:elines.
.****************************************************************/
.*  Help for Ok Pushbutton                                      */
.*  PANEL_BTN_OK                                                */
.****************************************************************/
:h1 res=911.OK
:lines.
Copies the Name and Phone Number fields to the display window.
:elines.
.****************************************************************/
.*  Help for NAME Entry Field                                   */
.*  PANEL_EN_NAME                                               */
.****************************************************************/
:h1 res=912.NAME
:lines.
Enter a name in this field.

When this field gains focus the default keyboard is loaded.
:elines.
:p.
:hp4.Example:
:xmp.
:font facename=Helv size=10x10.
APIRET    rc;
:p.
rc = (APIRET) VkpLoadKeyboard( NULL, hwnd );

   NULL - Specifies the default keyboard.
   hwnd - The window handle of the frame.
          that owns the Pop-Up Keyboard.
:ehp4.
:font facename=default.
:exmp.
.****************************************************************/
.*  Help for PHONE_NO Entry Field                               */
.*  PANEL_EN_PHNO                                               */
.****************************************************************/
:h1 res=913.Phone Number
:lines.
Enter a phone number in this field.

When this field gains focus the Numerical keyboard is loaded.
:elines.
:p.
:hp4.Example:
:xmp.
:font facename=Helv size=10x10.
APIRET    rc;
:p.
rc = (APIRET) VkpLoadKeyboard( "NUMKEY", hwnd );

   NUMKEY - Specifies the Numerical keyboard.
   hwnd - The window handle of the frame.
          that owns the Pop-Up Keyboard.
:ehp4.
:font facename=default.
:exmp.
:euserdoc.
