/*****************************************************************************/
/*                                                                           */
/* File Name:    LOADKBD.H                                                   */
/*                                                                           */
/* Description:  Defines, static variable definitons and function            */
/*               prototypes for Keyboard API Sample program.                 */
/*                                                                           */
/*                                                                           */
/*  Copyright (C) 1993 IBM Corporation                                       */
/*                                                                           */
/*      DISCLAIMER OF WARRANTIES.  The following [enclosed] code is          */
/*      sample code created by IBM Corporation. This sample code is not      */
/*      part of any standard or IBM product and is provided to you solely    */
/*      for  the purpose of assisting you in the development of your         */
/*      applications.  The code is provided "AS IS", without                 */
/*      warranty of any kind.  IBM shall not be liable for any damages       */
/*      arising out of your use of the sample code, even if they have been   */
/*      advised of the possibility of such damages.                          */
/*                                                                           */
/*****************************************************************************/
/*-------------------------------------------------------------------*/
/* Resource identifiers.                                             */
/*-------------------------------------------------------------------*/
#define ID_NULL                           9999
#define ID_WINDOW                          256
#define ID_ICON                           1000

/*-------------------------------------------------------------------*/
/* Menu item identifiers.                                            */
/*-------------------------------------------------------------------*/
#define IDM_START                         1300
#define IDM_START_DLG                     1310
#define IDM_EXIT_DLG                      1312
#define IDM_HELP                          1313

/*-------------------------------------------------------------------*/
/* Dialog item identifiers.                                          */
/*-------------------------------------------------------------------*/
#define IDD_DLG_DEMO                      1330
#define IDD_NAME                          1331
#define IDD_PHONE_NO                      1332
#define IDD_OK                            1333
#define IDD_TEXT_1                        1334
#define IDD_TEXT_2                        1335
#define IDD_INST_1                        1336
#define IDD_INST_2                        1337
#define IDD_INST_3                        1338
#define IDD_FRAME                         1339

/*-------------------------------------------------------------------*/
/* Help IDs                                                          */
/*-------------------------------------------------------------------*/
#define LOADKBD_HELPTABLE                  800
#define LOADKBD_HELPSUBTABLE               801
#define BTN_OK_HELPSUBTABLE                802
#define EN_NAME_HELPSUBTABLE               803
#define EN_PHNO_HELPSUBTABLE               804
#define BTNCLR_HELPSUBTABLE                805

#define PANEL_LOADKBD                      910
#define PANEL_BTN_OK                       911
#define PANEL_EN_NAME                      912
#define PANEL_EN_PHNO                      913
#define PANEL_BTNCLR                       914

/*-------------------------------------------------------------------*/
/* String identifiers.                                               */
/*-------------------------------------------------------------------*/
#define MY_MSG                            2800

#define IDS_APPNAME                   MY_MSG+1
#define IDS_FIELD_1_SEZ               MY_MSG+2
#define IDS_FIELD_2_SEZ               MY_MSG+3
#define IDS_PEN_NOT_INSTALLED         MY_MSG+4
#define IDS_PEN_NOT_RUNNING           MY_MSG+5
#define IDS_NO_KBD_LOAD               MY_MSG+6
#define IDS_NO_HELP                   MY_MSG+7

/*-------------------------------------------------------------------*/
/* Constants.                                                        */
/*-------------------------------------------------------------------*/

#define MAXSTRINGLEN                 80
#define MAXMSGLEN                    30
#define PARMLEN                      16

/*-------------------------------------------------------------------*/
/* Public Variables                                                  */
/*-------------------------------------------------------------------*/

static  HAB     hab;                           /* anchor block handle   */
static  HWND    hwndFrame;                     /* frame window handle   */
static  HWND    hwndClient;                    /* client window handle  */
static  HWND    hwndHelp;                      /* Help window handle    */
static  HWND    hwndDlgWin;                    /* dialog window handle  */
static  HMQ     hmq;                           /* message queue handle  */
static  QMSG    qmsg;                          /* message from msg Q    */
static  CHAR    szMsgString[MAXSTRINGLEN];     /* message buffer        */
static  CHAR    szMsg1String[MAXSTRINGLEN];    /* string for messages   */
static  CHAR    szMsg2String[MAXSTRINGLEN];    /* string for messages   */
static  CHAR    szString[MAXSTRINGLEN];        /* message buffer        */
static  CHAR    szField1[MAXMSGLEN];           /* entry field buffer    */
static  CHAR    szField2[MAXMSGLEN];           /* entry field buffer    */

/*-------------------------------------------------------------------*/
/* Internal function prototypes                                      */
/*-------------------------------------------------------------------*/

static MRESULT EXPENTRY MainWndProc( HWND, USHORT, MPARAM, MPARAM );
static MRESULT EXPENTRY DemoDlgProc( HWND, USHORT, MPARAM, MPARAM );
static VOID DisplayFields( HAB, PSZ, PSZ );
static VOID DisplayMessage( HAB, ULONG );
static VOID InitHelp( VOID );
