/*****************************************************************************/
/*                                                                           */
/* File Name:    LOADKBD.C                                                   */
/*                                                                           */
/* Description:  Tests Keyboard (VES) APIs.                                  */
/*                                                                           */
/* APIs Tested:  VkpCloseKb                                                  */
/*               VkbDeleteKeyboard                                           */
/*               VkbIsKbRunning                                              */
/*               VkbLoadKeyboard                                             */
/*                                                                           */
/*                                                                           */
/*  Copyright (C) 1993 IBM Corporation                                       */
/*                                                                           */
/*      DISCLAIMER OF WARRANTIES.  The following [enclosed] code is          */
/*      sample code created by IBM Corporation. This sample code is not      */
/*      part of any standard or IBM product and is provided to you solely    */
/*      for  the purpose of assisting you in the development of your         */
/*      applications.  The code is provided "AS IS", without                 */
/*      warranty of any kind.  IBM shall not be liable for any damages       */
/*      arising out of your use of the sample code, even if they have been   */
/*      advised of the possibility of such damages.                          */
/*                                                                           */
/*****************************************************************************/
#define INCL_PM
#define INCL_WIN
#define INCL_GPI
#define INCL_DOSERRORS
#define INCL_WINERRORS
#include <os2.h>
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include "loadkbd.h"
#include "penpm.h"

int main ( VOID )
{
   ULONG   flCreate;                     /* window creation control flags */

   hab = WinInitialize ( 0 );
   hmq = WinCreateMsgQueue ( hab, 0 );

   WinRegisterClass(
      hab,                               /* Anchor block handle           */
      "LOADKBDDemo",                         /* Window class name             */
      (PFNWP)MainWndProc,                /* Address of window procedure   */
      0L,                                /* No special Class Style        */
      0                                  /* No extra window words         */
      );

   flCreate = FCF_ICON          |
              FCF_TITLEBAR      |
              FCF_MENU          |
              FCF_SYSMENU       |
              FCF_MINBUTTON     |
              FCF_MAXBUTTON     |
              FCF_SIZEBORDER    |
              FCF_SHELLPOSITION |
              FCF_TASKLIST      ;

   hwndFrame = WinCreateStdWindow(
        HWND_DESKTOP,                    /* Desktop window is parent       */
        WS_VISIBLE,                      /* Frame Window Style             */
        &flCreate,                       /* Frame creation flag            */
        "LOADKBDDemo",                   /* Client window class name       */
        "Popup Keyboard API Demonstration", /* Title bar text              */
        0L,                              /* No special class style         */
        (HMODULE)NULL,                   /* Resource is in .EXE file       */
        ID_WINDOW,                       /* Frame window identifier        */
        &hwndClient                      /* Client window handle           */
        );

   /*  Ensure Pen for OS/2 is running.  */
   if( WrtWaitActive( WRT_IMMEDIATE_RETURN ) )
   {
     DisplayMessage(hwndFrame, IDS_PEN_NOT_RUNNING);
     return( 0 );
   }

   InitHelp();

   while ( WinGetMsg ( hab, &qmsg, (HWND)0, 0, 0 ) != FALSE )
       WinDispatchMsg ( hab, &qmsg );

   WinDestroyWindow ( hwndFrame );
   WinDestroyMsgQueue ( hmq );
   WinTerminate ( hab );

   return(0);
}
/********************************************************************/
/* MainWndProc - Main window procedure.                             */
/********************************************************************/
static MRESULT EXPENTRY MainWndProc( HWND hwnd,
                                     USHORT msg,
                                     MPARAM mp1,
                                     MPARAM mp2 )
{
   HPS     hps;                          /* cached PS handle         */
   RECTL   rect;                         /* rectangle coordinates    */

   switch( msg )
   {
       case WM_CREATE:

         return( (MRESULT)0 );

       case WM_COMMAND:
         switch((USHORT)mp1)
         {
             case IDM_START_DLG:

                 hwndDlgWin = WinLoadDlg( hwndFrame,
                                           hwnd,
                                          (PFNWP) DemoDlgProc,
                                          (HMODULE) NULL,
                                          IDD_DLG_DEMO,
                                          NULL );

                 break;

             case IDM_EXIT_DLG:

                 WinPostMsg( hwnd,
                             WM_CLOSE,
                             0L, 0L );
                 break;

             case IDM_HELP:

                 WinSendMsg( hwndHelp,
                             HM_DISPLAY_HELP,
                             MPFROMSHORT(PANEL_LOADKBD),
                             MPFROMSHORT(HM_RESOURCEID) );

                 break;

             default :
                 break;
         }
         break;

       case WM_CLOSE:

         WinPostMsg( hwnd,
                     WM_QUIT,
                     0L, 0L );
         return( (MRESULT)0 );

       case WM_PAINT:

           hps = WinBeginPaint ( hwnd,
                                 (HPS)0,
                                 (PRECTL) &rect );
           WinFillRect( hps,
                        (PRECTL) &rect,
                        (LONG) CLR_PALEGRAY );
           WinEndPaint ( hps );

           break;

       default:
           break;
   }
   return ( WinDefWindowProc( hwnd, msg, mp1, mp2 ) );
}

/********************************************************************/
/* DemoDlgProc - Keyboard API Demonstration window procedure.       */
/********************************************************************/
static MRESULT EXPENTRY DemoDlgProc( HWND hwnd,
                                     USHORT msg,
                                     MPARAM mp1,
                                     MPARAM mp2 )
{
   USHORT   usCmd;                       /* command code                   */
   USHORT   usMsg;                       /* message code                   */
   APIRET   ApiRc;                       /* api return code                */
   HPS      hps;                         /* cached PS handle               */
   RECTL    rclPaint;                    /* rectangle to re-paint          */
   ULONG    ulTextLen;                   /* entry field text length        */

   switch( msg )
   {
       case WM_INITDLG:

          WinSetFocus(HWND_DESKTOP, hwnd );
          return( (MRESULT) TRUE );

       case WM_CONTROL:

         usCmd = SHORT1FROMMP (mp1);
         usMsg = SHORT2FROMMP (mp1);
         switch( usMsg )
         {
           case EN_SETFOCUS:

             switch( usCmd )
             {
               case IDD_NAME:

                   /* Load the Popup Keyboard */
                   ApiRc = VkpLoadKeyboard( NULL, hwnd );

                   if( ApiRc == WRTERR_PEN_NOT_INSTALLED )
                   {
                      DisplayMessage( hab, IDS_PEN_NOT_INSTALLED );
                   }
                   else if( ApiRc != VKP_NO_ERROR )
                   {
                      sprintf( szMsgString, "%lx", ApiRc );
                      DisplayMessage( hab, IDS_NO_KBD_LOAD );
                   }

                   break;

               case IDD_PHONE_NO:

                   /* Load a Numerical keyboard for the Phone Number. */
                   ApiRc = VkpLoadKeyboard( "NUMBERS", hwnd );

                   if( ApiRc == WRTERR_PEN_NOT_INSTALLED )
                   {
                      DisplayMessage( hab, IDS_PEN_NOT_INSTALLED );
                   }
                   else if( ApiRc != VKP_NO_ERROR )
                   {
                      sprintf( szMsgString, "%lx", ApiRc );
                      DisplayMessage( hab, IDS_NO_KBD_LOAD );
                   }

                   break;

                   default :
                      break;
             }

           break;

           default :
               return ( WinDefWindowProc( hwnd, msg, mp1, mp2 ) );
         }
         break;

       case WM_COMMAND:

         switch((USHORT)mp1)
         {
           case IDD_OK:

               /* Get the contents of both entry fields and display. */
               ulTextLen = WinQueryDlgItemTextLength( hwnd, IDD_NAME );
               WinQueryDlgItemText( hwnd,
                                    IDD_NAME,
                                    ulTextLen+1,
                                    szMsg1String );

               ulTextLen = WinQueryDlgItemTextLength( hwnd, IDD_PHONE_NO );
               WinQueryDlgItemText( hwnd,
                                    IDD_PHONE_NO,
                                    ulTextLen+1,
                                    szMsg2String );

               DisplayFields( hwndFrame,
                              szMsg1String,
                              szMsg2String );

               break;

           default :
               return ( WinDefWindowProc( hwnd, msg, mp1, mp2 ) );

         }
         break;

       case WM_PAINT:

          hps = WinBeginPaint ( hwnd,
                                (HPS)0,
                                &rclPaint );
          WinFillRect( hps,
                       &rclPaint,
                       (LONG) CLR_PALEGRAY );
          WinEndPaint ( hps );

          break;

       default:
          return ( WinDefDlgProc( hwnd, msg, mp1, mp2 ) );

   }
   return ( (MRESULT)TRUE );
}
/********************************************************************/
/* DisplayFields - display the entry fields.                        */
/********************************************************************/
static VOID DisplayFields( HAB hab, PSZ szField1, PSZ szField2 )
{
   char szMsg1[MAXMSGLEN];
   char szMsg2[MAXMSGLEN];

   WinLoadString( hab,
                  0UL,
                  IDS_FIELD_1_SEZ,
                  MAXMSGLEN,
                  szMsg1 );

   WinLoadString( hab,
                  0UL,
                  IDS_FIELD_2_SEZ,
                  MAXMSGLEN,
                  szMsg2 );

   sprintf( szString,
            "%s%s%s%s%s",
            szMsg1,
            szField1,
            "\n",
            szMsg2,
            szField2 );

   WinAlarm( HWND_DESKTOP,                  /* desktop window handle   */
             WA_NOTE );                     /* type of alarm           */

   WinMessageBox( HWND_DESKTOP,             /* parent window handle    */
                  hwndClient,               /* owner window handle     */
                  szString,                 /* pointer to message text */
                  "You entered...",         /* title                   */
                  0,                        /* message box identifier  */
                  MB_OK |                   /* message box style       */
                  MB_MOVEABLE );

   return;
}

/********************************************************************/
/* DisplayMessage - display a message in a message box.             */
/********************************************************************/
static VOID DisplayMessage( HAB hab, ULONG ulStringNum )
{
   char szTemp[MAXSTRINGLEN];

   WinLoadString( hab,
                  0UL,
                  ulStringNum,
                  MAXSTRINGLEN,
                  szTemp );

   if( *szMsgString )
   {
      sprintf( szString, szTemp, szMsgString );
      szMsgString[0]='\0';
   }
   else
   {
      sprintf( szString, "%s", szTemp );
   }

   WinAlarm( HWND_DESKTOP,                  /* desktop window handle   */
             WA_NOTE );                     /* type of alarm           */

   WinMessageBox( HWND_DESKTOP,             /* parent window handle    */
                  hwndClient,               /* owner window handle     */
                  szString,                 /* pointer to message text */
                  "Demo sez...",            /* title                   */
                  0,                        /* message box identifier  */
                  MB_OK |                   /* message box style       */
                  MB_MOVEABLE |
                  MB_ICONEXCLAMATION );

   return;
}

/*****************************************************************************/
/* InitHelp()                                                                */
/*                                                                           */
/* DESCRIPTION: Help Procedure                                               */
/*                                                                           */
/*****************************************************************************/
VOID    InitHelp(VOID)
{

  HELPINIT      HelpInit;

   HelpInit.pszHelpLibraryName       = "loadkbd.hlp";
   HelpInit.pszHelpWindowTitle       = "Load Popup Keyboard Sample Program Help";
   HelpInit.hmodHelpTableModule      = 0;
   HelpInit.hmodAccelActionBarModule = 0;
   HelpInit.phtHelpTable             = (PHELPTABLE)MAKEULONG( LOADKBD_HELPTABLE, 0xffff );

   HelpInit.cb                       = sizeof( HELPINIT );
   HelpInit.ulReturnCode             = 0L;
   HelpInit.pszTutorialName          = (PSZ)NULL;
   HelpInit.idAccelTable             = 0L;
   HelpInit.idActionBar              = ID_WINDOW;
   HelpInit.fShowPanelId             = CMIC_HIDE_PANEL_ID;

   if ( ! ( hwndHelp = WinCreateHelpInstance( hab, &HelpInit ) ) )
     {

       /***************************/
       /* Help Creation error.    */
       /***************************/
       DisplayMessage(hab, IDS_NO_HELP);

     }
   else
     {
       WinAssociateHelpInstance( hwndHelp, hwndFrame );
     }
}
