/*****************************************************************************
*                                                                            *
*  File Name   : HWXPROCS.C                                                  *
*                                                                            *
*  Description : Window Procedures for the HWX_SAMP.EXE                      *
*                                                                            *
*  Function:  This file has all the window procedures for the HWX_SAMP.EXE   *
*                                                                            *
*  Copyright (C) 1993 IBM Corporation                                        *
*                                                                            *
*      DISCLAIMER OF WARRANTIES.  The following [enclosed] code is           *
*      sample code created by IBM Corporation. This sample code is not       *
*      part of any standard or IBM product and is provided to you solely     *
*      for  the purpose of assisting you in the development of your          *
*      applications.  The code is provided "AS IS", without                  *
*      warranty of any kind.  IBM shall not be liable for any damages        *
*      arising out of your use of the sample code, even if they have been    *
*      advised of the possibility of such damages.                           *
*                                                                            *
*****************************************************************************/

/*****************************************************************************
* DEFINES                                                                    *
*****************************************************************************/
#define INCL_PM

/*****************************************************************************
* INCLUDES                                                                   *
*****************************************************************************/
#include <os2.h>
#include <penpm.h>
#include "hwx_samp.h"

/*****************************************************************************
* DEBUG MESSAGES                                                             *
*****************************************************************************/
VOID DebugMessage ( char dmessage[50] )
   {
   WinMessageBox ( HWND_DESKTOP,
                   HWND_DESKTOP,
                   dmessage,
                   "Debug Message",
                   0,
                   MB_OK            |
                   MB_ERROR         |
                   MB_SYSTEMMODAL   |
                   MB_MOVEABLE );
   }

/*****************************************************************************
* Update the status window                                                   *
*****************************************************************************/
VOID StatusLine ( HWND hWnd, CHAR *StatusText )
   {
   int   x;
   CHAR  *tempchar;
   PMYWINDOWDATA pMyWindowData;

   pMyWindowData = (PMYWINDOWDATA) WinQueryWindowULong ( hWnd, 0 );

   x = strlen ( StatusText );

   for ( x; x>=0; x-- )
      {
      tempchar = &StatusText[x];
      WinSetWindowText ( pMyWindowData->StatusWindow, tempchar );
      };
   return;
   }

/*****************************************************************************
* COMMON WINDOWPROC MESSAGE HANDLING                                         *
*                                                                            *
* All of the window procedures will call this module if they do not handle   *
* any given message. This routine will in turn call the default window       *
* procedure ( WinDefWindowProc ) if the message isn't handled here.          *
*****************************************************************************/
MRESULT EXPENTRY HWXCOMMON ( HWND hWnd,
                             ULONG ulMsg,
                             MPARAM mp1,
                             MPARAM mp2 )
   {
   RECTL          rcl;
   HPS            hps;
   HWND           hFrame;
   PMYWINDOWDATA  pMyWindowData;

   switch ( ulMsg )
      {
      case  WM_INITMYWINDOW:
               DosAllocMem ( (VOID *) &pMyWindowData,
                             sizeof(MYWINDOWDATA),
                             PAG_COMMIT   |
                                 PAG_READ |
                                 PAG_WRITE );
               WinSetWindowULong ( hWnd, 0, (ULONG) pMyWindowData );
               pMyWindowData->StatusWindow = (HWND) mp1;
               pMyWindowData->prevent = FALSE;
               return ( (MRESULT) TRUE );
               break;

      case  WM_CLOSE:
               StatusLine ( hWnd, "" );
               hFrame = WinQueryWindow ( hWnd, QW_PARENT );
               WinDestroyWindow ( hFrame );
               return ( (MRESULT) 0 );
               break;

      case  WM_SETFOCUS:
               pMyWindowData = (PMYWINDOWDATA) WinQueryWindowPtr ( hWnd, 0 );
               if ( pMyWindowData != NULL )
                  StatusLine ( hWnd, "" );
               break;

      case  WM_COMMAND:
               switch ( LONGFROMMP(mp1) )
                  {
                  case  ID_QUIT:
                        WinPostMsg ( hWnd, WM_CLOSE, 0, 0 );
                        return ( (MRESULT) TRUE );
                        break;

                  case  ID_CLEAR:
                        WinSetWindowText ( WinQueryFocus ( HWND_DESKTOP ), " " );
                        return ( (MRESULT) TRUE );
                        break;

                  default:
                        break;
                  }
               break;


      case  WM_PAINT:
               hps = WinBeginPaint  ( hWnd, NULLHANDLE, (PRECTL)NULL );
               WinQueryWindowRect   ( hWnd, &rcl );
               WinFillRect          ( hps,  &rcl, SYSCLR_MENU );
               WinEndPaint          ( hps );
               return ( (MRESULT) TRUE );
               break;

      case  WM_SIZE:
               WinQueryWindowRect ( hWnd, &rcl );
               WinSetWindowPos  ( WinWindowFromID ( hWnd, ID_HWX_CONTROL1 ),
                                  HWND_TOP,
                                  2,
                                  2,
                                  rcl.xRight-4,
                                  rcl.yTop-4,
                                  SWP_ACTIVATE |
                                    SWP_MOVE   |
                                    SWP_SIZE   |
                                    SWP_SHOW );
               return ( (MRESULT) TRUE );
               break;

      default:
            break;
      }
   return( (MRESULT) WinDefWindowProc ( hWnd, ulMsg, mp1, mp2 )  );
   }

/******************************************************************************
* HX_BORDER                                                                   *
*                                                                             *
* Create a control with a solid black border.                                 *
******************************************************************************/
MRESULT EXPENTRY HWX_HX_BORDER ( HWND   hWnd,
                                 ULONG  ulMsg,
                                 MPARAM mp1,
                                 MPARAM mp2)
   {
   HWND     hHwxControl;
   RECTL    rcl;

   switch ( ulMsg )
      {
      case  WM_CREATE:
               WinPostMsg ( hWnd,
                            WM_CREATEHWXCONTROL,
                            (MPARAM) 0,
                            (MPARAM) 0 );
               WinShowWindow ( hWnd, TRUE );
               break;

      case  WM_CREATEHWXCONTROL:
               WinQueryWindowRect ( hWnd, &rcl );
               hHwxControl =  WinCreateWindow ( hWnd,
                                                WC_HWXENTRY,
                                                "",
                                                HX_BORDER |
                                                WS_VISIBLE,
                                                2,
                                                2,
                                                rcl.xRight-4,
                                                rcl.yTop-4,
                                                hWnd,
                                                HWND_BOTTOM,
                                                ID_HWX_CONTROL1,
                                                NULL,
                                                NULL );
               if ( !hHwxControl )
                  {
                  DebugMessage ( "Control creation failed" );
                  return( (MRESULT) FALSE );
                  };
               return ( (MRESULT) TRUE );
               break;

      default:
               break;
      }
   return ( HWXCOMMON ( hWnd, ulMsg, mp1, mp2 ) );
   }

/******************************************************************************
* HX_3DBORDER                                                                 *
*                                                                             *
* Create a control with a 3D type of border.                                  *
******************************************************************************/
MRESULT EXPENTRY HWX_HX_3DBORDER ( HWND   hWnd,
                                   ULONG  ulMsg,
                                   MPARAM mp1,
                                   MPARAM mp2)
   {
   HWND     hHwxControl;
   RECTL    rcl;

   switch ( ulMsg )
      {
      case  WM_CREATE:
               WinPostMsg ( hWnd,
                            WM_CREATEHWXCONTROL,
                            (MPARAM) 0,
                            (MPARAM) 0 );
               WinShowWindow ( hWnd, TRUE );
               break;

      case  WM_CREATEHWXCONTROL:
               WinQueryWindowRect ( hWnd, &rcl );
               hHwxControl =  WinCreateWindow ( hWnd,
                                                WC_HWXENTRY,
                                                "",
                                                HX_3DBORDER |
                                                WS_VISIBLE,
                                                2,
                                                2,
                                                rcl.xRight-4,
                                                rcl.yTop-4,
                                                hWnd,
                                                HWND_BOTTOM,
                                                ID_HWX_CONTROL1,
                                                NULL,
                                                NULL );
               if ( !hHwxControl )
                  {
                  DebugMessage ( "Control creation failed" );
                  return( (MRESULT) FALSE );
                  };
               return ( (MRESULT) TRUE );
               break;

      default:
               break;
      }
   return ( HWXCOMMON ( hWnd, ulMsg, mp1, mp2 ) );
   }

/******************************************************************************
* WS_VISIBLE                                                                  *
*                                                                             *
* Create a visible control.                                                   *
******************************************************************************/
MRESULT EXPENTRY HWX_WS_VISIBLE ( HWND   hWnd,
                                  ULONG  ulMsg,
                                  MPARAM mp1,
                                  MPARAM mp2)
   {
   HWND     hHwxControl;
   RECTL    rcl;

   switch ( ulMsg )
      {
      case  WM_CREATE:
               WinPostMsg ( hWnd,
                            WM_CREATEHWXCONTROL,
                            (MPARAM) 0,
                            (MPARAM) 0 );
               WinShowWindow ( hWnd, TRUE );
               break;

      case  WM_CREATEHWXCONTROL:
               WinQueryWindowRect ( hWnd, &rcl );
               hHwxControl =  WinCreateWindow ( hWnd,
                                                WC_HWXENTRY,
                                                "",
                                                WS_VISIBLE,
                                                2,
                                                2,
                                                rcl.xRight-4,
                                                rcl.yTop-4,
                                                hWnd,
                                                HWND_BOTTOM,
                                                ID_HWX_CONTROL1,
                                                NULL,
                                                NULL );
               if ( !hHwxControl )
                  {
                  DebugMessage ( "Control creation failed" );
                  return( (MRESULT) FALSE );
                  };
               return ( (MRESULT) TRUE );
               break;

      default:
               break;
      }
   return ( HWXCOMMON ( hWnd, ulMsg, mp1, mp2 ) );
   }

/******************************************************************************
* WS_DISABLED                                                                 *
*                                                                             *
* Create a disabled control.                                                  *
******************************************************************************/
MRESULT EXPENTRY HWX_WS_DISABLED ( HWND   hWnd,
                                   ULONG  ulMsg,
                                   MPARAM mp1,
                                   MPARAM mp2)
   {
   HWND     hHwxControl;
   RECTL    rcl;

   switch ( ulMsg )
      {
      case  WM_CREATE:
               WinPostMsg ( hWnd,
                            WM_CREATEHWXCONTROL,
                            (MPARAM) 0,
                            (MPARAM) 0 );
               WinShowWindow ( hWnd, TRUE );
               break;

      case  WM_CREATEHWXCONTROL:
               WinQueryWindowRect ( hWnd, &rcl );
               hHwxControl =  WinCreateWindow ( hWnd,
                                                WC_HWXENTRY,
                                                "",
                                                WS_DISABLED |
                                                WS_VISIBLE,
                                                2,
                                                2,
                                                rcl.xRight-4,
                                                rcl.yTop-4,
                                                hWnd,
                                                HWND_BOTTOM,
                                                ID_HWX_CONTROL1,
                                                NULL,
                                                NULL );
               if ( !hHwxControl )
                  {
                  DebugMessage ( "Control creation failed" );
                  return( (MRESULT) FALSE );
                  };
               return ( (MRESULT) TRUE );
               break;

      case  WM_TAP:
               WinEnableWindow ( WinWindowFromID ( hWnd, ID_HWX_CONTROL1 ), TRUE );
               break;

      default:
               break;
      }
   return ( HWXCOMMON ( hWnd, ulMsg, mp1, mp2 ) );
   }

/******************************************************************************
* HX_3DBORDER | HX_BORDER                                                     *
*                                                                             *
* The default action when both border styles are specified is to use the      *
* HX_BORDER style.                                                            *
******************************************************************************/
MRESULT EXPENTRY HWX_HX_3DBORDER_AND_BORDER ( HWND   hWnd,
                                              ULONG  ulMsg,
                                              MPARAM mp1,
                                              MPARAM mp2)
   {
   HWND     hHwxControl;
   RECTL    rcl;

   switch ( ulMsg )
      {
      case  WM_CREATE:
               WinPostMsg ( hWnd,
                            WM_CREATEHWXCONTROL,
                            (MPARAM) 0,
                            (MPARAM) 0 );
               WinShowWindow ( hWnd, TRUE );
               break;

      case  WM_CREATEHWXCONTROL:
               WinQueryWindowRect ( hWnd, &rcl );
               hHwxControl =  WinCreateWindow ( hWnd,
                                                WC_HWXENTRY,
                                                "",
                                                HX_3DBORDER |
                                                HX_BORDER |
                                                WS_VISIBLE,
                                                2,
                                                2,
                                                rcl.xRight-4,
                                                rcl.yTop-4,
                                                hWnd,
                                                HWND_BOTTOM,
                                                ID_HWX_CONTROL1,
                                                NULL,
                                                NULL );
               if ( !hHwxControl )
                  {
                  DebugMessage ( "Control creation failed" );
                  return( (MRESULT) FALSE );
                  };
               return ( (MRESULT) TRUE );
               break;

      default:
               break;
      }
   return ( HWXCOMMON ( hWnd, ulMsg, mp1, mp2 ) );
   }

/******************************************************************************
* SIZING OF A CONTROL TO A SPECIFIC NUMBER OF ROWS AND COLUMNS. In this case  *
* we will create a control with a 3d border and 2 rows of 5 columns. The      *
* control uses the PPMSV_CHARACTER_BOX_DX and PPMSV_CHARACTER_BOX_DY system   *
* values to size the control within the window.                               *
*                                                                             *
*     rows      = 2                                                           *
*     columns   = 5                                                           *
*     charboxdx = WrtQuerySysValue ( HWND_DESKTOP, PPMSV_CHARACTER_BOX_DX )   *
*     charboxdy = WrtQuerySysValue ( HWND_DESKTOP, PPMSV_CHARACTER_BOX_DY )   *
*     baseline  = charboxdy / 3                                               *
*     controlcx = (columns * charboxdx ) + (charboxdx / 2)                    *
*     controlcy = (rows    * ( charboxdy + baseline ) ) + baseline            *
******************************************************************************/
MRESULT EXPENTRY HWX_SIZING ( HWND   hWnd,
                              ULONG  ulMsg,
                              MPARAM mp1,
                              MPARAM mp2)
   {
   HWND            hHwxControl;
   RECTL           rcl;
   SHORT    CharBoxDX;
   SHORT    CharBoxDY;
   SHORT    Rows;
   SHORT    Columns;
   SHORT    BaseLineDY;
   static ULONG    ControlDX;
   static ULONG    ControlDY;
   SHORT    BorderCX;
   SHORT    BorderCY;
   CHAR     debugvalue[50];

   switch ( ulMsg )
      {
      case  WM_CREATE:
               WinPostMsg ( hWnd,
                            WM_CREATEHWXCONTROL,
                            (MPARAM) 0,
                            (MPARAM) 0 );
               WinShowWindow ( hWnd, TRUE );
               break;

      case  WM_CREATEHWXCONTROL:

               BorderCX = WinQuerySysValue ( HWND_DESKTOP, SV_CXBORDER );
               BorderCY = WinQuerySysValue ( HWND_DESKTOP, SV_CYBORDER );

               CharBoxDX  = WrtQuerySysValue ( HWND_DESKTOP, PPMSV_CHARACTER_BOX_DX );
               CharBoxDY  = WrtQuerySysValue ( HWND_DESKTOP, PPMSV_CHARACTER_BOX_DY );
               Rows       = 2;
               Columns    = 5;
               BaseLineDY = CharBoxDY / 3;
               ControlDX  = ( ( Columns * CharBoxDX ) + ( CharBoxDX / 2 ) + ( 2 * BorderCX ) ) ;
               ControlDY  = ( ( Rows * ( CharBoxDY + BaseLineDY ) ) + BaseLineDY + ( 2 * BorderCY ) );
               WinQueryWindowRect ( hWnd, &rcl );
               hHwxControl =  WinCreateWindow ( hWnd,
                                                WC_HWXENTRY,
                                                "",
                                                HX_3DBORDER |
                                                   WS_VISIBLE,
                                                (rcl.xRight - ControlDX ) / 2,
                                                (rcl.yTop   - ControlDY ) / 2,
                                                ControlDX,
                                                ControlDY,
                                                hWnd,
                                                HWND_BOTTOM,
                                                ID_HWX_CONTROL1,
                                                NULL,
                                                NULL );
               if ( !hHwxControl )
                  {
                  sprintf ( debugvalue, "x=%d, y=%d, dx=%d, dy=%d", (rcl.xRight - ControlDX ) / 2,
                                                (rcl.yTop   - ControlDY ) / 2,
                                                ControlDX,
                                                ControlDY );

                  DebugMessage ( debugvalue );
                  return( (MRESULT) FALSE );
                  };
               return ( (MRESULT) TRUE );
               break;

      case  WM_SIZE:
               WinQueryWindowRect ( hWnd, &rcl );
               WinSetWindowPos  ( WinWindowFromID ( hWnd, ID_HWX_CONTROL1 ),
                                  HWND_TOP,
                                  (rcl.xRight - ControlDX ) / 2,
                                  (rcl.yTop   - ControlDY ) / 2,
                                  ControlDX,
                                  ControlDY,
                                  SWP_ACTIVATE |
                                    SWP_MOVE   |
                                    SWP_SIZE   |
                                    SWP_SHOW );
               return ( (MRESULT) TRUE );
               break;

      default:
               break;
      }
   return ( HWXCOMMON ( hWnd, ulMsg, mp1, mp2 ) );
   }

/******************************************************************************
* STRINGS: LOADING OF STRINGS AT CREATION TIME                                *
*                                                                             *
* This example shows how to initialize the control with text at window        *
* creation time.                                                              *
******************************************************************************/
MRESULT EXPENTRY HWX_INITIAL_TEXT ( HWND   hWnd,
                                    ULONG  ulMsg,
                                    MPARAM mp1,
                                    MPARAM mp2)
   {
   HWND     hHwxControl;
   RECTL    rcl;

   switch ( ulMsg )
      {
      case  WM_CREATE:
               WinPostMsg ( hWnd,
                            WM_CREATEHWXCONTROL,
                            (MPARAM) 0,
                            (MPARAM) 0 );
               WinShowWindow ( hWnd, TRUE );
               break;

      case  WM_CREATEHWXCONTROL:
               WinQueryWindowRect ( hWnd, &rcl );
               hHwxControl =  WinCreateWindow ( hWnd,
                                                WC_HWXENTRY,
                                                "TEST OF LOADING A STRING",
                                                HX_3DBORDER |
                                                   WS_VISIBLE,
                                                2,
                                                2,
                                                rcl.xRight-4,
                                                rcl.yTop-4,
                                                hWnd,
                                                HWND_BOTTOM,
                                                ID_HWX_CONTROL1,
                                                NULL,
                                                NULL );
               if ( !hHwxControl )
                  {
                  DebugMessage ( "Control creation failed" );
                  return( (MRESULT) FALSE );
                  };
               return ( (MRESULT) TRUE );
               break;

      default:
               break;
      }
   return ( HWXCOMMON ( hWnd, ulMsg, mp1, mp2 ) );
   }

/******************************************************************************
* NOTIFICATION MESSAGES: HXN_OVERFLOW                                         *
*                                                                             *
* This notification message is sent to the owner of the control to indicate   *
* that the contents of the control have been truncated. This only happens     *
* when the control's content is longer than 1024 characters.                  *
******************************************************************************/
MRESULT EXPENTRY HWX_HXN_OVERFLOW ( HWND   hWnd,
                                    ULONG  ulMsg,
                                    MPARAM mp1,
                                    MPARAM mp2)
   {
   HWND     hHwxControl;
   RECTL    rcl;
   int      i;
   char     teststring[1050];

   switch ( ulMsg )
      {
      case  WM_CREATE:
               WinPostMsg ( hWnd,
                            WM_CREATEHWXCONTROL,
                            (MPARAM) 0,
                            (MPARAM) 0 );
               WinShowWindow ( hWnd, TRUE );
               break;

      case  WM_CREATEHWXCONTROL:
               WinQueryWindowRect ( hWnd, &rcl );
               for ( i=0; i<1050; i++ )
                  {
                  teststring[i] = 'a';
                  };
               teststring[1050] = '\0';
               hHwxControl =  WinCreateWindow ( hWnd,
                                                WC_HWXENTRY,
                                                teststring,
                                                HX_3DBORDER |
                                                   WS_VISIBLE,
                                                2,
                                                2,
                                                rcl.xRight-4,
                                                rcl.yTop-4,
                                                hWnd,
                                                HWND_BOTTOM,
                                                ID_HWX_CONTROL1,
                                                NULL,
                                                NULL );
               if ( !hHwxControl )
                  {
                  DebugMessage ( "Control creation failed" );
                  return( (MRESULT) FALSE );
                  };
               return ( (MRESULT) TRUE );
               break;

      case  WM_CONTROL:
               switch ( SHORT2FROMMP(mp1) )
                  {
                  case  HXN_OVERFLOW:
                        StatusLine ( hWnd, "Handwriting Control Overflow" );
                        break;

                  default:
                        break;
                  };
               break;

      default:
               break;
      }
   return ( HWXCOMMON ( hWnd, ulMsg, mp1, mp2 ) );
   }

/******************************************************************************
* NOTIFICATION MESSAGES: HXN_SETFOCUS                                         *
*                                                                             *
* When the control gets focus, this notification message is sent to the       *
* owner of the control.                                                       *
******************************************************************************/
MRESULT EXPENTRY HWX_HXN_SETFOCUS ( HWND   hWnd,
                                    ULONG  ulMsg,
                                    MPARAM mp1,
                                    MPARAM mp2)
   {
   HWND     hHwxControl;
   RECTL    rcl;

   switch ( ulMsg )
      {
      case  WM_CREATE:
               WinPostMsg ( hWnd,
                            WM_CREATEHWXCONTROL,
                            (MPARAM) 0,
                            (MPARAM) 0 );
               WinShowWindow ( hWnd, TRUE );
               break;

      case  WM_CREATEHWXCONTROL:
               WinQueryWindowRect ( hWnd, &rcl );
               hHwxControl =  WinCreateWindow ( hWnd,
                                                WC_HWXENTRY,
                                                "",
                                                HX_3DBORDER |
                                                   WS_VISIBLE,
                                                2,
                                                2,
                                                rcl.xRight-4,
                                                rcl.yTop-4,
                                                hWnd,
                                                HWND_BOTTOM,
                                                ID_HWX_CONTROL1,
                                                NULL,
                                                NULL );
               if ( !hHwxControl )
                  {
                  DebugMessage ( "Control creation failed" );
                  return( (MRESULT) FALSE );
                  };
               return ( (MRESULT) TRUE );
               break;

      case  WM_CONTROL:
               switch ( SHORT2FROMMP(mp1) )
                  {
                  case  HXN_SETFOCUS:
                        StatusLine ( hWnd, "Setting Focus" );
                        WinSetWindowText ( WinWindowFromID ( hWnd, ID_HWX_CONTROL1 ),
                                           "Hello" );
                        return ( (MRESULT) 0 );
                        break;

                  default:
                        break;
                  };
               break;

      default:
               break;
      }
   return ( HWXCOMMON ( hWnd, ulMsg, mp1, mp2 ) );
   }

/******************************************************************************
* NOTIFICATION MESSAGES: HXN_KILLFOCUS                                        *
*                                                                             *
* This message is sent to the owner of the control whenever the control gives *
* up focus.                                                                   *
******************************************************************************/
MRESULT EXPENTRY HWX_HXN_KILLFOCUS ( HWND   hWnd,
                                     ULONG  ulMsg,
                                     MPARAM mp1,
                                     MPARAM mp2)
   {
   HWND     hHwxControl;
   RECTL    rcl;

   switch ( ulMsg )
      {
      case  WM_CREATE:
               WinPostMsg ( hWnd,
                            WM_CREATEHWXCONTROL,
                            (MPARAM) 0,
                            (MPARAM) 0 );
               WinShowWindow ( hWnd, TRUE );
               break;

      case  WM_CREATEHWXCONTROL:
               WinQueryWindowRect ( hWnd, &rcl );
               hHwxControl =  WinCreateWindow ( hWnd,
                                                WC_HWXENTRY,
                                                "",
                                                HX_3DBORDER |
                                                   WS_VISIBLE,
                                                2,
                                                2,
                                                rcl.xRight-4,
                                                rcl.yTop-4,
                                                hWnd,
                                                HWND_BOTTOM,
                                                ID_HWX_CONTROL1,
                                                NULL,
                                                NULL );
               if ( !hHwxControl )
                  {
                  DebugMessage ( "Control creation failed" );
                  return( (MRESULT) FALSE );
                  };
               return ( (MRESULT) TRUE );
               break;

      case  WM_CONTROL:
               switch ( SHORT2FROMMP(mp1) )
                  {
                  case  HXN_KILLFOCUS:
                        StatusLine ( hWnd, "Losing Focus" );
                        WinSetWindowText ( WinWindowFromID ( hWnd, ID_HWX_CONTROL1 ),
                                           "Good Bye" );
                        return ( (MRESULT) 0 );
                        break;

                  default:
                        break;
                  };
               break;

      default:
               break;
      }
   return ( HWXCOMMON ( hWnd, ulMsg, mp1, mp2 ) );
   }

/******************************************************************************
* NOTIFICATION MESSAGES: HXN_CONTENTS_CHANGED                                 *
*                                                                             *
* This notification message is sent to the owner of the control whenever the  *
* contents of the control has changed.                                        *
******************************************************************************/
MRESULT EXPENTRY HWX_HXN_CONTENTS_CHANGED ( HWND   hWnd,
                                            ULONG  ulMsg,
                                            MPARAM mp1,
                                            MPARAM mp2)
   {
   HWND     hHwxControl;
   RECTL    rcl;

   switch ( ulMsg )
      {
      case  WM_CREATE:
               WinPostMsg ( hWnd,
                            WM_CREATEHWXCONTROL,
                            (MPARAM) 0,
                            (MPARAM) 0 );
               WinShowWindow ( hWnd, TRUE );
               break;

      case  WM_CREATEHWXCONTROL:
               WinQueryWindowRect ( hWnd, &rcl );
               hHwxControl =  WinCreateWindow ( hWnd,
                                                WC_HWXENTRY,
                                                "",
                                                HX_3DBORDER |
                                                   WS_VISIBLE,
                                                2,
                                                2,
                                                rcl.xRight-4,
                                                rcl.yTop-4,
                                                hWnd,
                                                HWND_BOTTOM,
                                                ID_HWX_CONTROL1,
                                                NULL,
                                                NULL );
               if ( !hHwxControl )
                  {
                  DebugMessage ( "Control creation failed" );
                  return( (MRESULT) FALSE );
                  };
               return ( (MRESULT) TRUE );
               break;

      case  WM_CONTROL:
               switch ( SHORT2FROMMP(mp1) )
                  {
                  case  HXN_CONTENTS_CHANGED:
                        StatusLine ( hWnd, "Handwriting Control Contents Changed" );
                        break;

                  default:
                        break;
                  };
               break;

      default:
               break;
      }
   return ( HWXCOMMON ( hWnd, ulMsg, mp1, mp2 ) );
   }

/******************************************************************************
* NOTIFICATION MESSAGES: HXN_STROKE_ADD                                       *
*                                                                             *
* This notificatioom message is sent to inform the owner of the control that  *
* the user has begun to ink into the control and thus the contents of the     *
* control may be about to change.                                             *
******************************************************************************/
MRESULT EXPENTRY HWX_HXN_STROKE_ADD ( HWND   hWnd,
                                      ULONG  ulMsg,
                                      MPARAM mp1,
                                      MPARAM mp2)
   {
   HWND           hHwxControl;
   RECTL          rcl;
   HWND           hMenu;
   MENUITEM       menuitem;
   PMYWINDOWDATA  pMyWindowData ;

   switch ( ulMsg )
      {
      case  WM_CREATE:
               WinPostMsg ( hWnd,
                            WM_CREATEHWXCONTROL,
                            (MPARAM) 0,
                            (MPARAM) 0 );
               WinShowWindow ( hWnd, TRUE );
               break;

      case  WM_CREATEHWXCONTROL:
               hMenu = WinWindowFromID ( WinQueryWindow ( hWnd, QW_PARENT ),
                                         FID_MENU );
               menuitem.iPosition   = MIT_END;
               menuitem.afStyle     = MIS_TEXT;
               menuitem.afAttribute = 0;
               menuitem.id          = ID_MENUITEM;
               menuitem.hItem       = 0;
               menuitem.hwndSubMenu = 0;

               WinSendMsg ( hMenu,
                            MM_INSERTITEM,
                            (MPARAM) &menuitem,
                            (MPARAM) "PreventStrokes" );
               WinQueryWindowRect ( hWnd, &rcl );
               hHwxControl =  WinCreateWindow ( hWnd,
                                                WC_HWXENTRY,
                                                "",
                                                HX_3DBORDER |
                                                   WS_VISIBLE,
                                                2,
                                                2,
                                                rcl.xRight-4,
                                                rcl.yTop-4,
                                                hWnd,
                                                HWND_BOTTOM,
                                                ID_HWX_CONTROL1,
                                                NULL,
                                                NULL );
               if ( !hHwxControl )
                  {
                  DebugMessage ( "Control creation failed" );
                  return( (MRESULT) FALSE );
                  };
               return ( (MRESULT) TRUE );
               break;

      case  WM_CONTROL:
               switch ( SHORT2FROMMP(mp1) )
                  {
                  case  HXN_STROKE_ADDED:
                        pMyWindowData = (PMYWINDOWDATA) WinQueryWindowPtr ( hWnd, 0 );
                        if ( pMyWindowData->prevent )
                           StatusLine ( hWnd, "Preventing strokes from being added" );
                        else
                           StatusLine ( hWnd, "Permiting strokes to be added" );
                        return ( (MRESULT) pMyWindowData->prevent );
                        break;

                  default:
                        break;
                  };
               break;

      /***********************************************************************
      * Messages from the menu                                               *
      ***********************************************************************/
      case  WM_COMMAND:
               pMyWindowData = (PMYWINDOWDATA) WinQueryWindowPtr ( hWnd, 0 );
               if ( SHORT1FROMMP (mp1) == ID_MENUITEM )
                  {
                  hMenu = WinWindowFromID ( WinQueryWindow ( hWnd, QW_PARENT ),
                                            FID_MENU );
                  if ( pMyWindowData->prevent )
                     {
                     pMyWindowData->prevent = FALSE;
                     WinSendMsg ( hMenu,
                                  MM_SETITEMTEXT,
                                  (MPARAM) ID_MENUITEM,
                                  (MPARAM) "PreventStrokes" );
                     }
                  else
                     {
                     pMyWindowData->prevent = TRUE;
                     WinSendMsg ( hMenu,
                                  MM_SETITEMTEXT,
                                  (MPARAM) ID_MENUITEM,
                                  (MPARAM) "PermitStrokes" );
                     };

                  };
               break;

      default:
               break;
      }
   return ( HWXCOMMON ( hWnd, ulMsg, mp1, mp2 ) );
   }

/******************************************************************************
* NOTIFICATION MESSAGES: HXN_GESTURE_PENDING                                  *
*                                                                             *
* This notification message is sent to the owner of the control when the user *
* has stroked a gesture in the control. The result of the gesture             *
* recognition could cause the contents of the control to change.              *
******************************************************************************/
MRESULT EXPENTRY HWX_HXN_GESTURE_PENDING ( HWND   hWnd,
                                           ULONG  ulMsg,
                                           MPARAM mp1,
                                           MPARAM mp2)
   {
   HWND     hHwxControl;
   RECTL    rcl;
   HWND     hMenu;
   MENUITEM menuitem;
   PMYWINDOWDATA  pMyWindowData ;

   switch ( ulMsg )
      {
      case  WM_CREATE:
               WinPostMsg ( hWnd,
                            WM_CREATEHWXCONTROL,
                            (MPARAM) 0,
                            (MPARAM) 0 );
               WinShowWindow ( hWnd, TRUE );
               break;

      case  WM_CREATEHWXCONTROL:
               hMenu = WinWindowFromID ( WinQueryWindow ( hWnd, QW_PARENT ),
                                         FID_MENU );
               menuitem.iPosition   = MIT_END;
               menuitem.afStyle     = MIS_TEXT;
               menuitem.afAttribute = 0;
               menuitem.id          = ID_MENUITEM;
               menuitem.hItem       = 0;
               menuitem.hwndSubMenu = 0;

               WinSendMsg ( hMenu,
                            MM_INSERTITEM,
                            (MPARAM) &menuitem,
                            (MPARAM) "PreventGestures" );
               WinQueryWindowRect ( hWnd, &rcl );
               hHwxControl =  WinCreateWindow ( hWnd,
                                                WC_HWXENTRY,
                                                "",
                                                HX_3DBORDER |
                                                   WS_VISIBLE,
                                                2,
                                                2,
                                                rcl.xRight-4,
                                                rcl.yTop-4,
                                                hWnd,
                                                HWND_BOTTOM,
                                                ID_HWX_CONTROL1,
                                                NULL,
                                                NULL );
               if ( !hHwxControl )
                  {
                  DebugMessage ( "Control creation failed" );
                  return( (MRESULT) FALSE );
                  };
               return ( (MRESULT) TRUE );
               break;

      case  WM_CONTROL:
               switch ( SHORT2FROMMP(mp1) )
                  {
                  case  HXN_GESTURE_PENDING:
                        pMyWindowData = (PMYWINDOWDATA) WinQueryWindowPtr ( hWnd, 0 );
                        if ( pMyWindowData->prevent )
                           StatusLine ( hWnd, "Preventing gesture processing" );
                        else
                           StatusLine ( hWnd, "Permiting gestures processing" );
                        return ( (MRESULT) pMyWindowData->prevent );
                        break;

                  default:
                        break;
                  };
               break;

      /***********************************************************************
      * Messages from the menu                                               *
      ***********************************************************************/
      case  WM_COMMAND:
               if ( SHORT1FROMMP (mp1) == ID_MENUITEM )
                  {
                  pMyWindowData = (PMYWINDOWDATA) WinQueryWindowPtr ( hWnd, 0 );
                  hMenu = WinWindowFromID ( WinQueryWindow ( hWnd, QW_PARENT ),
                                            FID_MENU );
                  if ( pMyWindowData->prevent )
                     {
                     pMyWindowData->prevent = FALSE;
                     WinSendMsg ( hMenu,
                                  MM_SETITEMTEXT,
                                  (MPARAM) ID_MENUITEM,
                                  (MPARAM) "PreventGestures" );
                     }
                  else
                     {
                     pMyWindowData->prevent = TRUE;
                     WinSendMsg ( hMenu,
                                  MM_SETITEMTEXT,
                                  (MPARAM) ID_MENUITEM,
                                  (MPARAM) "PermitGestures" );
                     };

                  };
               break;

      default:
               break;
      }
   return ( HWXCOMMON ( hWnd, ulMsg, mp1, mp2 ) );
   }

/******************************************************************************
* NOTIFICATION MESSAGES: HXN_DELETE_PENDING                                   *
*                                                                             *
* This notification message is sent to the owner of the control when the user *
* has issued a deletion operation in the control. The result of the which     *
* will cause the contents of the control to change.                           *
******************************************************************************/
MRESULT EXPENTRY HWX_HXN_DELETE_PENDING  ( HWND   hWnd,
                                           ULONG  ulMsg,
                                           MPARAM mp1,
                                           MPARAM mp2)
   {
   HWND     hHwxControl;
   RECTL    rcl;
   HWND     hMenu;
   MENUITEM menuitem;
   PMYWINDOWDATA  pMyWindowData ;

   switch ( ulMsg )
      {
      case  WM_CREATE:
               WinPostMsg ( hWnd,
                            WM_CREATEHWXCONTROL,
                            (MPARAM) 0,
                            (MPARAM) 0 );
               WinShowWindow ( hWnd, TRUE );
               break;

      case  WM_CREATEHWXCONTROL:
               hMenu = WinWindowFromID ( WinQueryWindow ( hWnd, QW_PARENT ),
                                         FID_MENU );
               menuitem.iPosition   = MIT_END;
               menuitem.afStyle     = MIS_TEXT;
               menuitem.afAttribute = 0;
               menuitem.id          = ID_MENUITEM;
               menuitem.hItem       = 0;
               menuitem.hwndSubMenu = 0;

               WinSendMsg ( hMenu,
                            MM_INSERTITEM,
                            (MPARAM) &menuitem,
                            (MPARAM) "PreventDelete" );
               WinQueryWindowRect ( hWnd, &rcl );
               hHwxControl =  WinCreateWindow ( hWnd,
                                                WC_HWXENTRY,
                                                "",
                                                HX_3DBORDER |
                                                   WS_VISIBLE,
                                                2,
                                                2,
                                                rcl.xRight-4,
                                                rcl.yTop-4,
                                                hWnd,
                                                HWND_BOTTOM,
                                                ID_HWX_CONTROL1,
                                                NULL,
                                                NULL );
               if ( !hHwxControl )
                  {
                  DebugMessage ( "Control creation failed" );
                  return( (MRESULT) FALSE );
                  };
               return ( (MRESULT) TRUE );
               break;

      case  WM_CONTROL:
               switch ( SHORT2FROMMP(mp1) )
                  {
                  case  HXN_DELETE_PENDING:
                        pMyWindowData = (PMYWINDOWDATA) WinQueryWindowPtr ( hWnd, 0 );
                        if ( pMyWindowData->prevent )
                           StatusLine ( hWnd, "Preventing delete processing" );
                        else
                           StatusLine ( hWnd, "Permiting delete processing" );
                        return ( (MRESULT) pMyWindowData->prevent );
                        break;

                  default:
                        break;
                  };
               break;

      /***********************************************************************
      * Messages from the menu                                               *
      ***********************************************************************/
      case  WM_COMMAND:
               if ( SHORT1FROMMP (mp1) == ID_MENUITEM )
                  {
                  pMyWindowData = (PMYWINDOWDATA) WinQueryWindowPtr ( hWnd, 0 );
                  hMenu = WinWindowFromID ( WinQueryWindow ( hWnd, QW_PARENT ),
                                            FID_MENU );
                  if ( pMyWindowData->prevent )
                     {
                     pMyWindowData->prevent = FALSE;
                     WinSendMsg ( hMenu,
                                  MM_SETITEMTEXT,
                                  (MPARAM) ID_MENUITEM,
                                  (MPARAM) "PreventDelete" );
                     }
                  else
                     {
                     pMyWindowData->prevent = TRUE;
                     WinSendMsg ( hMenu,
                                  MM_SETITEMTEXT,
                                  (MPARAM) ID_MENUITEM,
                                  (MPARAM) "PermitDelete" );
                     };

                  };
               break;

      default:
               break;
      }
   return ( HWXCOMMON ( hWnd, ulMsg, mp1, mp2 ) );
   }

/******************************************************************************
* NOTIFICATION MESSAGES: HXN_INSERT_PENDING                                   *
*                                                                             *
* This notification message is sent to the owner of the control when the user *
* has issued a insertion operation in the control. The result of the which    *
* will cause the contents of the control to change.                           *
******************************************************************************/
MRESULT EXPENTRY HWX_HXN_INSERT_PENDING  ( HWND   hWnd,
                                           ULONG  ulMsg,
                                           MPARAM mp1,
                                           MPARAM mp2)
   {
   HWND     hHwxControl;
   RECTL    rcl;
   HWND     hMenu;
   MENUITEM menuitem;
   PMYWINDOWDATA  pMyWindowData ;

   switch ( ulMsg )
      {
      case  WM_CREATE:
               WinPostMsg ( hWnd,
                            WM_CREATEHWXCONTROL,
                            (MPARAM) 0,
                            (MPARAM) 0 );
               WinShowWindow ( hWnd, TRUE );
               break;

      case  WM_CREATEHWXCONTROL:
               hMenu = WinWindowFromID ( WinQueryWindow ( hWnd, QW_PARENT ),
                                         FID_MENU );
               menuitem.iPosition   = MIT_END;
               menuitem.afStyle     = MIS_TEXT;
               menuitem.afAttribute = 0;
               menuitem.id          = ID_MENUITEM;
               menuitem.hItem       = 0;
               menuitem.hwndSubMenu = 0;

               WinSendMsg ( hMenu,
                            MM_INSERTITEM,
                            (MPARAM) &menuitem,
                            (MPARAM) "PreventInsert" );
               WinQueryWindowRect ( hWnd, &rcl );
               hHwxControl =  WinCreateWindow ( hWnd,
                                                WC_HWXENTRY,
                                                "",
                                                HX_3DBORDER |
                                                   WS_VISIBLE,
                                                2,
                                                2,
                                                rcl.xRight-4,
                                                rcl.yTop-4,
                                                hWnd,
                                                HWND_BOTTOM,
                                                ID_HWX_CONTROL1,
                                                NULL,
                                                NULL );
               if ( !hHwxControl )
                  {
                  DebugMessage ( "Control creation failed" );
                  return( (MRESULT) FALSE );
                  };
               return ( (MRESULT) TRUE );
               break;

      case  WM_CONTROL:
               switch ( SHORT2FROMMP(mp1) )
                  {
                  case  HXN_INSERT_PENDING:
                        pMyWindowData = (PMYWINDOWDATA) WinQueryWindowPtr ( hWnd, 0 );
                        if ( pMyWindowData->prevent )
                           StatusLine ( hWnd, "Preventing insert processing" );
                        else
                           StatusLine ( hWnd, "Permiting insert processing" );
                        return ( (MRESULT) pMyWindowData->prevent );
                        break;

                  default:
                        break;
                  };
               break;

      /***********************************************************************
      * Messages from the menu                                               *
      ***********************************************************************/
      case  WM_COMMAND:
               if ( SHORT1FROMMP (mp1) == ID_MENUITEM )
                  {
                  pMyWindowData = (PMYWINDOWDATA) WinQueryWindowPtr ( hWnd, 0 );
                  hMenu = WinWindowFromID ( WinQueryWindow ( hWnd, QW_PARENT ),
                                            FID_MENU );
                  if ( pMyWindowData->prevent )
                     {
                     pMyWindowData->prevent = FALSE;
                     WinSendMsg ( hMenu,
                                  MM_SETITEMTEXT,
                                  (MPARAM) ID_MENUITEM,
                                  (MPARAM) "PreventInsert" );
                     }
                  else
                     {
                     pMyWindowData->prevent = TRUE;
                     WinSendMsg ( hMenu,
                                  MM_SETITEMTEXT,
                                  (MPARAM) ID_MENUITEM,
                                  (MPARAM) "PermitInsert" );
                     };

                  };
               break;

      default:
               break;
      }
   return ( HWXCOMMON ( hWnd, ulMsg, mp1, mp2 ) );
   }

/******************************************************************************
* NOTIFICATION MESSAGES: WM_HELP                                              *
*                                                                             *
* This is a standard PM message, however it is also generated as a result of  *
* the user entering a ? gesture into the control.                             *
******************************************************************************/
MRESULT EXPENTRY HWX_WM_HELP ( HWND   hWnd,
                               ULONG  ulMsg,
                               MPARAM mp1,
                               MPARAM mp2)
   {
   HWND     hHwxControl;
   RECTL    rcl;

   switch ( ulMsg )
      {
      case  WM_CREATE:
               WinPostMsg ( hWnd,
                            WM_CREATEHWXCONTROL,
                            (MPARAM) 0,
                            (MPARAM) 0 );
               WinShowWindow ( hWnd, TRUE );
               break;

      case  WM_CREATEHWXCONTROL:
               WinQueryWindowRect ( hWnd, &rcl );
               hHwxControl =  WinCreateWindow ( hWnd,
                                                WC_HWXENTRY,
                                                "",
                                                HX_3DBORDER |
                                                   WS_VISIBLE,
                                                2,
                                                2,
                                                rcl.xRight-4,
                                                rcl.yTop-4,
                                                hWnd,
                                                HWND_BOTTOM,
                                                ID_HWX_CONTROL1,
                                                NULL,
                                                NULL );
               if ( !hHwxControl )
                  {
                  DebugMessage ( "Control creation failed" );
                  return( (MRESULT) FALSE );
                  };
               return ( (MRESULT) TRUE );
               break;

      case  WM_HELP:
               StatusLine ( hWnd, "Handwriting Control Help" );
               break;

      default:
               break;
      }

   return ( HWXCOMMON ( hWnd, ulMsg, mp1, mp2 ) );
   }

/******************************************************************************
* RELATED API'S: WinSetWindowText                                             *
*                                                                             *
* This is a standard PM API. It populates the control with the specified text *
******************************************************************************/
MRESULT EXPENTRY HWX_WINSETWINDOWTEXT ( HWND   hWnd,
                                        ULONG  ulMsg,
                                        MPARAM mp1,
                                        MPARAM mp2)
   {
   HWND     hHwxControl;
   HWND     hMenu;
   MENUITEM menuitem;
   RECTL    rcl;

   switch ( ulMsg )
      {
      case  WM_CREATE:
               WinPostMsg ( hWnd,
                            WM_CREATEHWXCONTROL,
                            (MPARAM) 0,
                            (MPARAM) 0 );
               WinShowWindow ( hWnd, TRUE );
               break;

      case  WM_CREATEHWXCONTROL:
               hMenu = WinWindowFromID ( WinQueryWindow ( hWnd, QW_PARENT ),
                                         FID_MENU );
               menuitem.iPosition   = MIT_END;
               menuitem.afStyle     = MIS_TEXT;
               menuitem.afAttribute = 0;
               menuitem.id          = ID_MENUITEM;
               menuitem.hItem       = 0;
               menuitem.hwndSubMenu = 0;

               WinSendMsg ( hMenu,
                            MM_INSERTITEM,
                            (MPARAM) &menuitem,
                            (MPARAM) "SetText" );
               WinShowWindow ( hWnd, TRUE );
               WinQueryWindowRect ( hWnd, &rcl );
               hHwxControl =  WinCreateWindow ( hWnd,
                                                WC_HWXENTRY,
                                                "",
                                                HX_3DBORDER |
                                                   WS_VISIBLE,
                                                2,
                                                2,
                                                rcl.xRight-4,
                                                rcl.yTop-4,
                                                hWnd,
                                                HWND_BOTTOM,
                                                ID_HWX_CONTROL1,
                                                NULL,
                                                NULL );
               if ( !hHwxControl )
                  {
                  DebugMessage ( "Control creation failed" );
                  return( (MRESULT) FALSE );
                  };
               return ( (MRESULT) TRUE );
               break;

      /***********************************************************************
      * Messages from the menu                                               *
      ***********************************************************************/
      case  WM_COMMAND:
               if ( SHORT1FROMMP (mp1) == ID_MENUITEM )
                  {
                  WinSetWindowText ( WinWindowFromID ( hWnd, ID_HWX_CONTROL1 ),
                                     "TESTING" );
                  };
               break;

      default:
               break;
      }
   return ( HWXCOMMON ( hWnd, ulMsg, mp1, mp2 ) );
   }

/******************************************************************************
* RELATED API'S: WinQueryWindowText                                           *
*                                                                             *
* This is a standard PM API. It supplies the text contents of the control.    *
******************************************************************************/
MRESULT EXPENTRY HWX_WINQUERYWINDOWTEXT ( HWND   hWnd,
                                          ULONG  ulMsg,
                                          MPARAM mp1,
                                          MPARAM mp2)
   {
   HWND     hHwxControl;
   HWND     hMenu;
   MENUITEM menuitem;
   RECTL    rcl;
   CHAR     szText[1025];

   switch ( ulMsg )
      {
      case  WM_CREATE:
               WinPostMsg ( hWnd,
                            WM_CREATEHWXCONTROL,
                            (MPARAM) 0,
                            (MPARAM) 0 );
               WinShowWindow ( hWnd, TRUE );
               break;

      case  WM_CREATEHWXCONTROL:
               hMenu = WinWindowFromID ( WinQueryWindow ( hWnd, QW_PARENT ),
                                         FID_MENU );
               menuitem.iPosition   = MIT_END;
               menuitem.afStyle     = MIS_TEXT;
               menuitem.afAttribute = 0;
               menuitem.id          = ID_MENUITEM;
               menuitem.hItem       = 0;
               menuitem.hwndSubMenu = 0;

               WinSendMsg ( hMenu,
                            MM_INSERTITEM,
                            (MPARAM) &menuitem,
                            (MPARAM) "QueryText" );

               WinQueryWindowRect ( hWnd, &rcl );
               hHwxControl =  WinCreateWindow ( hWnd,
                                                WC_HWXENTRY,
                                                "",
                                                HX_3DBORDER |
                                                   WS_VISIBLE,
                                                2,
                                                2,
                                                rcl.xRight-4,
                                                rcl.yTop-4,
                                                hWnd,
                                                HWND_BOTTOM,
                                                ID_HWX_CONTROL1,
                                                NULL,
                                                NULL );
               if ( !hHwxControl )
                  {
                  DebugMessage ( "Control creation failed" );
                  return( (MRESULT) FALSE );
                  };
               return ( (MRESULT) TRUE );
               break;

      /***********************************************************************
      * Messages from the menu                                               *
      ***********************************************************************/
      case  WM_COMMAND:
               if ( SHORT1FROMMP (mp1) == ID_MENUITEM )
                  {
                  WinQueryWindowText ( WinWindowFromID ( hWnd, ID_HWX_CONTROL1 ),
                                       sizeof(szText),
                                       szText );
                  StatusLine ( hWnd, szText );
                  };
               break;

      default:
               break;
      }
   return ( HWXCOMMON ( hWnd, ulMsg, mp1, mp2 ) );
   }

/******************************************************************************
* RELATED API'S: WinEnableWindow                                              *
*                                                                             *
* This is a standard PM API. It will enable and disable the control.          *
******************************************************************************/
MRESULT EXPENTRY HWX_WINENABLEWINDOW ( HWND   hWnd,
                                       ULONG  ulMsg,
                                       MPARAM mp1,
                                       MPARAM mp2)
   {
   HWND        hHwxControl;
   HWND        hMenu;
   MENUITEM    menuitem;
   RECTL       rcl;
   static BOOL state = TRUE;

   switch ( ulMsg )
      {
      case  WM_CREATE:
               WinPostMsg ( hWnd,
                            WM_CREATEHWXCONTROL,
                            (MPARAM) 0,
                            (MPARAM) 0 );
               WinShowWindow ( hWnd, TRUE );
               break;

      case  WM_CREATEHWXCONTROL:
               hMenu = WinWindowFromID ( WinQueryWindow ( hWnd, QW_PARENT ),
                                         FID_MENU );
               menuitem.iPosition   = MIT_END;
               menuitem.afStyle     = MIS_TEXT;
               menuitem.afAttribute = 0;
               menuitem.id          = ID_MENUITEM;
               menuitem.hItem       = 0;
               menuitem.hwndSubMenu = 0;

               WinSendMsg ( hMenu,
                            MM_INSERTITEM,
                            (MPARAM) &menuitem,
                            (MPARAM) "Disable" );

               WinQueryWindowRect ( hWnd, &rcl );
               hHwxControl =  WinCreateWindow ( hWnd,
                                                WC_HWXENTRY,
                                                "",
                                                HX_3DBORDER |
                                                   WS_VISIBLE,
                                                2,
                                                2,
                                                rcl.xRight-4,
                                                rcl.yTop-4,
                                                hWnd,
                                                HWND_BOTTOM,
                                                ID_HWX_CONTROL1,
                                                NULL,
                                                NULL );
               if ( !hHwxControl )
                  {
                  DebugMessage ( "Control creation failed" );
                  return( (MRESULT) FALSE );
                  };
               return ( (MRESULT) TRUE );
               break;

      /***********************************************************************
      * Messages from the menu                                               *
      ***********************************************************************/
      case  WM_COMMAND:
               if ( SHORT1FROMMP (mp1) == ID_MENUITEM )
                  {
                  hMenu = WinWindowFromID ( WinQueryWindow ( hWnd, QW_PARENT ),
                                            FID_MENU );
                  if ( state )
                     {
                     state = FALSE;
                     WinEnableWindow ( WinWindowFromID ( hWnd, ID_HWX_CONTROL1 ), FALSE );
                     WinSendMsg ( hMenu,
                                  MM_SETITEMTEXT,
                                  (MPARAM) ID_MENUITEM,
                                  (MPARAM) "Enable" );
                     StatusLine ( hWnd, "Control is disabled" );
                     }
                  else
                     {
                     state = TRUE;
                     WinEnableWindow ( WinWindowFromID ( hWnd, ID_HWX_CONTROL1 ), TRUE );
                     WinSendMsg ( hMenu,
                                  MM_SETITEMTEXT,
                                  (MPARAM) ID_MENUITEM,
                                  (MPARAM) "Disable" );
                     StatusLine ( hWnd, "Control is enabled" );
                     };

                  };
               break;

      default:
               break;
      }
   return ( HWXCOMMON ( hWnd, ulMsg, mp1, mp2 ) );
   }

/******************************************************************************
* MISC: MULTIPLE HANDWRITING CONTROLS                                         *
*                                                                             *
* This is a simple example to show that multiple handwriting controls can be  *
* used within the same parent window.                                         *
******************************************************************************/
MRESULT EXPENTRY HWX_MULTIPLE_CONTROLS (  HWND   hWnd,
                                          ULONG  ulMsg,
                                          MPARAM mp1,
                                          MPARAM mp2)
   {
   HWND     hHwxControl[4];
   RECTL    rcl;
   ULONG    x[4];
   ULONG    y[4];
   ULONG    cx;
   ULONG    cy;
   ULONG    i;
   ULONG    id[4];

   id[0]   = ID_HWX_CONTROL1;
   id[1]   = ID_HWX_CONTROL2;
   id[2]   = ID_HWX_CONTROL3;
   id[3]   = ID_HWX_CONTROL4;
   switch ( ulMsg )
      {
      case  WM_CREATE:
               WinPostMsg ( hWnd,
                            WM_CREATEHWXCONTROL,
                            (MPARAM) 0,
                            (MPARAM) 0 );
               WinShowWindow ( hWnd, TRUE );
               break;

      case  WM_CREATEHWXCONTROL:
               WinQueryWindowRect ( hWnd, &rcl );
               cx      = rcl.xRight/2 - 2;
               cy      = rcl.yTop/2 - 2;
               x[0]    = 2;
               y[0]    = 2;
               x[1]    = x[0] + cx + 2;
               y[1]    = y[0];
               x[2]    = x[0];
               y[2]    = y[0] + cy + 2;
               x[3]    = x[1];
               y[3]    = y[2];
               for ( i = 0; i<4; i++ )
                  {
                  hHwxControl[i] =  WinCreateWindow ( hWnd,
                                                      WC_HWXENTRY,
                                                      "",
                                                      HX_BORDER,
                                                      x[i],
                                                      y[i],
                                                      cx,
                                                      cy,
                                                      hWnd,
                                                      HWND_BOTTOM,
                                                      id[i],
                                                      NULL,
                                                      NULL );
                  if ( !hHwxControl[i] )
                     {
                     DebugMessage ( "Control creation failed" );
                     return( (MRESULT) FALSE );
                     };
                  };
               for ( i=0; i<4; i++ )
                  {
                  WinShowWindow ( WinWindowFromID ( hWnd, id[i] ), TRUE );
                  };
               return ( (MRESULT) TRUE );
               break;

      case  WM_SIZE:
               WinQueryWindowRect ( hWnd, &rcl );
               cx      = rcl.xRight/2 - 2;
               cy      = rcl.yTop/2 - 2;
               x[0]    = 2;
               y[0]    = 2;
               x[1]    = x[0] + cx + 2;
               y[1]    = y[0];
               x[2]    = x[0];
               y[2]    = y[0] + cy + 2;
               x[3]    = x[1];
               y[3]    = y[2];
               for ( i = 0; i<4; i++ )
                  {
                  WinSetWindowPos  ( WinWindowFromID ( hWnd, id[i] ),
                                     HWND_TOP,
                                     x[i],
                                     y[i],
                                     cx,
                                     cy,
                                     SWP_ACTIVATE |
                                       SWP_MOVE   |
                                       SWP_SIZE   |
                                       SWP_SHOW );
                  };
               return ( (MRESULT) TRUE );
               break;

      default:
               break;
      }
   return ( HWXCOMMON ( hWnd, ulMsg, mp1, mp2 ) );
   }

