#===================================================================
#
# HIDEKBD Make file
#
#===================================================================
#
#===================================================================
#
.SUFFIXES:
.SUFFIXES: .rc .res .obj .lst .c .hlp .itl .ipf

#===================================================================
#
#  Symbol definitions
#
#===================================================================

#===================================================================
#
# Default compilation macros for sample programs
#
#===================================================================
#
# Compile switchs
#
# /c      compile don't link
# /Fa+    Write ASM  file to DASD ( + = YES, - = NO
# /Fd+    Write temp file to DASD ( /Fd- = Write temp files to virtual memory )
# /Fl+    Write basic listing file  ( + = YES, - = NO )
# /Gd     use runtime library that: ( + = Dynamic Link, - = Static Link )
# /Ge     use runtime library that: ( + = EXE Built,    - = DLL Built )
# /Gm     use the multi-threaded libraries ( + = YES, - = NO )
# /Kb     Control basic diagnostic message (/Kb+ = ON, /Kb- = OFF )
# /Kp     Unused Parameter Messages        (/Kp+ = ON, /Kp- = OFF )
# /Fp2    Pack on two byte boundaries
# /Lf+    Write full  listing file  ( + = YES, - = NO )
# /Ms     use the system calling convention and not optilink as the default
# /O      Optimization: ( + = ON, - = OFF )
# /Rx     Subsystem Development (where x = e | n, e=runtime environ, n=none)
# /Se     allow cset  extensions
# /Ss     allow  "//" for comment lines
# /SpX    Pack on "X" boundary, where "X" is 1, 2, 4
# /Ti+    Compile for Debug
#

CCE = icc  /c /Kb+ /Kp+

LFLAGSD    = /ALIGN:4 /NOI
LIBS       = OS2386+PENPM
LINK       = LINK386 $(LFLAGSD)
RC         = rc

#-------------------------------------------------------------------
#   A list of all of the object files
#-------------------------------------------------------------------

all: hidekbd.exe hidekbd.hlp

hidekbd.obj:  hidekbd.c hidekbd.h
  $(CCE) hidekbd.c

hidekbd.hlp: hidekbd.ipf hidekbd.rc
  ipfc hidekbd.ipf


hidekbd.res: hidekbd.rc hidekbd.h hidekbd.ico hidekbd.dlg
    $(RC) -r hidekbd.rc

hidekbd.lnk: hidekbd.mak hidekbd.def
    echo hidekbd.obj        > hidekbd.lnk
    echo hidekbd.exe       >> hidekbd.lnk
    echo hidekbd.map       >> hidekbd.lnk
    echo $(LIBS)            >> hidekbd.lnk
    echo hidekbd.def       >> hidekbd.lnk

hidekbd.exe : hidekbd.obj hidekbd.def hidekbd.lnk hidekbd.mak hidekbd.res
    $(LINK) @hidekbd.lnk
    $(RC) hidekbd.res hidekbd.exe


